/* -*-C++-*-
 * ###################################################################
 *  Cpptcl - connecting C++ with Tcl
 * 
 *  FILE: "cpptcl_data_members.h"
 *                                    created: 21/10/97 {2:15:10 pm} 
 *                                last update: 05/06/98 {16:23:24 PM} 
 *  Author: Vince Darley
 *  E-mail: <darley@fas.harvard.edu>
 *    mail: Division of Engineering and Applied Sciences, Harvard University
 *          Oxford Street, Cambridge MA 02138, USA
 *     www: <http://www.fas.harvard.edu/~darley/>
 *  
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *  Description: 
 * 
 *  History
 * 
 *  modified by  rev reason
 *  -------- --- --- -----------
 *  21/10/97 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_data_members_
#define _Cpptcl_cpptcl_data_members_

#include "cpptcl_config_mem.h"
#include "cpptcl_data_limits.h"
#include <string.h>

//@Section: Cpptcl library
//@Man: 
DLL_IMPORT_EXPORT
class cpp_data_mem: public cpp_config_mem {
  protected:
    ///
	cpp_data_mem(const cpp_data_mem& c):cpp_config_mem(c) {}
  public:
	Cpptcl_BaseClass(cpp_data_mem);
    ///
	virtual void tcl_get_min(tcl_obj& t) const { t << "-infinity";}
    ///
	virtual void tcl_get_max(tcl_obj& t) const { t << "infinity";}
    ///
	virtual cpp_mem& set_items(const char* i)=0;
    ///
    virtual const char* items(void) const=0;
    ///
    virtual bool is_itemised(void) const=0;
    ///
	cpp_data_mem(const char* n):cpp_config_mem(n) {}
	~cpp_data_mem(void) {}
    ///
	int parse_meta_commands(tcl_obj& tcl_, tcl_args& arg);
	///
	void get_syntax(tcl_args& arg) const;
    ///
    void conversion_error(tcl_args& arg) const;
    ///
	virtual void list_items(tcl_obj& obuf) const;
};
//@Section: Cpptcl library
//@Man: 
template <class T> class cpp_member_t: public cpp_data_mem {
  protected:
    ///
	cpp_member_t(const cpp_member_t<T>& c):cpp_data_mem(c),_min(c._min),_max(c._max) {}
    ///
	limit_<T>* _min;
    ///
	limit_<T>* _max;
  public:
    /// 
    DLL_IMPORT_EXPORT
    static const char* _data_type;
    ///
	const char* data_type(void) const { return _data_type;}
    ///
	cpp_member_t(const char* n):cpp_data_mem(n),_min(0),_max(0) {}
	///
	~cpp_member_t(void) {}
	///
    bool is_itemised(void) const {
		return (_max ? _max->itemised() : false);
    }
    ///
	virtual T get(tcl_object * o) const=0;
    ///
	virtual T set(tcl_object * o, T val) const=0;
	///
    const char* items(void) const {
    	return (is_itemised() ? _max->items() : 0);
    }
    ///
	void tcl_get(tcl_object* o, tcl_obj& t) const;
    ///
	void tcl_set(tcl_object* o, tcl_args_reader& t) const;
    ///
	cpp_member_t<T>& set_min(T t) { 
		if(_min == 0) _min = new limit_fixed<T>(t); return *this;
	}
    ///
	cpp_member_t<T>& set_max(T t) { 
		if(_max == 0) _min = new limit_fixed<T>(t); return *this;
	}
	///
	bool in_range(T t) const;
	
    ///
	cpp_mem& set_items(const char* i) { 
		// change return type to 'cpp_member_t<T>&' when compilers support it.
		if(i && _min == 0 && _max == 0) {
			T max_count = (T) 0;
			const char* items = i;
			for(;*i; i += strlen(i)+1) {
				max_count += 1;
			}
			_min = new limit_fixed<T>((T)1);
			_max = new limit_fixed<T>((T)max_count,items);
		}
		return *this;
	}
    ///
	inline T min(void) const;
    ///
	inline T max(void) const;
    ///
	inline void tcl_get_min(tcl_obj& t) const;
    ///
	inline void tcl_get_max(tcl_obj& t) const;
    ///
	inline void list_items(tcl_obj& obuf) const;
#ifdef HAVE_TEMPLATE_MEMBERS
	template <class S> void tget(S& s, tcl_object* in) {s = (S) get(in);}
#else
	#define CPPTCL_MAKE_TGET(S) \
	void tget(S& s, tcl_object* in) {s = (S)get(in);}
	CPPTCL_MAKE_TGET(int);
	CPPTCL_MAKE_TGET(bool);
	CPPTCL_MAKE_TGET(float);
	CPPTCL_MAKE_TGET(double);
	CPPTCL_MAKE_TGET(long);
#endif	
	
};

inline void cpp_member_t<bool>::tcl_get_min(tcl_obj& t) const {t << "false";}
inline void cpp_member_t<bool>::tcl_get_max(tcl_obj& t) const {t << "true";}
inline bool cpp_member_t<bool>::min(void) const {return false;}
inline bool cpp_member_t<bool>::max(void) const {return true;}
inline bool cpp_member_t<bool>::in_range(bool) const { return true;}
inline void cpp_member_t<bool>::list_items(tcl_obj& obuf) const {
	obuf << "false true";
}
template <class T>
inline T cpp_member_t<T>::min(void) const {return _min->value(container);}
template <class T>
inline T cpp_member_t<T>::max(void) const {return _max->value(container);}
template <class T>
inline bool cpp_member_t<T>::in_range(T t) const {
	return (((_max && t > max()) || (_max && t < min())) ? false : true);
}
template <class T>
inline void cpp_member_t<T>::tcl_get_min(tcl_obj& t) const {
	if(_min) {t << min();} else {cpp_data_mem::tcl_get_min(t);}
}
template <class T>
inline void cpp_member_t<T>::tcl_get_max(tcl_obj& t) const {
	if(_max) {t << max();} else {cpp_data_mem::tcl_get_max(t);}
}
template <class T>
inline void cpp_member_t<T>::list_items(tcl_obj& obuf) const { 
	cpp_data_mem::list_items(obuf);
}

//@Section: Cpptcl library
//@Man: 
template <class T> class cpp_member: public cpp_member_t<T> {
  protected:
    ///
	cpp_mem* copy(void) const {return new cpp_member<T>(*this);}
    ///
	cpp_member(const cpp_member<T>& c):cpp_member_t<T>(c),_mptr(c._mptr) {}
    ///
	T tcl_object::*_mptr;
  public:  
    ///
	T& reference(tcl_object* o) const { return o->*_mptr;}
    ///
	T get(tcl_object * o) const { return o->*_mptr;}
    ///
	T set(tcl_object * o, T val) const { return (o->*_mptr = val);}	
    ///
	cpp_member(const char* n, T tcl_object::*ptr):cpp_member_t<T>(n),_mptr(ptr) {}
	~cpp_member(void) {}
	///
	virtual bool private_data(const cpp_private& data) const {
		return (data == (cpp_mptr)_mptr);
	}
};
//@Section: Cpptcl library
//@Man: 
template <class T> class cpp_member_fnr: public cpp_member_t<T> {
  protected:
    ///
	cpp_mem* copy(void) const {return new cpp_member_fnr<T>(*this);}
    ///
	cpp_member_fnr(const cpp_member_fnr<T>& c)
	:cpp_member_t<T>(c),_mptr(c._mptr) {}
    ///
	T& (tcl_object::*_mptr) (void);
  public:  
    ///
	T& reference(tcl_object* o) const { return (o->*_mptr)();}
    ///
	T get(tcl_object * o) const { return (o->*_mptr)();}
    ///
	T set(tcl_object * o, T val) const { return ((o->*_mptr)() = val);}	
    ///
	cpp_member_fnr(const char* n, T& (tcl_object::*ptr) (void))
	:cpp_member_t<T>(n),_mptr(ptr) {}
	~cpp_member_fnr(void) {}
	///
	virtual bool private_data(const cpp_private& data) const {
	    #ifdef __GNUC__
	    return (data == (cpp_mfptr)_mptr);
	    #else
	    return (data == (cpp_mptr)_mptr);
	    #endif
	}
};
//@Section: Cpptcl library
//@Man: 
template <class T> class cpp_member_fnv: public cpp_member_t<T> {
  protected:
    ///
	cpp_mem* copy(void) const {return new cpp_member_fnv<T>(*this);}
    ///
	cpp_member_fnv(const cpp_member_fnv<T>& c):cpp_member_t<T>(c),
	  	_read_fptr(c._read_fptr),_write_fptr(c._write_fptr) {}
	///
    T (tcl_object::*_read_fptr)(void) const;  	
	///
    void (tcl_object::*_write_fptr)(T);  	
  public:  
    ///
	T get(tcl_object * o) const {return (o->*_read_fptr)();}
    ///
	T set(tcl_object * o, T val) const {(o->*_write_fptr)(val); return val;}	
    ///
	bool read_only(void) const {return (_write_fptr ? false: true);}
	~cpp_member_fnv(void) {}
    ///
	cpp_member_fnv(const char* n, 
		T (tcl_object::*read_fptr)(void) const,
		void (tcl_object::*write_fptr)(T))
	:cpp_member_t<T>(n),_read_fptr(read_fptr),_write_fptr(write_fptr) {}
	///
	virtual bool private_data(const cpp_private& data) const {
            #ifdef __GNUC__
	    return (data == (cpp_mfptr)_read_fptr);
            #else
	    return (data == (cpp_mptr)_read_fptr);
            #endif
	}
};

template <class S, class T>
inline S cpptcl_read(cpp_member_t<T>& mem, tcl_object* in) {
	return (S) mem.get(in);
}

/*
template <class S, class T> 
cpp_member_info member_def(const char*, T (S::*mb));
template <class S, class T> 
inline cpp_member_info member_def(const char* n, T (S::*mb)) {
	cpp_member_info(n,cpp_member<T>((T tcl_object::*)mb));
}
*/

#define cppDatamember(n,a,T) \
	cpp_member<T>(n,(T tcl_object::*)&a)
#define cppDatamemberreffn(n,a,T) \
	cpp_member_fnr<T>(n,(T& (tcl_object::*)(void) const)a)
#define cppDatamemberfn(n,a,b,T) \
	cpp_member_fnv<T>(n,(T (tcl_object::*)(void) const)a, \
	(void (tcl_object::*)(T))b)
#define cppMemType(T) const char* cpp_member_t<T>::_data_type = #T

#endif
