/* THIS FILE IS NOW SPLIT INTO TWO PIECES: g_fontdb.c and g_fontd2.c, TO
   FACILITATE COMPILING.  This is the first half, containing PS fonts and
   Hershey vector fonts. */

/*----------------------------------------------------------------------*/

/* This file contains information about PS fonts, Hershey vector fonts, PCL
   fonts, and Stick fonts (i.e., device-resident vector fonts), and about
   the way in which they are divided into typefaces.  For the non-Hershey
   fonts, the most important information is the width tables.  For the
   Hershey fonts, it is the mapping from the character position in the
   font, to the position of the corresponding glyph in the glyph array in
   g_her_glyph.c.  Accented characters are formed as composites. */

#include "sys-defines.h"
#include "extern.h"


/* The 35 standard PS fonts, with ISO8859-1 (ISO-Latin-1) encoding where
   that is appropriate.  (Note that NUM_PS_FONTS is defined to equal 35 in
   extern.h.)  Each plPSFontInfoStruct includes these elements:

   (1) PS name, (1a) alternative PS name if any (may be NULL), 
   	(1c) 2nd alternative PS name if any (may be NULL),
   (2a) X name, (2b) alternative X name if any (may be NULL)
   (3) PCL typeface number.
   (4) PCL info: fixedwidth(0) / proportional(1).
   (5) PCL info: upright(0) / italic(1) / condensed(4) / cond. italic(5) /
   	compressed i.e. extra cond. (8) / expanded (24) / outline (32) / 
	inline (64).
   (6) PCL info: normal weight(0) / bold(3) / extra bold(4), etc.
   (7) PCL info: "symbol set" i.e. native character set/encoding.
   	(0 = Roman-8 i.e. default set; 14 = ISO8859-1 i.e. ECMA-94 Latin 1;
	621 = PS Symbol; 18540 = Wingdings.  In PCL as opposed to HP-GL/2,
	these numbers are encoded base 32, as a number and a letter.  E.g.,
	621 is written as 19M since 19*32+13, and 'M' is letter #13.)
   (8) and (9) (normalized) font ascent and descent (from font bounding box),
   (10) the font cap height
   (11a) the font width information (an array, size 256),   
   (11b) the `left edge of glyph' information (an array, size 256),   
   (12) a typeface id (an index into the _ps_typeface_info[] array below)
   (13) a font index (which font within the typeface this is)
   (14) a Fig font id, for use by FigPlotter methods
   (15) an `iso8859-1' flag, for the PS driver, which must re-encode
*/

/* IMPORTANT: The fonts in this array may be referred to elsewhere in the
   libplot code by number.  If you change the internal numbering of
   Postscript fonts, i.e., the order in which they appear in this array, be
   sure to update the definitions DEFAULT_POSTSCRIPT_FONT_INDEX, etc. in
   extern.h.  Also update the arrays _ps_font_to_cgm_font_id[] and
   _cgm_font_id_to_ps_font[], below. */

const struct plPSFontInfoStruct _ps_font_info[] = {
{
  "Helvetica",			/* #0 */
  NULL,
  NULL,
  "helvetica-medium-r-normal",
  NULL,
  24580, 1, 0, 0, 14,
  931, 225,
  718,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 278, 355, 556, 556, 889, 667, 222,
    333, 333, 389, 584, 278, 584, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 278, 278,
    584, 584, 584, 556, 1015, 667, 667, 722, 722, 667,
    611, 778, 722, 278, 500, 667, 556, 833, 722, 778,
    667, 778, 722, 667, 611, 722, 667, 944, 667, 667,
    611, 278, 278, 278, 469, 556, 222, 556, 556, 500,
    556, 556, 278, 556, 556, 222, 222, 500, 222, 833,
    556, 556, 556, 556, 333, 500, 278, 556, 500, 722,
    500, 500, 500, 334, 260, 334, 584, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 260, 556, 333, 737,
    370, 556, 584, 333, 737, 333, 400, 584, 333, 333,
    333, 556, 537, 278, 333, 333, 365, 556, 834, 834,
    834, 611, 667, 667, 667, 667, 667, 667, 1000, 722,
    667, 667, 667, 667, 278, 278, 278, 278, 722, 722,
    778, 778, 778, 778, 778, 584, 778, 722, 722, 722,
    722, 667, 667, 611, 556, 556, 556, 556, 556, 556,
    889, 500, 556, 556, 556, 556, 278, 278, 278, 278,
    556, 556, 556, 556, 556, 556, 556, 584, 611, 556,
    556, 556, 556, 500, 556, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 90, 70, 28, 32, 39, 44, 53,
    68, 34, 39, 39, 87, 39, 87, -17,
    37, 101, 26, 34, 25, 32, 38, 37,
    38, 42, 87, 87, 48, 39, 48, 56,
    147, 14, 74, 44, 81, 86, 86, 48,
    77, 91, 17, 76, 76, 73, 76, 39,
    86, 39, 88, 49, 14, 79, 20, 16,
    19, 14, 23, 63, -17, 28, -14, 0,
    65, 36, 58, 30, 35, 40, 14, 40,
    65, 67, -16, 67, 67, 65, 65, 35,
    58, 35, 77, 32, 14, 68, 8, 14,
    11, 11, 31, 42, 94, 42, 61, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 118, 51, 33, 28, 3, 94, 43,
    40, -14, 24, 97, 39, 44, -14, 10,
    54, 39, 4, 5, 122, 68, 18, 77,
    45, 43, 25, 97, 73, 43, 45, 91,
    14, 14, 14, 14, 14, 14, 8, 44,
    86, 86, 86, 86, -13, 91, -6, 13,
    0, 76, 39, 39, 39, 39, 39, 39,
    39, 79, 79, 79, 79, 14, 86, 67,
    36, 36, 36, 36, 36, 36, 36, 30,
    40, 40, 40, 40, -13, 95, -6, 13,
    35, 65, 35, 35, 35, 35, 35, 39,
    28, 68, 68, 68, 68, 11, 58, 11
  },
  0, 1,
  16,
  true},
{
  "Helvetica-Oblique",		/* #1 */
  NULL,
  NULL,
  "helvetica-medium-o-normal",
  NULL,
  24580, 1, 1, 0, 14,
  931, 225,
  718,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 278, 355, 556, 556, 889, 667, 222,
    333, 333, 389, 584, 278, 584, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 278, 278,
    584, 584, 584, 556, 1015, 667, 667, 722, 722, 667,
    611, 778, 722, 278, 500, 667, 556, 833, 722, 778,
    667, 778, 722, 667, 611, 722, 667, 944, 667, 667,
    611, 278, 278, 278, 469, 556, 222, 556, 556, 500,
    556, 556, 278, 556, 556, 222, 222, 500, 222, 833,
    556, 556, 556, 556, 333, 500, 278, 556, 500, 722,
    500, 500, 500, 334, 260, 334, 584, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 260, 556, 333, 737,
    370, 556, 584, 333, 737, 333, 400, 584, 333, 333,
    333, 556, 537, 278, 333, 333, 365, 556, 834, 834,
    834, 611, 667, 667, 667, 667, 667, 667, 1000, 722,
    667, 667, 667, 667, 278, 278, 278, 278, 722, 722,
    778, 778, 778, 778, 778, 584, 778, 722, 722, 722,
    722, 667, 667, 611, 556, 556, 556, 556, 556, 556,
    889, 500, 556, 556, 556, 556, 278, 278, 278, 278,
    556, 556, 556, 556, 556, 556, 556, 584, 611, 556,
    556, 556, 556, 500, 556, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 90, 168, 73, 69, 147, 77, 151,
    108, -9, 165, 85, 56, 85, 87, -21,
    93, 207, 26, 75, 61, 68, 91, 137,
    74, 82, 87, 56, 94, 63, 50, 161,
    215, 14, 74, 108, 81, 86, 86, 111,
    77, 91, 47, 76, 76, 73, 76, 105,
    86, 105, 88, 90, 148, 123, 173, 169,
    19, 167, 23, 21, 140, -14, 42, -27,
    165, 61, 58, 74, 84, 84, 86, 42,
    65, 67, -60, 67, 67, 65, 65, 83,
    14, 84, 77, 63, 102, 94, 119, 125,
    11, 15, 31, 92, 90, 0, 111, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 77, 95, 49, 60, 81, 90, 76,
    168, 54, 100, 146, 106, 93, 54, 143,
    169, 39, 64, 90, 248, 24, 126, 129,
    2, 166, 100, 120, 150, 114, 130, 85,
    14, 14, 14, 14, 14, 14, 8, 108,
    86, 86, 86, 86, 91, 91, 91, 91,
    69, 76, 105, 105, 105, 105, 105, 50,
    43, 123, 123, 123, 123, 167, 86, 67,
    61, 61, 61, 61, 61, 61, 61, 74,
    84, 84, 84, 84, 95, 95, 95, 95,
    81, 65, 83, 83, 83, 83, 83, 85,
    29, 94, 94, 94, 94, 15, 14, 15
  },
  0, 2,
  17,
  true},
{
  "Helvetica-Bold",		/* #2 */
  NULL,
  NULL,
  "helvetica-bold-r-normal",
  NULL,
  24580, 1, 0, 3, 14,
  962, 228,
  718,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 333, 474, 556, 556, 889, 722, 278,
    333, 333, 389, 584, 278, 584, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 333, 333,
    584, 584, 584, 611, 975, 722, 722, 722, 722, 667,
    611, 778, 722, 278, 556, 722, 611, 833, 722, 778,
    667, 778, 722, 667, 611, 722, 667, 944, 667, 667,
    611, 333, 278, 333, 584, 556, 278, 556, 611, 556,
    611, 556, 333, 611, 611, 278, 278, 556, 278, 889,
    611, 611, 611, 611, 389, 556, 333, 611, 556, 778,
    556, 556, 500, 389, 280, 389, 584, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 280, 556, 333, 737,
    370, 556, 584, 333, 737, 333, 400, 584, 333, 333,
    333, 611, 556, 278, 333, 333, 365, 556, 834, 834,
    834, 611, 722, 722, 722, 722, 722, 722, 1000, 722,
    667, 667, 667, 667, 278, 278, 278, 278, 722, 722,
    778, 778, 778, 778, 778, 584, 778, 722, 722, 722,
    722, 667, 667, 611, 556, 556, 556, 556, 556, 556,
    889, 556, 556, 556, 556, 556, 278, 278, 278, 278,
    611, 611, 611, 611, 611, 611, 611, 584, 611, 611,
    611, 611, 611, 556, 611, 556
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 90, 98, 18, 30, 28, 54, 69,
    35, 19, 27, 40, 64, 40, 64, -33,
    32, 69, 26, 27, 27, 27, 31, 25,
    32, 30, 92, 92, 38, 40, 38, 60,
    118, 20, 76, 44, 76, 76, 76, 44,
    71, 64, 22, 87, 76, 69, 69, 44,
    76, 44, 76, 39, 14, 72, 19, 16,
    14, 15, 25, 63, -33, 24, 62, 0,
    69, 29, 61, 34, 34, 23, 10, 40,
    65, 69, 3, 69, 69, 64, 65, 34,
    62, 34, 64, 30, 10, 66, 13, 10,
    15, 10, 20, 48, 84, 24, 61, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 90, 34, 28, -3, -9, 84, 34,
    6, -11, 22, 88, 40, 27, -11, -6,
    57, 40, 9, 8, 108, 66, -8, 58,
    6, 26, 6, 88, 26, 26, 16, 55,
    20, 20, 20, 20, 20, 20, 5, 44,
    76, 76, 76, 76, -50, 64, -37, -21,
    -5, 69, 44, 44, 44, 44, 44, 40,
    33, 72, 72, 72, 72, 15, 76, 69,
    29, 29, 29, 29, 29, 29, 29, 34,
    23, 23, 23, 23, -50, 69, -37, -21,
    34, 65, 34, 34, 34, 34, 34, 40,
    22, 66, 66, 66, 66, 10, 62, 10
  },
  0, 3,
  18,
  true},
{
  "Helvetica-BoldOblique",	/* #3 */
  NULL,
  NULL,
  "helvetica-bold-o-normal",
  NULL,
  24580, 1, 1, 3, 14,
  962, 228,
  718,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 333, 474, 556, 556, 889, 722, 278,
    333, 333, 389, 584, 278, 584, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 333, 333,
    584, 584, 584, 611, 975, 722, 722, 722, 722, 667,
    611, 778, 722, 278, 556, 722, 611, 833, 722, 778,
    667, 778, 722, 667, 611, 722, 667, 944, 667, 667,
    611, 333, 278, 333, 584, 556, 278, 556, 611, 556,
    611, 556, 333, 611, 611, 278, 278, 556, 278, 889,
    611, 611, 611, 611, 389, 556, 333, 611, 556, 778,
    556, 556, 500, 389, 280, 389, 584, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 280, 556, 333, 737,
    370, 556, 584, 333, 737, 333, 400, 584, 333, 333,
    333, 611, 556, 278, 333, 333, 365, 556, 834, 834,
    834, 611, 722, 722, 722, 722, 722, 722, 1000, 722,
    667, 667, 667, 667, 278, 278, 278, 278, 722, 722,
    778, 778, 778, 778, 778, 584, 778, 722, 722, 722,
    722, 667, 667, 611, 556, 556, 556, 556, 556, 556,
    889, 556, 556, 556, 556, 556, 278, 278, 278, 278,
    611, 611, 611, 611, 611, 611, 611, 584, 611, 611,
    611, 611, 611, 556, 611, 556
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 94, 193, 60, 67, 136, 89, 167,
    76, -25, 146, 82, 28, 82, 64, -37,
    86, 173, 26, 65, 60, 64, 85, 125,
    69, 78, 92, 56, 82, 58, 36, 165,
    186, 20, 76, 107, 76, 76, 76, 108,
    71, 64, 60, 87, 76, 69, 69, 107,
    76, 107, 76, 81, 140, 116, 172, 169,
    14, 168, 25, 21, 124, -18, 131, -27,
    165, 55, 61, 79, 82, 70, 87, 38,
    65, 69, -42, 69, 69, 64, 65, 82,
    18, 80, 64, 63, 100, 98, 126, 123,
    15, 42, 20, 94, 80, -18, 115, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 50, 79, 50, 27, 60, 80, 61,
    137, 56, 92, 135, 105, 73, 55, 122,
    175, 40, 69, 91, 236, 22, 98, 110,
    -37, 148, 92, 104, 132, 132, 99, 53,
    20, 20, 20, 20, 20, 20, 5, 107,
    76, 76, 76, 76, 64, 64, 64, 64,
    62, 69, 107, 107, 107, 107, 107, 57,
    35, 116, 116, 116, 116, 168, 76, 69,
    55, 55, 55, 55, 55, 55, 56, 79,
    70, 70, 70, 70, 69, 69, 69, 69,
    82, 65, 82, 82, 82, 82, 82, 82,
    22, 98, 98, 98, 98, 42, 18, 42
  },
  0, 4,
  19,
  true},
{
  "Helvetica-Narrow",		/* #4 */
  NULL,
  NULL,
  "helvetica-medium-r-narrow",
  NULL,
  24580, 1, 4, 0, 14,
  931, 225,
  718,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 228, 228, 291, 456, 456, 729, 547, 182,
    273, 273, 319, 479, 228, 479, 228, 228, 456, 456,
    456, 456, 456, 456, 456, 456, 456, 456, 228, 228,
    479, 479, 479, 456, 832, 547, 547, 592, 592, 547,
    501, 638, 592, 228, 410, 547, 456, 683, 592, 638,
    547, 638, 592, 547, 501, 592, 547, 774, 547, 547,
    501, 228, 228, 228, 385, 456, 182, 456, 456, 410,
    456, 456, 228, 456, 456, 182, 182, 410, 182, 683,
    456, 456, 456, 456, 273, 410, 228, 456, 410, 592,
    410, 410, 410, 274, 213, 274, 479, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    228, 273, 456, 456, 456, 456, 213, 456, 273, 604,
    303, 456, 479, 273, 604, 273, 328, 479, 273, 273,
    273, 456, 440, 228, 273, 273, 299, 456, 684, 684,
    684, 501, 547, 547, 547, 547, 547, 547, 820, 592,
    547, 547, 547, 547, 228, 228, 228, 228, 592, 592,
    638, 638, 638, 638, 638, 479, 638, 592, 592, 592,
    592, 547, 547, 501, 456, 456, 456, 456, 456, 456,
    729, 410, 456, 456, 456, 456, 228, 228, 228, 228,
    456, 456, 456, 456, 456, 456, 456, 479, 501, 456,
    456, 456, 456, 410, 456, 410
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 74, 57, 23, 26, 32, 36, 43,
    56, 28, 32, 32, 71, 32, 71, -14,
    30, 83, 21, 28, 20, 26, 31, 30,
    31, 34, 71, 71, 39, 32, 39, 46,
    121, 11, 61, 36, 66, 71, 71, 39,
    63, 75, 14, 62, 62, 60, 62, 32,
    71, 32, 72, 40, 11, 65, 16, 13,
    16, 11, 19, 52, -14, 23, -11, 0,
    53, 30, 48, 25, 29, 33, 11, 33,
    53, 55, -13, 55, 55, 53, 53, 29,
    48, 29, 63, 26, 11, 56, 7, 11,
    9, 9, 25, 34, 77, 34, 50, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 97, 42, 27, 23, 2, 77, 35,
    33, -11, 20, 80, 32, 36, -11, 8,
    44, 32, 3, 4, 100, 56, 15, 63,
    37, 35, 20, 80, 60, 35, 37, 75,
    11, 11, 11, 11, 11, 11, 7, 36,
    71, 71, 71, 71, -11, 75, -5, 11,
    0, 62, 32, 32, 32, 32, 32, 32,
    32, 65, 65, 65, 65, 11, 71, 55,
    30, 30, 30, 30, 30, 30, 30, 25,
    33, 33, 33, 33, -11, 78, -5, 11,
    29, 53, 29, 29, 29, 29, 29, 32,
    23, 56, 56, 56, 56, 9, 48, 9
  },
  1, 1,
  20,
  true},
{
  "Helvetica-Narrow-Oblique",	/* #5 */
  NULL,
  NULL,
  "helvetica-medium-o-narrow",
  NULL,
  24580, 1, 5, 0, 14,
  931, 225,
  718,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 228, 228, 291, 456, 456, 729, 547, 182,
    273, 273, 319, 479, 228, 479, 228, 228, 456, 456,
    456, 456, 456, 456, 456, 456, 456, 456, 228, 228,
    479, 479, 479, 456, 832, 547, 547, 592, 592, 547,
    501, 638, 592, 228, 410, 547, 456, 683, 592, 638,
    547, 638, 592, 547, 501, 592, 547, 774, 547, 547,
    501, 228, 228, 228, 385, 456, 182, 456, 456, 410,
    456, 456, 228, 456, 456, 182, 182, 410, 182, 683,
    456, 456, 456, 456, 273, 410, 228, 456, 410, 592,
    410, 410, 410, 274, 213, 274, 479, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    228, 273, 456, 456, 456, 456, 213, 456, 273, 604,
    303, 456, 479, 273, 604, 273, 328, 479, 273, 273,
    273, 456, 440, 228, 273, 273, 299, 456, 684, 684,
    684, 501, 547, 547, 547, 547, 547, 547, 820, 592,
    547, 547, 547, 547, 228, 228, 228, 228, 592, 592,
    638, 638, 638, 638, 638, 479, 638, 592, 592, 592,
    592, 547, 547, 501, 456, 456, 456, 456, 456, 456,
    729, 410, 456, 456, 456, 456, 228, 228, 228, 228,
    456, 456, 456, 456, 456, 456, 456, 479, 501, 456,
    456, 456, 456, 410, 456, 410
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 74, 138, 60, 57, 120, 63, 124,
    89, -7, 135, 70, 46, 70, 71, -17,
    77, 170, 21, 61, 50, 55, 74, 112,
    60, 67, 71, 46, 77, 52, 41, 132,
    176, 11, 61, 88, 66, 71, 71, 91,
    63, 75, 39, 62, 62, 60, 62, 86,
    71, 86, 72, 74, 122, 101, 142, 138,
    16, 137, 19, 17, 115, -11, 35, -22,
    135, 50, 48, 61, 69, 69, 71, 34,
    53, 55, -49, 55, 55, 53, 53, 68,
    11, 69, 63, 52, 84, 77, 98, 103,
    9, 12, 25, 75, 74, 0, 91, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 63, 78, 40, 49, 67, 74, 63,
    138, 44, 82, 120, 87, 77, 44, 117,
    138, 32, 52, 74, 203, 20, 103, 106,
    2, 136, 82, 98, 123, 93, 106, 70,
    11, 11, 11, 11, 11, 11, 7, 88,
    71, 71, 71, 71, 75, 75, 75, 75,
    57, 62, 86, 86, 86, 86, 86, 41,
    35, 101, 101, 101, 101, 137, 71, 55,
    50, 50, 50, 50, 50, 50, 50, 61,
    69, 69, 69, 69, 78, 78, 78, 78,
    67, 53, 68, 68, 68, 68, 68, 70,
    24, 77, 77, 77, 77, 12, 11, 12
  },
  1, 2,
  21,
  true},
{
  "Helvetica-Narrow-Bold",	/* #6 */
  NULL,
  NULL,
  "helvetica-bold-r-narrow",
  NULL,
  24580, 1, 4, 3, 14,
  962, 228,
  718,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 228, 273, 389, 456, 456, 729, 592, 228,
    273, 273, 319, 479, 228, 479, 228, 228, 456, 456,
    456, 456, 456, 456, 456, 456, 456, 456, 273, 273,
    479, 479, 479, 501, 800, 592, 592, 592, 592, 547,
    501, 638, 592, 228, 456, 592, 501, 683, 592, 638,
    547, 638, 592, 547, 501, 592, 547, 774, 547, 547,
    501, 273, 228, 273, 479, 456, 228, 456, 501, 456,
    501, 456, 273, 501, 501, 228, 228, 456, 228, 729,
    501, 501, 501, 501, 319, 456, 273, 501, 456, 638,
    456, 456, 410, 319, 230, 319, 479, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    228, 273, 456, 456, 456, 456, 230, 456, 273, 604,
    303, 456, 479, 273, 604, 273, 328, 479, 273, 273,
    273, 501, 456, 228, 273, 273, 299, 456, 684, 684,
    684, 501, 592, 592, 592, 592, 592, 592, 820, 592,
    547, 547, 547, 547, 228, 228, 228, 228, 592, 592,
    638, 638, 638, 638, 638, 479, 638, 592, 592, 592,
    592, 547, 547, 501, 456, 456, 456, 456, 456, 456,
    729, 456, 456, 456, 456, 456, 228, 228, 228, 228,
    501, 501, 501, 501, 501, 501, 501, 479, 501, 501,
    501, 501, 501, 456, 501, 456
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 74, 80, 15, 25, 23, 44, 57,
    29, 16, 22, 33, 52, 33, 52, -27,
    26, 57, 21, 22, 22, 22, 25, 20,
    26, 25, 75, 75, 31, 33, 31, 49,
    97, 16, 62, 36, 62, 62, 62, 36,
    58, 52, 18, 71, 62, 57, 57, 36,
    62, 36, 62, 32, 11, 59, 16, 13,
    11, 12, 20, 52, -27, 20, 51, 0,
    57, 24, 50, 28, 28, 19, 8, 33,
    53, 57, 2, 57, 57, 52, 53, 28,
    51, 28, 52, 25, 8, 54, 11, 8,
    12, 8, 16, 39, 69, 20, 50, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 74, 28, 23, -2, -7, 69, 28,
    5, -9, 18, 72, 33, 22, -9, -5,
    47, 33, 7, 7, 89, 54, -7, 48,
    5, 21, 5, 72, 21, 21, 13, 45,
    16, 16, 16, 16, 16, 16, 4, 36,
    62, 62, 62, 62, -41, 52, -30, -17,
    -4, 57, 36, 36, 36, 36, 36, 33,
    27, 59, 59, 59, 59, 12, 62, 57,
    24, 24, 24, 24, 24, 24, 24, 28,
    19, 19, 19, 19, -41, 57, -30, -17,
    28, 53, 28, 28, 28, 28, 28, 33,
    18, 54, 54, 54, 54, 8, 51, 8
  },
  1, 3,
  22,
  true},
{
  "Helvetica-Narrow-BoldOblique", /* #7 */
  NULL,
  NULL,
  "helvetica-bold-o-narrow",
  NULL,
  24580, 1, 5, 3, 14,
  962, 228,
  718,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 228, 273, 389, 456, 456, 729, 592, 228,
    273, 273, 319, 479, 228, 479, 228, 228, 456, 456,
    456, 456, 456, 456, 456, 456, 456, 456, 273, 273,
    479, 479, 479, 501, 800, 592, 592, 592, 592, 547,
    501, 638, 592, 228, 456, 592, 501, 683, 592, 638,
    547, 638, 592, 547, 501, 592, 547, 774, 547, 547,
    501, 273, 228, 273, 479, 456, 228, 456, 501, 456,
    501, 456, 273, 501, 501, 228, 228, 456, 228, 729,
    501, 501, 501, 501, 319, 456, 273, 501, 456, 638,
    456, 456, 410, 319, 230, 319, 479, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    228, 273, 456, 456, 456, 456, 230, 456, 273, 604,
    303, 456, 479, 273, 604, 273, 328, 479, 273, 273,
    273, 501, 456, 228, 273, 273, 299, 456, 684, 684,
    684, 501, 592, 592, 592, 592, 592, 592, 820, 592,
    547, 547, 547, 547, 228, 228, 228, 228, 592, 592,
    638, 638, 638, 638, 638, 479, 638, 592, 592, 592,
    592, 547, 547, 501, 456, 456, 456, 456, 456, 456,
    729, 456, 456, 456, 456, 456, 228, 228, 228, 228,
    501, 501, 501, 501, 501, 501, 501, 479, 501, 501,
    501, 501, 501, 456, 501, 456
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 77, 158, 49, 55, 112, 73, 137,
    62, -21, 120, 67, 23, 67, 52, -30,
    71, 142, 21, 54, 50, 53, 70, 102,
    57, 64, 75, 46, 67, 48, 30, 135,
    152, 16, 62, 88, 62, 62, 62, 89,
    58, 52, 49, 71, 62, 57, 57, 88,
    62, 88, 62, 66, 114, 96, 141, 138,
    11, 137, 20, 17, 101, -14, 107, -22,
    136, 45, 50, 65, 67, 58, 71, 31,
    53, 57, -35, 57, 57, 52, 53, 67,
    15, 66, 52, 52, 82, 80, 103, 101,
    12, 34, 16, 77, 66, -14, 94, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 41, 65, 41, 22, 49, 66, 50,
    112, 46, 75, 111, 86, 60, 45, 100,
    143, 33, 57, 75, 194, 18, 80, 90,
    -30, 121, 75, 85, 108, 108, 82, 44,
    16, 16, 16, 16, 16, 16, 4, 88,
    62, 62, 62, 62, 52, 52, 52, 52,
    51, 57, 88, 88, 88, 88, 88, 47,
    29, 96, 96, 96, 96, 137, 62, 57,
    45, 45, 45, 45, 45, 45, 46, 65,
    58, 58, 58, 58, 57, 57, 57, 57,
    67, 53, 67, 67, 67, 67, 67, 67,
    18, 80, 80, 80, 80, 34, 15, 34
  },
  1, 4,
  23,
  true},
{
  "Times-Roman",		/* #8 */
  NULL,
  NULL,
  "times-medium-r-normal",
  NULL,
  25093, 1, 0, 0, 14,
  898, 218,
  662,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 408, 500, 500, 833, 778, 333,
    333, 333, 500, 564, 250, 564, 250, 278, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 278, 278,
    564, 564, 564, 444, 921, 722, 667, 667, 722, 611,
    556, 722, 722, 333, 389, 722, 611, 889, 722, 722,
    556, 722, 667, 556, 611, 722, 722, 944, 722, 722,
    611, 333, 278, 333, 469, 500, 333, 444, 500, 444,
    500, 444, 333, 500, 500, 278, 278, 500, 278, 778,
    500, 500, 500, 500, 333, 389, 278, 500, 500, 722,
    500, 500, 444, 480, 200, 480, 541, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 333, 500, 500, 500, 500, 200, 500, 333, 760,
    276, 500, 564, 333, 760, 333, 400, 564, 300, 300,
    333, 500, 453, 250, 333, 300, 310, 500, 750, 750,
    750, 444, 722, 722, 722, 722, 722, 722, 889, 667,
    611, 611, 611, 611, 333, 333, 333, 333, 722, 722,
    722, 722, 722, 722, 722, 564, 722, 722, 722, 722,
    722, 722, 556, 500, 444, 444, 444, 444, 444, 444,
    667, 444, 444, 444, 444, 444, 278, 278, 278, 278,
    500, 500, 500, 500, 500, 500, 500, 564, 500, 500,
    500, 500, 500, 500, 500, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 130, 77, 5, 44, 61, 42, 79,
    48, 29, 69, 30, 56, 30, 70, -9,
    24, 111, 30, 43, 12, 32, 34, 20,
    56, 30, 81, 80, 28, 30, 28, 68,
    116, 15, 17, 28, 16, 12, 12, 32,
    19, 18, 10, 34, 12, 12, 12, 34,
    16, 34, 17, 42, 17, 14, 16, 5,
    10, 22, 9, 88, -9, 34, 24, 0,
    115, 37, 3, 25, 27, 25, 20, 28,
    9, 16, -70, 7, 19, 16, 16, 29,
    5, 24, 5, 51, 13, 9, 19, 21,
    17, 14, 27, 100, 67, 130, 40, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 97, 53, 12, -22, -53, 67, 70,
    18, 38, 4, 42, 30, 39, 38, 11,
    57, 30, 1, 15, 93, 36, -22, 70,
    52, 57, 6, 44, 37, 31, 15, 30,
    15, 15, 15, 15, 15, 15, 0, 28,
    12, 12, 12, 12, 18, 18, 11, 18,
    16, 12, 34, 34, 34, 34, 34, 38,
    34, 14, 14, 14, 14, 22, 16, 12,
    37, 37, 37, 37, 37, 37, 38, 25,
    25, 25, 25, 25, -8, 16, -16, -9,
    29, 16, 29, 29, 29, 29, 29, 30,
    29, 9, 9, 9, 9, 14, 5, 14
  },
  2, 1,
  0,
  true},
{
  "Times-Italic",		/* #9 */
  NULL,
  NULL,
  "times-medium-i-normal",
  NULL,
  25093, 1, 1, 0, 14,
  883, 217,
  653,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 420, 500, 500, 833, 778, 333,
    333, 333, 500, 675, 250, 675, 250, 278, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 333, 333,
    675, 675, 675, 500, 920, 611, 611, 667, 722, 611,
    611, 722, 722, 333, 444, 667, 556, 833, 667, 722,
    611, 722, 611, 500, 556, 722, 611, 833, 611, 556,
    556, 389, 278, 389, 422, 500, 333, 500, 500, 444,
    500, 444, 278, 500, 500, 278, 278, 444, 278, 722,
    500, 500, 500, 500, 389, 389, 278, 500, 444, 667,
    444, 444, 389, 400, 275, 400, 541, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 389, 500, 500, 500, 500, 275, 500, 333, 760,
    276, 500, 675, 333, 760, 333, 400, 675, 300, 300,
    333, 500, 523, 250, 333, 300, 310, 500, 750, 750,
    750, 500, 611, 611, 611, 611, 611, 611, 889, 667,
    611, 611, 611, 611, 333, 333, 333, 333, 722, 667,
    722, 722, 722, 722, 722, 675, 722, 722, 722, 722,
    722, 556, 611, 500, 500, 500, 500, 500, 500, 500,
    667, 444, 444, 444, 444, 444, 278, 278, 278, 278,
    500, 500, 500, 500, 500, 500, 500, 675, 500, 500,
    500, 500, 500, 444, 500, 444
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 39, 144, 2, 31, 79, 76, 151,
    42, 16, 128, 86, -4, 86, 27, -65,
    32, 49, 12, 15, 1, 15, 30, 75,
    30, 23, 50, 27, 84, 86, 84, 132,
    118, -51, -8, 66, -8, -1, 8, 52,
    -8, -8, -6, 7, -8, -18, -20, 60,
    0, 59, -13, 17, 59, 102, 76, 71,
    -29, 78, -6, 21, -41, 12, 0, 0,
    171, 17, 23, 30, 15, 31, -147, 8,
    19, 49, -124, 14, 41, 12, 14, 27,
    -75, 25, 45, 16, 37, 42, 21, 16,
    -27, -24, -2, 51, 105, -7, 40, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 59, 77, 10, -22, 27, 105, 53,
    107, 41, 42, 53, 86, 49, 41, 99,
    101, 86, 33, 43, 180, -30, 55, 70,
    -30, 43, 67, 55, 33, 34, 23, 28,
    -51, -51, -51, -51, -51, -51, -27, 66,
    -1, -1, -1, -1, -8, -8, -8, -8,
    -8, -20, 60, 60, 60, 60, 60, 93,
    60, 102, 102, 102, 102, 78, 0, -168,
    17, 17, 17, 17, 17, 17, 23, 26,
    31, 31, 31, 31, 49, 49, 34, 49,
    27, 14, 27, 27, 27, 27, 27, 86,
    28, 42, 42, 42, 42, -24, -75, -24
  },
  2, 2,
  1,
  true},
{
  "Times-Bold",			/* #10 */
  NULL,
  NULL,
  "times-bold-r-normal",
  NULL,
  25093, 1, 0, 3, 14,
  935, 218,
  676,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 555, 500, 500, 1000, 833, 333,
    333, 333, 500, 570, 250, 570, 250, 278, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 333, 333,
    570, 570, 570, 500, 930, 722, 667, 722, 722, 667,
    611, 778, 778, 389, 500, 778, 667, 944, 722, 778,
    611, 778, 722, 556, 667, 722, 722, 1000, 722, 722,
    667, 333, 278, 333, 581, 500, 333, 500, 556, 444,
    556, 444, 333, 500, 556, 278, 333, 556, 278, 833,
    556, 500, 556, 556, 444, 389, 333, 556, 500, 722,
    500, 500, 444, 394, 220, 394, 520, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 333, 500, 500, 500, 500, 220, 500, 333, 747,
    300, 500, 570, 333, 747, 333, 400, 570, 300, 300,
    333, 556, 540, 250, 333, 300, 330, 500, 750, 750,
    750, 500, 722, 722, 722, 722, 722, 722, 1000, 722,
    667, 667, 667, 667, 389, 389, 389, 389, 722, 722,
    778, 778, 778, 778, 778, 570, 778, 722, 722, 722,
    722, 722, 611, 556, 500, 500, 500, 500, 500, 500,
    722, 444, 444, 444, 444, 444, 278, 278, 278, 278,
    500, 556, 500, 500, 500, 500, 500, 570, 500, 556,
    556, 556, 556, 500, 556, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 81, 83, 4, 29, 124, 62, 79,
    46, 27, 56, 33, 39, 33, 41, -24,
    24, 65, 17, 16, 19, 22, 28, 17,
    28, 26, 82, 82, 31, 33, 31, 57,
    108, 9, 16, 49, 14, 16, 16, 37,
    21, 20, 3, 30, 19, 14, 16, 35,
    16, 35, 26, 35, 31, 16, 16, 19,
    16, 15, 28, 67, -25, 32, 73, 0,
    70, 25, 17, 25, 25, 25, 14, 28,
    16, 16, -57, 22, 16, 16, 21, 25,
    19, 34, 29, 25, 20, 16, 21, 23,
    12, 16, 21, 22, 66, 54, 29, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 82, 53, 21, -26, -64, 66, 57,
    -2, 26, -1, 23, 33, 44, 26, 1,
    57, 33, 0, 3, 86, 33, 0, 41,
    68, 28, 18, 27, 28, -7, 23, 55,
    9, 9, 9, 9, 9, 9, 4, 49,
    16, 16, 16, 16, 20, 20, 20, 20,
    6, 16, 35, 35, 35, 35, 35, 48,
    35, 16, 16, 16, 16, 15, 16, 19,
    25, 25, 25, 25, 25, 25, 33, 25,
    25, 25, 25, 25, -26, 16, -36, -36,
    25, 21, 25, 25, 25, 25, 25, 33,
    25, 16, 16, 16, 16, 16, 19, 16
  },
  2, 3,
  2,
  true},
{
  "Times-BoldItalic",		/* #11 */
  NULL,
  NULL,
  "times-bold-i-normal",
  NULL,
  25093, 1, 1, 3, 14,
  921, 218,
  669,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 389, 555, 500, 500, 833, 778, 333,
    333, 333, 500, 570, 250, 606, 250, 278, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 333, 333,
    570, 570, 570, 500, 832, 667, 667, 667, 722, 667,
    667, 722, 778, 389, 500, 667, 611, 889, 722, 722,
    611, 722, 667, 556, 611, 722, 667, 889, 667, 611,
    611, 333, 278, 333, 570, 500, 333, 500, 500, 444,
    500, 444, 333, 500, 556, 278, 278, 500, 278, 778,
    556, 500, 500, 500, 389, 389, 278, 556, 444, 667,
    500, 444, 389, 348, 220, 348, 570, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 389, 500, 500, 500, 500, 220, 500, 333, 747,
    266, 500, 606, 333, 747, 333, 400, 570, 300, 300,
    333, 576, 500, 250, 333, 300, 300, 500, 750, 750,
    750, 500, 667, 667, 667, 667, 667, 667, 944, 667,
    667, 667, 667, 667, 389, 389, 389, 389, 722, 722,
    722, 722, 722, 722, 722, 570, 722, 722, 722, 722,
    722, 611, 611, 500, 500, 500, 500, 500, 500, 500,
    722, 444, 444, 444, 444, 444, 278, 278, 278, 278,
    500, 556, 500, 500, 500, 500, 500, 570, 500, 556,
    556, 556, 556, 444, 500, 444
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 67, 136, -33, -20, 39, 5, 98,
    28, -44, 65, 33, -60, 51, -9, -64,
    17, 5, -27, -15, -15, -11, 23, 52,
    3, -12, 23, -25, 31, 33, 31, 79,
    63, -67, -24, 32, -46, -27, -13, 21,
    -24, -32, -46, -21, -22, -29, -27, 27,
    -27, 27, -29, 2, 50, 67, 65, 65,
    -24, 73, -11, -37, -1, -56, 67, 0,
    128, -21, -14, -5, -21, 5, -169, -52,
    -13, 2, -189, -23, 2, -14, -6, -3,
    -120, 1, -21, -19, -11, 15, 16, 16,
    -46, -94, -43, 5, 66, -129, 54, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 19, 42, -32, -26, 33, 66, 36,
    55, 30, 16, 12, 51, 2, 30, 51,
    83, 33, 2, 17, 139, -60, -57, 51,
    -80, 30, 56, 12, 7, -9, 7, 30,
    -67, -67, -67, -67, -67, -67, -64, 32,
    -27, -27, -27, -27, -32, -32, -32, -32,
    -31, -27, 27, 27, 27, 27, 27, 48,
    27, 67, 67, 67, 67, 73, -27, -200,
    -21, -21, -21, -21, -21, -21, -5, -24,
    5, 5, 5, 5, 2, 2, -2, 2,
    -3, -6, -3, -3, -3, -3, -3, 33,
    -3, 15, 15, 15, 15, -94, -120, -94
  },
  2, 4,
  3,
  true},
{
  "AvantGarde-Book",		/* #12 */
  NULL,
  NULL,
  "itc avant garde gothic-book-r-normal", /* as used e.g. by SGI */
  "avantgarde-book-r-normal",	/* as used e.g. by SunOS */
  24607, 1, 0, 0, 14,
  955, 222,
  740,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 277, 295, 309, 554, 554, 775, 757, 351,
    369, 369, 425, 606, 277, 606, 277, 437, 554, 554,
    554, 554, 554, 554, 554, 554, 554, 554, 277, 277,
    606, 606, 606, 591, 867, 740, 574, 813, 744, 536,
    485, 872, 683, 226, 482, 591, 462, 919, 740, 869,
    592, 871, 607, 498, 426, 655, 702, 960, 609, 592,
    480, 351, 605, 351, 606, 500, 351, 683, 682, 647,
    685, 650, 314, 673, 610, 200, 203, 502, 200, 938,
    610, 655, 682, 682, 301, 388, 339, 608, 554, 831,
    480, 536, 425, 351, 672, 351, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    277, 295, 554, 554, 554, 554, 672, 615, 369, 747,
    369, 425, 606, 332, 747, 485, 400, 606, 332, 332,
    375, 608, 564, 277, 324, 332, 369, 425, 831, 831,
    831, 591, 740, 740, 740, 740, 740, 740, 992, 813,
    536, 536, 536, 536, 226, 226, 226, 226, 790, 740,
    869, 869, 869, 869, 869, 606, 868, 655, 655, 655,
    655, 592, 592, 554, 683, 683, 683, 683, 683, 683,
    1157, 647, 650, 650, 650, 650, 200, 200, 200, 200,
    655, 610, 655, 655, 655, 655, 655, 606, 653, 608,
    608, 608, 608, 536, 682, 536
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 111, 36, 33, 70, 21, 56, 94,
    47, 14, 58, 51, 14, 51, 102, 44,
    29, 135, 40, 34, 14, 26, 24, 63,
    41, 24, 102, 14, 46, 51, 52, 64,
    65, 12, 74, 43, 74, 70, 70, 40,
    76, 76, 6, 81, 82, 76, 75, 43,
    75, 40, 70, 22, 6, 75, 8, 11,
    8, 1, 12, 133, 118, 14, 53, 0,
    95, 42, 68, 41, 39, 38, 19, 37,
    62, 65, -44, 70, 65, 66, 65, 42,
    64, 37, 65, 24, 14, 62, 7, 13,
    12, 15, 10, 70, 299, 20, 72, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 110, 48, 4, 8, 4, 299, 85,
    73, -9, -3, 40, 51, 30, -9, 73,
    56, 51, 19, 18, 78, 80, 22, 102,
    80, 63, 12, 39, 100, 81, 46, 65,
    12, 12, 12, 12, 12, 12, -20, 43,
    70, 70, 70, 70, -47, 44, -64, 2,
    40, 75, 43, 43, 43, 43, 43, 74,
    43, 75, 75, 75, 75, 1, 60, 61,
    42, 42, 42, 42, 42, 42, 34, 41,
    38, 38, 38, 38, -60, 31, -77, -11,
    42, 65, 42, 42, 42, 42, 42, 51,
    41, 62, 62, 62, 62, 15, 64, 15
  },
  3, 1,
  4,
  true},
{
  "AvantGarde-BookOblique",	/* #13 */
  NULL,
  NULL,
  "itc avant garde gothic-book-o-normal",
  "avantgarde-book-o-normal",
  24607, 1, 1, 0, 14,
  955, 222,
  740,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 277, 295, 309, 554, 554, 775, 757, 351,
    369, 369, 425, 606, 277, 606, 277, 437, 554, 554,
    554, 554, 554, 554, 554, 554, 554, 554, 277, 277,
    606, 606, 606, 591, 867, 740, 574, 813, 744, 536,
    485, 872, 683, 226, 482, 591, 462, 919, 740, 869,
    592, 871, 607, 498, 426, 655, 702, 960, 609, 592,
    480, 351, 605, 351, 606, 500, 351, 683, 682, 647,
    685, 650, 314, 673, 610, 200, 203, 502, 200, 938,
    610, 655, 682, 682, 301, 388, 339, 608, 554, 831,
    480, 536, 425, 351, 672, 351, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    277, 295, 554, 554, 554, 554, 672, 615, 369, 747,
    369, 425, 606, 332, 747, 485, 400, 606, 332, 332,
    375, 608, 564, 277, 324, 332, 369, 425, 831, 831,
    831, 591, 740, 740, 740, 740, 740, 740, 992, 813,
    536, 536, 536, 536, 226, 226, 226, 226, 790, 740,
    869, 869, 869, 869, 869, 606, 868, 655, 655, 655,
    655, 592, 592, 554, 683, 683, 683, 683, 683, 683,
    1157, 647, 650, 650, 650, 650, 200, 200, 200, 200,
    655, 610, 655, 655, 655, 655, 655, 606, 653, 608,
    608, 608, 608, 536, 682, 536
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 111, 130, 71, 107, 124, 92, 195,
    89, -24, 170, 92, 2, 92, 102, 25,
    71, 260, 40, 73, 39, 69, 65, 110,
    77, 111, 102, 2, 87, 73, 51, 158,
    126, 12, 74, 105, 74, 70, 70, 103,
    76, 76, 37, 81, 82, 76, 75, 105,
    75, 102, 70, 57, 131, 118, 145, 148,
    8, 138, 12, 145, 255, -19, 110, -23,
    232, 88, 68, 87, 85, 84, 104, 56,
    62, 65, -80, 70, 65, 66, 65, 88,
    28, 83, 65, 49, 104, 100, 108, 114,
    12, 97, 10, 115, 280, -15, 114, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 74, 115, 29, 24, 75, 280, 118,
    191, 53, 102, 92, 110, 76, 53, 197,
    158, 47, 74, 98, 203, 46, 119, 137,
    52, 190, 116, 60, 183, 164, 126, 64,
    12, 12, 12, 12, 12, 12, -20, 105,
    70, 70, 70, 70, 76, 76, 76, 76,
    104, 75, 105, 105, 105, 105, 105, 87,
    76, 118, 118, 118, 118, 138, 60, 61,
    88, 88, 88, 88, 88, 88, 80, 87,
    84, 84, 84, 84, 65, 65, 41, 65,
    88, 65, 88, 88, 88, 88, 88, 92,
    51, 100, 100, 100, 100, 97, 28, 97
  },
  3, 2,
  5,
  true},
{
  "AvantGarde-Demi",		/* #14 */
  NULL,
  NULL,
  "itc avant garde gothic-demi-r-normal",
  "avantgarde-demi-r-normal",
  24607, 1, 0, 2, 14,
  1021, 251,
  740,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 280, 280, 360, 560, 560, 860, 680, 280,
    380, 380, 440, 600, 280, 600, 280, 460, 560, 560,
    560, 560, 560, 560, 560, 560, 560, 560, 280, 280,
    600, 600, 600, 560, 740, 740, 580, 780, 700, 520,
    480, 840, 680, 280, 480, 620, 440, 900, 740, 840,
    560, 840, 580, 520, 420, 640, 700, 900, 680, 620,
    500, 320, 640, 320, 600, 500, 280, 660, 660, 640,
    660, 640, 280, 660, 600, 240, 260, 580, 240, 940,
    600, 640, 660, 660, 320, 440, 300, 600, 560, 800,
    560, 580, 460, 340, 600, 340, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    280, 280, 560, 560, 560, 560, 600, 560, 500, 740,
    360, 460, 600, 420, 740, 420, 400, 600, 336, 336,
    420, 576, 600, 280, 340, 336, 360, 460, 840, 840,
    840, 560, 740, 740, 740, 740, 740, 740, 900, 780,
    520, 520, 520, 520, 280, 280, 280, 280, 742, 740,
    840, 840, 840, 840, 840, 600, 840, 640, 640, 640,
    640, 620, 560, 600, 660, 660, 660, 660, 660, 660,
    1080, 640, 640, 640, 640, 640, 240, 240, 240, 240,
    640, 600, 640, 640, 640, 640, 640, 600, 660, 600,
    600, 600, 600, 580, 660, 580
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 73, 19, 29, 58, 36, 34, 72,
    74, 37, 67, 48, 73, 48, 73, 6,
    32, 137, 36, 28, 15, 25, 23, 62,
    33, 24, 73, 73, 46, 48, 46, 38,
    50, 7, 70, 34, 63, 61, 61, 27,
    71, 72, 2, 89, 72, 63, 70, 33,
    72, 32, 64, 12, 6, 55, 8, 7,
    4, -2, 19, 66, 96, 36, 73, 0,
    72, 27, 47, 37, 34, 31, 15, 32,
    54, 53, 16, 80, 54, 54, 54, 25,
    47, 31, 63, 19, 21, 50, 3, 11,
    3, 8, 20, -3, 233, 23, 67, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 74, 43, -2, 27, -10, 233, 28,
    78, -12, 19, 61, 48, 71, -12, 72,
    57, 48, 13, 8, 91, 38, -7, 73,
    98, 72, 23, 61, 92, 62, 18, 68,
    7, 7, 7, 7, 7, 7, -5, 34,
    61, 61, 61, 61, -45, 46, -59, -32,
    25, 70, 33, 33, 33, 33, 33, 59,
    33, 55, 55, 55, 55, -2, 72, 51,
    27, 27, 27, 27, 27, 27, 29, 37,
    31, 31, 31, 31, -65, 26, -79, -52,
    27, 54, 25, 25, 25, 25, 25, 48,
    35, 50, 50, 50, 50, 8, 47, 8
  },
  3, 3,
  6,
  true},
{
  "AvantGarde-DemiOblique",	/* #15 */
  NULL,
  NULL,
  "itc avant garde gothic-demi-o-normal",
  "avantgarde-demi-o-normal",
  24607, 1, 1, 2, 14,
  1021, 251,
  740,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 280, 280, 360, 560, 560, 860, 680, 280,
    380, 380, 440, 600, 280, 600, 280, 460, 560, 560,
    560, 560, 560, 560, 560, 560, 560, 560, 280, 280,
    600, 600, 600, 560, 740, 740, 580, 780, 700, 520,
    480, 840, 680, 280, 480, 620, 440, 900, 740, 840,
    560, 840, 580, 520, 420, 640, 700, 900, 680, 620,
    500, 320, 640, 320, 600, 500, 280, 660, 660, 640,
    660, 640, 280, 660, 600, 240, 260, 580, 240, 940,
    600, 640, 660, 660, 320, 440, 300, 600, 560, 800,
    560, 580, 460, 340, 600, 340, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    280, 280, 560, 560, 560, 560, 600, 560, 500, 740,
    360, 460, 600, 420, 740, 420, 400, 600, 336, 336,
    420, 576, 600, 280, 340, 336, 360, 460, 840, 840,
    840, 560, 740, 740, 740, 740, 740, 740, 900, 780,
    520, 520, 520, 520, 280, 280, 280, 280, 742, 740,
    840, 840, 840, 840, 840, 600, 840, 640, 640, 640,
    640, 620, 560, 600, 660, 660, 660, 660, 660, 660,
    1080, 640, 640, 640, 640, 640, 240, 240, 240, 240,
    640, 600, 640, 640, 640, 640, 640, 600, 660, 600,
    600, 600, 600, 580, 660, 580
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 73, 127, 66, 99, 139, 71, 159,
    120, 8, 174, 84, 48, 84, 73, -13,
    70, 230, 44, 67, 36, 64, 64, 83,
    71, 110, 73, 48, 84, 63, 45, 135,
    109, 7, 70, 97, 63, 61, 61, 89,
    71, 72, 34, 89, 72, 63, 70, 95,
    72, 94, 64, 49, 119, 97, 145, 144,
    4, 135, 19, 89, 233, 7, 142, -23,
    158, 73, 47, 84, 80, 77, 62, 33,
    54, 53, -18, 80, 54, 54, 54, 71,
    13, 78, 63, 49, 86, 87, 106, 114,
    3, 75, 20, 40, 214, -12, 114, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 40, 110, 38, 53, 83, 214, 65,
    196, 50, 127, 105, 105, 114, 50, 192,
    160, 37, 73, 87, 224, 3, 90, 108,
    67, 182, 131, 81, 187, 157, 97, 69,
    7, 7, 7, 7, 7, 7, -5, 97,
    61, 61, 61, 61, 72, 72, 72, 72,
    83, 70, 95, 95, 95, 95, 95, 76,
    94, 97, 97, 97, 97, 135, 72, 51,
    73, 73, 73, 73, 73, 73, 75, 83,
    77, 77, 77, 77, 53, 53, 39, 53,
    73, 54, 71, 71, 71, 71, 71, 84,
    81, 87, 87, 87, 87, 75, 13, 75
  },
  3, 4,
  7,
  true},
{
  "Bookman-Light",		/* #16 */
  NULL,
  NULL,
  "itc bookman-light-r-normal",	/* as used e.g. by SGI */
  "bookman-light-r-normal",	/* our former convention, from SunOS */
  24607, 1, 0, -3, 14,
  908, 251,
  681,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 320, 300, 380, 620, 620, 900, 800, 220,
    300, 300, 440, 600, 320, 600, 320, 600, 620, 620,
    620, 620, 620, 620, 620, 620, 620, 620, 320, 320,
    600, 600, 600, 540, 820, 680, 740, 740, 800, 720,
    640, 800, 800, 340, 600, 720, 600, 920, 740, 800,
    620, 820, 720, 660, 620, 780, 700, 960, 720, 640,
    640, 300, 600, 300, 600, 500, 220, 580, 620, 520,
    620, 520, 320, 540, 660, 300, 300, 620, 300, 940,
    660, 560, 620, 580, 440, 520, 380, 680, 520, 780,
    560, 540, 480, 280, 600, 280, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    320, 300, 620, 620, 620, 620, 600, 520, 420, 740,
    420, 360, 600, 400, 740, 440, 400, 600, 372, 372,
    340, 680, 600, 320, 320, 372, 420, 360, 930, 930,
    930, 540, 680, 680, 680, 680, 680, 680, 1260, 740,
    720, 720, 720, 720, 340, 340, 340, 340, 800, 740,
    800, 800, 800, 800, 800, 600, 800, 780, 780, 780,
    780, 640, 620, 660, 580, 580, 580, 580, 580, 580,
    860, 520, 520, 520, 520, 520, 300, 300, 300, 300,
    560, 660, 560, 560, 560, 560, 560, 600, 560, 680,
    680, 680, 680, 540, 620, 540
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 75, 56, 65, 34, 22, 45, 46,
    76, 17, 54, 51, 90, 51, 92, 74,
    40, 160, 42, 40, 25, 60, 45, 60,
    44, 37, 92, 90, 49, 51, 48, 27,
    55, -37, 31, 44, 31, 31, 31, 44,
    31, 31, -23, 31, 31, 26, 26, 44,
    31, 44, 31, 28, -37, 25, -30, -30,
    -30, -30, 10, 92, 74, 41, 52, 0,
    46, 35, -2, 37, 37, 37, 20, 17,
    20, 20, -109, 20, 20, 17, 20, 37,
    20, 37, 20, 40, 20, 20, -23, -19,
    -16, -23, 7, 21, 264, 21, 52, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 75, 116, 8, 58, -22, 264, 33,
    68, 24, 49, 51, 51, 50, 23, 68,
    50, 51, 20, 12, 68, 20, 14, 92,
    68, 80, 56, 51, 80, 80, 52, 23,
    -37, -37, -37, -37, -37, -37, -36, 44,
    31, 31, 31, 31, 31, 31, 28, 28,
    31, 26, 44, 44, 44, 44, 44, 51,
    44, 25, 25, 25, 25, -30, 31, -109,
    35, 35, 35, 35, 35, 35, 35, 37,
    37, 37, 37, 37, 20, 20, 8, 8,
    37, 20, 37, 37, 37, 37, 37, 51,
    37, 20, 20, 20, 20, -23, 20, -23
  },
  4, 1,
  8,
  true},
{
  "Bookman-LightItalic",	/* #17 */
  NULL,
  NULL,
  "itc bookman-light-i-normal",
  "bookman-light-i-normal",
  24607, 1, 1, -3, 14,
  883, 250,
  681,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 300, 320, 360, 620, 620, 800, 820, 280,
    280, 280, 440, 600, 300, 600, 300, 600, 620, 620,
    620, 620, 620, 620, 620, 620, 620, 620, 300, 300,
    600, 600, 600, 540, 780, 700, 720, 720, 740, 680,
    620, 760, 800, 320, 560, 720, 580, 860, 720, 760,
    600, 780, 700, 640, 600, 720, 680, 960, 700, 660,
    580, 260, 600, 260, 600, 500, 280, 620, 600, 480,
    640, 540, 340, 560, 620, 280, 280, 600, 280, 880,
    620, 540, 600, 560, 400, 540, 340, 620, 540, 880,
    540, 600, 520, 360, 600, 380, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    300, 320, 620, 620, 620, 620, 600, 620, 420, 740,
    440, 300, 600, 320, 740, 440, 400, 600, 372, 372,
    320, 620, 620, 300, 320, 372, 400, 300, 930, 930,
    930, 540, 700, 700, 700, 700, 700, 700, 1220, 720,
    680, 680, 680, 680, 320, 320, 320, 320, 740, 720,
    760, 760, 760, 760, 760, 600, 760, 720, 720, 720,
    720, 660, 600, 620, 620, 620, 620, 620, 620, 620,
    880, 480, 540, 540, 540, 540, 280, 280, 280, 280,
    540, 620, 540, 540, 540, 540, 540, 600, 540, 620,
    620, 620, 620, 600, 600, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 103, 107, 107, 78, 56, 65, 148,
    96, -8, 139, 91, 88, 91, 96, 104,
    86, 154, 66, 55, 69, 70, 89, 143,
    61, 77, 96, 88, 79, 91, 93, 114,
    102, -25, 21, 88, 21, 21, 21, 88,
    21, 21, -2, 21, 21, 18, 18, 88,
    21, 61, 21, 61, 50, 118, 87, 87,
    -25, 87, 8, 56, 84, 15, 97, 0,
    191, 71, 88, 65, 65, 65, -160, 4,
    88, 88, -200, 88, 100, 88, 88, 65,
    -24, 65, 88, 65, 88, 88, 88, 88,
    9, 60, 38, 122, 294, 13, 91, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 73, 148, 4, 100, 71, 294, 38,
    185, 84, 130, 70, 91, 78, 84, 178,
    120, 91, 68, 70, 178, 53, 112, 137,
    45, 114, 139, 60, 91, 91, 99, 18,
    -25, -25, -25, -25, -25, -25, -45, 88,
    21, 21, 21, 21, 21, 21, 21, 21,
    21, 18, 88, 88, 88, 88, 88, 91,
    88, 118, 118, 118, 118, 87, 21, -121,
    71, 71, 71, 71, 71, 71, 71, 65,
    65, 65, 65, 65, 88, 88, 76, 88,
    65, 88, 65, 65, 65, 65, 65, 91,
    65, 88, 88, 88, 88, 60, -24, 60
  },
  4, 2,
  9,
  true},
{
  "Bookman-Demi",		/* #18 */
  NULL,
  NULL,
  "itc bookman-demi-r-normal",
  "bookman-demi-r-normal",
  24607, 1, 0, 2, 14,
  934, 250,
  681,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 340, 360, 420, 660, 660, 940, 800, 320,
    320, 320, 460, 600, 340, 600, 340, 600, 660, 660,
    660, 660, 660, 660, 660, 660, 660, 660, 340, 340,
    600, 600, 600, 660, 820, 720, 720, 740, 780, 720,
    680, 780, 820, 400, 640, 800, 640, 940, 740, 800,
    660, 800, 780, 660, 700, 740, 720, 940, 780, 700,
    640, 300, 600, 300, 600, 500, 320, 580, 600, 580,
    640, 580, 380, 580, 680, 360, 340, 660, 340, 1000,
    680, 620, 640, 620, 460, 520, 460, 660, 600, 800,
    600, 620, 560, 320, 600, 320, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    340, 360, 660, 660, 660, 660, 600, 600, 500, 740,
    400, 400, 600, 360, 740, 460, 400, 600, 396, 396,
    400, 660, 800, 340, 360, 396, 400, 400, 990, 990,
    990, 660, 720, 720, 720, 720, 720, 720, 1140, 740,
    720, 720, 720, 720, 400, 400, 400, 400, 780, 740,
    800, 800, 800, 800, 800, 600, 800, 740, 740, 740,
    740, 700, 660, 660, 580, 580, 580, 580, 580, 580,
    880, 580, 580, 580, 580, 580, 360, 360, 360, 360,
    620, 680, 620, 620, 620, 620, 620, 600, 620, 660,
    660, 660, 660, 620, 640, 620
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 82, 11, 84, 48, 12, 21, 82,
    48, 20, 62, 51, 78, 51, 76, 50,
    30, 137, 41, 37, 19, 44, 34, 36,
    36, 33, 76, 75, 49, 51, 48, 61,
    60, -34, 20, 35, 20, 20, 20, 35,
    20, 20, -12, 20, 20, 20, 20, 35,
    20, 35, 20, 21, -4, 15, -20, -20,
    1, -20, 6, 75, 50, 21, 52, 0,
    82, 28, -20, 31, 31, 31, 22, 9,
    22, 22, -94, 22, 9, 22, 22, 31,
    22, 31, 22, 22, 22, 22, -6, -6,
    8, 6, 22, 14, 243, 15, 51, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 84, 133, 10, 77, -28, 243, 36,
    68, 23, 27, 34, 51, 20, 23, 68,
    50, 51, 14, 5, 68, 22, 51, 76,
    68, 65, 17, 34, 65, 65, 15, 62,
    -34, -34, -34, -34, -34, -34, -34, 35,
    20, 20, 20, 20, 20, 20, 18, 18,
    20, 20, 35, 35, 35, 35, 35, 48,
    35, 15, 15, 15, 15, -20, 20, -61,
    28, 28, 28, 28, 28, 28, 28, 31,
    31, 31, 31, 31, 22, 22, -2, -2,
    31, 22, 31, 31, 31, 31, 31, 51,
    31, 22, 22, 22, 22, 6, 22, 6
  },
  4, 3,
  10,
  true},
{
  "Bookman-DemiItalic",		/* #19 */
  NULL,
  NULL,
  "itc bookman-demi-i-normal",
  "bookman-demi-i-normal",
  24607, 1, 1, 2, 14,
  941, 250,
  681,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 340, 320, 380, 680, 680, 880, 980, 320,
    260, 260, 460, 600, 340, 600, 340, 360, 680, 680,
    680, 680, 680, 680, 680, 680, 680, 680, 340, 340,
    620, 600, 620, 620, 780, 720, 720, 700, 760, 720,
    660, 760, 800, 380, 620, 780, 640, 860, 740, 760,
    640, 760, 740, 700, 700, 740, 660, 1000, 740, 660,
    680, 260, 580, 260, 620, 500, 320, 680, 600, 560,
    680, 560, 420, 620, 700, 380, 320, 700, 380, 960,
    680, 600, 660, 620, 500, 540, 440, 680, 540, 860,
    620, 600, 560, 300, 620, 300, 620, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    340, 320, 680, 680, 680, 680, 620, 620, 520, 780,
    440, 380, 620, 280, 780, 480, 400, 600, 408, 408,
    340, 680, 680, 340, 360, 408, 440, 380, 1020, 1020,
    1020, 620, 720, 720, 720, 720, 720, 720, 1140, 700,
    720, 720, 720, 720, 380, 380, 380, 380, 760, 740,
    760, 760, 760, 760, 760, 600, 760, 740, 740, 740,
    740, 660, 640, 660, 680, 680, 680, 680, 680, 680,
    880, 560, 560, 560, 560, 560, 380, 380, 380, 380,
    600, 680, 600, 600, 600, 600, 600, 600, 600, 680,
    680, 680, 680, 600, 660, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 86, 140, 157, 45, 106, 48, 171,
    31, -35, 126, 91, 100, 91, 106, 9,
    87, 123, 67, 72, 63, 78, 88, 123,
    68, 71, 106, 100, 79, 91, 89, 145,
    80, -27, 14, 78, 14, 14, 14, 77,
    14, 14, 8, 14, 14, 14, 14, 78,
    -6, 37, 14, 59, 70, 112, 72, 72,
    -7, 72, 23, 9, 73, -18, 92, 0,
    155, 84, 57, 58, 60, 59, -192, 21,
    93, 83, -160, 97, 109, 83, 83, 59,
    -24, 60, 84, 32, 106, 83, 56, 56,
    10, 25, 36, 49, 303, -8, 101, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 64, 161, 0, 148, 92, 303, 46,
    180, 83, 118, 62, 81, 59, 83, 177,
    130, 91, 91, 86, 176, 54, 137, 126,
    68, 118, 127, 62, 118, 118, 86, 83,
    -27, -27, -27, -27, -27, -27, -27, 78,
    14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 78, 78, 78, 78, 78, 91,
    21, 112, 112, 112, 112, 72, -6, -231,
    84, 84, 84, 84, 84, 84, 39, 58,
    59, 59, 59, 59, 83, 83, 83, 83,
    59, 83, 59, 59, 59, 59, 59, 91,
    17, 83, 83, 83, 83, 25, -24, 25
  },
  4, 4, 
  11,
  true},
{
  "Courier",			/* #20 */
  "CourierPS",
  NULL,
  "courier-medium-r-normal",
  NULL,
  24579, 0, 0, 0, 14,
  805, 250,
  562,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 236, 187, 93, 105, 81, 63, 213,
    269, 160, 116, 80, 181, 80, 229, 125,
    106, 96, 70, 75, 78, 92, 111, 82,
    102, 96, 229, 181, 41, 80, 66, 129,
    77, 3, 43, 41, 43, 53, 53, 31,
    32, 96, 34, 38, 47, 4, 7, 43,
    79, 43, 38, 72, 38, 17, -4, -3,
    23, 24, 86, 269, 118, 158, 94, 0,
    224, 53, 14, 66, 45, 66, 114, 45,
    18, 95, 82, 43, 95, -5, 26, 62,
    9, 45, 60, 80, 87, 21, 10, -4,
    20, 7, 99, 182, 275, 163, 63, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 236, 96, 84, 73, 26, 275, 113,
    148, 0, 156, 37, 87, 103, 0, 120,
    123, 87, 177, 155, 242, 21, 50, 222,
    224, 172, 157, 37, 0, 0, 8, 108,
    3, 3, 3, 3, 3, 3, 3, 41,
    53, 53, 53, 53, 96, 96, 96, 96,
    30, 7, 43, 43, 43, 43, 43, 87,
    43, 17, 17, 17, 17, 24, 79, 48,
    53, 53, 53, 53, 53, 53, 19, 66,
    66, 66, 66, 66, 95, 95, 94, 95,
    62, 26, 62, 62, 62, 62, 62, 87,
    62, 21, 21, 21, 21, 7, -6, 7
  },
  5, 1,
  12,
  true},
{
  "Courier-Oblique",		/* #21 */
  "CourierPS-Oblique",
#ifndef USE_LJ_FONTS_IN_PS
  "Courier-Italic",		/* treat name of similar PCL font as alias */
#else
  NULL,
#endif
  "courier-medium-o-normal",
  NULL,
  24579, 0, 1, 0, 14,
  805, 250,
  562,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 243, 273, 133, 108, 134, 87, 283,
    313, 137, 212, 129, 157, 129, 238, 112,
    154, 98, 70, 82, 108, 99, 155, 182,
    132, 93, 238, 157, 96, 109, 85, 222,
    127, 3, 43, 93, 43, 53, 53, 83,
    32, 96, 52, 38, 47, 4, 7, 94,
    79, 95, 38, 76, 108, 125, 105, 106,
    23, 133, 86, 246, 249, 135, 175, -27,
    343, 76, 29, 106, 85, 106, 114, 61,
    33, 95, 52, 58, 95, -5, 26, 102,
    -24, 85, 60, 78, 167, 101, 90, 76,
    20, -4, 99, 233, 222, 140, 116, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 225, 151, 124, 94, 120, 238, 104,
    262, 53, 209, 92, 155, 152, 53, 232,
    214, 96, 230, 213, 348, 72, 100, 275,
    197, 231, 210, 58, 65, 65, 73, 105,
    3, 3, 3, 3, 3, 3, 3, 93,
    53, 53, 53, 53, 96, 96, 96, 96,
    43, 7, 94, 94, 94, 94, 94, 103,
    94, 125, 125, 125, 125, 133, 79, 48,
    76, 76, 76, 76, 76, 76, 41, 106,
    106, 106, 106, 106, 95, 95, 95, 95,
    102, 26, 102, 102, 102, 102, 102, 136,
    102, 101, 101, 101, 101, -4, -24, -4
  },
  5, 2, 
  13,
  true},
{
  "Courier-Bold",		/* #22 */
  "CourierPS-Bold",
  NULL,
  "courier-bold-r-normal",
  NULL,
  24579, 0, 0, 3, 14,
  801, 250,
  562,
    {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 202, 135, 56, 82, 5, 36, 171,
    219, 139, 91, 71, 123, 71, 192, 98,
    87, 81, 61, 63, 53, 70, 90, 55,
    83, 79, 191, 123, 66, 71, 77, 98,
    16, -9, 30, 22, 30, 25, 39, 22,
    20, 77, 37, 21, 39, -2, 8, 22,
    48, 32, 24, 47, 21, 4, -13, -18,
    12, 12, 62, 245, 99, 125, 108, 0,
    178, 35, 0, 40, 20, 40, 83, 30,
    5, 77, 63, 20, 77, -22, 18, 30,
    -1, 20, 47, 68, 47, -1, -1, -18,
    6, -4, 81, 160, 255, 136, 71, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 202, 66, 72, 54, 10, 255, 83,
    128, 0, 147, 8, 71, 100, 0, 88,
    86, 71, 143, 138, 205, -1, 6, 196,
    205, 153, 147, 47, -56, -47, -47, 99,
    -9, -9, -9, -9, -9, -9, -29, 22,
    25, 25, 25, 25, 77, 77, 77, 77,
    30, 8, 22, 22, 22, 22, 22, 81,
    22, 4, 4, 4, 4, 12, 48, 22,
    35, 35, 35, 35, 35, 35, -4, 40,
    40, 40, 40, 40, 77, 77, 63, 77,
    58, 18, 30, 30, 30, 30, 30, 71,
    30, -1, -1, -1, -1, -4, -14, -4
  },
  5, 3, 
  14,
  true},
{
  "Courier-BoldOblique",	/* #23 */
  "CourierPS-BoldOblique",
#ifndef USE_LJ_FONTS_IN_PS
  "Courier-BoldItalic",		/* treat name of similar PCL font as alias */
#else
  NULL,
#endif
  "courier-bold-o-normal",
  NULL,
  24579, 0, 1, 3, 14,
  801, 250,
  562,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600, 600, 600, 600, 600,
    600, 600, 600, 600, 600, 600
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 216, 212, 88, 87, 102, 62, 230,
    266, 117, 179, 114, 99, 114, 207, 91,
    136, 93, 61, 72, 82, 77, 136, 147,
    115, 76, 206, 99, 121, 96, 97, 183,
    66, -9, 30, 75, 30, 25, 39, 75,
    20, 77, 59, 21, 39, -2, 8, 74,
    48, 84, 24, 54, 86, 101, 84, 84,
    12, 109, 62, 223, 223, 103, 171, -27,
    297, 62, 13, 81, 61, 81, 83, 41,
    18, 77, 37, 33, 77, -22, 18, 71,
    -31, 61, 47, 67, 118, 70, 70, 53,
    6, -20, 81, 204, 202, 114, 120, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 197, 121, 107, 77, 98, 218, 74,
    244, 53, 189, 63, 135, 143, 53, 195,
    173, 76, 192, 193, 313, 50, 61, 249,
    169, 213, 189, 72, 14, 23, 8, 101,
    -9, -9, -9, -9, -9, -9, -29, 74,
    25, 25, 25, 25, 77, 77, 77, 77,
    30, 8, 74, 74, 74, 74, 74, 105,
    48, 101, 101, 101, 101, 109, 48, 22,
    62, 62, 62, 62, 62, 62, 21, 81,
    81, 81, 81, 81, 77, 77, 77, 77,
    93, 18, 71, 71, 71, 71, 71, 114,
    55, 70, 70, 70, 70, -20, -31, -20
  },
  5, 4,
  15,
  true},
{
  "NewCenturySchlbk-Roman",	/* #24 */
  NULL,
  NULL,
  "new century schoolbook-medium-r-normal",
  "newcenturyschlbk-medium-r-normal", /* name formerly used by DEC */
  24703, 1, 0, 0, 14,
  965, 250,
  722,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 296, 389, 556, 556, 833, 815, 204,
    333, 333, 500, 606, 278, 606, 278, 278, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 278, 278,
    606, 606, 606, 444, 737, 722, 722, 722, 778, 722,
    667, 778, 833, 407, 556, 778, 667, 944, 815, 778,
    667, 778, 722, 630, 667, 815, 722, 981, 704, 704,
    611, 333, 606, 333, 606, 500, 204, 556, 556, 444,
    574, 500, 333, 537, 611, 315, 296, 593, 315, 889,
    611, 500, 574, 556, 444, 463, 389, 611, 537, 778,
    537, 537, 481, 333, 606, 333, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 296, 556, 556, 556, 556, 606, 500, 333, 737,
    334, 426, 606, 333, 737, 333, 400, 606, 333, 333,
    333, 611, 606, 278, 333, 333, 300, 426, 834, 834,
    834, 444, 722, 722, 722, 722, 722, 722, 1000, 722,
    722, 722, 722, 722, 407, 407, 407, 407, 778, 815,
    778, 778, 778, 778, 778, 606, 778, 815, 815, 815,
    815, 704, 667, 574, 556, 556, 556, 556, 556, 556,
    796, 444, 500, 500, 500, 500, 315, 315, 315, 315,
    500, 611, 500, 500, 500, 500, 500, 606, 500, 611,
    611, 611, 611, 537, 574, 537
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 86, 61, 28, 45, 43, 51, 25,
    40, 54, 57, 50, 62, 50, 77, -32,
    42, 100, 35, 42, 28, 46, 41, 59,
    42, 41, 77, 62, 50, 50, 50, 29,
    -8, -8, 29, 45, 29, 29, 29, 45,
    29, 38, 5, 29, 29, 29, 24, 45,
    29, 45, 29, 47, 19, 16, -8, 5,
    -8, -11, 24, 126, 132, 18, 89, 0,
    25, 44, 10, 34, 34, 34, 18, 23,
    7, 18, -86, 10, 18, 26, 22, 34,
    22, 34, 18, 46, 18, 22, -6, 1,
    8, 4, 42, 54, 267, 54, 72, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 86, 74, 18, 26, -1, 267, 55,
    16, -8, -4, 39, 50, 42, -8, 10,
    57, 50, 14, 18, 91, 22, 60, 71,
    29, 39, 4, 39, 39, 39, 28, 29,
    -8, -8, -8, -8, -8, -8, 0, 45,
    29, 29, 29, 29, 38, 38, 38, 38,
    29, 24, 45, 45, 45, 45, 45, 74,
    45, 16, 16, 16, 16, -11, 29, 30,
    44, 44, 44, 44, 44, 44, 34, 34,
    34, 34, 34, 34, 8, 18, 1, 7,
    34, 22, 34, 34, 34, 34, 34, 50,
    34, 22, 22, 22, 22, 4, 22, 4
  },
  6, 1,
  24,
  true},
{
  "NewCenturySchlbk-Italic",	/* #25 */
  NULL,
  NULL,
  "new century schoolbook-medium-i-normal",
  "newcenturyschlbk-medium-i-normal",
  24703, 1, 1, 0, 14,
  958, 250,
  722,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 333, 400, 556, 556, 833, 852, 204,
    333, 333, 500, 606, 278, 606, 278, 606, 556, 556,
    556, 556, 556, 556, 556, 556, 556, 556, 278, 278,
    606, 606, 606, 444, 747, 704, 722, 722, 778, 722,
    667, 778, 833, 407, 611, 741, 667, 944, 815, 778,
    667, 778, 741, 667, 685, 815, 704, 926, 704, 685,
    667, 333, 606, 333, 606, 500, 204, 574, 556, 444,
    611, 444, 333, 537, 611, 333, 315, 556, 333, 889,
    611, 500, 574, 556, 444, 444, 352, 611, 519, 778,
    500, 500, 463, 333, 606, 333, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    278, 333, 556, 556, 556, 556, 606, 500, 333, 747,
    422, 426, 606, 333, 747, 333, 400, 606, 333, 333,
    333, 611, 650, 278, 333, 333, 372, 426, 834, 834,
    834, 444, 704, 704, 704, 704, 704, 704, 870, 722,
    722, 722, 722, 722, 407, 407, 407, 407, 778, 815,
    778, 778, 778, 778, 778, 606, 778, 815, 815, 815,
    815, 685, 667, 556, 574, 574, 574, 574, 574, 574,
    722, 444, 444, 444, 444, 444, 333, 333, 333, 333,
    500, 611, 500, 500, 500, 500, 500, 606, 500, 611,
    611, 611, 611, 500, 574, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 17, 127, 28, 4, 43, 24, 39,
    53, -93, 80, 50, -39, 50, 17, 132,
    30, 50, -37, -2, -8, 4, 36, 69,
    6, 8, 17, -39, 36, 50, 64, 102,
    -2, -87, -33, 40, -33, -33, -33, 40,
    -33, -33, -14, -33, -33, -33, -51, 40,
    -33, 40, -45, -6, 40, 93, 36, 53,
    -75, 31, -25, -55, 132, -77, 89, 0,
    39, 2, 32, 2, 2, -6, -68, -79,
    14, 29, -166, 0, 14, 14, 14, 2,
    -101, 2, 10, 2, 24, 44, 31, 31,
    -33, -83, -33, 38, 267, -87, 72, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -22, 62, -13, 26, 40, 267, -10,
    59, -2, 72, -15, 50, 32, -2, 52,
    86, 50, 0, 22, 132, -60, 48, 71,
    3, 34, 66, -15, 34, 34, 22, -3,
    -87, -87, -87, -87, -87, -87, -87, 40,
    -33, -33, -33, -33, -33, -33, -33, -33,
    -33, -51, 40, 40, 40, 40, 40, 74,
    16, 93, 93, 93, 93, 31, -33, -76,
    2, 2, 2, 2, 2, 2, -18, 2,
    -6, -6, -6, -6, 29, 29, 29, 29,
    2, 14, 2, 2, 2, 2, 2, 50,
    2, 44, 44, 44, 44, -83, -101, -83
  },
  6, 2,
  25,
  true},
{
  "NewCenturySchlbk-Bold",	/* #26 */
  NULL,
  NULL,
  "new century schoolbook-bold-r-normal",
  "newcenturyschlbk-bold-r-normal",
  24703, 1, 0, 3, 14,
  988, 250,
  722,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 287, 296, 333, 574, 574, 833, 852, 241,
    389, 389, 500, 606, 278, 606, 278, 278, 574, 574,
    574, 574, 574, 574, 574, 574, 574, 574, 278, 278,
    606, 606, 606, 500, 747, 759, 778, 778, 833, 759,
    722, 833, 870, 444, 648, 815, 722, 981, 833, 833,
    759, 833, 815, 667, 722, 833, 759, 981, 722, 722,
    667, 389, 606, 389, 606, 500, 241, 611, 648, 556,
    667, 574, 389, 611, 685, 370, 352, 667, 352, 963,
    685, 611, 667, 648, 519, 500, 426, 685, 611, 889,
    611, 611, 537, 389, 606, 389, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    287, 296, 574, 574, 574, 574, 606, 500, 333, 747,
    367, 500, 606, 333, 747, 333, 400, 606, 344, 344,
    333, 685, 747, 278, 333, 344, 367, 500, 861, 861,
    861, 500, 759, 759, 759, 759, 759, 759, 981, 778,
    759, 759, 759, 759, 444, 444, 444, 444, 833, 833,
    833, 833, 833, 833, 833, 606, 833, 833, 833, 833,
    833, 722, 759, 611, 611, 611, 611, 611, 611, 611,
    870, 556, 574, 574, 574, 574, 370, 370, 370, 370,
    611, 685, 611, 611, 611, 611, 611, 606, 611, 685,
    685, 685, 685, 611, 667, 611
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 53, 0, 36, 25, 14, 34, 22,
    77, 44, 54, 50, 40, 50, 44, -42,
    27, 83, 19, 23, 19, 32, 27, 45,
    27, 27, 44, 40, 50, 50, 50, 23,
    -2, -19, 19, 39, 19, 19, 19, 39,
    19, 29, 6, 19, 19, 10, 5, 39,
    24, 39, 19, 51, 16, 14, -19, 7,
    -12, -12, 28, 84, 122, 50, 66, 0,
    22, 40, 4, 32, 32, 32, 11, 30,
    17, 26, -86, 17, 17, 17, 17, 32,
    17, 32, 17, 48, 21, 17, 12, 16,
    12, 12, 38, 36, 249, 76, 72, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 53, 32, 16, 27, -10, 249, 62,
    -12, -2, 1, 46, 50, 42, -2, -6,
    57, 50, -3, -3, 84, 17, 96, 53,
    17, 31, 1, 46, 31, 31, 15, 23,
    -19, -19, -19, -19, -19, -19, -29, 39,
    19, 19, 19, 19, 29, 29, 29, 29,
    19, 5, 39, 39, 39, 39, 39, 65,
    39, 14, 14, 14, 14, -12, 24, -2,
    40, 40, 40, 40, 40, 40, 32, 32,
    32, 32, 32, 32, 21, 26, 9, 7,
    32, 17, 32, 32, 32, 32, 32, 50,
    32, 17, 17, 17, 17, 12, 17, 12
  },
  6, 3,
  26,
  true},
{
  "NewCenturySchlbk-BoldItalic", /* #27 */
  NULL,
  NULL,
  "new century schoolbook-bold-i-normal",
  "newcenturyschlbk-bold-i-normal",
  24703, 1, 1, 3, 14,
  991, 250,
  722,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 287, 333, 400, 574, 574, 889, 889, 259,
    407, 407, 500, 606, 287, 606, 287, 278, 574, 574,
    574, 574, 574, 574, 574, 574, 574, 574, 287, 287,
    606, 606, 606, 481, 747, 741, 759, 759, 833, 741,
    704, 815, 870, 444, 667, 778, 704, 944, 852, 833,
    741, 833, 796, 685, 722, 833, 741, 944, 741, 704,
    704, 407, 606, 407, 606, 500, 259, 667, 611, 537,
    667, 519, 389, 611, 685, 389, 370, 648, 389, 944,
    685, 574, 648, 630, 519, 481, 407, 685, 556, 833,
    574, 519, 519, 407, 606, 407, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    287, 333, 574, 574, 574, 574, 606, 500, 333, 747,
    412, 481, 606, 333, 747, 333, 400, 606, 344, 344,
    333, 685, 650, 287, 333, 344, 356, 481, 861, 861,
    861, 481, 741, 741, 741, 741, 741, 741, 889, 759,
    741, 741, 741, 741, 444, 444, 444, 444, 833, 852,
    833, 833, 833, 833, 833, 606, 833, 833, 833, 833,
    833, 704, 741, 574, 667, 667, 667, 667, 667, 667,
    815, 537, 519, 519, 519, 519, 389, 389, 389, 389,
    574, 685, 574, 574, 574, 574, 574, 606, 574, 685,
    685, 685, 685, 519, 648, 519
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 66, 30, 9, 54, 32, 48,
    72, -70, 58, 50, -57, 50, -20, -41,
    21, 25, -38, -7, -13, 0, 31, 64,
    0, 0, -20, -57, 50, 50, 50, 79,
    -4, -75, -50, 37, -47, -41, -41, 37,
    -41, -41, -20, -41, -41, -44, -61, 37,
    -41, 37, -41, 1, 41, 88, 32, 40,
    -82, 13, -33, 1, 161, -101, 66, 0,
    47, 6, 29, 0, 0, 0, -48, -63,
    0, 32, -205, -11, 32, 0, 0, 0,
    -119, 0, 0, 0, 24, 30, 30, 30,
    -46, -66, -19, 52, 249, -25, 72, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -44, 30, -18, 27, 17, 249, -30,
    33, -2, 47, -35, 50, 2, -2, 47,
    86, 50, -17, 3, 123, -89, 25, 57,
    -21, 19, 42, -31, 17, 17, 35, 0,
    -75, -75, -75, -75, -75, -75, -86, 37,
    -41, -41, -41, -41, -41, -41, -41, -41,
    -47, -61, 37, 37, 37, 37, 37, 65,
    35, 88, 88, 88, 88, 13, -41, -91,
    6, 6, 6, 6, 6, 6, -18, 0,
    0, 0, 0, 0, 32, 32, 21, 31,
    0, 0, 0, 0, 0, 0, 0, 50,
    0, 30, 30, 30, 30, -66, -119, -66
  },
  6, 4,
  27,
  true},
{
  "Palatino-Roman",		/* #28 */
  NULL,
  NULL,
  "palatino-medium-r-normal",
  NULL,
  24591, 1, 0, 0, 14,
  927, 283,
  692,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 278, 371, 500, 500, 840, 778, 278,
    333, 333, 389, 606, 250, 606, 250, 606, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 250, 250,
    606, 606, 606, 444, 747, 778, 611, 709, 774, 611,
    556, 763, 832, 337, 333, 726, 611, 946, 831, 786,
    604, 786, 668, 525, 613, 778, 722, 1000, 667, 667,
    667, 333, 606, 333, 606, 500, 278, 500, 553, 444,
    611, 479, 333, 556, 582, 291, 234, 556, 291, 883,
    582, 546, 601, 560, 395, 424, 326, 603, 565, 834,
    516, 556, 500, 333, 606, 333, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 278, 500, 500, 500, 500, 606, 500, 333, 747,
    333, 500, 606, 333, 747, 333, 400, 606, 300, 300,
    333, 603, 628, 250, 333, 300, 333, 500, 750, 750,
    750, 444, 778, 778, 778, 778, 778, 778, 944, 709,
    611, 611, 611, 611, 337, 337, 337, 337, 774, 831,
    786, 786, 786, 786, 786, 606, 833, 778, 778, 778,
    778, 667, 604, 556, 500, 500, 500, 500, 500, 500,
    758, 444, 479, 479, 479, 479, 287, 287, 287, 287,
    546, 582, 546, 546, 546, 546, 546, 606, 556, 603,
    603, 603, 603, 556, 601, 556
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 81, 52, 4, 30, 39, 43, 45,
    60, 32, 32, 51, 16, 51, 67, 87,
    29, 60, 16, 15, 2, 13, 32, 44,
    30, 20, 66, 16, 57, 51, 48, 43,
    24, 15, 26, 22, 22, 22, 22, 22,
    22, 22, -15, 22, 22, 16, 17, 22,
    22, 22, 22, 24, 18, 12, 8, 8,
    14, 9, 15, 79, 81, 45, 51, 0,
    45, 32, -15, 26, 35, 26, 23, 32,
    6, 21, -40, 21, 21, 16, 6, 32,
    8, 35, 21, 30, 22, 18, 6, 6,
    20, 12, 16, 58, 275, 44, 51, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 81, 61, 12, 30, 5, 275, 26,
    17, 11, 24, 50, 51, 17, 11, 11,
    50, 51, 0, 1, 78, 18, 39, 67,
    96, 31, 10, 50, 30, 15, 15, 43,
    15, 15, 15, 15, 15, 15, -10, 22,
    22, 22, 22, 22, 22, 22, 13, 19,
    14, 17, 22, 22, 22, 22, 22, 83,
    30, 12, 12, 12, 12, 9, 32, 23,
    32, 32, 32, 32, 32, 32, 30, 26,
    26, 26, 26, 26, 8, 21, -12, -6,
    32, 6, 32, 32, 32, 32, 32, 51,
    16, 18, 18, 18, 18, 12, -2, 12
  },
  7, 1,
  28,
  true},
{
  "Palatino-Italic",		/* #29 */
  NULL,
  NULL,
  "palatino-medium-i-normal",
  NULL,
  24591, 1, 1, 0, 14,
  918, 276,
  692,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 500, 500, 500, 889, 778, 278,
    333, 333, 389, 606, 250, 606, 250, 296, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 250, 250,
    606, 606, 606, 500, 747, 722, 611, 667, 778, 611,
    556, 722, 778, 333, 333, 667, 556, 944, 778, 778,
    611, 778, 667, 556, 611, 778, 722, 944, 722, 667,
    667, 333, 606, 333, 606, 500, 278, 444, 463, 407,
    500, 389, 278, 500, 500, 278, 278, 444, 278, 778,
    556, 444, 500, 463, 389, 389, 333, 556, 500, 722,
    500, 500, 444, 333, 606, 333, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 333, 500, 500, 500, 500, 606, 500, 333, 747,
    333, 500, 606, 333, 747, 333, 400, 606, 300, 300,
    333, 556, 500, 250, 333, 300, 333, 500, 750, 750,
    750, 500, 722, 722, 722, 722, 722, 722, 941, 667,
    611, 611, 611, 611, 333, 333, 333, 333, 778, 778,
    778, 778, 778, 778, 778, 606, 778, 778, 778, 778,
    778, 667, 611, 500, 444, 444, 444, 444, 444, 444,
    638, 407, 389, 389, 389, 389, 278, 278, 278, 278,
    444, 556, 444, 444, 444, 444, 444, 606, 444, 556,
    556, 556, 556, 500, 500, 500
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 76, 140, 4, 15, 74, 47, 78,
    54, 2, 76, 51, 8, 51, 53, -40,
    36, 54, 12, 22, 15, 14, 49, 53,
    36, 32, 44, -9, 53, 51, 53, 114,
    27, -19, 26, 45, 28, 30, 0, 50,
    -3, 7, -35, 13, 16, -19, 2, 53,
    9, 53, 9, 42, 53, 88, 75, 71,
    20, 52, 20, 18, 81, 7, 51, 0,
    78, 4, 37, 25, 17, 15, -162, -37,
    10, 34, -70, 8, 36, 24, 24, 17,
    -7, 24, 26, 9, 41, 32, 21, 21,
    9, -8, -1, 15, 275, 14, 51, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 56, 2, 14, 35, 275, 14,
    78, 11, 60, 57, 51, 19, 11, 74,
    90, 51, 13, 28, 122, 15, 33, 53,
    -9, 61, 66, 63, 31, 31, 35, 57,
    -19, -19, -19, -19, -19, -19, -4, 45,
    30, 30, 30, 30, 7, 7, 7, 7,
    19, 2, 53, 53, 53, 53, 53, 83,
    32, 88, 88, 88, 88, 52, 9, -160,
    4, 4, 4, 4, 4, 4, 1, 25,
    15, 15, 15, 15, 34, 34, 29, 34,
    17, 24, 17, 17, 17, 17, 17, 51,
    -18, 32, 32, 32, 32, -8, -39, -8
  },
  7, 2, 
  29,
  true},
{
  "Palatino-Bold",		/* #30 */
  NULL,
  NULL,
  "palatino-bold-r-normal",
  NULL,
  24591, 1, 0, 3, 14,
  924, 266,
  681,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 278, 402, 500, 500, 889, 833, 278,
    333, 333, 444, 606, 250, 606, 250, 296, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 250, 250,
    606, 606, 606, 444, 747, 778, 667, 722, 833, 611,
    556, 833, 833, 389, 389, 778, 611, 1000, 833, 833,
    611, 833, 722, 611, 667, 778, 778, 1000, 667, 667,
    667, 333, 606, 333, 606, 500, 278, 500, 611, 444,
    611, 500, 389, 556, 611, 333, 333, 611, 333, 889,
    611, 556, 611, 611, 389, 444, 333, 611, 556, 833,
    500, 556, 500, 310, 606, 310, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 278, 500, 500, 500, 500, 606, 500, 333, 747,
    438, 500, 606, 333, 747, 333, 400, 606, 300, 300,
    333, 611, 641, 250, 333, 300, 488, 500, 750, 750,
    750, 444, 778, 778, 778, 778, 778, 778, 1000, 722,
    611, 611, 611, 611, 389, 389, 389, 389, 833, 833,
    833, 833, 833, 833, 833, 606, 833, 778, 778, 778,
    778, 667, 611, 611, 500, 500, 500, 500, 500, 500,
    778, 444, 500, 500, 500, 500, 333, 333, 333, 333,
    556, 611, 556, 556, 556, 556, 556, 606, 556, 611,
    611, 611, 611, 556, 611, 556
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 63, 22, 4, 28, 61, 52, 29,
    65, 28, 44, 51, -6, 51, 47, -9,
    33, 35, 25, 22, 12, 42, 37, 46,
    34, 31, 47, -6, 49, 51, 49, 43,
    42, 24, 39, 44, 35, 39, 28, 47,
    36, 39, -11, 39, 39, 32, 35, 47,
    39, 47, 39, 57, 17, 26, 20, 17,
    17, 15, 24, 73, 72, 42, 52, 0,
    29, 40, 10, 37, 42, 42, 34, 26,
    24, 34, 3, 21, 24, 24, 24, 40,
    29, 52, 30, 39, 22, 25, 11, 13,
    20, 10, 16, 5, 260, 22, 51, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 59, 73, -2, 32, 17, 260, 30,
    -8, 26, 77, 36, 51, 16, 26, 1,
    50, 51, 5, 9, 78, 25, 19, 47,
    73, 14, 89, 37, 19, 9, 15, 33,
    24, 24, 24, 24, 24, 24, 12, 44,
    39, 39, 39, 39, 39, 39, 26, 20,
    10, 35, 47, 47, 47, 47, 47, 72,
    32, 26, 26, 26, 26, 15, 39, 30,
    40, 40, 40, 40, 40, 40, 46, 37,
    42, 42, 42, 42, 18, 34, -2, -8,
    40, 24, 40, 40, 40, 40, 40, 51,
    23, 25, 25, 25, 25, 10, 17, 10
  },
  7, 3,
  30,
  true},
{
  "Palatino-BoldItalic",	/* #31 */
  NULL,
  NULL,
  "palatino-bold-i-normal",
  NULL,
  24591, 1, 1, 3, 14,
  926, 271,
  681,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 250, 333, 500, 500, 500, 889, 833, 278,
    333, 333, 444, 606, 250, 606, 250, 315, 500, 500,
    500, 500, 500, 500, 500, 500, 500, 500, 250, 250,
    606, 606, 606, 444, 833, 722, 667, 685, 778, 611,
    556, 778, 778, 389, 389, 722, 611, 944, 778, 833,
    667, 833, 722, 556, 611, 778, 667, 1000, 722, 611,
    667, 333, 606, 333, 606, 500, 278, 556, 537, 444,
    556, 444, 333, 500, 556, 333, 333, 556, 333, 833,
    556, 556, 556, 537, 389, 444, 389, 556, 556, 833,
    500, 556, 500, 333, 606, 333, 606, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    250, 333, 500, 500, 500, 500, 606, 556, 333, 747,
    333, 500, 606, 389, 747, 333, 400, 606, 300, 300,
    333, 556, 556, 250, 333, 300, 333, 500, 750, 750,
    750, 444, 722, 722, 722, 722, 722, 722, 944, 685,
    611, 611, 611, 611, 389, 389, 389, 389, 778, 778,
    833, 833, 833, 833, 833, 606, 833, 778, 778, 778,
    778, 611, 667, 556, 556, 556, 556, 556, 556, 556,
    738, 444, 444, 444, 444, 444, 333, 333, 333, 333,
    556, 556, 556, 556, 556, 556, 556, 606, 556, 556,
    556, 556, 556, 556, 556, 556
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 58, 137, 4, 20, 56, 74, 76,
    58, -12, 84, 50, -33, 51, 48, 1,
    42, 41, 1, 8, 3, 14, 39, 69,
    26, 27, 38, -33, 49, 51, 48, 91,
    82, -35, 8, 69, 0, 11, -6, 72,
    -12, -1, -29, -10, 26, -23, -2, 76,
    11, 76, 4, 50, 56, 83, 67, 67,
    -9, 54, 1, 45, 72, -21, 63, 0,
    65, 44, 44, 32, 38, 28, -130, -50,
    22, 26, -64, 34, 64, 19, 17, 48,
    -21, 32, 20, 25, 42, 22, 19, 27,
    -8, 13, 31, 18, 259, -1, 51, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 2, 52, 21, 32, 11, 259, 47,
    90, 26, 47, 35, 51, 37, 26, 76,
    50, 50, 26, 23, 153, -15, 14, 67,
    12, 41, 51, 35, 18, 14, 18, -12,
    -35, -35, -35, -35, -35, -35, -29, 69,
    11, 11, 11, 11, -1, -1, -1, -1,
    0, -2, 76, 76, 76, 76, 76, 72,
    57, 83, 83, 83, 83, 54, 11, -131,
    44, 44, 44, 44, 44, 44, 44, 32,
    28, 28, 28, 28, 26, 26, 26, 26,
    48, 17, 48, 48, 48, 48, 48, 50,
    14, 22, 22, 22, 22, 13, -21, 13
  },
  7, 4,
  31,
  true},
{
  "ZapfChancery-MediumItalic",	/* #32 */
  NULL,
  NULL,
  "itc zapf chancery-medium-i-normal", /* as used e.g. by SGI */
  "zapfchancery-medium-i-normal", /* our former convention, from SunOS */
  45099, 1, 1, 0, 14,
  831, 314,
  708,
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 220, 280, 220, 440, 440, 680, 780, 240,
    260, 220, 420, 520, 220, 520, 220, 340, 440, 440,
    440, 440, 440, 440, 440, 440, 440, 440, 260, 240,
    520, 520, 520, 380, 700, 620, 600, 520, 700, 620,
    580, 620, 680, 380, 400, 660, 580, 840, 700, 600,
    540, 600, 600, 460, 500, 740, 640, 880, 560, 560,
    620, 240, 480, 320, 520, 500, 240, 420, 420, 340,
    440, 340, 320, 400, 440, 240, 220, 440, 240, 620,
    460, 400, 440, 400, 300, 320, 320, 460, 440, 680,
    420, 400, 440, 240, 520, 240, 520, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    220, 280, 440, 440, 440, 440, 520, 420, 360, 740,
    260, 340, 520, 280, 740, 440, 400, 520, 264, 264,
    300, 460, 500, 220, 300, 264, 260, 380, 660, 660,
    660, 400, 620, 620, 620, 620, 620, 620, 740, 520,
    620, 620, 620, 620, 380, 380, 380, 380, 700, 700,
    600, 600, 600, 600, 600, 520, 660, 740, 740, 740,
    740, 560, 540, 420, 420, 420, 420, 420, 420, 420,
    540, 340, 340, 340, 340, 340, 240, 240, 240, 240,
    400, 460, 400, 400, 400, 400, 400, 520, 440, 460,
    460, 460, 460, 400, 440, 400
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 119, 120, 83, 60, 132, 126, 168,
    96, -13, 139, 117, 25, 117, 102, 74,
    79, 41, 17, 1, 77, 60, 90, 157,
    65, 32, 98, 29, 139, 117, 139, 150,
    127, 13, 85, 93, 86, 91, 120, 148,
    18, 99, -14, 53, 53, 58, 85, 94,
    42, 84, 58, 45, 63, 126, 124, 94,
    -30, 41, 42, -13, 140, -27, 132, 0,
    169, 92, 82, 87, 102, 87, -119, -108,
    55, 100, -112, 87, 102, 86, 101, 87,
    -23, 87, 101, 46, 106, 102, 87, 87,
    70, -24, 26, 55, 320, -10, 123, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 72, 122, -16, 50, -1, 320, 53,
    243, 137, 111, 98, 117, 69, 137, 222,
    171, 117, 72, 59, 265, 7, 105, 139,
    12, 83, 128, 117, 56, 56, 39, 82,
    13, 13, 13, 13, 13, 13, -21, 93,
    91, 91, 91, 91, 99, 99, 99, 99,
    86, 85, 94, 94, 94, 94, 94, 133,
    83, 126, 126, 126, 126, 41, 52, -127,
    92, 92, 92, 92, 92, 92, 67, 62,
    87, 87, 87, 87, 100, 100, 100, 100,
    87, 101, 87, 87, 87, 87, 87, 117,
    46, 102, 102, 102, 102, -24, -38, -24
  },
  8, 1,
  33,
  true},
{
  "ZapfDingbats",		/* #33 */
  NULL,
  NULL,
  "itc zapf dingbats-medium-r-normal",
  "zapfdingbats-medium-r-normal", /* our former convention, from SunOS etc. */
  45101, 1, 0, 0, 460,
  820, 143,
  662,	/* cap height not in AFM file; this is Times-Roman value */
  {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 278, 974, 961, 974, 980, 719, 789, 790,
    791, 690, 960, 939, 549, 855, 911, 933, 911, 945,
    974, 755, 846, 762, 761, 571, 677, 763, 760, 759,
    754, 494, 552, 537, 577, 692, 786, 788, 788, 790,
    793, 794, 816, 823, 789, 841, 823, 833, 816, 831,
    923, 744, 723, 749, 790, 792, 695, 776, 768, 792,
    759, 707, 708, 682, 701, 826, 815, 789, 789, 707,
    687, 696, 689, 786, 787, 713, 791, 785, 791, 873,
    761, 762, 762, 759, 759, 892, 892, 788, 784, 438,
    138, 277, 415, 392, 392, 668, 668, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 732, 544, 544,  910, 667, 760, 760, 776, 595,
    694, 626, 788, 788, 788, 788, 788, 788, 788, 788,
    788, 788, 788, 788, 788, 788, 788, 788, 788, 788,
    788, 788, 788, 788, 788, 788, 788, 788, 788, 788,
    788, 788, 788, 788, 788, 788, 788, 788, 788, 788,
    788, 788, 894, 838, 1016, 458, 748, 924, 748, 918,
    927, 928, 928, 834, 873, 828, 924, 924, 917, 930,
    931, 463, 883, 836, 836, 867, 867, 696, 696, 874,
    0, 874, 760, 946, 771, 865, 771, 888, 967, 888,
    831, 873, 927, 970, 918, 0
  },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 35, 35, 35, 35, 34, 35, 35,
    35, 35, 35, 35, 29, 34, 35, 35,
    35, 35, 35, 34, 36, 35, 35, -1,
    36, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 34, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 34, 36, 35, 35, 34,
    35, 35, 35, 36, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 34, 35, 36, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 35, 56, 34, 35, 35, 35, 0,
    35, 34, 35, 34, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 34, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    35, 35, 35, 35, 35, 35, 35, 35,
    0, 35, 35, 35, 34, 35, 34, 34,
    35, 34, 35, 36, 35, 35, 34, 0
  },
  9, 1,
  34,
  false},
{
  "Symbol",			/* #34 */
  "SymbolPS",
  NULL,
  "symbol-medium-r-normal",
  NULL,
  45358, 1, 0, 0, 621,
  1010, 293,
  662,	/* cap height not in AFM file; this is Times-Roman value */
 {
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 250, 333, 713, 500, 549, 833, 778, 439,
   333, 333, 500, 549, 250, 549, 250, 278, 500, 500,
   500, 500, 500, 500, 500, 500, 500, 500, 278, 278,
   549, 549, 549, 444, 549, 696, 660, 710, 612, 652,
   763, 603, 765, 351, 631, 724, 686, 918, 739, 750,
   768, 741, 580, 592, 632, 690, 439, 768, 645, 795,
   650, 333, 863, 333, 658, 500, 500, 631, 549, 549,
   494, 439, 521, 411, 603, 329, 603, 549, 549, 576,
   521, 549, 549, 521, 549, 603, 439, 576, 713, 686,
   493, 686, 494, 480, 200, 480, 549, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 620, 247, 549, 167, 713, 500, 753, 753, 753,
   753, 1042, 987, 603, 987, 603, 400, 549, 411, 549,
   549, 713, 494, 460, 549, 549, 549, 549, 1000, 603,
   1000, 658, 823, 686, 795, 987, 768, 768, 823, 768,
   768, 713, 713, 713, 713, 713, 713, 713, 768, 713,
   790, 790, 890, 823, 549, 250, 713, 603, 603, 1042,
   987, 603, 987, 603, 494, 329, 790, 790, 786, 713,
   384, 384, 384, 384, 384, 384, 494, 494, 494, 494,
   762, 329, 274, 686, 686, 686, 384, 384, 384, 384,
   384, 384, 494, 494, 494, 0
 },
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 128, 31, 20, 25, 63, 41, 48,
    53, 30, 65, 10, 56, 11, 69, 0,
    23, 117, 25, 39, 16, 29, 36, 24,
    54, 31, 81, 83, 26, 11, 26, 70,
    11, 4, 29, -9, 6, 32, 26, 24,
    39, 32, 18, 35, 6, 28, 29, 41,
    25, 41, 28, 5, 33, -8, 40, 34,
    40, 15, 44, 86, 163, 33, 15, -2,
    480, 41, 61, 12, 40, 22, 27, 5,
    0, 0, 36, 33, 24, 33, -9, 35,
    10, 43, 50, 30, 10, 7, 12, 42,
    27, 12, 60, 58, 65, 79, 17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, 27, 29, -180, 26, 2, 86,
    142, 117, 113, 24, 32, 45, 49, 45,
    50, 10, 20, 29, 17, 27, 26, 50,
    10, 15, 14, 14, 111, 280, -60, 15,
    175, 10, 26, 159, 43, 43, 39, 40,
    40, 20, 20, 36, 37, 37, 45, 45,
    26, 36, 50, 51, 18, 25, 10, 69,
    15, 23, 30, 27, 30, 39, 45, 44,
    18, 25, 50, 49, 5, 14, 40, 40,
    40, 0, 0, 0, 201, 14, 201, 201,
    53, 21, 2, 332, 332, 39, 54, 398,
    54, 22, 305, 20, 17, 201, 17, 0
  },
  2, 0,
  32,
  false},
{
  NULL,				/* DUMMY */
  NULL,
  NULL,
  NULL,
  NULL,
  0, 0, 0, 0, 0,
  0, 0,
  0,
 {0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    
 0, 0, 0, 0, 0, 0},
  {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0
  },
  0, 0, 0,
  false}
};

/* The array _ps_font_to_cgm_font_id[] performs a map from internal PS font
   number, i.e. location in the preceding list of 35 fonts, to CGM font id,
   as used by CGM Plotters in WebCGM output.  _cgm_font_id_to_ps_font[]
   performs the inverse map.  

   These maps are permutations of the interval 0..34, and are restricted
   only by the requirement that the original `Adobe 13' (the PS fonts built
   into the first Apple LaserWriters) be mapped to 0..12.  We impose that
   requirement because in WebCGM format, the Adobe 13 are a bit special:
   they are assumed always to be available.  If any of the other 23 is
   included, a `FONT PROPERTIES' command needs to be emitted for it. */
   
const int _ps_font_to_cgm_font_id[] = 
{ 0, 1, 2, 3, 13, 14, 15, 16, 4, 5, 6, 7, 17, 18, 19, 20, 21, 22, 23, 24, 8, 9, 10, 11, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 12 };

const int _cgm_font_id_to_ps_font[] = 
{ 0, 1, 2, 3, 8, 9, 10, 11, 20, 21, 22, 23, 34, 4, 5, 6, 7, 12, 13, 14, 15, 16, 17, 18, 19, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 };

/* The following are the most important CGM properties of the 35 Postscript
   fonts, arranged according to the font id we use in CGM files, rather
   than our internal numbering.  

   The font properties that may be specified in a CGM file are taken from
   the `Minimum Font Description Subset' of ISO/IEC 9541.  For the 35
   Postscript fonts, we take the values of the CGM properties from the file
   `r_ps.fnt' in the RALCGM distribution.  The properties are: posture,
   weight, proportionate width, `design group', and structure (always 1,
   signifying a filled [non-outline] font).

   According to the "CGM Handbook", posture 1 means upright, posture 2
   means oblique, and posture 4 means italic.  I don't understand why the
   italic fonts are specified as having oblique posture.

   Design group is a hierarchical classification.  Here is a partial list
   of design groups (for a fuller list, see the file `f_dsn.fnt' in the
   RALCGM distribution).

	   4         Serif
	   4.1         Oldstyle
	   4.1.1         Venetian
	   4.1.2         Garalde
	   4.1.3         Dutch / English	[NewCenturySchlbk]
	   4.2         Transitional
	   4.2.1         Direct Line
	   4.2.2         Modified
	   4.3         Modern
	   4.3.1         Continental
	   4.3.2         Fat Face
	   4.4         Contemporary
	   4.4.1         Eclectic
	   4.4.2         Fine Serif		[AvantGarde,Palatino]
	   4.4.3         Lettering
	   4.5         Legibility
	   4.5.1         Rounded (traditional)	[Times]
	   4.5.2         Elliptical (square)	[Bookman]
	   4.6         Square Serif
	   4.6.1         Monotone
	   4.6.2         Clarendon
	   4.6.3         French Clarendon
	   4.6.4         Short (stub)
	   4.6.5         Typewriter		[Courier]
	   4.6.6         Dot Matrix
	   4.7         Latin
	   4.7.1         Solid
	   4.7.2         Inline
	   4.8         Engraving
	   4.8.1         Barbed Serif
	   4.8.2         Straight serif (fine)
	   4.9         Free Form
	   4.9.1         Solid
	   4.9.2         Outline
	   4.10        Computer
	   4.10.1         OCR
	   4.10.2         Digital
	   4.11        Miscellaneous
	   4.12        Mincho
	   4.12.1        Old Style
	   4.12.2        New Style
	   4.12.3        Miscellaneous
	   
	   5         Sans Serif
	   5.1         Gothic
	   5.1.1         Grotesque
	   5.1.2         Neo-grotesque		[Helvetica]
	   5.1.3         Typewriter
	   
	   8 Symbols and Ornaments		[Symbol,ZapfDingbats] 

*/

const plCGMFontProperties _cgm_font_properties[] = {
  { "Helvetica", "", "", 			1, 5, 5, { 5, 1, 2 }, 1 },
  { "Helvetica", "", "Oblique",			2, 5, 5, { 5, 1, 2 }, 1 },
  { "Helvetica", "", "Bold",			1, 7, 5, { 5, 1, 2 }, 1 },
  { "Helvetica", "", "BoldOblique",		2, 7, 5, { 5, 1, 2 }, 1 },
  { "Times", "", "Roman", 			1, 5, 5, { 4, 5, 1 }, 1 },
  { "Times", "", "Italic", 			2, 5, 5, { 4, 5, 1 }, 1 },
  { "Times", "", "Bold", 			1, 7, 5, { 4, 5, 1 }, 1 },
  { "Times", "", "BoldItalic", 			2, 7, 5, { 4, 5, 1 }, 1 },
  { "Courier", "", "", 				1, 5, 5, { 4, 6, 5 }, 1 },
  { "Courier", "", "Oblique",			2, 5, 5, { 4, 6, 5 }, 1 },
  { "Courier", "", "Bold",			1, 7, 5, { 4, 6, 5 }, 1 },
  { "Courier", "", "BoldOblique",		2, 7, 5, { 4, 6, 5 }, 1 },
  { "Symbol", "", "",				1, 5, 5, { 8, 2, 0 }, 1 },
  { "Helvetica", "Narrow", "", 			1, 5, 3, { 5, 1, 2 }, 1 },
  { "Helvetica", "Narrow", "Oblique",		2, 5, 3, { 5, 1, 2 }, 1 },
  { "Helvetica", "Narrow", "Bold",		1, 7, 3, { 5, 1, 2 }, 1 },
  { "Helvetica", "Narrow", "BoldOblique",	2, 7, 3, { 5, 1, 2 }, 1 },
  { "AvantGarde", "", "Book", 			1, 5, 5, { 4, 4, 2 }, 1 },
  { "AvantGarde", "", "BookOblique",		2, 5, 5, { 4, 4, 2 }, 1 },
  { "AvantGarde", "", "Demi",			1, 6, 5, { 4, 4, 2 }, 1 },
  { "AvantGarde", "", "DemiOblique",		2, 6, 5, { 4, 4, 2 }, 1 },
  { "Bookman", "", "Light",			1, 4, 5, { 4, 5, 2 }, 1 },
  { "Bookman", "", "LightItalic",		2, 4, 5, { 4, 5, 2 }, 1 },
  { "Bookman", "", "Demi", 			1, 6, 5, { 4, 5, 2 }, 1 },
  { "Bookman", "", "DemiItalic",		2, 6, 5, { 4, 5, 2 }, 1 },
  { "NewCenturySchlbk", "", "Roman",		1, 5, 5, { 4, 1, 3 }, 1 },
  { "NewCenturySchlbk", "", "Italic", 		2, 5, 5, { 4, 1, 3 }, 1 },
  { "NewCenturySchlbk", "", "Bold", 		1, 7, 5, { 4, 1, 3 }, 1 },
  { "NewCenturySchlbk", "", "BoldItalic",	2, 7, 5, { 4, 1, 3 }, 1 },
  { "Palatino", "", "Roman",			1, 5, 5, { 4, 4, 2 }, 1 },
  { "Palatino", "", "Italic", 			2, 5, 5, { 4, 4, 2 }, 1 },
  { "Palatino", "", "Bold", 			1, 7, 5, { 4, 4, 2 }, 1 },
  { "Palatino", "", "BoldItalic",		2, 7, 5, { 4, 4, 2 }, 1 },
  { "ZapfChancery", "", "MediumItalic",		2, 5, 5, { 6, 1, 1 }, 1 },
  { "ZapfDingbats", "", "",			1, 5, 5, { 8, 0, 0 }, 1 }
};

/* Known PS typefaces.  Each plTypefaceInfoStruct contains the following
   information:
   
   (1) number of valid fonts [should be >= 2, since every typeface
       should include a symbol font (the zeroth font, the 1st listed)]
   (2) a list of fonts (each number is an index into
       the _ps_font_info[] array above).

   The number of valid fonts should be <= FONTS_PER_TYPEFACE; the
   initializers are filled out with dummy fonts to get arrays of length
   FONTS_PER_TYPEFACE. */

const struct plTypefaceInfoStruct _ps_typeface_info[] = 
{
  /* Helvetica, #0 */
  { 5, { 34, 0, 1, 2, 3, 999, 999, 999, 999, 999 } },
  /* Helvetica-Narrow, #1 */
  { 5, { 34, 4, 5, 6, 7, 999, 999, 999, 999, 999  } }, 
  /* Times, #2 */
  { 5, { 34, 8, 9, 10, 11, 999, 999, 999, 999, 999  } },
  /* AvantGarde, #3 */
  { 5, { 34, 12, 13, 14, 15, 999, 999, 999, 999, 999  } }, 
  /* Bookman, #4 */
  { 5, { 34, 16, 17, 18, 19, 999, 999, 999, 999, 999  } }, 
  /* Courier, #5 */
  { 5, { 34, 20, 21, 22, 23, 999, 999, 999, 999, 999  } },
  /* New Century Schoolbook, #6 */
  { 5, { 34, 24, 25, 26, 27, 999, 999, 999, 999, 999  } }, 
  /* Palatino, #7 */
  { 5, { 34, 28, 29, 30, 31, 999, 999, 999, 999, 999  } },
  /* Zapf Chancery, #8 */
  { 2, { 34, 32, 999, 999, 999, 999, 999, 999, 999, 999 } },
  /* Zapf Dingbats, #9 */
  { 2, { 34, 33, 999, 999, 999, 999, 999, 999, 999, 999 } },
};


/* The Hershey vector fonts we support.  Each character in a Hershey font
   is an index into the glyph array in g_her_glyphs.c.  Each
   plHersheyFontInfoStruct includes these elements:

   (1) PS-style name for the font
   (2) an alias for the font (for backward compatibility)
   (3) Allen Hershey's original name for the font
   (4) the characters in the font (an array of glyph indices, size 256)
   (5) a typeface id (an index into the _ps_typeface_info[] array below)
   (6) a font index (which font within the typeface this is)
   (7) an `obliquing requested' flag (set if glyphs should be sheared)
   (8) an `iso8859-1' flag
   (9) a `visible' flag (false for the two Kana fonts,
        which are only used internally) */

/* Each Hershey font below may contain up to 256 Hershey glyphs, each of
   which is specified by a number that indexes into the array in
   g_her_glyph.c.  Only the ranges 0x20..0x7e and 0xa0..0xff are directly
   accessible to the user.

   There are several sorts of hole in the Hershey fonts, i.e., entries in
   the character arrays in these printable ranges which are not proper
   glyphs.  They are:

   0. undefined characters: thorn, eth, the guillemets, the mysterious
   `currency' symbol, and the European 'euro' currency symbol.  These are
   written as UNDE, which is a glyph consisting of several horizontal
   lines.

   1. the characters onesuperior, twosuperior, threesuperior, ordmasculine,
   ordfeminine.  These are written as 0, which means an empty glyph.  That
   is because they not implemented as conventional glyphs at all: the
   corresponding entries in this table are never accessed.  In the file
   g_cntrlify.c these characters are mapped to sequences of control
   sequences, which implement them as superscripts.
   
   2. the characters ae, AE, and germandbls (i.e. eszet), which (except in
   Gothic-German) are also written as 0.  That is because they are
   `deligatured' in g_cntrlify.c, via a translation table in g_cntrlify.h.
   Deligaturization maps them to the two-characters sequences "ae", "AE",
   and "ss".  The corresponding entries in this table are never accessed.

   3. the accented ISO-Latin-1 characters.  These are written as ACC0,
   ACC1, or ACC2, any of which signifies that they should be looked up in
   the following table of accented characters, yielding an accent and a
   character.  They signify respectively that the accent should be
   superimposed on the character, that it should be raised by 7 Hershey
   units (for capitals), and that it should be raised by 7 units and also
   displaced rightward by 2 units (for italic capitals).
   
   4. the small Katakana in the HersheyEUC font.  These are written as KS
   (i.e. Katakana small) + true glyph number.  This means that they should
   be isotropically compressed, with the baseline preserved.


   In many Hershey fonts, the `nonprintable' range 0x80..0x9f is
   nonprintable only in the sense that it is not directly accessible to the
   user; it may contain ligatures, macros, and variant characters.  In fact
   the just-mentioned accents, used in the construction of accented
   ISO-Latin-1 characters, are stored there.  Our convention for the
   0x80..0x9f range, for ISO-Latin-1 Hershey fonts, is:

   0200: ff
   0201: fi
   0202: fl
   0203: ffi
   0204: ffl
   0205--0207: other ligatures (font-specific)
   0210: acute accent
   0211: grave accent
   0212: dieresis
   0213: circumflex accent
   0214: circumflex accent for `i'
   0215: tilde accent
   0216: ring accent for `a'
   0217: cedilla	[NOT YET IMPLEMENTED]
   0230: variant [final] form for `s'
   0231: dotless i

   In the symbol fonts, we store miscellaneous symbols and astronomical
   symbols in this range.  In fact, in the symbol fonts the astronomical
   symbols overflow to the other nonprintable range 0x00..0x1f 
   (the twelve zodiacal signs are stored there). */

#define CEDILLA UNDE   /* currently undefined, to be implemented someday */

/* IMPORTANT: The fonts in this array may be referred to elsewhere in the
   code by number.  If you change the numbering of Hershey fonts, i.e., the
   order in which they appear in this array, be sure to update, e.g., the
   definitions DEFAULT_HERSHEY_FONT_INDEX, HERSHEY_SERIF, HERSHEY_EUC
   etc. in extern.h. */

const struct plHersheyFontInfoStruct _hershey_font_info[] = 
{
  {
    "HersheySerif",		/* #0 */
    NULL,
    "Complex Roman",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 2214, 2217, 2275, 2274, 2271, 2272, 2251,
      2221, 2222, 2219, 2232, 2211, 2231, 2210, 2220,
      2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207,
      2208, 2209, 2212, 2213, 2241, 2238, 2242, 2215,
      2273, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
      2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015,
      2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023,
      2024, 2025, 2026, 2223, 4002, 2224, 4110, 4013,
      2252, 2101, 2102, 2103, 2104, 2105, 2106, 2107,
      2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115,
      2116, 2117, 2118, 2119, 2120, 2121, 2122, 2123,
      2124, 2125, 2126, 2225, 2229, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      2177, 2178, 2179, 2180, 2181, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      2119, 2182, 0, 0, 0, 0, 0, 0,
      /* ISO-Latin-1 encoding resumes */
      2199, 4113,  910,  272, UNDE, 4125, 4106, 2276,
      4182,  274,    0, UNDE, 4080, 4104,  273, 4187,
      2218, 2233,    0,    0, 4180, 2138, UNDE, 729,
      CEDILLA, 0,    0, UNDE, 270,  261,  271, 4114,
      ACC1, ACC1, ACC1, ACC1, ACC1, 2078,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,  727,
      2015, ACC1, ACC1, ACC1, ACC1, ACC1, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
      2115, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    0, 1, false, true, true
  },
  {
    "HersheySerif-Italic",	/* #1 */
    NULL,
    "Complex Italic",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 2214, 2217, 2275, 2274, 2271, 2272, 2251,
      2221, 2222, 2219, 2232, 2211, 2231, 2210, 2770,
      2750, 2751, 2752, 2753, 2754, 2755, 2756, 2757,
      2758, 2759, 2212, 2213, 2241, 2238, 2242, 2215,
      2273, 2051, 2052, 2053, 2054, 2055, 2056, 2057,
      2058, 2059, 2060, 2061, 2062, 2063, 2064, 2065,
      2066, 2067, 2068, 2069, 2070, 2071, 2072, 2073,
      2074, 2075, 2076, 2223, 4002, 2224, 4110, 4013,
      2252, 2151, 2152, 2153, 2154, 2155, 2156, 2157,
      2158, 2159, 2160, 2161, 2162, 2163, 2164, 2165,
      2166, 2167, 2168, 2169, 2170, 2171, 2172, 2173,
      2174, 2175, 2176, 2225, 2229, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      2191, 2192, 2193, 2194, 2195, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      2169, 2196, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      2199, 4113,  910,  272, UNDE, 4129, 4106, 2276,
      4182,  274,    0, UNDE, 4080, 4104,  273, 4187,
      2218, 2233,    0,    0, 4180, 2138, UNDE,  729,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4114,
      ACC2, ACC2, ACC2, ACC2, ACC2, ACC2,    0, ACC0,
      ACC2, ACC2, ACC2, ACC2, ACC2, ACC2, ACC2, ACC2,
      UNDE, ACC2, ACC2, ACC2, ACC2, ACC2, ACC2,  727,
      2065, ACC2, ACC2, ACC2, ACC2, ACC2, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
      2165, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    0, 2, false, true, true
  },
  {
    "HersheySerif-Bold",	/* #2 */
    NULL,
    "Triplex Roman",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      3249, 3214, 3228, 3232, 3219, 3233, 3218, 3217,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 3230, 3226, 3231, 3215,
      3234, 3001, 3002, 3003, 3004, 3005, 3006, 3007,
      3008, 3009, 3010, 3011, 3012, 3013, 3014, 3015,
      3016, 3017, 3018, 3019, 3020, 3021, 3022, 3023,
      3024, 3025, 3026, 2223, 4178, 2224, 4110, 4013,
      3216, 3101, 3102, 3103, 3104, 3105, 3106, 3107,
      3108, 3109, 3110, 3111, 3112, 3113, 3114, 3115,
      3116, 3117, 3118, 3119, 3120, 3121, 3122, 3123,
      3124, 3125, 3126, 2225, 4108, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      3119, 4160, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      3249, 4119,  910,  272, UNDE, 4126, 4107, 2276,
      4182,  274,    0, UNDE, 4080, 4105,  273, 4187,
      3229, 2233,    0,    0, 4180, 3138, UNDE, 4131,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4120,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,  727,
      3015, ACC1, ACC1, ACC1, ACC1, ACC1, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
      3115, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    0, 3, false, true, true
  },
  {
    "HersheySerif-BoldItalic",	/* #3 */
    NULL,
    "Triplex Italic",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      3249, 3264, 3278, 3282, 3269, 3283, 3268, 3267,
      3271, 3272, 3273, 3275, 3261, 3274, 3260, 3270,
      3250, 3251, 3252, 3253, 3254, 3255, 3256, 3257,
      3258, 3259, 3262, 3263, 3280, 3276, 3281, 3265,
      3284, 3051, 3052, 3053, 3054, 3055, 3056, 3057,
      3058, 3059, 3060, 3061, 3062, 3063, 3064, 3065,
      3066, 3067, 3068, 3069, 3070, 3071, 3072, 3073,
      3074, 3075, 3076, 2223, 4178, 2224, 4110, 4013,
      3266, 3151, 3152, 3153, 3154, 3155, 3156, 3157,
      3158, 3159, 3160, 3161, 3162, 3163, 3164, 3165,
      3166, 3167, 3168, 3169, 3170, 3171, 3172, 3173,
      3174, 3175, 3176, 2225, 4108, 2226, 2246,    0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      3169, 4161, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      3249, 4121,  910,  272, UNDE, 4130, 4107, 2276,
      4182,  274,    0, UNDE, 4080, 4105,  273, 4187,
      3279, 2233,    0,    0, 4180, 3138, UNDE, 4131,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4122,
      ACC2, ACC2, ACC2, ACC2, ACC2, ACC2,    0, ACC0,
      ACC2, ACC2, ACC2, ACC2, ACC2, ACC2, ACC2, ACC2,
      UNDE, ACC2, ACC2, ACC2, ACC2, ACC2, ACC2,  727,
      3065, ACC2, ACC2, ACC2, ACC2, ACC2, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
      3165, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    0, 4, false, true, true
  },
  {
    "HersheyCyrillic",	/* #4 */
    NULL,
    "Complex Cyrillic",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 2214, 2217, 2275, 2274, 2271, 2272, 2251,
      2221, 2222, 2219, 2232, 2211, 2231, 2210, 2220,
      2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207,
      2208, 2209, 2212, 2213, 2241, 2238, 2242, 2215,
      2273, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
      2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015,
      2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023,
      2024, 2025, 2026, 2223, 4002, 2224, 4110, 4013,
      2252, 2101, 2102, 2103, 2104, 2105, 2106, 2107,
      2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115,
      2116, 2117, 2118, 2119, 2120, 2121, 2122, 2123,
      2124, 2125, 2126, 2225, 2229, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      2177, 2178, 2179, 2180, 2181, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      2119, 0, 0, 0, 0, 0, 0, 0,
      /* begin bogus region */
      0, 0, 0, ACC0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, ACC1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 274,
      /* end bogus region */
      2931, 2901, 2902, 2923, 2905, 2906, 2921, 2904,
      2922, 2909, 2910, 2911, 2912, 2913, 2914, 2915,
      2916, 2932, 2917, 2918, 2919, 2920, 2907, 2903,
      2929, 2928, 2908, 2925, 2930, 2926, 2924, 2927,
      2831, 2801, 2802, 2823, 2805, 2806, 2821, 2804,
      2822, 2809, 2810, 2811, 2812, 2813, 2814, 2815,
      2816, 2832, 2817, 2818, 2819, 2820, 2807, 2803,
      2829, 2828, 2808, 2825, 2830, 2826, 2824, 2827,
    },
    0, 5, false, false, true
  },
  {
    "HersheyCyrillic-Oblique",	/* #5 */
    NULL,
    "Complex Cyrillic (obliqued)",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 2214, 2217, 2275, 2274, 2271, 2272, 2251,
      2221, 2222, 2219, 2232, 2211, 2231, 2210, 2220,
      2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207,
      2208, 2209, 2212, 2213, 2241, 2238, 2242, 2215,
      2273, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
      2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015,
      2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023,
      2024, 2025, 2026, 2223, 4002, 2224, 4110, 4013,
      2252, 2101, 2102, 2103, 2104, 2105, 2106, 2107,
      2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115,
      2116, 2117, 2118, 2119, 2120, 2121, 2122, 2123,
      2124, 2125, 2126, 2225, 2229, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      2177, 2178, 2179, 2180, 2181, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      2119, 0, 0, 0, 0, 0, 0, 0,
      /* begin bogus region */
      0, 0, 0, ACC0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, ACC1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 274,
      /* end bogus region */
      2931, 2901, 2902, 2923, 2905, 2906, 2921, 2904,
      2922, 2909, 2910, 2911, 2912, 2913, 2914, 2915,
      2916, 2932, 2917, 2918, 2919, 2920, 2907, 2903,
      2929, 2928, 2908, 2925, 2930, 2926, 2924, 2927,
      2831, 2801, 2802, 2823, 2805, 2806, 2821, 2804,
      2822, 2809, 2810, 2811, 2812, 2813, 2814, 2815,
      2816, 2832, 2817, 2818, 2819, 2820, 2807, 2803,
      2829, 2828, 2808, 2825, 2830, 2826, 2824, 2827,
    },
    0, 6, true, false, true
  },
  {
    "HersheyHiragana",	/* #6 */
    NULL,
    "Hiragana (from oriental glyph database)",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      4399, 4200+KS, 4200, 4201+KS, 4201, 4202+KS, 4202, 4203+KS, 
      4203, 4204+KS, 4204, 4205, 4255, 4206, 4256, 4207, 
      4257, 4208, 4258, 4209, 4259, 4210, 4260, 4211, 
      4261, 4212, 4262, 4213, 4263, 4214, 4264, 4215, 
      4265, 4216, 4266, 4217+KS, 4217, 4267, 4218, 4268, 
      4219, 4269, 4220, 4221, 4222, 4223, 4224, 4225, 
      4270, 4275, 4226, 4271, 4276, 4227, 4272, 4277, 
      4228, 4273, 4278, 4229, 4274, 4279, 4230, 4231, 
      4232, 4233, 4234, 4235+KS, 4235, 4237+KS, 4237, 4239+KS, 
      4239, 4240, 4241, 4242, 4243, 4244, 4245+KS, 4245, 
      4246, 4248, 4249, 4250,    0,    0,    0,    0,
      4197, 4196, 4195,    0,    0,    0,    0,    0,
      /********************/
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
    },
    0, 6, false, false, false
  },
  {
    "HersheyKatakana",	/* #7 */
    NULL,
    "Katakana (from oriental glyph database)",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      4399, 4300+KS, 4300, 4301+KS, 4301, 4302+KS, 4302, 4303+KS, 
      4303, 4304+KS, 4304, 4305, 4355, 4306, 4356, 4307, 
      4357, 4308, 4358, 4309, 4359, 4310, 4360, 4311, 
      4361, 4312, 4362, 4313, 4363, 4314, 4364, 4315, 
      4365, 4316, 4366, 4317+KS, 4317, 4367, 4318, 4368, 
      4319, 4369, 4320, 4321, 4322, 4323, 4324, 4325, 
      4370, 4375, 4326, 4371, 4376, 4327, 4372, 4377, 
      4328, 4373, 4378, 4329, 4374, 4379, 4330, 4331, 
      4332, 4333, 4334, 4335+KS, 4335, 4337+KS, 4337, 4339+KS, 
      4339, 4340, 4341, 4342, 4343, 4344, 4345+KS, 4345, 
      4346, 4348, 4349, 4350, 4398, 4305+KS, 4308+KS,  0,
      4197, 4196, 4195,    0,    0,    0,    0,    0,
      /********************/
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
    },
    0, 7, false, false, false
  },
  {
    "HersheyEUC",		/* #8 */
    NULL,
    "Composite Japanese (from oriental glyph database)",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 2214, 2217, 2275, 2274, 2271, 2272, 2251,
      2221, 2222, 2219, 2232, 2211, 2231, 2210, 2220,
      2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207,
      2208, 2209, 2212, 2213, 2241, 2238, 2242, 2215,
      2273, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
      2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015,
      2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023,
      2024, 2025, 2026, 2223, 4125, 2224, 4110, 4013,
      2252, 2101, 2102, 2103, 2104, 2105, 2106, 2107,
      2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115,
      2116, 2117, 2118, 2119, 2120, 2121, 2122, 2123,
      2124, 2125, 2126, 2225, 2229, 2226, 4008, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      2177, 2178, 2179, 2180, 2181, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      2119, 2182, 0, 0, 0, 0, 0, 0,
      /* printable single-byte 8-bit characters (none for this font) */
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
         0,    0,    0,    0,    0,    0,    0,    0,
    },
    0, 7, false, false, true
  },
  {
    "HersheySans",		/* #9 */
    NULL,
    "Simplex Roman",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      699, 714, 717, 733, 719, 697, 734, 731,
      721, 722, 728, 725, 711, 724, 710, 720,
      700, 701, 702, 703, 704, 705, 706, 707,
      708, 709, 712, 713, 691, 726, 692, 715,
      690, 501, 502, 503, 504, 505, 506, 507,
      508, 509, 510, 511, 512, 513, 514, 515,
      516, 517, 518, 519, 520, 521, 522, 523,
      524, 525, 526, 693, 4002, 694, 4110, 4013,
      730, 601, 602, 603, 604, 605, 606, 607,
      608, 609, 610, 611, 612, 613, 614, 615,
      616, 617, 618, 619, 620, 621, 622, 623,
      624, 625, 626, 695, 723, 696, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      4188, 4189, 4182, 4190, 4191, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      619, 4162, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      699, 4111,  910,  272, UNDE, 4127, 4106, 2276,
      4182,  274, 0, UNDE, 4080, 4104,  273, 4187,
      718, 2233, 0, 0, 4188, 638, UNDE, 729,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4112,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,  727,
       515, ACC1, ACC1, ACC1, ACC1, ACC1, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
       615, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    1, 1, false, true, true
  },
  {
    "HersheySans-Oblique",		/* #10 */
    NULL,
    "Simplex Roman (obliqued)",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      699, 714, 717, 733, 719, 697, 734, 731,
      721, 722, 728, 725, 711, 724, 710, 720,
      700, 701, 702, 703, 704, 705, 706, 707,
      708, 709, 712, 713, 691, 726, 692, 715,
      690, 501, 502, 503, 504, 505, 506, 507,
      508, 509, 510, 511, 512, 513, 514, 515,
      516, 517, 518, 519, 520, 521, 522, 523,
      524, 525, 526, 693, 4002, 694, 4110, 4013,
      730, 601, 602, 603, 604, 605, 606, 607,
      608, 609, 610, 611, 612, 613, 614, 615,
      616, 617, 618, 619, 620, 621, 622, 623,
      624, 625, 626, 695, 723, 696, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      4188, 4189, 4182, 4190, 4191, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      619, 4162, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      699, 4111,  910,  272, UNDE, 4127, 4106, 2276,
      4182,  274, 0, UNDE, 4080, 4104,  273, 4187,
      718, 2233, 0, 0, 4188, 638, UNDE, 729,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4112,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,  727,
       515, ACC1, ACC1, ACC1, ACC1, ACC1, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
       615, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    1, 2, true, true, true
  },
  {
    "HersheySans-Bold",		/* #11 */
    NULL,
    "Duplex Roman",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2699, 2714, 2728, 2732, 2719, 2733, 2718, 2717,
      2721, 2722, 2723, 2725, 2711, 2724, 2710, 2720,
      2700, 2701, 2702, 2703, 2704, 2705, 2706, 2707,
      2708, 2709, 2712, 2713, 2730, 2726, 2731, 2715,
      2734, 2501, 2502, 2503, 2504, 2505, 2506, 2507,
      2508, 2509, 2510, 2511, 2512, 2513, 2514, 2515,
      2516, 2517, 2518, 2519, 2520, 2521, 2522, 2523,
      2524, 2525, 2526, 2223, 4178, 2224, 4110, 4013,
      2716, 2601, 2602, 2603, 2604, 2605, 2606, 2607,
      2608, 2609, 2610, 2611, 2612, 2613, 2614, 2615,
      2616, 2617, 2618, 2619, 2620, 2621, 2622, 2623,
      2624, 2625, 2626, 2225, 4108, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      2619, 4163, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      2699, 4115,  910,  272, UNDE, 4128, 4107, 2276,
      4182,  274, 0, UNDE, 4080, 4105,  273, 4187,
      2729, 2233, 0, 0, 4180, 3138, UNDE, 4131,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4116,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,  727,
      2515, ACC1, ACC1, ACC1, ACC1, ACC1, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
      2615, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    1, 3, false, true, true
  },
  {
    "HersheySans-BoldOblique",		/* #12 */
    NULL,
    "Duplex Roman (obliqued)",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2699, 2714, 2728, 2732, 2719, 2733, 2718, 2717,
      2721, 2722, 2723, 2725, 2711, 2724, 2710, 2720,
      2700, 2701, 2702, 2703, 2704, 2705, 2706, 2707,
      2708, 2709, 2712, 2713, 2730, 2726, 2731, 2715,
      2734, 2501, 2502, 2503, 2504, 2505, 2506, 2507,
      2508, 2509, 2510, 2511, 2512, 2513, 2514, 2515,
      2516, 2517, 2518, 2519, 2520, 2521, 2522, 2523,
      2524, 2525, 2526, 2223, 4178, 2224, 4110, 4013,
      2716, 2601, 2602, 2603, 2604, 2605, 2606, 2607,
      2608, 2609, 2610, 2611, 2612, 2613, 2614, 2615,
      2616, 2617, 2618, 2619, 2620, 2621, 2622, 2623,
      2624, 2625, 2626, 2225, 4108, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      2619, 4163, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      2699, 4115,  910,  272, UNDE, 4128, 4107, 2276,
      4182,  274, 0, UNDE, 4080, 4105,  273, 4187,
      2729, 2233, 0, 0, 4180, 3138, UNDE, 4131,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4116,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,  727,
      2515, ACC1, ACC1, ACC1, ACC1, ACC1, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
      2615, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    1, 4, true, true, true
  },
  {
    "HersheyScript",		/* #13 */
    NULL,
    "Simplex Script",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      699, 714, 717, 733, 719, 697, 734, 731,
      721, 722, 728, 725, 711, 724, 710, 720,
      700, 701, 702, 703, 704, 705, 706, 707,
      708, 709, 712, 713, 691, 726, 692, 715,
      690, 551, 552, 553, 554, 555, 556, 557,
      558, 559, 560, 561, 562, 563, 564, 565,
      566, 567, 568, 569, 570, 571, 572, 573,
      574, 575, 576, 693, 4002, 694, 4110, 4013,
      730, 651, 652, 653, 654, 655, 656, 657,
      658, 659, 660, 661, 662, 663, 664, 665,
      666, 667, 668, 669, 670, 671, 672, 673,
      674, 675, 676, 695, 723, 696, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      669, 0, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      699, 4111,  910,  272, UNDE, 4127, 4106, 2276,
      4182,  274, 0, UNDE, 4080, 4104,  273, 4187,
      718, 2233, 0, 0, 4180, 638, UNDE, 729,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4112,
      551, 551, 551, 551, 551, 551, UNDE, 553,
      555, 555, 555, 555, 559, 559, 559, 559,
      UNDE, 564, 565, 565, 565, 565, 565, 727,
      565, 571, 571, 571, 571, 575, UNDE, 0,
      651, 651, 651, 651, 651, 651, 0, 653,
      655, 655, 655, 655, 659, 659, 659, 659,
      UNDE, 664, 665, 665, 665, 665, 665, 2237,
      665, 671, 671, 671, 671, 675, UNDE, 675
    },
    2, 1, false, true, true
  },
  {
    "HersheyScript-Bold",		/* #14 */
    NULL,
    "Complex Script",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2749, 2764, 2778, 2782, 2769, 2783, 2768, 2767,
      2771, 2772, 2773, 2775, 2761, 2774, 2760, 2770,
      2750, 2751, 2752, 2753, 2754, 2755, 2756, 2757,
      2758, 2759, 2762, 2763, 2780, 2776, 2781, 2765,
      2784, 2551, 2552, 2553, 2554, 2555, 2556, 2557,
      2558, 2559, 2560, 2561, 2562, 2563, 2564, 2565,
      2566, 2567, 2568, 2569, 2570, 2571, 2572, 2573,
      2574, 2575, 2576, 2223, 4002, 2224, 4110, 4013,
      2766, 2651, 2652, 2653, 2654, 2655, 2656, 2657,
      2658, 2659, 2660, 2661, 2662, 2663, 2664, 2665,
      2666, 2667, 2668, 2669, 2670, 2671, 2672, 2673,
      2674, 2675, 2676, 2225, 2229, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      2669, 0, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      2749, 4117,  910,  272, UNDE, 4128, 4106, 2276,
      4182,  274, 0, UNDE, 4080, 4105,  273, 4187,
      2779, 2233, 0, 0, 4180, 638, UNDE, 729,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4118,
      2551, 2551, 2551, 2551, 2551, 2551, 0, 2553,
      2555, 2555, 2555, 2555, 2559, 2559, 2559, 2559,
      UNDE, 2554, 2555, 2555, 2555, 2555, 2555, 727,
      2555, 2571, 2571, 2571, 2571, 2575, UNDE, 0,
      2651, 2651, 2651, 2651, 2651, 2651, 0, 2653,
      2655, 2655, 2655, 2655, 2659, 2659, 2659, 2659,
      UNDE, 2664, 2665, 2665, 2665, 2665, 2665, 2237,
      2665, 2671, 2671, 2671, 2671, 2675, UNDE, 2675
    },
    2, 3, false, true, true
  },
  {
    "HersheyGothicEnglish",	/* #15 */
    "HersheyGothic-English",
    "Gothic English",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      3699, 3714, 3728, 3732, 3719, 3733, 3718, 3717,
      3721, 3722, 3723, 3725, 3711, 3724, 3710, 3720,
      3700, 3701, 3702, 3703, 3704, 3705, 3706, 3707,
      3708, 3709, 3712, 3713, 3730, 3726, 3731, 3715,
      3734, 3501, 3502, 3503, 3504, 3505, 3506, 3507,
      3508, 3509, 3510, 3511, 3512, 3513, 3514, 3515,
      3516, 3517, 3518, 3519, 3520, 3521, 3522, 3523,
      3524, 3525, 3526, 2223, 4178, 2224, 4110, 4013,
      3716, 3601, 3602, 3603, 3604, 3605, 3606, 3607,
      3608, 3609, 3610, 3611, 3612, 3613, 3614, 3615,
      3616, 3617, 3618, 3619, 3620, 3621, 3622, 3623,
      3624, 3625, 3626, 2225, 4108, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      3619, 4165, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      3699, 4123,  910,  272, UNDE, 4126, 4107, 2276,
      4182,  274, 0, UNDE, 4080, 4105,  273, 4187,
      3729, 2233, 0, 0, 4180, 3138, UNDE, 4131,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4124,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,  727,
      3515, ACC1, ACC1, ACC1, ACC1, ACC1, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
      3615, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    3, 1, false, true, true
  },
  {
    "HersheyGothicGerman",	/* #16 */
    "HersheyGothic-German",
    "Gothic German",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      3249, 3214, 3228, 3232, 3219, 3233, 3218, 3217,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 3230, 3226, 3231, 3215,
      3234, 3301, 3302, 3303, 3304, 3305, 3306, 3307,
      3308, 3309, 3310, 3311, 3312, 3313, 3314, 3315,
      3316, 3317, 3318, 3319, 3320, 3321, 3322, 3323,
      3324, 3325, 3326, 2223, 4178, 2224, 4110, 4013,
      3216, 3401, 3402, 3403, 3404, 3405, 3406, 3407,
      3408, 3409, 3410, 3411, 3412, 3413, 3414, 3415,
      3416, 3417, 3418, 3419, 3420, 3421, 3422, 3423,
      3424, 3425, 3426, 2225, 4108, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 4179, 3429, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      3427, 4164, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      3249, 4119,  910,  272, UNDE, 4126, 4107, 2276,
      4182,  274, 0, UNDE, 4080, 4105,  273, 4187,
      3229, 2233, 0, 0, 4180, 3138, UNDE, 4131,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4120,
      ACC1, ACC1, ACC1, ACC1, 3330, ACC1,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, 3331,  727,
      3515, ACC1, ACC1, ACC1, 3332, ACC1, UNDE, 3428,
      ACC0, ACC0, ACC0, ACC0, 3430, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, 3431, 2237,
      3615, ACC0, ACC0, ACC0, 3432, ACC0, UNDE, ACC0,
    },
    4, 1, false, true, true
  },
  {
    "HersheyGothicItalian",	/* #17 */
    "HersheyGothic-Italian",
    "Gothic Italian",
    {
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      3249, 3214, 3228, 3232, 3219, 3233, 3218, 3217,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 3230, 3226, 3231, 3215,
      3234, 3801, 3802, 3803, 3804, 3805, 3806, 3807,
      3808, 3809, 3810, 3811, 3812, 3813, 3814, 3815,
      3816, 3817, 3818, 3819, 3820, 3821, 3822, 3823,
      3824, 3825, 3826, 2223, 4178, 2224, 4110, 4013,
      3216, 3901, 3902, 3903, 3904, 3905, 3906, 3907,
      3908, 3909, 3910, 3911, 3912, 3913, 3914, 3915,
      3916, 3917, 3918, 3919, 3920, 3921, 3922, 3923,
      3924, 3925, 3926, 2225, 4108, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible to the user.  We store
	 ligatures, accents, and variant glyphs there. */
      0, 0, 0, 0, 0, 0, 0, 0, 
      4180, 4181, 4182, 4183, 4184, 4185, 4186, 0,
      0, 0, 0, 0, 0, 0, 0, 0,
      3919, 4166, 0, 0, 0, 0, 0, 0, 
      /* ISO-Latin-1 encoding resumes */
      3249, 4119,  910,  272, UNDE, 4126, 4107, 2276,
      4182,  274, 0, UNDE, 4080, 4105,  273, 4187,
      3229, 2233, 0, 0, 4180, 3138, UNDE, 4131,
      CEDILLA, 0, 0, UNDE, 270,  261,  271, 4120,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,    0, ACC0,
      ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,
      UNDE, ACC1, ACC1, ACC1, ACC1, ACC1, ACC1,  727,
      3815, ACC1, ACC1, ACC1, ACC1, ACC1, UNDE,    0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,    0, ACC0,
      ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0,
      UNDE, ACC0, ACC0, ACC0, ACC0, ACC0, ACC0, 2237,
      3915, ACC0, ACC0, ACC0, ACC0, ACC0, UNDE, ACC0,
    },
    5, 1, false, true, true
  },
  {
    "HersheySerifSymbol",	/* #18 */
    "HersheySerif-Symbol",	/* for backward compatibility */
    "Complex Greek",
    {
      /* The range 00..037 isn't accessible except through macros, since in
	 the standard symbol encoding, it's empty.  We store misc. non-font
	 characters (e.g., Hershey zodiacal signs) in this range. */
         0, 2301, 2302, 2303, 2304, 2305, 2306, 2307,
      2308, 2309, 2310, 2311, 2312,    0,    0,    0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 2214, 4014, 2275, 2279, 2271, 2272,  282,
      2221, 2222, 2219, 2232, 2211, 2231, 2210, 2220,
      2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207,
      2208, 2209, 2212, 2213, 2241, 2238, 2242, 2215,
       250, 2027, 2028, 2048, 2030, 2031, 2047, 2029,
      2033, 2035, 2134, 2036, 2037, 2038, 2039, 2041,
      2042, 2034, 2043, 2044, 2045, 2025, 2187, 2050,
      2040, 2049, 2032, 2223,  740, 2224,  738, 4013,
      4009, 2127, 2128, 2148, 2130, 2131, 2186, 2129,
      2133, 2135, 2147, 2136, 2137, 2138, 2139, 2141,
      2142, 2185, 2143, 2144, 2145, 2146, 4083, 2150,
      2140, 2149, 2132, 2225, 2229, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible except through macros, since
	 in the standard symbol encoding, it's empty.  We store
	 misc. non-font characters (e.g., Hershey astronomical symbols) in
	 this range. */
         0,    0,    0,    0, 4019, 4020, 4021, 4022,
      UNDE, 2281, 2282, 2283, 2284, 2285, 2286, 2287,
      2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295,
      2187, 2277, 2278, 2269, 2234, 2230, 4008, 4012, 
      /* symbol encoding resumes... */
      2199, 2046, 2216, 2243, 2220, 2270, 2156,  744,
       743,  742,  741, 4045, 2263, 2262, 2261, 2264,
      2218, 2233, 2217, 2244, 2235, 2245, 2265,  828,
      2237, 2239, 2240,  248, 4070, 4044, 4051, 4065,
      2077, 3309, 3318, 2190, 4003, 4004, 4071, 2259,
      2257, 2258, 4011, 4082, 2256, 4010, 2260, 4007,
       739, 2266,  273,  274, 4098, 2401, 2267, 2236,
      4080, 4078, 4081, 4046, 4048, 4050, 4049, 4047,
       743, 2227,  273,  274, 4097, 2402, UNDE, UNDE,
      UNDE, 4176, UNDE, 4174, UNDE, UNDE, UNDE, UNDE,
      UNDE, 2228, 2268, UNDE, UNDE, UNDE, UNDE, UNDE,
      UNDE, 4177, UNDE, 4175, UNDE, UNDE, UNDE,    0
    },
    6, 1, false, false, true
  },
  {
    "HersheySerifSymbol-Oblique",	/* #19 */
    NULL,
    "Complex Greek (obliqued)",
    {
      /* The range 00..037 isn't accessible except through macros, since in
	 the standard symbol encoding, it's empty.  We store misc. non-font
	 characters (e.g., Hershey zodiacal signs) in this range. */
         0, 2301, 2302, 2303, 2304, 2305, 2306, 2307,
      2308, 2309, 2310, 2311, 2312,    0,    0,    0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 2214, 4014, 2275, 2279, 2271, 2272,  282,
      2221, 2222, 2219, 2232, 2211, 2231, 2210, 2220,
      2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207,
      2208, 2209, 2212, 2213, 2241, 2238, 2242, 2215,
       250, 2027, 2028, 2048, 2030, 2031, 2047, 2029,
      2033, 2035, 2134, 2036, 2037, 2038, 2039, 2041,
      2042, 2034, 2043, 2044, 2045, 2025, 2187, 2050,
      2040, 2049, 2032, 2223,  740, 2224,  738, 4013,
      4009, 2127, 2128, 2148, 2130, 2131, 2186, 2129,
      2133, 2135, 2147, 2136, 2137, 2138, 2139, 2141,
      2142, 2185, 2143, 2144, 2145, 2146, 4083, 2150,
      2140, 2149, 2132, 2225, 2229, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible except through macros, since
	 in the standard symbol encoding, it's empty.  We store
	 misc. non-font characters (e.g., Hershey astronomical symbols) in
	 this range. */
         0,    0,    0,    0, 4019, 4020, 4021, 4022,
      UNDE, 2281, 2282, 2283, 2284, 2285, 2286, 2287,
      2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295,
      2187, 2277, 2278, 2269, 2234, 2230, 4008, 4012, 
      /* symbol encoding resumes... */
      2199, 2046, 2216, 2243, 2220, 2270, 2156,  744,
       743,  742,  741, 4045, 2263, 2262, 2261, 2264,
      2218, 2233, 2217, 2244, 2235, 2245, 2265,  828,
      2237, 2239, 2240,  248, 4070, 4044, 4051, 4065,
      2077, 3309, 3318, 2190, 4003, 4004, 4071, 2259,
      2257, 2258, 4011, 4082, 2256, 4010, 2260, 4007,
       739, 2266,  273,  274, 4098, 2401, 2267, 2236,
      4080, 4078, 4081, 4046, 4048, 4050, 4049, 4047,
       743, 2227,  273,  274, 4097, 2402, UNDE, UNDE,
      UNDE, 4176, UNDE, 4174, UNDE, UNDE, UNDE, UNDE,
      UNDE, 2228, 2268, UNDE, UNDE, UNDE, UNDE, UNDE,
      UNDE, 4177, UNDE, 4175, UNDE, UNDE, UNDE,    0
    },
    6, 2, true, false, true
  },
  {
    "HersheySerifSymbol-Bold",	/* #20 */
    NULL,
    "Triplex Greek",
    {
      /* The range 00..037 isn't accessible except through macros, since in
	 the standard symbol encoding, it's empty.  We store misc. non-font
	 characters (e.g., Hershey zodiacal signs) in this range. */
         0, 2301, 2302, 2303, 2304, 2305, 2306, 2307,
      2308, 2309, 2310, 2311, 2312,    0,    0,    0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 3214, 4014, 3232, 2279, 3233, 3219,  282,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 3230, 3226, 3231, 3215,
       250, 3027, 3028, 3048, 3030, 3031, 3047, 3029,
      3033, 3035, 3134, 3036, 3037, 3038, 3039, 3041,
      3042, 3034, 3043, 3044, 3045, 3025, 3187, 3050,
      3040, 3049, 3032, 2223,  740, 2224,  738, 4013,
      4009, 3127, 3128, 3148, 3130, 3131, 3186, 3129,
      3133, 3135, 3147, 3136, 3137, 3138, 3139, 3141,
      3142, 3185, 3143, 3144, 3145, 3146, 3150, 3150,
      3140, 3149, 3132, 2225, 4108, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible except through macros, since
	 in the standard symbol encoding, it's empty.  We store
	 misc. non-font characters (e.g., Hershey astronomical symbols) in
	 this range. */
         0,    0,    0,    0, 4019, 4020, 4021, 4022,
      UNDE, 2281, 2282, 2283, 2284, 2285, 2286, 2287,
      2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295,
      3187, 2277, 2278, 2269, 2234, 2230, 4008, 4012, 
      /* symbol encoding resumes... */
      2199, 3046, 3227, 2243, 3220, 2270, 3156,  744,
       743,  742,  741, 4045, 2263, 2262, 2261, 2264,
      3218, 2233, 3228, 2244, 2235, 2245, 3183,  828,
      2237, 2239, 2240,  248, 4070, 4044, 4051, 4065,
      2077, 3309, 3318, 2190, 4003, 4004, 4071, 2259,
      2257, 2258, 4011, 4082, 2256, 4010, 2260, 4007,
       739, 3083,  273,  274, 4098, 2401, 2267, 2236,
      4080, 4078, 4081, 4046, 4048, 4050, 4049, 4047,
       743, 2227,  273,  274, 4097, 2402, UNDE, UNDE,
      UNDE, 4176, UNDE, 4174, UNDE, UNDE, UNDE, UNDE,
      UNDE, 2228, 2268, UNDE, UNDE, UNDE, UNDE, UNDE,
      UNDE, 4177, UNDE, 4175, UNDE, UNDE, UNDE,    0
    },
    6, 3, false, false, true
  },
  {
    "HersheySerifSymbol-BoldOblique",	/* #21 */
    NULL,
    "Triplex Greek (obliqued)",
    {
      /* The range 00..037 isn't accessible except through macros, since in
	 the standard symbol encoding, it's empty.  We store misc. non-font
	 characters (e.g., Hershey zodiacal signs) in this range. */
         0, 2301, 2302, 2303, 2304, 2305, 2306, 2307,
      2308, 2309, 2310, 2311, 2312,    0,    0,    0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199, 3214, 4014, 3232, 2279, 3233, 3219,  282,
      3221, 3222, 3223, 3225, 3211, 3224, 3210, 3220,
      3200, 3201, 3202, 3203, 3204, 3205, 3206, 3207,
      3208, 3209, 3212, 3213, 3230, 3226, 3231, 3215,
       250, 3027, 3028, 3048, 3030, 3031, 3047, 3029,
      3033, 3035, 3134, 3036, 3037, 3038, 3039, 3041,
      3042, 3034, 3043, 3044, 3045, 3025, 3187, 3050,
      3040, 3049, 3032, 2223,  740, 2224,  738, 4013,
      4009, 3127, 3128, 3148, 3130, 3131, 3186, 3129,
      3133, 3135, 3147, 3136, 3137, 3138, 3139, 3141,
      3142, 3185, 3143, 3144, 3145, 3146, 3150, 3150,
      3140, 3149, 3132, 2225, 4108, 2226, 2246, 0,
      /* The range 0200--0237 isn't accessible except through macros, since
	 in the standard symbol encoding, it's empty.  We store
	 misc. non-font characters (e.g., Hershey astronomical symbols) in
	 this range. */
         0,    0,    0,    0, 4019, 4020, 4021, 4022,
      UNDE, 2281, 2282, 2283, 2284, 2285, 2286, 2287,
      2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295,
      3187, 2277, 2278, 2269, 2234, 2230, 4008, 4012, 
      /* symbol encoding resumes... */
      2199, 3046, 3227, 2243, 3220, 2270, 3156,  744,
       743,  742,  741, 4045, 2263, 2262, 2261, 2264,
      3218, 2233, 3228, 2244, 2235, 2245, 3183,  828,
      2237, 2239, 2240,  248, 4070, 4044, 4051, 4065,
      2077, 3309, 3318, 2190, 4003, 4004, 4071, 2259,
      2257, 2258, 4011, 4082, 2256, 4010, 2260, 4007,
       739, 3083,  273,  274, 4098, 2401, 2267, 2236,
      4080, 4078, 4081, 4046, 4048, 4050, 4049, 4047,
       743, 2227,  273,  274, 4097, 2402, UNDE, UNDE,
      UNDE, 4176, UNDE, 4174, UNDE, UNDE, UNDE, UNDE,
      UNDE, 2228, 2268, UNDE, UNDE, UNDE, UNDE, UNDE,
      UNDE, 4177, UNDE, 4175, UNDE, UNDE, UNDE,    0
    },
    6, 4, true, false, true
  },
  {
    "HersheySansSymbol",	/* #22 */
    "HersheySans-Symbol",	/* for backward compatibility */
    "Simplex Greek",
    {
      /* The range 00..037 isn't accessible except through macros, since in
	 the standard symbol encoding, it's empty.  We store misc. non-font
	 characters (e.g., Hershey zodiacal signs) in this range. */
         0, 2301, 2302, 2303, 2304, 2305, 2306, 2307,
      2308, 2309, 2310, 2311, 2312,    0,    0,    0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199,  714, 4014,  733, 2279,  697,  734,  282,
       721,  722,  728,  725,  711,  724,  710,  720,
       700,  701,  702,  703,  704,  705,  706,  707,
       708,  709,  712,  713, 2241,  726, 2242,  715,
       250,  527,  528,  548,  530,  531,  547,  529,
       533,  535,  534,  536,  537,  538,  539,  541,
       542,  534,  543,  544,  545,  525,  687,  550,
       540,  549,  532,  693,  740,  694,  738, 4013,
      4009,  627,  628,  648,  630,  631,  686,  629,
       633,  635,  647,  636,  637,  638,  639,  641,
       642,  685,  643,  644,  645,  646,  650,  650,
       640,  649,  632,  695, 2229,  696, 2246,    0,
      /* The range 0200--0237 isn't accessible except through macros, since
	 in the standard symbol encoding, it's empty.  We store
	 misc. non-font characters (e.g., Hershey astronomical symbols) in
	 this range. */
         0,    0,    0,    0, 4019, 4020, 4021, 4022,
      UNDE, 2281, 2282, 2283, 2284, 2285, 2286, 2287,
      2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295,
       687, 2277, 2278, 2269, 2234, 2230, 4008, 4012, 
      /* symbol encoding resumes... */
      2199,  546,  716, 2243,  720,  736, 2156,  744,
       743,  742,  741, 4045, 2263, 2262, 2261, 2264,
       718, 2233,  717, 2244, 2235, 2245,  683,  828,
      2237, 2239, 2240,  248, 4070, 4044, 4051, 4065,
      2077, 3309, 3318, 2190, 4003, 4004, 4071, 2259,
      2257, 2258, 4011, 4082, 2256, 4010, 2260, 4007,
       739,  583,  273,  274, 4098, 2401, 2267, 2236,
      4080, 4078, 4081, 4046, 4048, 4050, 4049, 4047,
       743, 2227,  273,  274, 4097, 2402, UNDE, UNDE,
      UNDE, 4172, UNDE, 4170, UNDE, UNDE, UNDE, UNDE,
      UNDE, 2228, 2268, UNDE, UNDE, UNDE, UNDE, UNDE,
      UNDE, 4173, UNDE, 4171, UNDE, UNDE, UNDE,    0
    },
    7, 1, false, false, true
  },
  {
    "HersheySansSymbol-Oblique", /* #23 */
    NULL,
    "Simplex Greek (obliqued)",
    {
      /* The range 00..037 isn't accessible except through macros, since in
	 the standard symbol encoding, it's empty.  We store misc. non-font
	 characters (e.g., Hershey zodiacal signs) in this range. */
         0, 2301, 2302, 2303, 2304, 2305, 2306, 2307,
      2308, 2309, 2310, 2311, 2312,    0,    0,    0,
      0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0,
      2199,  714, 4014,  733, 2279,  697,  734,  282,
       721,  722,  728,  725,  711,  724,  710,  720,
       700,  701,  702,  703,  704,  705,  706,  707,
       708,  709,  712,  713, 2241,  726, 2242,  715,
       250,  527,  528,  548,  530,  531,  547,  529,
       533,  535,  534,  536,  537,  538,  539,  541,
       542,  534,  543,  544,  545,  525,  687,  550,
       540,  549,  532,  693,  740,  694,  738, 4013,
      4009,  627,  628,  648,  630,  631,  686,  629,
       633,  635,  647,  636,  637,  638,  639,  641,
       642,  685,  643,  644,  645,  646,  650,  650,
       640,  649,  632,  695, 2229,  696, 2246,    0,
      /* The range 0200--0237 isn't accessible except through macros, since
	 in the standard symbol encoding, it's empty.  We store
	 misc. non-font characters (e.g., Hershey astronomical symbols) in
	 this range. */
         0,    0,    0,    0, 4019, 4020, 4021, 4022,
      UNDE, 2281, 2282, 2283, 2284, 2285, 2286, 2287,
      2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295,
       687, 2277, 2278, 2269, 2234, 2230, 4008, 4012, 
      /* symbol encoding resumes... */
      2199,  546,  716, 2243,  720,  736, 2156,  744,
       743,  742,  741, 4045, 2263, 2262, 2261, 2264,
       718, 2233,  717, 2244, 2235, 2245,  683,  828,
      2237, 2239, 2240,  248, 4070, 4044, 4051, 4065,
      2077, 3309, 3318, 2190, 4003, 4004, 4071, 2259,
      2257, 2258, 4011, 4082, 2256, 4010, 2260, 4007,
       739,  583,  273,  274, 4098, 2401, 2267, 2236,
      4080, 4078, 4081, 4046, 4048, 4050, 4049, 4047,
       743, 2227,  273,  274, 4097, 2402, UNDE, UNDE,
      UNDE, 4172, UNDE, 4170, UNDE, UNDE, UNDE, UNDE,
      UNDE, 2228, 2268, UNDE, UNDE, UNDE, UNDE, UNDE,
      UNDE, 4173, UNDE, 4171, UNDE, UNDE, UNDE,    0
    },
    7, 2, true, false, true
  },
  {
    NULL,			/* DUMMY */
    NULL,
    NULL,
    {
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0,      
      0, 0, 0, 0, 0, 0
    },
    0, 0, false, false, false
  }
};

/* Accented character table, used (1) by ISO-Latin-1 Hershey fonts, and (2)
   by HersheyCyrillic and HersheyCyrillic-Oblique.  (Really the union of
   three non-conflicting tables.)  This table maps each accented character
   to a base character and an accent.

   The indices of the accent glyphs, in the glyph table in g_her_glyph.c,
   are stored in the inaccessible 0x80--0x9f region (i.e., \0200--\0237
   region) of each font. */

const struct plHersheyAccentedCharInfoStruct _hershey_accented_char_info[] = 
{
  /* for HersheyCyrillic[-Oblique] (KOI8-R encoding) accented characters */
  {0243, 0305, 0212},		/* edieresis */
  {0263, 0345, 0212},		/* Edieresis */
  /* for ISO-Latin-1 accented characters */
  {0300, 'A', 0211},		/* Agrave */
  {0301, 'A', 0210},		/* Aacute */
  {0302, 'A', 0213},		/* Acircumflex */
  {0303, 'A', 0215},		/* Atilde */
  {0304, 'A', 0212},		/* Adieresis */
  {0305, 'A', 0216},		/* Aring */
  {0307, 'C', 0217},		/* Ccedilla */
  {0310, 'E', 0211},		/* Egrave */
  {0311, 'E', 0210},		/* Eacute */
  {0312, 'E', 0213},		/* Ecircumflex */
  {0313, 'E', 0212},		/* Edieresis */
  {0314, 'I', 0210},		/* Igrave */
  {0315, 'I', 0211},		/* Iacute */
  {0316, 'I', 0214},		/* Icircumflex (note narrow circ.) */
  {0317, 'I', 0212},		/* Idieresis */
  {0321, 'N', 0215},		/* Ntilde */
  {0322, 'O', 0211},		/* Ograve */
  {0323, 'O', 0210},		/* Oacute */
  {0324, 'O', 0213},		/* Ocircumflex */
  {0325, 'O', 0215},		/* Otilde */
  {0326, 'O', 0212},		/* Odieresis */
  {0331, 'U', 0211},		/* Ugrave */
  {0332, 'U', 0210},		/* Uacute */
  {0333, 'U', 0213},		/* Ucircumflex */
  {0334, 'U', 0212},		/* Udieresis */
  {0335, 'Y', 0210},		/* Yacute */
  {0340, 'a', 0211},		/* agrave */
  {0341, 'a', 0210},		/* aacute */
  {0342, 'a', 0214},		/* acircumflex */
  {0343, 'a', 0215},		/* atilde */
  {0344, 'a', 0212},		/* adieresis */
  {0345, 'a', 0216},		/* aring */
  {0347, 'c', 0217},		/* ccedilla */
  {0350, 'e', 0211},		/* egrave */
  {0351, 'e', 0210},		/* eacute */
  {0352, 'e', 0214},		/* ecircumflex */
  {0353, 'e', 0212},		/* edieresis */
  {0354, 0231, 0210},		/* igrave */
  {0355, 0231, 0211},		/* iacute */
  {0356, 0231, 0214},		/* icircumflex (note narrow circ.) */
  {0357, 0231, 0212},		/* idieresis */
  {0361, 'n', 0215},		/* ntilde */
  {0362, 'o', 0211},		/* ograve */
  {0363, 'o', 0210},		/* oacute */
  {0364, 'o', 0214},		/* ocircumflex */
  {0365, 'o', 0215},		/* otilde */
  {0366, 'o', 0212},		/* odieresis */
  {0371, 'u', 0211},		/* ugrave */
  {0372, 'u', 0210},		/* uacute */
  {0373, 'u', 0214},		/* ucircumflex */
  {0374, 'u', 0212},		/* udieresis */
  {0375, 'y', 0210},		/* yacute */
  {0377, 'y', 0212},		/* ydieresis */
  {0, 0, 0}
};

/* known Hershey vector font typefaces.  Each plTypefaceInfoStruct contains
   the following information:
   
   (1) number of valid fonts [should be >= 2, since every typeface
       should include a symbol font (the zeroth font, the 1st listed)]
   (2) a list of fonts (each number is an index into
       the _hershey_font_info[] array above).

   The number of valid fonts should be <= FONTS_PER_TYPEFACE; the
   initializers are filled out with dummy fonts to get arrays of length
   FONTS_PER_TYPEFACE. */

const struct plTypefaceInfoStruct _hershey_typeface_info[] = 
{
  /* Hershey Serif [including Cyrillic, Cyrillic-Obl., and EUC], typeface #0 */
  { 8, { 18, 0, 1, 2, 3, 4, 5, 8, 999, 999 } },
  /* Hershey Sans, typeface #1 */
  { 5, { 22, 9, 10, 11, 12, 999, 999, 999, 999, 999 } },
  /* Hershey Script [note duplicates], typeface #2 */
  { 5, { 18, 13, 13, 14, 14, 999, 999, 999, 999, 999 } },
  /* Hershey Gothic English, typeface #3 */
  { 2, { 18, 15, 999, 999, 999, 999, 999, 999, 999, 999 } },
  /* Hershey Gothic German, typeface #4 */
  { 2, { 18, 16, 999, 999, 999, 999, 999, 999, 999, 999 } },
  /* Hershey Gothic Italian, typeface #5 */
  { 2, { 18, 17, 999, 999, 999, 999, 999, 999, 999, 999 } },
  /* Hershey Serif Symbol, typeface #6 */
  { 5, { 18, 18, 19, 20, 21, 999, 999, 999, 999, 999 } },
  /* Hershey Sans Symbol, typeface #7 */
  { 3, { 22, 22, 23, 999, 999, 999, 999, 999, 999, 999 } },
};
