/*
 * (llc_c_st.c)- This module contains state transition of connection component.
 * 
 * Description of event functions and actions there is in 802.2 LLC standard,
 * or in "llc_c_ac.c" and "llc_c_ev.c" modules.
 *
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 

#define LLC_C_ST_C


#include <net/cm_types.h>
#include <net/cm_mm.h>
#include <net/cm_dll.h>
#include <net/cm_frame.h>
#include <net/llc_if.h>
#include <net/llc_sap.h>
#include <net/llc_conn.h>
#include <net/llc_main.h>
#include <net/llc_glob.h>
#include <net/llc_c_ev.h>
#include <net/llc_c_ac.h>
#include <net/llc_c_st.h>
#include <net/llc_dbg.h>
#include <net/llc_pdu.h>

#ifdef LLC_C_ST_DBG
  #define  DBG_MSG(body) { printk body; }
#else
  #define  DBG_MSG(body)  ;
#endif

#define NO_EVENT_QUALIFIERS    NULL
#define NO_TRANSITION_ACTIONS  NULL


/* ----------------- COMMON CONNECTION STATE transitions ----------------- *
 * Common transitions for 
 * CONN_STATE_NORMAL, 
 * CONN_STATE_BUSY, 
 * CONN_STATE_REJECT,
 * CONN_STATE_AWAIT, 
 * CONN_STATE_AWAIT_BUSY  and
 * CONN_STATE_AWAIT_REJECT  states
 */

/* 
 * State transitions for 
 * CONN_EV_DISCONNECT_REQUEST event 
 */

static conn_action_t common_actions_1 [] = 
{
	conn_ac_send_disc_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	conn_ac_set_cause_flag_1,
	NULL
};

static conn_state_transition_t common_state_transition_1 = 
{  
	conn_ev_disconnect_request,
	CONN_STATE_D_CONN,
	NO_EVENT_QUALIFIERS,
	common_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_RESET_REQUEST event 
 */

static conn_action_t common_actions_2 [] = 
{
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	conn_ac_set_cause_flag_1,
	NULL
};

static conn_state_transition_t common_state_transition_2 =
{  
	conn_ev_reset_request,
	CONN_STATE_RESET,
	NO_EVENT_QUALIFIERS,
	common_actions_2
};


/* 
 * State transitions for 
 * CONN_EV_RX_SABME_CMD_Pbit_SET_X event 
 */

static conn_action_t common_actions_3 [] =
{
	conn_ac_stop_all_timers,
	conn_ac_set_vs_0,
	conn_ac_set_vr_0,
	conn_ac_send_ua_rsp_f_set_p,
	conn_ac_reset_indication,      
	conn_ac_set_p_flag_0,        
	conn_ac_set_remote_busy_0,
	conn_reset,
	NULL
};

static conn_state_transition_t common_state_transition_3 =
{  
	conn_ev_rx_sabme_cmd_pbit_set_x,
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,
	common_actions_3
};


/* 
 * State transitions for 
 * CONN_EV_RX_DISC_CMD_Pbit_SET_X event 
 */

static conn_action_t common_actions_4 [] =
{
	conn_ac_stop_all_timers,
	conn_ac_send_ua_rsp_f_set_p,        
	conn_ac_disconnect_indication,
	conn_disconnect, 
	NULL
};

static conn_state_transition_t common_state_transition_4 =
{  
	conn_ev_rx_disc_cmd_pbit_set_x,
	CONN_STATE_ADM,
	NO_EVENT_QUALIFIERS,
	common_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_RX_FRMR_RSP_Fbit_SET_X event 
 */

static conn_action_t common_actions_5 [] =
{
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	conn_ac_reset_indication,  
	conn_ac_set_cause_flag_0,
	conn_reset,
	NULL
};

static conn_state_transition_t common_state_transition_5 =
{  
	conn_ev_rx_frmr_rsp_fbit_set_x,
	CONN_STATE_RESET,
	NO_EVENT_QUALIFIERS,
	common_actions_5
};


/* 
 * State transitions for 
 * CONN_EV_RX_DM_RSP_Fbit_SET_X event 
 */

us16 my_action1(connection_t *conn, conn_state_event_t *event)

{
	printk("start of DM processing ...\n");
	return (0);
}
us16 my_action2(connection_t *conn, conn_state_event_t *event)

{
	printk("end of DM processing ...\n");
	return (0);
}
static conn_action_t common_actions_6 [] =
{
	conn_ac_disconnect_indication,
	conn_ac_stop_all_timers,
	conn_disconnect,
	NULL
};

static conn_state_transition_t common_state_transition_6 =
{  
	conn_ev_rx_dm_rsp_fbit_set_x,
	CONN_STATE_ADM,
	NO_EVENT_QUALIFIERS,
        common_actions_6
};


/* 
 * State transitions for 
 * CONN_EV_RX_ZZZ_CMD_Pbit_SET_X_INVAL_Nr event 
 */

static conn_action_t common_actions_7a [] =
{
	conn_ac_send_frmr_rsp_f_set_x,         
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	NULL
};

static conn_state_transition_t common_state_transition_7a =
{  
	conn_ev_rx_zzz_cmd_pbit_set_x_inval_nr,
	CONN_STATE_ERROR,
	NO_EVENT_QUALIFIERS,
	common_actions_7a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_X_INVAL_Ns event 
 */

static conn_action_t common_actions_7b [] =
{
	conn_ac_send_frmr_rsp_f_set_x,         
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	NULL
};

static conn_state_transition_t common_state_transition_7b =
{  
	conn_ev_rx_i_cmd_pbit_set_x_inval_ns,
	CONN_STATE_ERROR,
	NO_EVENT_QUALIFIERS,
	common_actions_7b
};


/* 
 * State transitions for 
 * CONN_EV_RX_ZZZ_RSP_Fbit_SET_X_INVAL_Nr event 
 */

static conn_action_t common_actions_8a [] =
{
	conn_ac_send_frmr_rsp_f_set_x,   
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	NULL
};

static conn_state_transition_t common_state_transition_8a =
{  
	conn_ev_rx_zzz_rsp_fbit_set_x_inval_nr,
	CONN_STATE_ERROR,
	NO_EVENT_QUALIFIERS,
	common_actions_8a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_X_INVAL_Ns event 
 */

static conn_action_t common_actions_8b [] =
{
	conn_ac_send_frmr_rsp_f_set_x,     
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	NULL
};

static conn_state_transition_t common_state_transition_8b =
{  
	conn_ev_rx_i_rsp_fbit_set_x_inval_ns,
	CONN_STATE_ERROR,
	NO_EVENT_QUALIFIERS,
	common_actions_8b
};


/* 
 * State transitions for 
 * CONN_EV_RX_BAD_PDU event 
 */

static conn_action_t common_actions_8c [] =
{
	conn_ac_send_frmr_rsp_f_set_x,  
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	NULL
};

static conn_state_transition_t common_state_transition_8c =
{  
	conn_ev_rx_bad_pdu,
	CONN_STATE_ERROR,
	NO_EVENT_QUALIFIERS,
	common_actions_8c
};


/* 
 * State transitions for 
 * CONN_EV_RX_UA_RSP_Fbit_SET_X event 
 */

static conn_action_t common_actions_9 [] =
{
	conn_ac_send_frmr_rsp_f_set_x,   
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	NULL
};

static conn_state_transition_t common_state_transition_9 =
{  
	conn_ev_rx_ua_rsp_fbit_set_x,
	CONN_STATE_ERROR,
	NO_EVENT_QUALIFIERS,
	common_actions_9
};


/* 
 * State transitions for 
 * CONN_EV_RX_XXX_RSP_Fbit_SET_1 event 
 */

/*

static conn_event_qfyr_t common_ev_qfyrs_10 [] = 
{
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t common_actions_10 [] =
{
	conn_ac_send_frmr_rsp_f_set_x, 
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	NULL
};

static conn_state_transition_t common_state_transition_10 =
{  
	conn_ev_rx_xxx_rsp_fbit_set_1,
	CONN_STATE_ERROR,
	common_ev_qfyrs_10,
	common_actions_10
};

*/

/* 
 * State transitions for 
 * CONN_EV_P_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t common_ev_qfyrs_11a [] = 
{
	conn_ev_qlfy_retry_count_gte_n2,
	NULL
};

static conn_action_t common_actions_11a [] =
{
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	conn_ac_set_cause_flag_0,
	NULL
};

static conn_state_transition_t common_state_transition_11a =
{  
	conn_ev_p_timer_expired,
	CONN_STATE_RESET,
	common_ev_qfyrs_11a,
	common_actions_11a
};


/* 
 * State transitions for 
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t common_ev_qfyrs_11b [] = 
{
	conn_ev_qlfy_retry_count_gte_n2,
	NULL
};

static conn_action_t common_actions_11b [] =
{   
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	conn_ac_set_cause_flag_0,
	NULL
};

static conn_state_transition_t common_state_transition_11b =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_RESET,
	common_ev_qfyrs_11b,
	common_actions_11b
};


/* 
 * State transitions for 
 * CONN_EV_REJ_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t common_ev_qfyrs_11c [] = 
{
	conn_ev_qlfy_retry_count_gte_n2, 
	NULL
};

static conn_action_t common_actions_11c [] =
{   
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	conn_ac_set_cause_flag_0,
	NULL
};

static conn_state_transition_t common_state_transition_11c =
{  
	conn_ev_rej_timer_expired,
	CONN_STATE_RESET,
	common_ev_qfyrs_11c,
	common_actions_11c
};


/* 
 * State transitions for 
 * CONN_EV_BUSY_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t   common_ev_qfyrs_11d [] = 
{
	conn_ev_qlfy_retry_count_gte_n2, 
	NULL
};

static conn_action_t common_actions_11d [] =
{  
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_stop_other_timers,
	conn_ac_set_retry_count_0,
	conn_ac_set_cause_flag_0,
	NULL
};

static conn_state_transition_t common_state_transition_11d =
{  
	conn_ev_busy_timer_expired,
	CONN_STATE_RESET,
	common_ev_qfyrs_11d,
	common_actions_11d
};


/* 
 * Common dummy state transition; must be last entry for all state
 * transition groups
 */

static conn_state_transition_t common_state_transition_n =
{
	NULL,
	0,
	NULL,
	NULL
};


/* --------------------- CONN_STATE_ADM transitions ---------------------- */


/* 
 * State transitions for 
 * CONN_EV_CONNECT_REQUEST event 
 */

static conn_action_t adm_actions_1 [] =
{
	conn_ac_send_sabme_cmd_p_set_x,  
	conn_ac_start_ack_timer,
	conn_ac_set_retry_count_0,
	conn_ac_set_s_flag_0,
	NULL
};

static conn_state_transition_t adm_state_transition_1 =
{  
	conn_ev_connect_request,
	CONN_STATE_SETUP,
	NO_EVENT_QUALIFIERS,
	adm_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_RX_SABME_CMD_Pbit_SET_X event 
 */

static conn_action_t adm_actions_2 [] =
{  
	conn_ac_send_ua_rsp_f_set_p,       
	conn_ac_set_vs_0,
	conn_ac_set_vr_0,
	conn_ac_set_retry_count_0,
	conn_ac_set_p_flag_0,    
	conn_ac_set_remote_busy_0,
	conn_ac_connect_indication,   
	NULL
};

static conn_state_transition_t adm_state_transition_2 =
{  
	conn_ev_rx_sabme_cmd_pbit_set_x, 
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,             
	adm_actions_2
};


/* 
 * State transitions for 
 * CONN_EV_RX_DISC_CMD_Pbit_SET_X event 
 */

static conn_action_t adm_actions_3 [] =
{
	conn_ac_send_dm_rsp_f_set_p,       
	conn_disconnect,
	NULL
};

static conn_state_transition_t adm_state_transition_3 =
{  
	conn_ev_rx_disc_cmd_pbit_set_x,
	CONN_STATE_ADM,
	NO_EVENT_QUALIFIERS,
	adm_actions_3
};


/* 
 * State transitions for 
 * CONN_EV_RX_XXX_CMD_Pbit_SET_1 event 
 */

static conn_action_t adm_actions_4 [] =
{
	conn_ac_send_dm_rsp_f_set_1,     
	conn_disconnect,
	NULL
};

static conn_state_transition_t adm_state_transition_4 =
{  
	conn_ev_rx_xxx_cmd_pbit_set_1,
	CONN_STATE_ADM,
	NO_EVENT_QUALIFIERS,
	adm_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_RX_XXX_YYY event 
 */

static conn_action_t adm_actions_5 [] =
{
	conn_disconnect,            
	NULL
};

static conn_state_transition_t adm_state_transition_5 =
{  
	conn_ev_rx_any_frame,
	CONN_OUT_OF_SVC,
	NO_EVENT_QUALIFIERS,
	adm_actions_5
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t *adm_state_transitions [] =
{
	&adm_state_transition_1,     // Request
	&common_state_transition_n,

	&common_state_transition_n,  // local_busy

	&common_state_transition_n,  // init_pf_cycle

	&common_state_transition_n,  // timer

	&adm_state_transition_2,     // Receive frame
	&adm_state_transition_3,
	&adm_state_transition_4,
	&adm_state_transition_5,

	&common_state_transition_n
};


/* ---------------------  CONN_STATE_SETUP transitions ------------------- */


/* 
 * State transitions for 
 * CONN_EV_RX_SABME_CMD_Pbit_SET_X event 
 */

static conn_action_t setup_actions_1 [] =
{
	conn_ac_send_ua_rsp_f_set_p,      
	conn_ac_set_vs_0,
	conn_ac_set_vr_0,
	conn_ac_set_s_flag_1,
	NULL
};

static conn_state_transition_t setup_state_transition_1 =
{  
	conn_ev_rx_sabme_cmd_pbit_set_x,
	CONN_STATE_SETUP,
	NO_EVENT_QUALIFIERS,
	setup_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_RX_UA_RSP_Fbit_SET_X event 
 */

static conn_event_qfyr_t setup_ev_qfyrs_2 [] = 
{
	conn_ev_qlfy_p_flag_eq_f,  
	conn_ev_qlfy_set_status_connect,
	NULL
};

static conn_action_t setup_actions_2 [] =
{
	conn_ac_stop_ack_timer,  
	conn_ac_set_vs_0,
	conn_ac_set_vr_0,
	conn_ac_update_p_flag,   
	conn_ac_set_remote_busy_0,
	conn_ac_connect_confirm,
	NULL
};

static conn_state_transition_t setup_state_transition_2 =
{  
	conn_ev_rx_ua_rsp_fbit_set_x,
	CONN_STATE_NORMAL,
	setup_ev_qfyrs_2,
	setup_actions_2
};


/* 
 * State transitions for 
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t setup_ev_qfyrs_3 [] = 
{
	conn_ev_qlfy_s_flag_eq_1, 
	conn_ev_qlfy_set_status_connect,
	NULL
};

static conn_action_t setup_actions_3 [] =
{
	conn_ac_set_p_flag_0,
	conn_ac_set_remote_busy_0,
	conn_ac_connect_confirm,
	NULL
};

static conn_state_transition_t setup_state_transition_3 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_NORMAL,
	setup_ev_qfyrs_3,
	setup_actions_3
};


/* 
 * State transitions for 
 * CONN_EV_RX_DISC_CMD_Pbit_SET_X event 
 */

static conn_event_qfyr_t setup_ev_qfyrs_4 [] = 
{
	conn_ev_qlfy_set_status_disconnect,
	NULL
};

static conn_action_t setup_actions_4 [] =
{
	conn_ac_send_dm_rsp_f_set_p,    
	conn_ac_stop_ack_timer,
	conn_ac_connect_confirm,
 	conn_disconnect,     
	NULL
};

static conn_state_transition_t setup_state_transition_4 =
{  
	conn_ev_rx_disc_cmd_pbit_set_x,
	CONN_STATE_ADM,
	setup_ev_qfyrs_4,
	setup_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_RX_DM_RSP_Fbit_SET_X event 
 */

static conn_event_qfyr_t setup_ev_qfyrs_5 [] = 
{
	conn_ev_qlfy_set_status_disconnect,
	NULL
};

static conn_action_t setup_actions_5 [] =
{
	conn_ac_stop_ack_timer,
	conn_ac_connect_confirm,
	conn_disconnect,              
	NULL
};

static conn_state_transition_t setup_state_transition_5 =
{  
	conn_ev_rx_dm_rsp_fbit_set_x,
	CONN_STATE_ADM,
	setup_ev_qfyrs_5,
	setup_actions_5
};

/* 
 * State transitions for 
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t setup_ev_qfyrs_7 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2,   
	conn_ev_qlfy_s_flag_eq_0,     
	NULL
};

static conn_action_t setup_actions_7 [] =
{
	conn_ac_send_sabme_cmd_p_set_x,  
	conn_ac_start_ack_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t setup_state_transition_7 =
{  
	conn_ev_ack_timer_expired,          
	CONN_STATE_SETUP,
	setup_ev_qfyrs_7,                   
	setup_actions_7
};


/* 
 * State transitions for 
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t setup_ev_qfyrs_8 [] = 
{
	conn_ev_qlfy_retry_count_gte_n2,   
	conn_ev_qlfy_s_flag_eq_0,       
	conn_ev_qlfy_set_status_failed,
	NULL
};

static conn_action_t setup_actions_8 [] =
{
	conn_ac_connect_confirm,
	conn_disconnect,
	NULL
};

static conn_state_transition_t setup_state_transition_8 =
{  
	conn_ev_ack_timer_expired,          
	CONN_STATE_ADM,
	setup_ev_qfyrs_8,                   
	setup_actions_8
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t *setup_state_transitions [] =
{
	&common_state_transition_n,  // Request

	&common_state_transition_n,  // local busy 
	&common_state_transition_n,  // init_pf_cycle 

	&setup_state_transition_3,   // Timer
	&setup_state_transition_7,
	&setup_state_transition_8,
	&common_state_transition_n,   

	&setup_state_transition_1,    // Receive frame
	&setup_state_transition_2,
	&setup_state_transition_4,
	&setup_state_transition_5,

	&common_state_transition_n
};



/* -------------------- CONN_STATE_NORMAL transitions -------------------- */


/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_1 [] = 
{
	conn_ev_qlfy_remote_busy_eq_0,      
	conn_ev_qlfy_p_flag_eq_0,        
	conn_ev_qlfy_last_frame_eq_0, 
	NULL
};

static conn_action_t normal_actions_1 [] =
{
	conn_ac_send_i_as_ack, 
	conn_ac_start_ack_timer_if_not_running,    
	NULL
};

static conn_state_transition_t normal_state_transition_1 =
{  
	conn_ev_data_request,               
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_1,                  
	normal_actions_1 
};


/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_2 [] = 
{
	conn_ev_qlfy_remote_busy_eq_0,     
	conn_ev_qlfy_p_flag_eq_0,    
	conn_ev_qlfy_last_frame_eq_1,  
	NULL
};

static conn_action_t normal_actions_2 [] =
{
	conn_ac_send_i_cmd_p_set_1,      
	conn_ac_start_p_timer,
	NULL
};

static conn_state_transition_t normal_state_transition_2 =
{  
	conn_ev_data_request,               
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_2,                  
	normal_actions_2
};


/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_2_1 [] = 
{
	conn_ev_qlfy_remote_busy_eq_1,
	conn_ev_qlfy_set_status_remote_busy,
	NULL
};

static conn_action_t normal_actions_2_1 [] =
{
	NULL
};

static conn_state_transition_t normal_state_transition_2_1 =
{  
	conn_ev_data_request,               
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_2_1,                
	normal_actions_2_1
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_DETECTED event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_3 [] = 
{
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t normal_actions_3 [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rnr_xxx_x_set_0,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t normal_state_transition_3 =
{  
	conn_ev_local_busy_detected,        
	CONN_STATE_BUSY,
	normal_ev_qfyrs_3,                  
	normal_actions_3
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_DETECTED event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_4 [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t normal_actions_4 [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rnr_xxx_x_set_0,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t normal_state_transition_4 =
{  
	conn_ev_local_busy_detected,        
	CONN_STATE_BUSY,
	normal_ev_qfyrs_4,                  
	normal_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_5a [] = 
{
	conn_ev_qlfy_p_flag_eq_0,     
	NULL
};

static conn_action_t normal_actions_5a [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_start_rej_timer,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t normal_state_transition_5a =
{  
	conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns,  
	CONN_STATE_REJECT,
	normal_ev_qfyrs_5a,                     
	normal_actions_5a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0_UNEXPD_Ns event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_5b [] = 
{
	conn_ev_qlfy_p_flag_eq_0,     
	NULL
};

static conn_action_t normal_actions_5b [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_start_rej_timer,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL 
};

static conn_state_transition_t normal_state_transition_5b =
{  
	conn_ev_rx_i_rsp_fbit_set_0_unexpd_ns,  
	CONN_STATE_REJECT,
	normal_ev_qfyrs_5b,                     
	normal_actions_5b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_1_UNEXPD_Ns event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_5c [] = 
{
	conn_ev_qlfy_p_flag_eq_1,    
	NULL
};

static conn_action_t normal_actions_5c [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_start_rej_timer,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t normal_state_transition_5c =
{  
	conn_ev_rx_i_rsp_fbit_set_1_unexpd_ns,  
	CONN_STATE_REJECT,
	normal_ev_qfyrs_5c,                     
	normal_actions_5c
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_6a [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t normal_actions_6a [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_start_rej_timer,
	NULL
};

static conn_state_transition_t normal_state_transition_6a =
{  
	conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns,  
	CONN_STATE_REJECT,
	normal_ev_qfyrs_6a,                     
	normal_actions_6a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0_UNEXPD_Ns event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_6b [] = 
{
	conn_ev_qlfy_p_flag_eq_1,
	NULL
};

static conn_action_t normal_actions_6b [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_start_rej_timer,
	NULL
};

static conn_state_transition_t normal_state_transition_6b =
{  
	conn_ev_rx_i_rsp_fbit_set_0_unexpd_ns,  
	CONN_STATE_REJECT,
	normal_ev_qfyrs_6b,                     
	normal_actions_6b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t normal_actions_7 [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rej_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_start_rej_timer,
	NULL
};

static conn_state_transition_t normal_state_transition_7 =
{  
	conn_ev_rx_i_cmd_pbit_set_1_unexpd_ns,  
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                    
	normal_actions_7
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_X event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_8a [] = 
{
	conn_ev_qlfy_p_flag_eq_f, 
	NULL
};

static conn_action_t normal_actions_8 [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication, 
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy_if_f_eq_1,
	conn_ac_send_ack_if_needed,  
	NULL
};

static conn_state_transition_t normal_state_transition_8a =
{  
	conn_ev_rx_i_rsp_fbit_set_x,    
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_8a,             
	normal_actions_8
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_8b [] = 
{
	conn_ev_qlfy_p_flag_eq_0,  
	NULL
};


static conn_state_transition_t normal_state_transition_8b =
{  
	conn_ev_rx_i_cmd_pbit_set_0,    
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_8b,             
	normal_actions_8
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0 event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_9a [] = 
{
	conn_ev_qlfy_p_flag_eq_1,  
	NULL
};

static conn_action_t normal_actions_9a [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_update_nr_received,
	conn_ac_data_indication,
	conn_ac_send_ack_if_needed, 
	NULL
};

static conn_state_transition_t normal_state_transition_9a =
{  
	conn_ev_rx_i_rsp_fbit_set_0,    
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_9a,             
	normal_actions_9a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_9b [] = 
{
	conn_ev_qlfy_p_flag_eq_1,
	NULL
};

static conn_action_t normal_actions_9b [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_update_nr_received,
	conn_ac_data_indication,
	conn_ac_send_ack_if_needed, 
	NULL
};

static conn_state_transition_t normal_state_transition_9b =
{  
	conn_ev_rx_i_cmd_pbit_set_0,    
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_9b,             
	normal_actions_9b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1 event 
 */

static conn_action_t normal_actions_10 [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_send_ack_rsp_f_set_1, 
	conn_ac_reset_sendack_flag,
	conn_ac_update_nr_received, 
	conn_ac_data_indication,
	NULL
};

static conn_state_transition_t normal_state_transition_10 =
{  
	conn_ev_rx_i_cmd_pbit_set_1,    
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,            
	normal_actions_10
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_0 event 
 */

static conn_action_t normal_actions_11a [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_11a =
{  
	conn_ev_rx_rr_cmd_pbit_set_0,   
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,            
	normal_actions_11a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_0 event 
 */

static conn_action_t normal_actions_11b [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_11b =
{  
	conn_ev_rx_rr_rsp_fbit_set_0,   
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,            
	normal_actions_11b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_1 event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_11c [] = 
{
	conn_ev_qlfy_p_flag_eq_1,  
	NULL
};

static conn_action_t normal_actions_11c [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,  
	conn_ac_increase_transmit_window_size, 
	conn_ac_clear_remote_busy,  
	NULL
};

static conn_state_transition_t normal_state_transition_11c =
{  
	conn_ev_rx_rr_rsp_fbit_set_1,   
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_11c,            
	normal_actions_11c
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_1 event 
 */

static conn_action_t normal_actions_12 [] =
{
	conn_ac_send_ack_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_adjust_npta_by_rr, 
	conn_ac_reset_sendack_flag, 
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_12 =
{  
	conn_ev_rx_rr_cmd_pbit_set_1,
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,
	normal_actions_12
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_0 event 
 */

static conn_action_t normal_actions_13a [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_13a =
{  
	conn_ev_rx_rnr_cmd_pbit_set_0,   
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,             
	normal_actions_13a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_0 event 
 */

static conn_action_t normal_actions_13b [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_13b =
{  
	conn_ev_rx_rnr_rsp_fbit_set_0,   
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,             
	normal_actions_13b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_1 event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_13c [] = 
{
	conn_ev_qlfy_p_flag_eq_1,   
	NULL
};

static conn_action_t normal_actions_13c [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_13c =
{  
	conn_ev_rx_rnr_rsp_fbit_set_1,   
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_13c,             
	normal_actions_13c
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_1 event 
 */

static conn_action_t normal_actions_14 [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_adjust_npta_by_rnr, 
	conn_ac_reset_sendack_flag,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_14 =
{  
	conn_ev_rx_rnr_cmd_pbit_set_1,   
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,             
	normal_actions_14
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_15a [] = 
{
	conn_ev_qlfy_p_flag_eq_0,  
	NULL
};

static conn_action_t normal_actions_15a [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_decrease_transmit_window_size,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_15a =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,   
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_15a,             
	normal_actions_15a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_X event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_15b [] = 
{
	conn_ev_qlfy_p_flag_eq_f,  
	NULL
};

static conn_action_t normal_actions_15b [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_decrease_transmit_window_size, 
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_15b =
{  
	conn_ev_rx_rej_rsp_fbit_set_x,   
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_15b,             
	normal_actions_15b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_16a [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t normal_actions_16a [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_decrease_transmit_window_size, 
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_16a =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,   
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_16a,             
	normal_actions_16a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_0 event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_16b [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t normal_actions_16b [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_decrease_transmit_window_size, 
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_16b =
{  
	conn_ev_rx_rej_rsp_fbit_set_0,   
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_16b,             
	normal_actions_16b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_1 event 
 */

static conn_action_t normal_actions_17 [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_decrease_transmit_window_size, 
	conn_ac_resend_i_rsp_f_set_1,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t normal_state_transition_17 =
{  
	conn_ev_rx_rej_cmd_pbit_set_1,   
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,             
	normal_actions_17
};


/* 
 * State transitions for 
 * CONN_EV_INIT_P_F_CYCLE event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_18 [] = 
{
	conn_ev_qlfy_p_flag_eq_0,
	NULL
};

static conn_action_t normal_actions_18 [] =
{
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_start_p_timer,
	NULL
};

static conn_state_transition_t normal_state_transition_18 =
{  
	conn_ev_init_p_f_cycle,
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_18,
	normal_actions_18
};


/* 
 * State transitions for
 * CONN_EV_P_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_19 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2, 
	NULL
};

static conn_action_t normal_actions_19 [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_reset_vs,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t normal_state_transition_19 =
{  
	conn_ev_p_timer_expired,    
	CONN_STATE_AWAIT,
	normal_ev_qfyrs_19,         
	normal_actions_19
};


/* 
 * State transitions for 
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_20a [] = 
{
	conn_ev_qlfy_p_flag_eq_0,         
	conn_ev_qlfy_retry_count_lt_n2, 
	NULL
};

static conn_action_t normal_actions_20a [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_reset_vs,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t normal_state_transition_20a =
{  
	conn_ev_ack_timer_expired,  
	CONN_STATE_AWAIT,
	normal_ev_qfyrs_20a,        
	normal_actions_20a
};


/* 
 * State transitions for 
 * CONN_EV_BUSY_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t   normal_ev_qfyrs_20b [] = 
{
	conn_ev_qlfy_p_flag_eq_0,         
	conn_ev_qlfy_retry_count_lt_n2,
	NULL
};

static conn_action_t       normal_actions_20b [] =
{
	conn_ac_reset_sendack_flag,
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_reset_vs,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t normal_state_transition_20b =
{  
	conn_ev_busy_timer_expired,     
	CONN_STATE_AWAIT,
	normal_ev_qfyrs_20b,            
	normal_actions_20b
};


/* 
 * State transitions for 
 * CONN_EV_TX_BUFF_FULL event 
 */

static conn_event_qfyr_t normal_ev_qfyrs_21 [] = 
{
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t normal_actions_21 [] =
{
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_start_p_timer,
	NULL
};

static conn_state_transition_t normal_state_transition_21 =
{  
	conn_ev_tx_buffer_full,              
	CONN_STATE_NORMAL,
	normal_ev_qfyrs_21,                  
	normal_actions_21
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t *normal_state_transitions [] =
{
	&normal_state_transition_1,     // Requests
	&normal_state_transition_2,
	&normal_state_transition_2_1,
	&common_state_transition_1,   
	&common_state_transition_2,   
	&common_state_transition_n,

	&normal_state_transition_21, 
	&normal_state_transition_3,     // Local busy 
	&normal_state_transition_4,
	&common_state_transition_n,

	&normal_state_transition_18,    // Init pf cycle 
	&common_state_transition_n,   

	&common_state_transition_11a,   // Timers 
	&common_state_transition_11b,
	&common_state_transition_11c,
	&common_state_transition_11d,

	&normal_state_transition_19,
	&normal_state_transition_20a,
	&normal_state_transition_20b,
	&common_state_transition_n,   


	&normal_state_transition_8b,    // Receive frames
	&normal_state_transition_9b,
	&normal_state_transition_10,
	&normal_state_transition_11b,
	&normal_state_transition_11c,
	&normal_state_transition_5a,     
	&normal_state_transition_5b,
	&normal_state_transition_5c,
	&normal_state_transition_6a,
	&normal_state_transition_6b,
	&normal_state_transition_7,
	&normal_state_transition_8a,
	&normal_state_transition_9a,
	&normal_state_transition_11a,
	&normal_state_transition_12,

	&normal_state_transition_13a,
	&normal_state_transition_13b,
	&normal_state_transition_13c,
	&normal_state_transition_14,
	&normal_state_transition_15a,
	&normal_state_transition_15b,
	&normal_state_transition_16a,
	&normal_state_transition_16b,
	&normal_state_transition_17,

	&common_state_transition_3,
	&common_state_transition_4,
	&common_state_transition_5,
	&common_state_transition_6,

	&common_state_transition_7a,
	&common_state_transition_7b,
	&common_state_transition_8a,
	&common_state_transition_8b,
	&common_state_transition_8c,
	&common_state_transition_9,      
	//&common_state_transition_10,   

	&common_state_transition_n
};



/* --------------------- CONN_STATE_BUSY transitions --------------------- */


/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_1 [] = 
{
	conn_ev_qlfy_remote_busy_eq_0,     
	conn_ev_qlfy_p_flag_eq_0,  
	NULL
};

static conn_action_t busy_actions_1 [] =
{
	conn_ac_send_i_xxx_x_set_0,
	conn_ac_start_ack_timer_if_not_running,
	NULL
};

static conn_state_transition_t busy_state_transition_1 =
{  
	conn_ev_data_request,           
	CONN_STATE_BUSY,
	busy_ev_qfyrs_1,                
	busy_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_2 [] = 
{
	conn_ev_qlfy_remote_busy_eq_0,
	conn_ev_qlfy_p_flag_eq_1,
	NULL
};

static conn_action_t busy_actions_2 [] =
{
	conn_ac_send_i_xxx_x_set_0,
	conn_ac_start_ack_timer_if_not_running,
	NULL
};

static conn_state_transition_t busy_state_transition_2 =
{  
	conn_ev_data_request,           
	CONN_STATE_BUSY,
	busy_ev_qfyrs_2,                
	busy_actions_2
};

/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_2_1 [] = 
{
	conn_ev_qlfy_remote_busy_eq_1, 
	conn_ev_qlfy_set_status_remote_busy,
	NULL
};

static conn_action_t busy_actions_2_1 [] =
{
	NULL
};

static conn_state_transition_t busy_state_transition_2_1 =
{  
	conn_ev_data_request,           
	CONN_STATE_BUSY,
	busy_ev_qfyrs_2_1,                
	busy_actions_2_1
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_3 [] = 
{
	conn_ev_qlfy_data_flag_eq_1, 
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t busy_actions_3 [] =
{
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_start_rej_timer,
	NULL
};

static conn_state_transition_t busy_state_transition_3 =
{  
	conn_ev_local_busy_cleared,     
	CONN_STATE_REJECT,
	busy_ev_qfyrs_3,                
	busy_actions_3
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_4 [] = 
{
	conn_ev_qlfy_data_flag_eq_1, 
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t busy_actions_4 [] =
{
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_start_rej_timer,
	NULL
};

static conn_state_transition_t busy_state_transition_4 =
{  
	conn_ev_local_busy_cleared,     
	CONN_STATE_REJECT,
	busy_ev_qfyrs_4,                
	busy_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_5 [] = 
{
	conn_ev_qlfy_data_flag_eq_0, 
	conn_ev_qlfy_p_flag_eq_0,  
	NULL
};

static conn_action_t busy_actions_5 [] =
{
	conn_ac_send_rr_xxx_x_set_0,
	NULL
};

static conn_state_transition_t busy_state_transition_5 =
{  
	conn_ev_local_busy_cleared,     
	CONN_STATE_NORMAL,
	busy_ev_qfyrs_5,                
	busy_actions_5
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_6 [] = 
{
	conn_ev_qlfy_data_flag_eq_0, 
	conn_ev_qlfy_p_flag_eq_1,  
	NULL
};

static conn_action_t busy_actions_6 [] =
{
	conn_ac_send_rr_xxx_x_set_0,
	NULL
};

static conn_state_transition_t busy_state_transition_6 =
{  
	conn_ev_local_busy_cleared,     
	CONN_STATE_NORMAL,
	busy_ev_qfyrs_6,                
	busy_actions_6
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_7 [] = 
{
	conn_ev_qlfy_data_flag_eq_2,
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t busy_actions_7 [] =
{
	conn_ac_send_rr_xxx_x_set_0,
	NULL
};

static conn_state_transition_t busy_state_transition_7 =
{  
	conn_ev_local_busy_cleared,     
	CONN_STATE_REJECT,
	busy_ev_qfyrs_7,                
	busy_actions_7
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_8 [] = 
{
	conn_ev_qlfy_data_flag_eq_2,
	conn_ev_qlfy_p_flag_eq_1,
	NULL
};

static conn_action_t busy_actions_8 [] =
{
	conn_ac_send_rr_xxx_x_set_0,
	NULL
};

static conn_state_transition_t busy_state_transition_8 =
{  
	conn_ev_local_busy_cleared,     
	CONN_STATE_REJECT,
	busy_ev_qfyrs_8,                
	busy_actions_8
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_X_UNEXPD_Ns event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_9a [] = 
{
	conn_ev_qlfy_p_flag_eq_f, 
	NULL
};

static conn_action_t busy_actions_9a [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_data_flag_1_if_data_flag_eq_0,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t busy_state_transition_9a =
{  
	conn_ev_rx_i_rsp_fbit_set_x_unexpd_ns,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_9a,                       
	busy_actions_9a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns event 
 */

static conn_event_qfyr_t   busy_ev_qfyrs_9b [] = 
{
	conn_ev_qlfy_p_flag_eq_0,  
	NULL
};

static conn_action_t busy_actions_9b [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_data_flag_1_if_data_flag_eq_0,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t busy_state_transition_9b =
{  
	conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_9b,                       
	busy_actions_9b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0_UNEXPD_Ns event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_10a [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t busy_actions_10a [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_set_data_flag_1_if_data_flag_eq_0,
	NULL
};

static conn_state_transition_t busy_state_transition_10a =
{  
	conn_ev_rx_i_rsp_fbit_set_0_unexpd_ns,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_10a,                      
	busy_actions_10a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_10b [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t busy_actions_10b [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_set_data_flag_1_if_data_flag_eq_0,
	NULL
};

static conn_state_transition_t busy_state_transition_10b =
{  
	conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_10b,                      
	busy_actions_10b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t busy_actions_11 [] =
{
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_set_data_flag_1_if_data_flag_eq_0,
	NULL
};

static conn_state_transition_t busy_state_transition_11 =
{  
	conn_ev_rx_i_cmd_pbit_set_1_unexpd_ns,  
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,                    
	busy_actions_11
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1 event 
 */

static conn_action_t busy_actions_12 [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_stop_rej_timer_if_data_flag_eq_2,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t busy_state_transition_12 =
{  
	conn_ev_rx_i_cmd_pbit_set_1,    
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,            
	busy_actions_12
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_X event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_13a [] = 
{
	conn_ev_qlfy_p_flag_eq_f,  
	NULL
};

static conn_action_t busy_actions_13a [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_update_p_flag,   
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_stop_rej_timer_if_data_flag_eq_2,
	conn_ac_set_data_flag_0,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t busy_state_transition_13a =
{  
	conn_ev_rx_i_rsp_fbit_set_x,    
	CONN_STATE_BUSY,
	busy_ev_qfyrs_13a,              
	busy_actions_13a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_13b [] = 
{
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t busy_actions_13b [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_update_p_flag,   
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_stop_rej_timer_if_data_flag_eq_2,
	conn_ac_set_data_flag_0,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t busy_state_transition_13b =
{  
	conn_ev_rx_i_cmd_pbit_set_0,    
	CONN_STATE_BUSY,
	busy_ev_qfyrs_13b,              
	busy_actions_13b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0 event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_14a [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t busy_actions_14a [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_stop_rej_timer_if_data_flag_eq_2,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t busy_state_transition_14a =
{  
	conn_ev_rx_i_rsp_fbit_set_0,    
	CONN_STATE_BUSY,
	busy_ev_qfyrs_14a,              
	busy_actions_14a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_14b [] = 
{
	conn_ev_qlfy_p_flag_eq_1,
	NULL
};

static conn_action_t busy_actions_14b [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_stop_rej_timer_if_data_flag_eq_2,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t busy_state_transition_14b =
{  
	conn_ev_rx_i_cmd_pbit_set_0,   
	CONN_STATE_BUSY,
	busy_ev_qfyrs_14b,              
	busy_actions_14b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_0 event 
 */

static conn_action_t busy_actions_15a [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_15a =
{  
	conn_ev_rx_rr_cmd_pbit_set_0,   
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,            
	busy_actions_15a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_0 event 
 */

static conn_action_t busy_actions_15b [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_15b =
{  
	conn_ev_rx_rr_rsp_fbit_set_0,   
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,            
	busy_actions_15b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_1 event 
 */

static conn_event_qfyr_t   busy_ev_qfyrs_15c [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t busy_actions_15c [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_15c =
{  
	conn_ev_rx_rr_rsp_fbit_set_1,   
	CONN_STATE_BUSY,
	busy_ev_qfyrs_15c,               
	busy_actions_15c
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_1 event 
 */

static conn_action_t busy_actions_16 [] =
{
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_16 =
{  
	conn_ev_rx_rr_cmd_pbit_set_1,   
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,            
	busy_actions_16
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_0 event 
 */

static conn_action_t busy_actions_17a [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_17a =
{  
	conn_ev_rx_rnr_cmd_pbit_set_0,  
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,            
	busy_actions_17a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_0 event 
 */

static conn_action_t busy_actions_17b [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_17b =
{  
	conn_ev_rx_rnr_rsp_fbit_set_0,  
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,            
	busy_actions_17b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_1 event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_17c [] = 
{
	conn_ev_qlfy_p_flag_eq_1,
	NULL
};

static conn_action_t busy_actions_17c [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_17c =
{  
	conn_ev_rx_rnr_rsp_fbit_set_1,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_17c,               
	busy_actions_17c
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_1 event 
 */

static conn_action_t busy_actions_18 [] =
{
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_18 =
{  
	conn_ev_rx_rnr_cmd_pbit_set_1,  
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,            
	busy_actions_18
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_19a [] = 
{
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t busy_actions_19a [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_19a =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_19a,               
	busy_actions_19a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_X event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_19b [] = 
{
	conn_ev_qlfy_p_flag_eq_f,
	NULL
};

static conn_action_t busy_actions_19b [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_19b =
{  
	conn_ev_rx_rej_rsp_fbit_set_x,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_19b,               
	busy_actions_19b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_20a [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t busy_actions_20a [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_20a =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_20a,               
	busy_actions_20a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_0 event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_20b [] = 
{
	conn_ev_qlfy_p_flag_eq_1,
	NULL
};

static conn_action_t busy_actions_20b [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_20b =
{  
	conn_ev_rx_rej_rsp_fbit_set_0,  
	CONN_STATE_BUSY,
	busy_ev_qfyrs_20b,              
	busy_actions_20b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_1 event 
 */

static conn_action_t busy_actions_21 [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t busy_state_transition_21 =
{  
	conn_ev_rx_rej_cmd_pbit_set_1,  
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,            
	busy_actions_21
};


/* 
 * State transitions for 
 * CONN_EV_INIT_P_F_CYCLE event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_22 [] = 
{
	conn_ev_qlfy_p_flag_eq_0,
	NULL
};

static conn_action_t busy_actions_22 [] =
{
 	conn_ac_send_rnr_cmd_p_set_1,
	conn_ac_start_p_timer,
	NULL
};

static conn_state_transition_t busy_state_transition_22 =
{  
	conn_ev_init_p_f_cycle,         
	CONN_STATE_BUSY,
	busy_ev_qfyrs_22,               
	busy_actions_22
 };


/* 
 * State transitions for 
 * CONN_EV_P_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_23 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2, 
	NULL
};

static conn_action_t busy_actions_23 [] =
{
	conn_ac_send_rnr_cmd_p_set_1,
	conn_ac_reset_vs,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t busy_state_transition_23 =
{  
	conn_ev_p_timer_expired,        
	CONN_STATE_AWAIT_BUSY,
	busy_ev_qfyrs_23,               
	busy_actions_23
};


/* 
 * State transitions for 
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_24a [] = 
{
	conn_ev_qlfy_p_flag_eq_0, 
	conn_ev_qlfy_retry_count_lt_n2, 
	NULL
};

static conn_action_t busy_actions_24a [] =
{
	conn_ac_send_rnr_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	conn_ac_reset_vs,
	NULL
};

static conn_state_transition_t busy_state_transition_24a =
{  
	conn_ev_ack_timer_expired,      
	CONN_STATE_AWAIT_BUSY,
	busy_ev_qfyrs_24a,              
	busy_actions_24a
};


/* 
 * State transitions for 
 * CONN_EV_BUSY_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t busy_ev_qfyrs_24b [] = 
{
	conn_ev_qlfy_p_flag_eq_0, 
	conn_ev_qlfy_retry_count_lt_n2, 
	NULL
};

static conn_action_t busy_actions_24b [] =
{
	conn_ac_send_rnr_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	conn_ac_reset_vs,
	NULL
};

static conn_state_transition_t busy_state_transition_24b =
{  
	conn_ev_busy_timer_expired,     
	CONN_STATE_AWAIT_BUSY,
	busy_ev_qfyrs_24b,              
	busy_actions_24b
};


/* 
 * State transitions for 
 * CONN_EV_REJ_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t   busy_ev_qfyrs_25 [] = 
{
	conn_ev_qlfy_p_flag_eq_0,  
	conn_ev_qlfy_retry_count_lt_n2,
	NULL
};

static conn_action_t busy_actions_25 [] =
{
	conn_ac_send_rnr_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	conn_ac_reset_vs,
	conn_ac_set_data_flag_1,
	NULL
};

static conn_state_transition_t busy_state_transition_25 =
{  
	conn_ev_rej_timer_expired,      
	CONN_STATE_AWAIT_BUSY,
	busy_ev_qfyrs_25,               
	busy_actions_25
};


/* 
 * State transitions for 
 * CONN_EV_REJ_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t   busy_ev_qfyrs_26 [] = 
{
	conn_ev_qlfy_p_flag_eq_1,  
	conn_ev_qlfy_retry_count_lt_n2, 
	NULL
};

static conn_action_t busy_actions_26 [] =
{
	conn_ac_set_data_flag_1,
	NULL
};

static conn_state_transition_t busy_state_transition_26 =
{  
	conn_ev_rej_timer_expired,      
	CONN_STATE_BUSY,
	busy_ev_qfyrs_26,               
	busy_actions_26
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t *busy_state_transitions [] =
{
	&common_state_transition_1,      // Request
	&common_state_transition_2,
	&busy_state_transition_1,
	&busy_state_transition_2,
	&busy_state_transition_2_1,
	&common_state_transition_n,

	&busy_state_transition_3,        // Local busy
	&busy_state_transition_4,
	&busy_state_transition_5,
	&busy_state_transition_6,
	&busy_state_transition_7,
	&busy_state_transition_8,
	&common_state_transition_n,

	&busy_state_transition_22,       // Initiate PF cycle
	&common_state_transition_n,

	&common_state_transition_11a,    // Timer
	&common_state_transition_11b,
	&common_state_transition_11c,
	&common_state_transition_11d,

	&busy_state_transition_23,   
	&busy_state_transition_24a,
	&busy_state_transition_24b,
	&busy_state_transition_25,
	&busy_state_transition_26,
	&common_state_transition_n,

	&busy_state_transition_9a,       // Receive frame
	&busy_state_transition_9b,
	&busy_state_transition_10a,
	&busy_state_transition_10b,
	&busy_state_transition_11,
	&busy_state_transition_12,
	&busy_state_transition_13a,
	&busy_state_transition_13b,
	&busy_state_transition_14a,
	&busy_state_transition_14b,
	&busy_state_transition_15a,
	&busy_state_transition_15b,
	&busy_state_transition_15c,
	&busy_state_transition_16,
	&busy_state_transition_17a,
	&busy_state_transition_17b,
	&busy_state_transition_17c,
	&busy_state_transition_18,
	&busy_state_transition_19a,
	&busy_state_transition_19b,
	&busy_state_transition_20a,
	&busy_state_transition_20b,
	&busy_state_transition_21,

	&common_state_transition_3,
	&common_state_transition_4,
	&common_state_transition_5,
	&common_state_transition_6,
	&common_state_transition_7a,
	&common_state_transition_7b,
	&common_state_transition_8a,
	&common_state_transition_8b,
	&common_state_transition_8c,
	&common_state_transition_9,
	// &common_state_transition_10,

	&common_state_transition_n
};



/* -------------------- CONN_STATE_REJECT transitions -------------------- */


/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t   reject_ev_qfyrs_1 [] = 
{
	conn_ev_qlfy_remote_busy_eq_0, 
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t       reject_actions_1 [] =
{
	conn_ac_send_i_xxx_x_set_0,
	NULL
};

static conn_state_transition_t reject_state_transition_1 =
{  
	conn_ev_data_request,           
	CONN_STATE_REJECT,
	reject_ev_qfyrs_1,              
	reject_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_2 [] = 
{
	conn_ev_qlfy_remote_busy_eq_0, 
	conn_ev_qlfy_p_flag_eq_1,   
	NULL
};

static conn_action_t reject_actions_2 [] =
{
	conn_ac_send_i_xxx_x_set_0,
	NULL
};

static conn_state_transition_t reject_state_transition_2 =
{  
	conn_ev_data_request,           
	CONN_STATE_REJECT,
	reject_ev_qfyrs_2,              
	reject_actions_2
};

/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_2_1 [] = 
{
	conn_ev_qlfy_remote_busy_eq_1, 
	conn_ev_qlfy_set_status_remote_busy,
	NULL
};

static conn_action_t reject_actions_2_1 [] =
{
	NULL
};

static conn_state_transition_t reject_state_transition_2_1 =
{  
	conn_ev_data_request,           
	CONN_STATE_REJECT,
	reject_ev_qfyrs_2_1,            
	reject_actions_2_1
};



/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_DETECTED event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_3 [] = 
{
	conn_ev_qlfy_p_flag_eq_0,    
	NULL
};

static conn_action_t reject_actions_3 [] =
{
	conn_ac_send_rnr_xxx_x_set_0,
	conn_ac_set_data_flag_2,
	NULL
};

static conn_state_transition_t reject_state_transition_3 =
{  
	conn_ev_local_busy_detected,    
	CONN_STATE_BUSY,
	reject_ev_qfyrs_3,              
	reject_actions_3
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_DETECTED event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_4 [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t reject_actions_4 [] =
{
	conn_ac_send_rnr_xxx_x_set_0,
	conn_ac_set_data_flag_2,
	NULL
};

static conn_state_transition_t reject_state_transition_4 =
{  
	conn_ev_local_busy_detected,    
	CONN_STATE_BUSY,
	reject_ev_qfyrs_4,              
	reject_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns event 
 */

static conn_action_t reject_actions_5a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t reject_state_transition_5a =
{  
	conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns,  
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                    
	reject_actions_5a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0_UNEXPD_Ns event 
 */

static conn_action_t reject_actions_5b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t reject_state_transition_5b =
{  
	conn_ev_rx_i_rsp_fbit_set_0_unexpd_ns,  
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                    
	reject_actions_5b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_1_UNEXPD_Ns event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_5c [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t reject_actions_5c [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_clear_remote_busy_if_f_eq_1,
	NULL
};

static conn_state_transition_t reject_state_transition_5c =
{  
	conn_ev_rx_i_rsp_fbit_set_1_unexpd_ns,  
	CONN_STATE_REJECT,
	reject_ev_qfyrs_5c,                     
	reject_actions_5c
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t reject_actions_6 [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	NULL
};

static conn_state_transition_t reject_state_transition_6 =
{  
	conn_ev_rx_i_cmd_pbit_set_1_unexpd_ns,  
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                    
	reject_actions_6
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_X event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_7a [] = 
{
	conn_ev_qlfy_p_flag_eq_f, 
	NULL
};

static conn_action_t reject_actions_7a [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_update_p_flag,
	conn_ac_send_ack_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy_if_f_eq_1,
	conn_ac_stop_rej_timer,
	NULL

};

static conn_state_transition_t reject_state_transition_7a =
{  
	conn_ev_rx_i_rsp_fbit_set_x,    
	CONN_STATE_NORMAL,
	reject_ev_qfyrs_7a,              
	reject_actions_7a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_7b [] = 
{
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t reject_actions_7b [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_update_p_flag,
	conn_ac_send_ack_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy_if_f_eq_1,
	conn_ac_stop_rej_timer,
	NULL
};

static conn_state_transition_t reject_state_transition_7b =
{  
	conn_ev_rx_i_cmd_pbit_set_0,     
	CONN_STATE_NORMAL,
	reject_ev_qfyrs_7b,              
	reject_actions_7b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0 event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_8a [] = 
{
	conn_ev_qlfy_p_flag_eq_1,
	NULL
};

static conn_action_t reject_actions_8a [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_ack_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_stop_rej_timer,
	NULL
};

static conn_state_transition_t reject_state_transition_8a =
{  
	conn_ev_rx_i_rsp_fbit_set_0,     
	CONN_STATE_NORMAL,
	reject_ev_qfyrs_8a,              
	reject_actions_8a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_8b [] = 
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t reject_actions_8b [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_ack_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_stop_rej_timer,
	NULL
};

static conn_state_transition_t reject_state_transition_8b =
{  
	conn_ev_rx_i_cmd_pbit_set_0,     
	CONN_STATE_NORMAL,
	reject_ev_qfyrs_8b,              
	reject_actions_8b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1 event 
 */

static conn_action_t reject_actions_9 [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_ack_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_stop_rej_timer,
	NULL
};

static conn_state_transition_t reject_state_transition_9 =
{  
	conn_ev_rx_i_cmd_pbit_set_1,     
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,             
	reject_actions_9
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_0 event 
 */

static conn_action_t reject_actions_10a [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_10a =
{  
	conn_ev_rx_rr_cmd_pbit_set_0,   
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,            
	reject_actions_10a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_0 event 
 */

static conn_action_t reject_actions_10b [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_10b =
{  
	conn_ev_rx_rr_rsp_fbit_set_0,   
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,            
	reject_actions_10b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_1 event 
 */

static conn_event_qfyr_t   reject_ev_qfyrs_10c [] =
{
	conn_ev_qlfy_p_flag_eq_1,    
	NULL
};

static conn_action_t reject_actions_10c [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_10c =
{  
	conn_ev_rx_rr_rsp_fbit_set_1,   
	CONN_STATE_REJECT,
	reject_ev_qfyrs_10c,            
	reject_actions_10c
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_1 event 
 */

static conn_action_t reject_actions_11 [] =
{
	conn_ac_send_ack_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_11 =
{  
	conn_ev_rx_rr_cmd_pbit_set_1,   
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,            
	reject_actions_11
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_0 event 
 */

static conn_action_t reject_actions_12a [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_12a =
{  
	conn_ev_rx_rnr_cmd_pbit_set_0,      
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                
	reject_actions_12a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_0 event 
 */

static conn_action_t reject_actions_12b [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_12b =
{  
	conn_ev_rx_rnr_rsp_fbit_set_0,      
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                
	reject_actions_12b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_1 event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_12c [] =
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t reject_actions_12c [] =
{
	conn_ac_update_p_flag,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_12c =
{  
	conn_ev_rx_rnr_rsp_fbit_set_1,      
	CONN_STATE_REJECT,
	reject_ev_qfyrs_12c,                
	reject_actions_12c
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_1 event 
 */

static conn_action_t reject_actions_13 [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_13 =
{  
	conn_ev_rx_rnr_cmd_pbit_set_1,      
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                
	reject_actions_13
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_14a [] =
{
	conn_ev_qlfy_p_flag_eq_0,  
	NULL
};

static conn_action_t reject_actions_14a [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_14a =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,      
	CONN_STATE_REJECT,
	reject_ev_qfyrs_14a,                
	reject_actions_14a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_X event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_14b [] =
{
	conn_ev_qlfy_p_flag_eq_f, 
	NULL
};

static conn_action_t reject_actions_14b [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_update_p_flag,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_14b =
{  
	conn_ev_rx_rej_rsp_fbit_set_x,      
	CONN_STATE_REJECT,
	reject_ev_qfyrs_14b,                
	reject_actions_14b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_15a [] =
{
	conn_ev_qlfy_p_flag_eq_1, 
	NULL
};

static conn_action_t reject_actions_15a [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_15a =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,      
	CONN_STATE_REJECT,
	reject_ev_qfyrs_15a,                
	reject_actions_15a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_0 event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_15b [] =
{
	conn_ev_qlfy_p_flag_eq_1,  
	NULL
};

static conn_action_t reject_actions_15b [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_15b =
{  
	conn_ev_rx_rej_rsp_fbit_set_0,      
	CONN_STATE_REJECT,
	reject_ev_qfyrs_15b,                
	reject_actions_15b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_1 event 
 */

static conn_action_t reject_actions_16 [] =
{
	conn_ac_set_vs_nr,
	conn_ac_update_nr_received,
	conn_ac_resend_i_rsp_f_set_1,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t reject_state_transition_16 =
{  
	conn_ev_rx_rej_cmd_pbit_set_1,      
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                 
	reject_actions_16
};


/* 
 * State transitions for 
 * CONN_EV_INIT_P_F_CYCLE event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_17 [] =
{
	conn_ev_qlfy_p_flag_eq_0, 
	NULL
};

static conn_action_t reject_actions_17 [] =
{
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_start_p_timer,
	NULL
};

static conn_state_transition_t reject_state_transition_17 =
{  
	conn_ev_init_p_f_cycle,         
	CONN_STATE_REJECT,
	reject_ev_qfyrs_17,             
	reject_actions_17
};


/* 
 * State transitions for 
 * CONN_EV_REJ_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_18 [] =
{
	conn_ev_qlfy_p_flag_eq_0,     
	conn_ev_qlfy_retry_count_lt_n2,   
	NULL
};

static conn_action_t reject_actions_18 [] =
{
	conn_ac_send_rej_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_start_rej_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t reject_state_transition_18 =
{  
	conn_ev_rej_timer_expired,      
	CONN_STATE_REJECT,
	reject_ev_qfyrs_18,             
	reject_actions_18
};


/* 
 * State transitions for 
 * CONN_EV_P_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_19 [] =
{
	conn_ev_qlfy_retry_count_lt_n2,  
	NULL
};

static conn_action_t reject_actions_19 [] =
{
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_start_rej_timer,
	conn_ac_increment_retry_count_by_1,
	conn_ac_reset_vs,
	NULL
};

static conn_state_transition_t reject_state_transition_19 =
{  
	conn_ev_p_timer_expired,        
	CONN_STATE_AWAIT_REJECT,
	reject_ev_qfyrs_19,             
	reject_actions_19
};


/* 
 * State transitions for 
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_20a [] =
{
	conn_ev_qlfy_p_flag_eq_0,       
	conn_ev_qlfy_retry_count_lt_n2,  
	NULL
};

static conn_action_t reject_actions_20a [] =
{
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_start_rej_timer,
	conn_ac_increment_retry_count_by_1,
	conn_ac_reset_vs, 
	NULL
};

static conn_state_transition_t reject_state_transition_20a =
{  
	conn_ev_ack_timer_expired,      
	CONN_STATE_AWAIT_REJECT,
	reject_ev_qfyrs_20a,            
	reject_actions_20a
};


/* 
 * State transitions for 
 * CONN_EV_BUSY_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t reject_ev_qfyrs_20b [] =
{
	conn_ev_qlfy_p_flag_eq_0,    
	conn_ev_qlfy_retry_count_lt_n2,  
	NULL
};

static conn_action_t reject_actions_20b [] =
{
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_start_rej_timer,
	conn_ac_increment_retry_count_by_1,
	conn_ac_reset_vs, 
	NULL
};

static conn_state_transition_t reject_state_transition_20b =
{  
	conn_ev_busy_timer_expired,     
	CONN_STATE_AWAIT_REJECT,
	reject_ev_qfyrs_20b,            
	reject_actions_20b
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t *reject_state_transitions [] =
{
	&common_state_transition_1,      // Request
	&common_state_transition_2,
	&common_state_transition_n,

	&reject_state_transition_1,
	&reject_state_transition_2,
	&reject_state_transition_2_1,

	&reject_state_transition_3,      // Local busy
	&reject_state_transition_4,
	&common_state_transition_n,

	&reject_state_transition_17,     // Initiate PF cycle
	&common_state_transition_n,

	&common_state_transition_11a,    // Timer
	&common_state_transition_11b,
	&common_state_transition_11c,
	&common_state_transition_11d,

	&reject_state_transition_18,
	&reject_state_transition_19,
	&reject_state_transition_20a,
	&reject_state_transition_20b,
	&common_state_transition_n,

	&common_state_transition_3,      // Receive frame
	&common_state_transition_4,
	&common_state_transition_5,
	&common_state_transition_6,
	&common_state_transition_7a,
	&common_state_transition_7b,
	&common_state_transition_8a,
	&common_state_transition_8b,
	&common_state_transition_8c,
	&common_state_transition_9,
	// &common_state_transition_10, 

	&reject_state_transition_5a,
	&reject_state_transition_5b,
	&reject_state_transition_5c,
	&reject_state_transition_6,
	&reject_state_transition_7a,
	&reject_state_transition_7b,
	&reject_state_transition_8a,
	&reject_state_transition_8b,
	&reject_state_transition_9,
	&reject_state_transition_10a,
	&reject_state_transition_10b,
	&reject_state_transition_10c,
	&reject_state_transition_11,
	&reject_state_transition_12a,
	&reject_state_transition_12b,
	&reject_state_transition_12c,
	&reject_state_transition_13,
	&reject_state_transition_14a,
	&reject_state_transition_14b,
	&reject_state_transition_15a,
	&reject_state_transition_15b,
	&reject_state_transition_16,

	&common_state_transition_n
};



/* -------------------- CONN_STATE_AWAIT transitions --------------------- */

/* 
 * State transitions for 
 * CONN_EV_DATA_REQUEST event 
 */

static conn_event_qfyr_t await_ev_qfyrs_1_0 [] = 
{
	conn_ev_qlfy_set_status_refuse,
	NULL
};

static conn_action_t await_actions_1_0 [] =
{
	NULL
};

static conn_state_transition_t await_state_transition_1_0 =
{  
	conn_ev_data_request,               
	CONN_STATE_AWAIT,
	await_ev_qfyrs_1_0,                 
	await_actions_1_0
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_DETECTED event 
 */

static conn_action_t await_actions_1 [] =
{
	conn_ac_send_rnr_xxx_x_set_0,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t await_state_transition_1 =
{  
	conn_ev_local_busy_detected,        
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,                
	await_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t await_actions_2 [] =
{
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_start_rej_timer,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_2 =
{  
	conn_ev_rx_i_rsp_fbit_set_1_unexpd_ns,  
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,                    
	await_actions_2
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns event 
 */

static conn_action_t await_actions_3a [] =
{
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_start_rej_timer,
	NULL
};

static conn_state_transition_t await_state_transition_3a =
{  
	conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns,  
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,                    
	await_actions_3a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0_UNEXPD_Ns event 
 */

static conn_action_t await_actions_3b [] =
{
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_start_rej_timer,
	NULL
};

static conn_state_transition_t await_state_transition_3b =
{  
	conn_ev_rx_i_rsp_fbit_set_0_unexpd_ns,  
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,                    
	await_actions_3b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t await_actions_4 [] =
{
	conn_ac_send_rej_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_start_rej_timer,
	conn_ac_start_p_timer,
	NULL
};

static conn_state_transition_t await_state_transition_4 =
{  
	conn_ev_rx_i_cmd_pbit_set_1_unexpd_ns,  
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,                    
	await_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_actions_5 [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_stop_p_timer,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_resend_i_xxx_x_set_0_or_send_rr,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_5 =
{  
	conn_ev_rx_i_rsp_fbit_set_1,    
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,            
	await_actions_5
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_actions_6a [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_rr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_state_transition_6a =
{  
	conn_ev_rx_i_rsp_fbit_set_0,    
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,            
	await_actions_6a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_actions_6b [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_rr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_state_transition_6b =
{  
	conn_ev_rx_i_cmd_pbit_set_0,    
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,            
	await_actions_6b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_actions_7 [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_state_transition_7 =
{  
	conn_ev_rx_i_cmd_pbit_set_1,    
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,            
	await_actions_7
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_actions_8a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_8a =
{  
	conn_ev_rx_rr_rsp_fbit_set_1,   
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,            
	await_actions_8a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_actions_8b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_8b =
{  
	conn_ev_rx_rej_rsp_fbit_set_1,      
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,                
	await_actions_8b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_actions_9a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_9a =
{  
	conn_ev_rx_rr_cmd_pbit_set_0,       
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,                
	await_actions_9a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_actions_9b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_9b =
{  
	conn_ev_rx_rr_rsp_fbit_set_0,       
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,                  
	await_actions_9b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_actions_9c [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_9c =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,      
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,                
	await_actions_9c
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_actions_9d [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_9d =
{  
	conn_ev_rx_rej_rsp_fbit_set_0,      
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,                
	await_actions_9d
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_actions_10a [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_10a =
{  
	conn_ev_rx_rr_cmd_pbit_set_1,       
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,                
	await_actions_10a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_actions_10b [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_10b =
{  
	conn_ev_rx_rej_cmd_pbit_set_1,      
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,                
	await_actions_10b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_actions_11 [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_11 =
{  
	conn_ev_rx_rnr_rsp_fbit_set_1,      
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,                
	await_actions_11
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_actions_12a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_12a =
{  
	conn_ev_rx_rnr_cmd_pbit_set_0,      
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,                
	await_actions_12a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_actions_12b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_12b =
{  
	conn_ev_rx_rnr_rsp_fbit_set_0,      
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,                
	await_actions_12b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_actions_13 [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_state_transition_13 =
{  
	conn_ev_rx_rnr_cmd_pbit_set_1,
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,
	await_actions_13
};


/* 
 * State transitions for 
 * CONN_EV_P_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t await_ev_qfyrs_14 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2,
	NULL
};

static conn_action_t await_actions_14 [] =
{
	conn_ac_send_rr_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t await_state_transition_14 =
{  
	conn_ev_p_timer_expired,
	CONN_STATE_AWAIT,
	await_ev_qfyrs_14,
	await_actions_14
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t *await_state_transitions [] =
{
	&common_state_transition_1,      // Request
	&common_state_transition_2,
	&await_state_transition_1_0,
	&common_state_transition_n,

	&await_state_transition_1,       // Local busy
	&common_state_transition_n,

	&common_state_transition_n,      // Initiate PF Cycle

	&common_state_transition_11a,    // Timer
	&common_state_transition_11b,
	&common_state_transition_11c,
	&common_state_transition_11d,

	&await_state_transition_14,
	&common_state_transition_n,

	&common_state_transition_3,      // Receive frame
	&common_state_transition_4,
	&common_state_transition_5,
	&common_state_transition_6,
	&common_state_transition_7a,
	&common_state_transition_7b,
	&common_state_transition_8a,
	&common_state_transition_8b,
	&common_state_transition_8c,
	&common_state_transition_9,
	// &common_state_transition_10,

	&await_state_transition_2,
	&await_state_transition_3a,
	&await_state_transition_3b,
	&await_state_transition_4,
	&await_state_transition_5,
	&await_state_transition_6a,
	&await_state_transition_6b,
	&await_state_transition_7,
	&await_state_transition_8a,
	&await_state_transition_8b,
	&await_state_transition_9a,
	&await_state_transition_9b,
	&await_state_transition_9c,
	&await_state_transition_9d,
	&await_state_transition_10a,
	&await_state_transition_10b,
	&await_state_transition_11,
	&await_state_transition_12a,
	&await_state_transition_12b,
	&await_state_transition_13,

	&common_state_transition_n
};



/* ------------------ CONN_STATE_AWAIT_BUSY transitions ------------------ */

/* 
 * State transitions for 
 * CONN_EV_DATA_CONN_REQUEST event 
 */

static conn_event_qfyr_t await_busy_ev_qfyrs_1_0 [] = 
{
	conn_ev_qlfy_set_status_refuse,
	NULL
};

static conn_action_t await_busy_actions_1_0 [] =
{
	NULL
};

static conn_state_transition_t await_busy_state_transition_1_0 =
{  
	conn_ev_data_request,                 
	CONN_STATE_AWAIT_BUSY,
	await_busy_ev_qfyrs_1_0,              
	await_busy_actions_1_0
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t await_busy_ev_qfyrs_1 [] = 
{
	conn_ev_qlfy_data_flag_eq_1, 
	NULL
};

static conn_action_t await_busy_actions_1 [] =
{
	conn_ac_send_rej_xxx_x_set_0,
	conn_ac_start_rej_timer,
	NULL
};

static conn_state_transition_t await_busy_state_transition_1 =
{  
	conn_ev_local_busy_cleared,         
	CONN_STATE_AWAIT_REJECT,
	await_busy_ev_qfyrs_1,              
	await_busy_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t await_busy_ev_qfyrs_2 [] = 
{
	conn_ev_qlfy_data_flag_eq_0, 
	NULL
};

static conn_action_t await_busy_actions_2 [] =
{
	conn_ac_send_rr_xxx_x_set_0,
	NULL
};

static conn_state_transition_t await_busy_state_transition_2 =
{  
	conn_ev_local_busy_cleared,         
	CONN_STATE_AWAIT,
	await_busy_ev_qfyrs_2,              
	await_busy_actions_2
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_CLEARED event 
 */

static conn_event_qfyr_t await_busy_ev_qfyrs_3 [] = 
{
	conn_ev_qlfy_data_flag_eq_2,
	NULL
};

static conn_action_t await_busy_actions_3 [] =
{
	conn_ac_send_rr_xxx_x_set_0,
	NULL
};

static conn_state_transition_t await_busy_state_transition_3 =
{  
	conn_ev_local_busy_cleared,         
	CONN_STATE_AWAIT_REJECT,
	await_busy_ev_qfyrs_3,              
	await_busy_actions_3
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t await_busy_actions_4 [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_set_data_flag_1,
	conn_ac_clear_remote_busy,
	conn_ac_resend_i_xxx_x_set_0,
	NULL
};

static conn_state_transition_t await_busy_state_transition_4 =
{  
	conn_ev_rx_i_rsp_fbit_set_1_unexpd_ns,  
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,                    
	await_busy_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns event 
 */

static conn_action_t await_busy_actions_5a [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_data_flag_1,
	NULL
};

static conn_state_transition_t await_busy_state_transition_5a =
{  
	conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns,  
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,                    
	await_busy_actions_5a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0_UNEXPD_Ns event 
 */

static conn_action_t await_busy_actions_5b [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_data_flag_1,
	NULL
};

static conn_state_transition_t await_busy_state_transition_5b =
{  
	conn_ev_rx_i_rsp_fbit_set_0_unexpd_ns,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_5b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t await_busy_actions_6 [] =
{
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_data_flag_1,
	NULL
};

static conn_state_transition_t await_busy_state_transition_6 =
{  
	conn_ev_rx_i_cmd_pbit_set_1_unexpd_ns,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_6
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_busy_actions_7 [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_stop_p_timer,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_data_flag_0,
	conn_ac_clear_remote_busy,
	conn_ac_resend_i_xxx_x_set_0,
	NULL

};

static conn_state_transition_t await_busy_state_transition_7 =
{  
	conn_ev_rx_i_rsp_fbit_set_1,
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_7
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_busy_actions_8a [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t await_busy_state_transition_8a =
{  
	conn_ev_rx_i_rsp_fbit_set_0,    
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,            
	await_busy_actions_8a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_busy_actions_8b [] =
{
	conn_ac_optional_send_rnr_xxx_x_set_0,
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t await_busy_state_transition_8b =
{  
	conn_ev_rx_i_cmd_pbit_set_0, 
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_8b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_busy_actions_9 [] =
{
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_data_flag_0,
	NULL
};

static conn_state_transition_t await_busy_state_transition_9 =
{  
	conn_ev_rx_i_cmd_pbit_set_1,    
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,            
	await_busy_actions_9
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_busy_actions_10a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_10a =
{  
	conn_ev_rx_rr_rsp_fbit_set_1,
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_10a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_busy_actions_10b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_10b =
{  
	conn_ev_rx_rej_rsp_fbit_set_1,      
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,                
	await_busy_actions_10b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_busy_actions_11a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_11a =
{  
	conn_ev_rx_rr_cmd_pbit_set_0,       
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,                
	await_busy_actions_11a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_busy_actions_11b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_11b =
{  
	conn_ev_rx_rr_rsp_fbit_set_0,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_11b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_busy_actions_11c [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_11c =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_11c
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_busy_actions_11d [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_11d =
{  
	conn_ev_rx_rej_rsp_fbit_set_0,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_11d
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_busy_actions_12a [] =
{
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_12a =
{  
	conn_ev_rx_rr_cmd_pbit_set_1,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_12a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_busy_actions_12b [] =
{
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_12b =
{  
	conn_ev_rx_rej_cmd_pbit_set_1,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_12b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_busy_actions_13 [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_13 =
{  
	conn_ev_rx_rnr_rsp_fbit_set_1,
	CONN_STATE_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_13
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_busy_actions_14a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_14a =
{  
	conn_ev_rx_rnr_cmd_pbit_set_0,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_14a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_busy_actions_14b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_14b =
{  
	conn_ev_rx_rnr_rsp_fbit_set_0,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_14b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_busy_actions_15 [] =
{
	conn_ac_send_rnr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_busy_state_transition_15 =
{  
	conn_ev_rx_rnr_cmd_pbit_set_1,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_busy_actions_15
};


/* 
 * State transitions for 
 * CONN_EV_P_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t await_busy_ev_qfyrs_16 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2, 
	NULL
};

static conn_action_t await_busy_actions_16 [] =
{
	conn_ac_send_rnr_cmd_p_set_1,
	conn_ac_start_p_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t await_busy_state_transition_16 =
{  
	conn_ev_p_timer_expired,
	CONN_STATE_AWAIT_BUSY,
	await_busy_ev_qfyrs_16,
	await_busy_actions_16
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t *await_busy_state_transitions [] =
{
	&common_state_transition_1,          // Request
	&common_state_transition_2,
	&await_busy_state_transition_1_0,
	&common_state_transition_n,

	&await_busy_state_transition_1,      // Local busy
	&await_busy_state_transition_2,
	&await_busy_state_transition_3,
	&common_state_transition_n,

	&common_state_transition_n,          // Initiate PF cycle

	&common_state_transition_11a,        // Timer
	&common_state_transition_11b,
	&common_state_transition_11c,
	&common_state_transition_11d,

	&await_busy_state_transition_16,
	&common_state_transition_n,

	&await_busy_state_transition_4,      // Receive frame
	&await_busy_state_transition_5a,
	&await_busy_state_transition_5b,
	&await_busy_state_transition_6,
	&await_busy_state_transition_7,
	&await_busy_state_transition_8a,
	&await_busy_state_transition_8b,
	&await_busy_state_transition_9,
	&await_busy_state_transition_10a,
	&await_busy_state_transition_10b,
	&await_busy_state_transition_11a,
	&await_busy_state_transition_11b,
	&await_busy_state_transition_11c,
	&await_busy_state_transition_11d,
	&await_busy_state_transition_12a,
	&await_busy_state_transition_12b,
	&await_busy_state_transition_13,
	&await_busy_state_transition_14a,
	&await_busy_state_transition_14b,
	&await_busy_state_transition_15,

	&common_state_transition_3,
	&common_state_transition_4,
	&common_state_transition_5,
	&common_state_transition_6,
	&common_state_transition_7a,
	&common_state_transition_7b,
	&common_state_transition_8a,
	&common_state_transition_8b,
	&common_state_transition_8c,
	&common_state_transition_9,
	// &common_state_transition_10,

	&common_state_transition_n
};



/* ----------------- CONN_STATE_AWAIT_REJECT transitions ----------------- */

/* 
 * State transitions for 
 * CONN_EV_DATA_CONN_REQUEST event 
 */

static conn_event_qfyr_t await_reject_ev_qfyrs_1_0 [] = 
{
	conn_ev_qlfy_set_status_refuse,
	NULL
};

static conn_action_t await_reject_actions_1_0 [] =
{
	NULL
};

static conn_state_transition_t await_reject_state_transition_1_0 =
{  
	conn_ev_data_request,
	CONN_STATE_AWAIT_REJECT,
	await_reject_ev_qfyrs_1_0,
	await_reject_actions_1_0
};


/* 
 * State transitions for 
 * CONN_EV_LOCAL_BUSY_DETECTED event 
 */

static conn_action_t await_rejct_actions_1 [] =
{
	conn_ac_send_rnr_xxx_x_set_0,
	conn_ac_set_data_flag_2,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_1 =
{  
	conn_ev_local_busy_detected,
	CONN_STATE_AWAIT_BUSY,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0_UNEXPD_Ns event 
 */

static conn_action_t await_rejct_actions_2a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_2a =
{  
	conn_ev_rx_i_cmd_pbit_set_0_unexpd_ns,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_2a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0_UNEXPD_Ns event 
 */

static conn_action_t await_rejct_actions_2b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_2b =
{  
	conn_ev_rx_i_rsp_fbit_set_0_unexpd_ns,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_2b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t await_rejct_actions_3 [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_3 =
{  
	conn_ev_rx_i_cmd_pbit_set_1_unexpd_ns,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_3
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_rejct_actions_4 [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_stop_p_timer,
	conn_ac_stop_rej_timer,   
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_resend_i_xxx_x_set_0_or_send_rr,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_4 =
{  
	conn_ev_rx_i_rsp_fbit_set_1,
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_4
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_rejct_actions_5a [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_rr_xxx_x_set_0,
	conn_ac_stop_rej_timer,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_5a =
{  
	conn_ev_rx_i_rsp_fbit_set_0,
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_5a
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_rejct_actions_5b [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_rr_xxx_x_set_0,
	conn_ac_stop_rej_timer,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_5b =
{  
	conn_ev_rx_i_cmd_pbit_set_0,     CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,             await_rejct_actions_5b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_rejct_actions_6 [] =
{
	conn_ac_increment_vr_by_1,
	conn_ac_data_indication,
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_stop_rej_timer,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_6 =
{  
	conn_ev_rx_i_cmd_pbit_set_1,
	CONN_STATE_AWAIT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_6
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_rejct_actions_7a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_7a =
{  
	conn_ev_rx_rr_rsp_fbit_set_1,
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_7a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_rejct_actions_7b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_7b =
{  
	conn_ev_rx_rej_rsp_fbit_set_1,
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_7b
};


/* 
 * State transitions for 
 * CONN_EV_RX_I_RSP_Fbit_SET_1_UNEXPD_Ns event 
 */

static conn_action_t await_rejct_actions_7c [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_resend_i_xxx_x_set_0,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_7c =
{  
	conn_ev_rx_i_rsp_fbit_set_1_unexpd_ns,
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_7c
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_rejct_actions_8a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_8a =
{  
	conn_ev_rx_rr_cmd_pbit_set_0,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_8a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_rejct_actions_8b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_8b =
{  
	conn_ev_rx_rr_rsp_fbit_set_0,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_8b
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_rejct_actions_8c [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_8c =
{  
	conn_ev_rx_rej_cmd_pbit_set_0,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_8c
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_rejct_actions_8d [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_8d =
{  
	conn_ev_rx_rej_rsp_fbit_set_0,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_8d
};


/* 
 * State transitions for 
 * CONN_EV_RX_RR_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_rejct_actions_9a [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_9a =
{  
	conn_ev_rx_rr_cmd_pbit_set_1,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_9a
};


/* 
 * State transitions for 
 * CONN_EV_RX_REJ_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_rejct_actions_9b [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_clear_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_9b =
{  
	conn_ev_rx_rej_cmd_pbit_set_1,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_9b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_1 event 
 */

static conn_action_t await_rejct_actions_10 [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_stop_p_timer,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_10 =
{  
	conn_ev_rx_rnr_rsp_fbit_set_1,
	CONN_STATE_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_10
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_0 event 
 */

static conn_action_t await_rejct_actions_11a [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_11a =
{  
	conn_ev_rx_rnr_cmd_pbit_set_0,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_11a
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_RSP_Fbit_SET_0 event 
 */

static conn_action_t await_rejct_actions_11b [] =
{
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_11b =
{  
	conn_ev_rx_rnr_rsp_fbit_set_0,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_11b
};


/* 
 * State transitions for 
 * CONN_EV_RX_RNR_CMD_Pbit_SET_1 event 
 */

static conn_action_t await_rejct_actions_12 [] =
{
	conn_ac_send_rr_rsp_f_set_1,
	conn_ac_update_nr_received,
	conn_ac_update_vs,
	conn_ac_set_remote_busy,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_12 =
{  
	conn_ev_rx_rnr_cmd_pbit_set_1,
	CONN_STATE_AWAIT_REJECT,
	NO_EVENT_QUALIFIERS,
	await_rejct_actions_12
};


/* 
 * State transitions for 
 * CONN_EV_P_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t await_rejct_ev_qfyrs_13 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2,
	NULL
};

static conn_action_t await_rejct_actions_13 [] =
{
	conn_ac_send_rej_cmd_p_set_1,
	conn_ac_stop_p_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t await_rejct_state_transition_13 =
{  
	conn_ev_p_timer_expired,
	CONN_STATE_AWAIT_REJECT,
	await_rejct_ev_qfyrs_13,
	await_rejct_actions_13
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t *await_rejct_state_transitions [] =
{
	&await_reject_state_transition_1_0,
	&common_state_transition_1,          // requests
	&common_state_transition_2,
	&common_state_transition_n,

	&await_rejct_state_transition_1,     // local busy 
	&common_state_transition_n,

	&common_state_transition_n,          // Initiate PF cycle

	&await_rejct_state_transition_13,    // timers 
	&common_state_transition_11a,
	&common_state_transition_11b,
	&common_state_transition_11c,
	&common_state_transition_11d,
	&common_state_transition_n,

	&await_rejct_state_transition_2a,    // receive frames 
	&await_rejct_state_transition_2b,
	&await_rejct_state_transition_3,
	&await_rejct_state_transition_4,
	&await_rejct_state_transition_5a,
	&await_rejct_state_transition_5b,
	&await_rejct_state_transition_6,
	&await_rejct_state_transition_7a,
	&await_rejct_state_transition_7b,
	&await_rejct_state_transition_7c,
	&await_rejct_state_transition_8a,
	&await_rejct_state_transition_8b,
	&await_rejct_state_transition_8c,
	&await_rejct_state_transition_8d,
	&await_rejct_state_transition_9a,
	&await_rejct_state_transition_9b,
	&await_rejct_state_transition_10,
	&await_rejct_state_transition_11a,
	&await_rejct_state_transition_11b,
	&await_rejct_state_transition_12,
	&common_state_transition_3,
	&common_state_transition_4,
	&common_state_transition_5,
	&common_state_transition_6,
	&common_state_transition_7a,
	&common_state_transition_7b,
	&common_state_transition_8a,
	&common_state_transition_8b,
	&common_state_transition_8c,
	&common_state_transition_9,
	// &common_state_transition_10,
	&common_state_transition_n
};



/* -------------------- CONN_STATE_D_CONN transitions -------------------- */

/* 
 * State transitions for 
 * CONN_EV_RX_SABME_CMD_Pbit_SET_X event,cause_flag = 1 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_1 [] = 
{
	conn_ev_qlfy_cause_flag_eq_1,           
	conn_ev_qlfy_set_status_conflict,
	NULL
};

static conn_action_t d_conn_actions_1 [] =
{
	conn_ac_send_dm_rsp_f_set_p,  
	conn_ac_stop_ack_timer,
	conn_ac_disconnect_confirm,
	conn_disconnect,
	NULL
};

static conn_state_transition_t d_conn_state_transition_1 =
{  
	conn_ev_rx_sabme_cmd_pbit_set_x,
	CONN_STATE_ADM,
	d_conn_ev_qfyrs_1,
	d_conn_actions_1
};


/* 
 * State transitions for 
 * CONN_EV_RX_SABME_CMD_Pbit_SET_X event,cause_flag = 0 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_1_1 [] = 
{
	conn_ev_qlfy_cause_flag_eq_0,           
	conn_ev_qlfy_set_status_conflict,
	NULL
};

static conn_action_t d_conn_actions_1_1 [] =
{
	conn_ac_send_dm_rsp_f_set_p, 
	conn_ac_stop_ack_timer,
	conn_disconnect,
	NULL
};

static conn_state_transition_t d_conn_state_transition_1_1 =
{  
	conn_ev_rx_sabme_cmd_pbit_set_x,
	CONN_STATE_ADM,
	d_conn_ev_qfyrs_1_1,
	d_conn_actions_1_1
};

/* 
 * State transitions for 
 * CONN_EV_RX_UA_RSP_Fbit_SET_X event,cause_flag = 1 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_2 [] = 
{
	conn_ev_qlfy_p_flag_eq_f,    
	conn_ev_qlfy_cause_flag_eq_1,
	conn_ev_qlfy_set_status_disconnect,
	NULL
};

static conn_action_t d_conn_actions_2 [] =
{
	conn_ac_stop_ack_timer,
	conn_ac_disconnect_confirm,
	conn_disconnect,    
	NULL
};

static conn_state_transition_t d_conn_state_transition_2 =
{  
	conn_ev_rx_ua_rsp_fbit_set_x,
	CONN_STATE_ADM,
	d_conn_ev_qfyrs_2,
	d_conn_actions_2  
};

/* 
 * State transitions for 
 * CONN_EV_RX_UA_RSP_Fbit_SET_X event,cause_flag = 0 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_2_1 [] = 
{
	conn_ev_qlfy_p_flag_eq_f,  
	conn_ev_qlfy_cause_flag_eq_0,
	conn_ev_qlfy_set_status_disconnect,
	NULL
};

static conn_action_t d_conn_actions_2_1 [] =
{
	conn_ac_stop_ack_timer,
	conn_disconnect,    
	NULL
};

static conn_state_transition_t d_conn_state_transition_2_1 =
{  
	conn_ev_rx_ua_rsp_fbit_set_x,
	CONN_STATE_ADM,
	d_conn_ev_qfyrs_2_1,
	d_conn_actions_2_1  
};

/* 
 * State transitions for 
 * CONN_EV_RX_DISC_CMD_Pbit_SET_X event 
 */

static conn_action_t d_conn_actions_3 [] =
{
	conn_ac_send_ua_rsp_f_set_p,  
	NULL
};

static conn_state_transition_t d_conn_state_transition_3 =
{  
	conn_ev_rx_disc_cmd_pbit_set_x,
	CONN_STATE_D_CONN,
	NO_EVENT_QUALIFIERS,
	d_conn_actions_3
};


/* 
 * State transitions for
 * CONN_EV_RX_DM_RSP_Fbit_SET_X event,cause_flag=1 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_4 [] = 
{
	conn_ev_qlfy_cause_flag_eq_1,
	conn_ev_qlfy_set_status_disconnect,
	NULL
};

static conn_action_t d_conn_actions_4 [] =
{
	conn_ac_stop_ack_timer,
	conn_ac_disconnect_confirm,
	conn_disconnect,    
	NULL
};

static conn_state_transition_t d_conn_state_transition_4 =
{  
	conn_ev_rx_dm_rsp_fbit_set_x,
	CONN_STATE_ADM,
	d_conn_ev_qfyrs_4,
	d_conn_actions_4
};

/* 
 * State transitions for 
 * CONN_EV_RX_DM_RSP_Fbit_SET_X event,cause_flag=0 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_4_1 [] = 
{
	conn_ev_qlfy_cause_flag_eq_0,
	conn_ev_qlfy_set_status_disconnect,
	NULL
};

static conn_action_t d_conn_actions_4_1 [] =
{
	conn_ac_stop_ack_timer,
	conn_disconnect,
	NULL
};

static conn_state_transition_t d_conn_state_transition_4_1 =
{  
	conn_ev_rx_dm_rsp_fbit_set_x,
	CONN_STATE_ADM,
	d_conn_ev_qfyrs_4_1,
	d_conn_actions_4_1
};

/* 
 * State transition for 
 * CONN_EV_DATA_CONN_REQUEST event 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_5 [] =
{
	conn_ev_qlfy_set_status_refuse,
	NULL
};

static conn_action_t d_conn_actions_5 [] =
{
	NULL
};

static conn_state_transition_t d_conn_state_transition_5 =
{
	conn_ev_data_request, CONN_STATE_D_CONN,
	d_conn_ev_qfyrs_5, d_conn_actions_5
};

/* 
 * State transitions for
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_6 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2,
	NULL
};

static conn_action_t d_conn_actions_6 [] =
{
	conn_ac_send_disc_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t d_conn_state_transition_6 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_D_CONN,
	d_conn_ev_qfyrs_6,
	d_conn_actions_6
};


/* 
 * State transitions for
 * CONN_EV_ACK_TIMER_EXPIRED event,cause_flag=1 
 */

static conn_event_qfyr_t d_conn_ev_qfyrs_7 [] = 
{
	conn_ev_qlfy_retry_count_gte_n2, 
	conn_ev_qlfy_cause_flag_eq_1,
	conn_ev_qlfy_set_status_failed,
	NULL
};

static conn_action_t d_conn_actions_7 [] =
{
	conn_ac_disconnect_confirm,
	conn_disconnect,    
	NULL
};

static conn_state_transition_t d_conn_state_transition_7 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_ADM,
	d_conn_ev_qfyrs_7,
	d_conn_actions_7 
};


/* 
 * State transitions for 
 * CONN_EV_ACK_TIMER_EXPIRED event,cause_flag=0 
 */

static conn_event_qfyr_t   d_conn_ev_qfyrs_8 [] = 
{
	conn_ev_qlfy_retry_count_gte_n2, 	
	conn_ev_qlfy_cause_flag_eq_0,
	conn_ev_qlfy_set_status_failed,
	NULL
};

static conn_action_t       d_conn_actions_8 [] =
{
	conn_disconnect,
	NULL
};

static conn_state_transition_t d_conn_state_transition_8 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_ADM,
	d_conn_ev_qfyrs_8,
	d_conn_actions_8 
};


/* 
 * Array of pointers; 
 * one to each transition 
 */

static conn_state_transition_t * d_conn_state_transitions [] =
{
	&d_conn_state_transition_5,      // Request
	&common_state_transition_n,

	&common_state_transition_n,      // Local busy

	&common_state_transition_n,      // Initiate PF cycle

	&d_conn_state_transition_6,      // Timer
	&d_conn_state_transition_7,
	&d_conn_state_transition_8,
	&common_state_transition_n,

	&d_conn_state_transition_1,      // Receive frame
	&d_conn_state_transition_1_1,
	&d_conn_state_transition_2,
	&d_conn_state_transition_2_1,
	&d_conn_state_transition_3,
	&d_conn_state_transition_4,
	&d_conn_state_transition_4_1,

	&common_state_transition_n
};



/* -------------------- CONN_STATE_RESET transitions --------------------- */

/* 
 * State transitions for 
 * CONN_EV_RX_SABME_CMD_Pbit_SET_X event 
 */

static conn_action_t reset_actions_1 [] =
{
	conn_ac_set_vs_0,
	conn_ac_set_vr_0,
	conn_ac_set_s_flag_1,
	conn_ac_send_ua_rsp_f_set_p,  
	NULL
};

static conn_state_transition_t reset_state_transition_1 =
{  
	conn_ev_rx_sabme_cmd_pbit_set_x,
	CONN_STATE_RESET,
	NO_EVENT_QUALIFIERS,
	reset_actions_1
};


/* 
 * State transitions for
 * CONN_EV_RX_UA_RSP_Fbit_SET_X event,cause_flag = 1 
 */

static conn_event_qfyr_t reset_ev_qfyrs_2 [] = 
{
	conn_ev_qlfy_p_flag_eq_f, 
	conn_ev_qlfy_cause_flag_eq_1,
	conn_ev_qlfy_set_status_connect,
	NULL
};

static conn_action_t reset_actions_2 [] =
{
	conn_ac_stop_ack_timer,
	conn_ac_set_vs_0,
	conn_ac_set_vr_0,
	conn_ac_update_p_flag,
	conn_ac_reset_confirm,
	conn_ac_set_remote_busy_0,
	conn_reset,
	NULL
};

static conn_state_transition_t reset_state_transition_2 =
{  
	conn_ev_rx_ua_rsp_fbit_set_x,
	CONN_STATE_NORMAL,
	reset_ev_qfyrs_2,
	reset_actions_2
};

/* 
 * State transitions for
 * CONN_EV_RX_UA_RSP_Fbit_SET_X event,cause_flag=0 
 */

static conn_event_qfyr_t reset_ev_qfyrs_2_1 [] = 
{
	conn_ev_qlfy_p_flag_eq_f,
	conn_ev_qlfy_cause_flag_eq_0,
	conn_ev_qlfy_set_status_reset_done,
	NULL
};

static conn_action_t reset_actions_2_1 [] =
{
	conn_ac_stop_ack_timer,
	conn_ac_set_vs_0,
	conn_ac_set_vr_0,
	conn_ac_update_p_flag,
	conn_ac_reset_confirm,
	conn_ac_set_remote_busy_0,
	conn_reset,
	NULL
};

static conn_state_transition_t reset_state_transition_2_1 =
{  
	conn_ev_rx_ua_rsp_fbit_set_x,
	CONN_STATE_NORMAL,
	reset_ev_qfyrs_2_1,
	reset_actions_2_1
};


/* 
 * State transitions for
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t reset_ev_qfyrs_3 [] = 
{
	conn_ev_qlfy_s_flag_eq_1,
	conn_ev_qlfy_set_status_reset_done,
	NULL
};

static conn_action_t reset_actions_3 [] =
{
	conn_ac_set_p_flag_0,
	conn_ac_set_remote_busy_0,
	NULL
};

static conn_state_transition_t reset_state_transition_3 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_NORMAL,
	reset_ev_qfyrs_3,
	reset_actions_3
};


/* 
 * State transitions for
 * CONN_EV_RX_DISC_CMD_Pbit_SET_X event,cause_flag=1 
 */

static conn_event_qfyr_t reset_ev_qfyrs_4 [] = 
{
	conn_ev_qlfy_cause_flag_eq_1, 
	conn_ev_qlfy_set_status_disconnect,
	NULL
};
static conn_action_t reset_actions_4 [] =
{
	conn_ac_send_dm_rsp_f_set_p, 
	conn_ac_disconnect_indication,
	conn_ac_stop_ack_timer,
	conn_disconnect,          
	NULL
};

static conn_state_transition_t reset_state_transition_4 =
{  
	conn_ev_rx_disc_cmd_pbit_set_x,
	CONN_STATE_ADM,
	reset_ev_qfyrs_4,
	reset_actions_4
};


/* 
 * State transitions for
 * CONN_EV_RX_DISC_CMD_Pbit_SET_X event,cause_flag=0 
 */

static conn_event_qfyr_t reset_ev_qfyrs_4_1 [] = 
{
	conn_ev_qlfy_cause_flag_eq_0,
	conn_ev_qlfy_set_status_refuse,
	NULL
};

static conn_action_t reset_actions_4_1 [] =
{
	conn_ac_send_dm_rsp_f_set_p,
	conn_ac_stop_ack_timer,
	conn_disconnect, 
	NULL
};

static conn_state_transition_t reset_state_transition_4_1 =
{  
	conn_ev_rx_disc_cmd_pbit_set_x,
	CONN_STATE_ADM,
	reset_ev_qfyrs_4_1,
	reset_actions_4_1
};


/* 
 * State transitions for
 * CONN_EV_RX_DM_RSP_Fbit_SET_X event, cause_flag = 1 
 */

static conn_event_qfyr_t reset_ev_qfyrs_5 [] = 
{
	conn_ev_qlfy_cause_flag_eq_1,
	conn_ev_qlfy_set_status_disconnect,
 	NULL
};

static conn_action_t reset_actions_5 [] =
{
	conn_ac_disconnect_indication,
	conn_ac_stop_ack_timer,
	conn_disconnect,
	NULL
};

static conn_state_transition_t reset_state_transition_5 =
{  
	conn_ev_rx_dm_rsp_fbit_set_x,
	CONN_STATE_ADM,
	reset_ev_qfyrs_5,
	reset_actions_5
};

/* 
 * State transitions for
 * CONN_EV_RX_DM_RSP_Fbit_SET_X event, cause_flag = 0 
 */

static conn_event_qfyr_t reset_ev_qfyrs_5_1 [] = 
{
	conn_ev_qlfy_cause_flag_eq_0, 
	conn_ev_qlfy_set_status_refuse,
	NULL
};

static conn_action_t reset_actions_5_1 [] =
{
	conn_ac_stop_ack_timer,
	conn_disconnect, 
	NULL
};

static conn_state_transition_t reset_state_transition_5_1 =
{  
	conn_ev_rx_dm_rsp_fbit_set_x,
	CONN_STATE_ADM,
	reset_ev_qfyrs_5_1,
	reset_actions_5_1
};

/* 
 * State transitions for
 * DATA_CONN_REQUEST event 
 */

static conn_event_qfyr_t reset_ev_qfyrs_6 [] = 
{
	conn_ev_qlfy_set_status_refuse,
	NULL
};

static conn_action_t reset_actions_6 [] =
{
	NULL
};

static conn_state_transition_t reset_state_transition_6 =
{  
	conn_ev_data_request,
	CONN_STATE_RESET,
	reset_ev_qfyrs_6,
	reset_actions_6
};

/* 
 * State transitions for
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t reset_ev_qfyrs_7 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2,
	conn_ev_qlfy_s_flag_eq_0,
	NULL
};

static conn_action_t reset_actions_7 [] =
{
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t reset_state_transition_7 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_RESET,
	reset_ev_qfyrs_7,
	reset_actions_7
};


/* 
 * State transitions for
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t reset_ev_qfyrs_8 [] = 
{
	conn_ev_qlfy_retry_count_gte_n2, 
	conn_ev_qlfy_s_flag_eq_0,
	conn_ev_qlfy_cause_flag_eq_1,
	conn_ev_qlfy_set_status_failed,
	NULL
};
static conn_action_t reset_actions_8 [] =
{
	conn_ac_disconnect_indication,
	conn_disconnect,
	NULL
};

static conn_state_transition_t reset_state_transition_8 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_ADM,
	reset_ev_qfyrs_8,
	reset_actions_8
};

/* 
 * State transitions for
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t reset_ev_qfyrs_8_1 [] = 
{
	conn_ev_qlfy_retry_count_gte_n2, 
	conn_ev_qlfy_s_flag_eq_0,
	conn_ev_qlfy_cause_flag_eq_0, 
	conn_ev_qlfy_set_status_failed,
	NULL
};
static conn_action_t reset_actions_8_1 [] =
{
	conn_ac_disconnect_indication,
	conn_disconnect,
	NULL
};

static conn_state_transition_t reset_state_transition_8_1 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_ADM,
	reset_ev_qfyrs_8_1,
	reset_actions_8_1
};


/* 
 * Array of pointers;
 * one to each transition 
 */

static conn_state_transition_t *reset_state_transitions [] =
{
	&reset_state_transition_6,       // Request
	&common_state_transition_n,

	&common_state_transition_n,      // Local busy

	&common_state_transition_n,      // Initiate PF cycle

	&reset_state_transition_3,       // Timer
	&reset_state_transition_7,
	&reset_state_transition_8,
	&reset_state_transition_8_1,
	&common_state_transition_n,

	&reset_state_transition_1,       // Receive frame
	&reset_state_transition_2,
	&reset_state_transition_2_1,
	&reset_state_transition_4,
	&reset_state_transition_4_1,
	&reset_state_transition_5,
	&reset_state_transition_5_1,

	&common_state_transition_n
};



/* -------------------- CONN_STATE_ERROR transitions --------------------- */

/* 
 * State transitions for
 * CONN_EV_RX_SABME_CMD_Pbit_SET_X event 
 */

static conn_action_t error_actions_1 [] =
{
	conn_ac_set_vs_0,
	conn_ac_set_vr_0,
	conn_ac_send_ua_rsp_f_set_p,
	conn_ac_reset_indication,
	conn_ac_set_p_flag_0,
	conn_ac_set_remote_busy_0,
	conn_ac_stop_ack_timer,
	conn_reset,
	NULL
};

static conn_state_transition_t error_state_transition_1 =
{  
	conn_ev_rx_sabme_cmd_pbit_set_x,
	CONN_STATE_NORMAL,
	NO_EVENT_QUALIFIERS,
	error_actions_1
};


/* 
 * State transitions for
 * CONN_EV_RX_DISC_CMD_Pbit_SET_X event 
 */

static conn_action_t error_actions_2 [] =
{
	conn_ac_send_ua_rsp_f_set_p,
	conn_ac_disconnect_indication,
	conn_ac_stop_ack_timer,
	conn_disconnect,
	NULL
};

static conn_state_transition_t error_state_transition_2 =
{  
	conn_ev_rx_disc_cmd_pbit_set_x,
	CONN_STATE_ADM,
	NO_EVENT_QUALIFIERS,
	error_actions_2
};


/* 
 * State transitions for
 * CONN_EV_RX_DM_RSP_Fbit_SET_X event 
 */

static conn_action_t error_actions_3 [] =
{
	conn_ac_disconnect_indication,
	conn_ac_stop_ack_timer,
	conn_disconnect, 
	NULL
};

static conn_state_transition_t error_state_transition_3 =
{  
	conn_ev_rx_dm_rsp_fbit_set_x,
	CONN_STATE_ADM,
	NO_EVENT_QUALIFIERS,
	error_actions_3
};


/* 
 * State transitions for
 * CONN_EV_RX_FRMR_RSP_Fbit_SET_X event 
 */

static conn_action_t error_actions_4 [] =
{
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_start_ack_timer,
	conn_ac_set_retry_count_0,
	conn_ac_set_cause_flag_0,
	NULL
};

static conn_state_transition_t error_state_transition_4 =
{  
	conn_ev_rx_frmr_rsp_fbit_set_x,
	CONN_STATE_RESET,
	NO_EVENT_QUALIFIERS,
	error_actions_4
};


/* 
 * State transitions for
 * CONN_EV_RX_XXX_CMD_Pbit_SET_X event 
 */

static conn_action_t error_actions_5 [] =
{
	conn_ac_resend_frmr_rsp_f_set_p,
	NULL
};

static conn_state_transition_t error_state_transition_5 =
{  
	conn_ev_rx_xxx_cmd_pbit_set_x,
	CONN_STATE_ERROR,
	NO_EVENT_QUALIFIERS,
	error_actions_5
};


/* 
 * State transitions for
 * CONN_EV_RX_XXX_RSP_Fbit_SET_X event 
 */

static conn_state_transition_t error_state_transition_6 =
{  
	conn_ev_rx_xxx_rsp_fbit_set_x,
	CONN_STATE_ERROR,
	NO_EVENT_QUALIFIERS,
	NO_TRANSITION_ACTIONS
};


/* 
 * State transitions for
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t error_ev_qfyrs_7 [] = 
{
	conn_ev_qlfy_retry_count_lt_n2,
	NULL
};

static conn_action_t       error_actions_7 [] =
{
	conn_ac_resend_frmr_rsp_f_set_0, 
	conn_ac_start_ack_timer,
	conn_ac_increment_retry_count_by_1,
	NULL
};

static conn_state_transition_t error_state_transition_7 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_ERROR,
	error_ev_qfyrs_7,
	error_actions_7
};


/* 
 * State transitions for
 * CONN_EV_ACK_TIMER_EXPIRED event 
 */

static conn_event_qfyr_t error_ev_qfyrs_8 [] = 
{
	conn_ev_qlfy_retry_count_gte_n2,
	NULL
};

static conn_action_t error_actions_8 [] =
{
	conn_ac_send_sabme_cmd_p_set_x,
	conn_ac_set_s_flag_0,
	conn_ac_start_ack_timer,
	conn_ac_set_retry_count_0,
	conn_ac_set_cause_flag_0,
	NULL
};

static conn_state_transition_t error_state_transition_8 =
{  
	conn_ev_ack_timer_expired,
	CONN_STATE_RESET,
	error_ev_qfyrs_8,
	error_actions_8
};

/* 
 * State transitions for
 * CONN_EV_DATA_CONN_REQUEST event 
 */

static conn_event_qfyr_t error_ev_qfyrs_9 [] = 
{
	conn_ev_qlfy_set_status_refuse,
	NULL
};

static conn_action_t error_actions_9 [] =
{
   NULL
};

static conn_state_transition_t error_state_transition_9 =
{  
	conn_ev_data_request,
	CONN_STATE_ERROR,
	error_ev_qfyrs_9,
	error_actions_9
};



/* 
 * Array of pointers;
 * one to each transition 
 */

static conn_state_transition_t *error_state_transitions [] =
{
	&error_state_transition_9,       // Request
	&common_state_transition_n,

	&common_state_transition_n,      // Local busy

	&common_state_transition_n,      // Initiate PF cycle


	&error_state_transition_7,       // Timer
	&error_state_transition_8,
	&common_state_transition_n,

	&error_state_transition_1,       // Receive frame
	&error_state_transition_2,
	&error_state_transition_3,
	&error_state_transition_4,
	&error_state_transition_5,
	&error_state_transition_6,

	&common_state_transition_n
};

/* ------------------- CONN_STATE_TEMP transitions ----------------- */


/* 
 * State transitions for
 * CONN_EV_DISCONNECT_REQUEST event 
 */

static conn_action_t temp_actions_1 [] =
{
	conn_ac_stop_all_timers,
	conn_ac_send_disc_cmd_p_set_x,
	conn_disconnect,                       
	NULL
};

static conn_state_transition_t temp_state_transition_1 =
{  
	conn_ev_disconnect_request,
	CONN_STATE_ADM,
	NO_EVENT_QUALIFIERS,
	temp_actions_1 
};


/* 
 * Array of pointers;
 * one to each transition 
 */

static conn_state_transition_t *temp_state_transitions [] =
{  
	&temp_state_transition_1,        // requests
	&common_state_transition_n,

	&common_state_transition_n,      // local busy

	&common_state_transition_n,      // init_pf_cycle

	&common_state_transition_n,      // timer

	&common_state_transition_n       // recieve
};


/* 
 * Connection State Transition Table 
 */

conn_state_t Connection_state_table [] =
{
	{ 	CONN_STATE_ADM,
		adm_state_transitions
	},
	
	{	CONN_STATE_SETUP,
		setup_state_transitions
	},
	
	{	CONN_STATE_NORMAL,
		normal_state_transitions
	},
	
	{	CONN_STATE_BUSY,
		busy_state_transitions
	},
	
	{	CONN_STATE_REJECT,
		reject_state_transitions
	},
	
	{	CONN_STATE_AWAIT,
		await_state_transitions
	},
	
	{	CONN_STATE_AWAIT_BUSY,
		await_busy_state_transitions
	},
	
	{	CONN_STATE_AWAIT_REJECT,
		await_rejct_state_transitions   
	},
	
	{	CONN_STATE_D_CONN,
		d_conn_state_transitions
	},
	
	{	CONN_STATE_RESET,
		reset_state_transitions         
	},
	
	{	CONN_STATE_ERROR,
		error_state_transitions         
	},
	
	{	CONN_STATE_TEMP,
		temp_state_transitions          
	}
};


