/* main.c: Top-level source file for Floo.
    Floo interpreter: version 0.2.
    Designed by Andrew Plotkin <erkyrath@netcom.com>
    http://www.eblong.com/zarf/glk/floo/index.html
*/

#include "glk.h"
#include "floo.h"

/* Global variables. */
strid_t gamefile = NULL; /* The source file being interpreted. */
floodict_t *sysdict = NULL; /* The main symbol dictionary. */
floodict_t *errdict = NULL; /* Dictionary of error-handling procedures. */
floodict_t *errinfodict = NULL; /* A small dict used to store information about the most
    recent error that occurred. */
stack_t *valst = NULL; /* The operand stack. */
stack_t *exst = NULL; /* The execution stack. */

/* The main Floo entry point (called by the Glk library) */
void glk_main()
{
    int initobjcount, initrefcount;
    obj_t *ob;
    
    if (!init_atomdict()) {
        floo_err("Unable to initialize.");
    }
    
    valst = new_stack();
    exst = new_stack();
    
    sysdict = new_floodict();
    errdict = new_floodict();
    errinfodict = new_floodict();
    
    if (!sysdict || !errdict || !errinfodict || !valst || !exst) {
        floo_err("Unable to initialize.");
    }
    
    if (!init_dispatch()) {
        floo_err("Unable to initialize.");
    }
    
    if (!init_sysdict()) {
        floo_err("Unable to initialize.");
    }
    
    initobjcount = obj_debugobjcounter();
    initrefcount = obj_debugrefcounter();
    
    if (!init_parser()) {
        floo_err("Unable to initialize.");
    }
    
    if (!gamefile) {
        floo_err("No source file open.");
    }
    if (!is_floo_file(gamefile)) {
        floo_err("This does not appear to be a Floo program.");
    }
    
    ob = new_obj(otyp_FileFrame);
    ob->u.fileframe.file = gamefile;
    stack_push(exst, ob);

    execute_loop();
    
    glk_exit();
}

void floo_err(char *str)
{
    winid_t rootwin = glk_window_get_root();
    winid_t win;
    if (!rootwin) {
        win = glk_window_open(0, 0, 0, wintype_TextBuffer, 1);
    }
    else {
        win = glk_window_open(rootwin, winmethod_Below | winmethod_Fixed, 
            3, wintype_TextBuffer, 0);
    }
    if (win) {
        glk_set_window(win);
        glk_put_string("Floo error: ");
        glk_put_string(str);
        glk_put_string("\n");
    }
    glk_exit();
}

