/*
** FILE: m6811-local.c
** RSC:  $Revision: 1.5 $ $Date: 93/02/23 21:28:38 $
*/

/* Subroutines used for code generation on Motorola HC6811C.
   Copyright (C) 1987, 1993 Free Software Foundation, Inc.
   Contributed by Otto Lind (otto@coactive.com)
   Based on original 6809 port by Tom Jones (jones@sal.wisc.edu)

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include "config.h"
#include "rtl.h"
#include "regs.h"
#include "hard-reg-set.h"
#include "real.h"
#include "insn-config.h"
#include "conditions.h"
#include "insn-flags.h"
#include "output.h"
#include "insn-attr.h"

/*
** enable this to have debug information output into the assembler file
** which shows what output_swap_regx() does to do index addressing fixups.
*/
#define DEBUG_SWAP	0

override_options ()
{
}

extern FILE *asm_out_file;
static int last_mem_size;	/* operand size (bytes) */

/*****************************************************************************
**
** Print Operand for assembler (based on 6809 port)
**
*****************************************************************************/
void
print_operand (file, x, code)
FILE *file;
rtx x;
int code;
{
    if (GET_CODE (x) == REG) {
	fputs (reg_names[REGNO (x)], file);
    }
    else if (GET_CODE (x) == MEM) {
	last_mem_size = GET_MODE_SIZE (GET_MODE (x));
	if (code == 'L') {	/* LSH of word address */
	    x = adj_offsettable_operand (x, 1);
	}
	output_address (XEXP (x, 0));
    }
    else if (GET_CODE (x) == CONST_DOUBLE && GET_MODE (x) != DImode)
    {
	union { double d; int i[2]; } u;
	u.i[0] = CONST_DOUBLE_LOW (x);
	u.i[1] = CONST_DOUBLE_HIGH (x);
	fprintf (file, "#%.9#g", u.d);
    }
    else {
	if (code == 'L') {	/* LSH of word address */
	    x = gen_rtx (CONST_INT, VOIDmode, (INTVAL(x) & 0xff));
	}
	else if (code == 'M') {	/* MSH of word address */
	    x = gen_rtx (CONST_INT, VOIDmode, ((INTVAL(x) >> 8) & 0xff));
	}
	putc ('#', file);
	output_addr_const (file, x);
    }
}

/*****************************************************************************
**
** Print a memory operand whose address is X, on file FILE (based on 6809 port)
**
*****************************************************************************/
void
print_operand_address (file, addr)
FILE *file;
register rtx addr;
{
    extern void debug_rtx ();		/* DEBUG */
    register rtx base = 0;
    register rtx offset = 0;
    int regno;

    switch (GET_CODE (addr))
    {
    case REG:
	regno = REGNO (addr);
	if (regno != HARD_Y_REGNUM)
	{
	    fprintf (file, "0,X");
#if DEBUG_SWAP
	    fprintf (file, "\t; reg: replacing %s with X ;",
	    	reg_names[REGNO (addr)]);
#endif
	}
	else
	{
	    fprintf (file, "0,Y");
	}
	break;

    case PRE_DEC:
	regno = REGNO (XEXP (addr, 0));
	if (regno != HARD_SP_REGNUM)
	{
	    debug_rtx (addr);
	    abort();
	}
	fputs (((last_mem_size == 1) ? ",-" : ",--"), file);
	fprintf (file, "%s", reg_names[regno]);
	break;

    case POST_INC:
	regno = REGNO (XEXP (addr, 0));
	if (regno != HARD_SP_REGNUM)
	{
	    debug_rtx (addr);
	    abort();
	}
	fprintf (file, ",%s", reg_names[regno]);
	fputs (((last_mem_size == 1) ? "+" : "++"), file);
	break;

    case PLUS:
	base = XEXP (addr, 0);
	if (GET_CODE (base) == MEM)
	    base = XEXP (base, 0);
	offset = XEXP (addr, 1);
	if (GET_CODE (offset) == MEM)
	    offset = XEXP (offset, 0);

	if ((CONSTANT_ADDRESS_P (base)) && (CONSTANT_ADDRESS_P (offset)))
	{
	    output_addr_const (file, base);
	    fputs ("+", file);
	    output_addr_const (file, offset);
	}

	else if ((CONSTANT_ADDRESS_P (offset)) && (A_REG_P (base)))
	{
	    if ((GET_CODE (offset) == CONST_INT) && (INTVAL (offset) < 256))
	    {
		output_addr_const (file, offset);
		if (REGNO (base) != HARD_Y_REGNUM)
		{
		    fprintf (file, ",X");
#if DEBUG_SWAP
		    fprintf (file, "\t; base: replacing %s with X ;",
			    reg_names[REGNO (base)]);
#endif
		}
		else
		{
		    fprintf (file, ",Y");
		}
	    }
	    else
	    {
		fprintf (file, "0,X");
	    }
	}

	else {
	    debug_rtx (addr);
	    abort();
	}
	break;

    default:
	if (CONSTANT_ADDRESS_P(addr))
	{
	    output_addr_const (file, addr);
	}
	else
	{
	    debug_rtx (addr);		/* DEBUG */
	    abort();
	}
	break;
    }
}

/*****************************************************************************
**
** Emit the asm directives needed to output a ascii string
**
*****************************************************************************/
void
output_asm_ascii(file, str, size)
FILE		*file;
unsigned char	*str;
int		size;
{
    register int	i;
    register int	c;
    int			emit_fcc = 1;

    for (i = 0; i < size; i++) {
	c = str[i] & 0377;
	if (c >= ' ' && c < 0177 && c != '\\' && c != '"') {
	    if (emit_fcc) {
		emit_fcc = 0;
		fprintf (file, "\tFCC\t\"");
	    }
	    putc(c, file);
	}
	else {
	    if (!emit_fcc) {
		emit_fcc = 1;
		fprintf(file, "\"\n");
	    }
	    fprintf(file, "\tFCB\t$%X\t\n", c);
	}
    }
    if (!emit_fcc) {
	fprintf(file, "\"\n");
    }
}

/*****************************************************************************
**
** Perform index register fixups for psuedo ZX registers.
**
*****************************************************************************/
void
output_swap_regx (addr)
register rtx addr;
{
    register rtx base;
    register rtx offset;
    addr = XEXP (addr, 0);

    switch (GET_CODE(addr))
    {
    case PLUS:
	base = XEXP (addr, 0);
	if (GET_CODE (base) == MEM)
	    base = XEXP (base, 0);
	if (A_REG_P (base))
	{
#if DEBUG_SWAP
	    fprintf (asm_out_file, "; output_swap_regx (PLUS): found %s\n",
			reg_names[REGNO (base)]);
#endif
	    if (REGNO (base) != HARD_Y_REGNUM)
		fprintf(asm_out_file, "\tLDX\t%s\n", reg_names[REGNO (base)]);
	    offset = XEXP (addr, 1);
	    if (GET_CODE (offset) == MEM)
		offset = XEXP (offset, 0);

	    if (CONSTANT_ADDRESS_P (offset))
	    {
	    	if ((GET_CODE (offset) != CONST_INT) ||
		    (INTVAL (offset) > 255))
		{
		    if (REGNO (base) == HARD_Y_REGNUM)
		    {
			fprintf(asm_out_file, "\tPSHY\n");
			fprintf(asm_out_file, "\tPULX\n");
		    }
		    fprintf(asm_out_file, "\tXGDX\n");
		    fprintf(asm_out_file, "\tADDD\t");
		    putc ('#', asm_out_file);
		    output_addr_const (asm_out_file, offset);
		    fprintf(asm_out_file,
		    	"\n\tXGDX\t\t; (output_swap_regx: addr computed)\n");
		}
	    }
	}
	break;

    case REG:
	if (A_REG_P (addr))
	{
	    if (REGNO (addr) != HARD_Y_REGNUM)
		fprintf(asm_out_file, "\tLDX\t%s\n", reg_names[REGNO (addr)]);
#if DEBUG_SWAP
	    fprintf (asm_out_file, "; output_swap_regx (REG): found %s\n",
			reg_names[REGNO (addr)]);
#endif
	}
	break;

    default:
	break;
    }
}

/*-------------------------------------------------------------------
    Update the CC Status (based on 6809 port)
---------------------------------------------------------------------
   Set the cc_status for the results of an insn whose pattern is EXP.
   We assume that jumps don't affect the condition codes.
   All else, clobbers the condition codes, by assumption.

   We assume that ALL add, minus, etc. instructions effect the condition
   codes.
-------------------------------------------------------------------*/
notice_update_cc (exp, insn)
rtx exp;
rtx insn;
{
    /*** recognize SET insn's ***/
    if (GET_CODE (exp) == SET) {
	/* Jumps do not alter the cc's.  */
	if (SET_DEST (exp) == pc_rtx)
	    return;

	/* Moving one register into another register (tfr):
	Doesn't alter the cc's.  */
	if (REG_P (SET_DEST (exp)) && (REG_P (SET_SRC (exp)))) {
	    return;
	}

	/* Moving memory into a register (load): Sets cc's. */
	if (REG_P (SET_DEST (exp)) && GET_CODE (SET_SRC (exp)) == MEM) {
	    cc_status.value1 = SET_SRC (exp);
	    cc_status.value2 = SET_DEST (exp);
	    return;
	}

	/* Moving register into memory (store): Sets cc's. */
	if (GET_CODE (SET_DEST (exp)) == MEM && REG_P (SET_SRC (exp))) {
	    cc_status.value1 = SET_SRC (exp);
	    cc_status.value2 = SET_DEST (exp);
	    return;
	}

	/* Function calls clobber the cc's.  */
	else if (GET_CODE (SET_SRC (exp)) == CALL) {
	    CC_STATUS_INIT;
	    return;
	}

	/* Tests and compares set the cc's in predictable ways.  */
	else if (SET_DEST (exp) == cc0_rtx) {
	    cc_status.flags = 0;
	    cc_status.value1 = SET_SRC (exp);
	    cc_status.value2 = SET_DEST (exp);
	    return;
	}

	/* Certain instructions effect the condition codes. */
	else if (GET_MODE (SET_SRC (exp)) == SImode
	    || GET_MODE (SET_SRC (exp)) == HImode) {
		switch (GET_CODE (SET_SRC (exp))) {
		case PLUS: case MINUS: case NEG:
		case AND: case IOR: case XOR:
		if (A_REG_P (SET_DEST (exp))) {
		    CC_STATUS_INIT;
		}
		else {
		    cc_status.value1 = SET_SRC (exp);
		    cc_status.value2 = SET_DEST (exp);
		}
		    break;

		default:
		    CC_STATUS_INIT;
		}
	    return;
	}
    }
    else if (GET_CODE (exp) == PARALLEL
	&& GET_CODE (XVECEXP (exp, 0, 0)) == SET) {
	    if (SET_DEST (XVECEXP (exp, 0, 0)) == pc_rtx)
		return;
	if (SET_DEST (XVECEXP (exp, 0, 0)) == cc0_rtx) {
	    CC_STATUS_INIT;
	    cc_status.value1 = SET_SRC (XVECEXP (exp, 0, 0));
	    return;
	}
    }

    /*** default action if we haven't recognized something
    and returned earlier ***/
    CC_STATUS_INIT;
}

				/* See flags.h and toplev.c */
extern int optimize;
extern int flag_strength_reduce;
extern int flag_no_peephole;
extern int flag_inline_functions;
extern int flag_omit_frame_pointer;
extern char *main_input_filename;
extern char *asm_file_name;
				/* See c-tree.h  and c-decl.c */
extern int flag_signed_char;

#include <time.h>
#include <sys/types.h>
#include <sys/timeb.h>

void
print_options (out)
     FILE *out;
{
  char *a_time;
  long c_time;

  fprintf (out, ";;; OPTIONS:\t%s%s%s%s%s\n",
	   (TARGET_SHORT_INT ? " -mshort_int":" -mlong_int"),
	   (TARGET_SHORT_BRANCH ? " -mshort_branch":" -mlong_branch"),
	   (optimize ? " optimize" : ""),
	   (flag_strength_reduce ? "" : " !strength_reduce"),
	   (flag_inline_functions ?" inline-functions":""));
  fprintf (out, ";;; OPTIONS:\t%s%s%s\n",
	   (flag_no_peephole ? "" : " peephole"),
	   (flag_omit_frame_pointer ?"" :" !omit_frame_pointer"),
	   (flag_signed_char ? " signed-char" : " !signed-char"));
  fprintf (out, ";;; Source:\t\t%s\n", main_input_filename);
  fprintf (out, ";;; Destination:\t%s\n", asm_file_name);
  c_time = time (0);
  a_time = ctime (&c_time);
  fprintf (out, ";;; Compiled:\t%s", a_time);
#ifdef __GNUC__
#ifndef __VERSION__
#define __VERSION__ "[unknown]"
#endif
  fprintf (out, ";;; (META)compiled by GNU C version %s.\n", __VERSION__);
#else
  fprintf (out, ";;; (META)compiled by CC.\n");
#endif
}
