
/*****************************************************************************/
/* 				   exec.c				     */
/*===========================================================================*/
/* 									     */
/*	exec.c	is the execution unit.  It is responsible for		     */
/*	generating the scenes from the proc_t structures produced	     */
/*	by the parser.							     */
/*									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/*****************************************************************************/

#include <stdio.h>
#include <assert.h>
#include "runtime.h"
#include "symbol.h"
#include "inter.h"

extern char	*mach_names[] ;
extern int	mach_names_size ;
extern char	*raytrace ;
extern int	pause_after_full_load ;
extern short int	doframe[] ;			    /* def in main.c */

void	exec_unit(), gen_frame(), seq_frame() ;

void
  exec_unit ( sequent )
int	sequent ;
{
	int	pidx ;
	proc_t	*scenep ;
	char	**pname ;
	frm_t	frame ;
	var_t	*var ;
	int	framecount ;
	FILE	*raysrc, *shout ;
	void	(*generate)() ;

	for( pname=procorder, pidx=0 ; pidx<procnumber ; pidx++,pname++ ) {
	    scenep = proc_head ;
	    while( scenep!=0 && strcmp(scenep->procname,*pname)!=0 )
		scenep = scenep->next ;
	    if( scenep==0 ) {
		fprintf(stderr,"cannot find scene %s\n",*pname) ;
	    } else {
		unlink("finished.list") ;
		/*............... open rayshade source file .................*/
		raysrc = fopen(scenep->desc.source,"r") ;
		/*.................... init intervals .......................*/
		var = scenep->var_head ;
		while( var!=0 ) {
		    var->currint = var->intlist ;
		    var = var->next ;
		}
		/*.................. run through frames .....................*/
		if( sequent ) {
		    shout = fopen("a1.remote","w") ;
		    generate = seq_frame ;
		} else {
		    generate = gen_frame ;
		}
		scenep->last_frame = -1 ;	  /* there was no last frame */
		framecount = scenep->desc.runtime*scenep->desc.speed ;
		for( frame=0 ; frame<framecount ; frame++ )
		    if( doframe[frame] )
			(*generate)(frame,scenep,raysrc,shout) ;
		fclose(raysrc) ;
	    }
	}
}

/*---------------------------------------------------------------------------*/
/* 				  gen_frame				     */
/*---------------------------------------------------------------------------*/
void
  gen_frame ( frame , scene , raysrc , shout )
frm_t	frame ;
proc_t	*scene ;
FILE	*raysrc ;
FILE	*shout ;
{
	register var_t		*var ;
	register inter_t	*inter ;
	register double		cval ;
	static int	next = 0 ;
	static char	buffspace[1024] ;
	static char	basename[128] ;
	static char	cwd[512] = {0} ;
	FILE		*remote ;
	int		length ;
	int		unchanged ;				  /* boolean */

	/*........................ get local info ...........................*/
	assert(mach_names_size!=0) ;
	if( cwd[0]==0 )
	    assert(getwd(cwd)!=0) ;

	/*................. open stream to remote machine ...................*/
	sprintf(buffspace,"/usr/ucb/rsh %s /bin/sh",mach_names[next]) ;
	remote=popen(buffspace,"w") ;
	assert(remote!=0) ;

	/*.................. get basename for next step .....................*/
	strcpy(basename,scene->desc.source) ;
	length=strlen(basename) ;
	if( strcmp(&basename[length-4],".ray")==0 )
	    basename[length-4] = '\0' ;

	/*......... copy file to remote machine with added def's ............*/
	fprintf(remote,"(\n") ;
	fprintf(remote,"cd %s\n",cwd) ;

	/*.................. . . . debugging info . . . .....................*/
	unchanged = scene->last_frame!=-1 ;	   /* force first to be done */
	fprintf(remote,"cat <<AnUnLiKeLyWoRd >%s.%03d.log \n",
	  basename,frame) ;
	fprintf(remote,"# 1 \"%s\"\n",scene->desc.source) ;
	for( var=scene->var_head ; var!=0 ; var=var->next ) {
	    while( var->currint->next!=0 && frame>=var->currint->next->start )
		var->currint = var->currint->next ;
	    cval = var->currint->calc(frame-var->currint->start,
	      var->currint->u.params) ;
	    if( cval!=var->prev_value )
		unchanged = 0 ;			     /* at least one changed */
	    var->prev_value = cval ;
	    fprintf(remote,"#define %s %f\n",var->vname,cval) ;
	}
	if( unchanged ) {
	    fprintf(remote,"frame  %s.%03d.ras is the same as %s.%03d.ras\n",
	      basename,frame,basename,scene->last_frame) ;
	} else {
	    fprintf(remote," -- insert source here -- \n") ;
	    fprintf(remote," -- calculated on %s\n",mach_names[next]) ;
	}
	fprintf(remote,"AnUnLiKeLyWoRd\n") ;

	/*.................. . . . do real command . . . ....................*/
	if( unchanged ) {
	    fprintf(remote,"ln -s %s.%03d.ras %s.%03d.ras\n",
	      basename,scene->last_frame,basename,frame) ;
	} else {
	    scene->last_frame = frame ;
	    fprintf(remote,"nice /lib/cpp <<AnUnLiKeLyWoRd | ") ;
	    fprintf(remote,"%s 1> %s.%03d.rle 2>>%s.%03d.log \n",
	      raytrace,basename,frame,basename,frame) ;
	    for( var=scene->var_head ; var!=0 ; var=var->next ) {
		/*	This 'while' is useless as long as debugging info is in*/
		/*	place above.  (Because it has already advanced.)     */
		while( var->currint->next!=0 && frame>=var->currint->next->start )
		    var->currint = var->currint->next ;
		cval = var->currint->calc(frame-var->currint->start,
		  var->currint->u.params) ;
		fprintf(remote,"#define %s %f\n",var->vname,cval) ;
	    }

	    /*......... . . . copy source to remote machine . . . ...........*/
	    rewind(raysrc) ;
	    fprintf(remote,"# 1 \"%s\"\n",scene->desc.source) ;
	    while( !feof(raysrc) ) {
		fgets(buffspace,sizeof buffspace,raysrc) ;
		fputs(buffspace,remote) ;
	    }
	    fprintf(remote,"AnUnLiKeLyWoRd\n") ;
	    fprintf(remote,"/home/cae4/sass/bin/mkras <%s.%03d.rle >%s.%03d.ras\n",
	      basename,frame,basename,frame) ;
	    fprintf(remote,"rm %s.%03d.rle\n",basename,frame) ;
	}
	fprintf(remote,"echo frame %03d finished\n",frame) ;
	fprintf(remote,") 1>&- 2>&- 0<&- &\n") ;
	fprintf(remote,"exit\n") ;
	pclose(remote) ;

	printf("frame %d started on %s\n",frame,mach_names[next]) ;
	fflush(stdout) ;
	if( !unchanged )
	    next = (next + 1) % mach_names_size ;
}

/*---------------------------------------------------------------------------*/
/* 				  seq_frame				     */
/*---------------------------------------------------------------------------*/
void
  seq_frame ( frame , scene , raysrc , out )
frm_t	frame ;
proc_t	*scene ;
FILE	*raysrc, *out ;
{
	register var_t		*var ;
	register inter_t	*inter ;
	register double		cval ;
	static char	buffspace[1024] ;
	static char	basename[128] ;
	int		length ;

	/*.................. get basename for next step .....................*/
	strcpy(basename,scene->desc.source) ;
	length=strlen(basename) ;
	if( strcmp(&basename[length-4],".ray")==0 )
	    basename[length-4] = '\0' ;

	/*.................. . . . do real command . . . ....................*/
	scene->last_frame = frame ;
	fprintf(out,"/lib/cpp <<AnUnLiKeLyWoRd | ") ;
	fprintf(out,"%s -O %s.%03d.rle -V %s.%03d.log \n",
	  raytrace,basename,frame,basename,frame) ;
	for( var=scene->var_head ; var!=0 ; var=var->next ) {
	    while( var->currint->next!=0 && frame>=var->currint->next->start )
		var->currint = var->currint->next ;
	    cval = var->currint->calc(frame-var->currint->start,
	      var->currint->u.params) ;
	    var->prev_value = cval ;
	    fprintf(out,"#define %s %f\n",var->vname,cval) ;
	}

	/*........... . . . copy source to remote machine . . . .............*/
	rewind(raysrc) ;
	fprintf(out,"# 1 \"%s\"\n",scene->desc.source) ;
	while( !feof(raysrc) ) {
	    fgets(buffspace,sizeof buffspace,raysrc) ;
	    fputs(buffspace,out) ;
	}
	fprintf(out,"AnUnLiKeLyWoRd\n") ;
	fprintf(out,"echo frame %03d finished\n",frame) ;

	printf("frame %d stored in a1.remote\n",frame) ;
	fflush(stdout) ;
}
