/*======================================================================
                    X F O R M . C 
                    doc: Fri Sep  6 13:49:26 1991
                    dlm: Thu Nov  7 12:43:45 1991
                    (c) 1991 A.M.J. Thurnherr
                    uE-Info: 35 27 FALSE 0 0 72 2 2 ofnI
======================================================================*/

#include	<math.h>
#include	"types.h"
#include	"utilities.h"

Mat persp,lat;		/* Transformation Matrices */
Pnt frust[2][4];	/* Frustrum */
int xSize,ySize;	/* ScreenSize */

void setScreen(x,y)	/* set screensize */
int x,y;
{
	xSize = x; ySize = y;
}

void xForm(p,p_)	/* xForm a point */
Pnt p,p_;
{
	Pnt tmp;

	vecMat2vec(p,persp,tmp);	/* Perspective */
	vecMat2vec(tmp,lat,p_);		/* LookAt */
}

void perspective(fov,aspect,near,far)
int fov; Fp aspect,near,far;
{
	Fp tFov2 = tan((Fp)fov*PI/3600.0),
	   nMf   = near - far;
	
	persp[0][0] = aspect*tFov2;
	zero3(persp[0],1,2,3);
	persp[1][1] = tFov2;
	zero3(persp[1],0,2,3);
	persp[2][3] = -1.0;
	zero3(persp[2],0,1,2);
	persp[3][2] = nMf/(2.0*near*far);
	persp[3][3] = (sqr(near)-sqr(far))/(2.0*near*far*nMf);
	zero2(persp[3],0,1);
}
	
void lookat(eyex,eyey,eyez,px,py,pz,twist)
Fp eyex,eyey,eyez,px,py,pz; int twist;
{
	Fp PhiDen,sinPhi,cosPhi,phiDen,sinphi,cosphi,sinTwi,cosTwi;
	Mat tmp1,tmp2;

	PhiDen = sqrt(sqr(px-eyex)+sqr(pz-eyez));
	if (PhiDen == 0.0) {		/* Dirty SGI trick */
		sinPhi = 0.0;
		cosPhi = 1.0;
	} else {
		sinPhi = (px-eyex)/PhiDen;
		cosPhi = (eyez-pz)/PhiDen;
		if ((sinPhi > 1.0) || (cosPhi > 1.0)) {
			sinPhi = 0.0;
			cosPhi = 1.0;
		}
	}

	phiDen = sqrt(sqr(px-eyex)+sqr(py-eyey)+sqr(pz-eyez));
	sinphi = (eyey-py)/phiDen;
	cosphi = PhiDen/phiDen;
	sinTwi = sin(twist/10.0);
	cosTwi = cos(twist/10.0);

	lat[0][0] = cosTwi;		/* RotZ(twist) */
	lat[0][1] = -sinTwi;
	zero2(lat[0],2,3);
	lat[1][0] = sinTwi;
	lat[1][1] = cosTwi;
	zero2(lat[1],2,3);
	lat[2][2] = 1.0;
	zero3(lat[2],0,1,3);
	lat[3][3] = 1.0;
	zero3(lat[3],0,1,2);

	tmp1[0][0] = 1.0;		/* RotX(-phi) */
	zero3(tmp1[0],1,2,3);
	tmp1[1][1] = cosphi;
	tmp1[1][2] = sinphi;
	zero2(tmp1[1],0,3);
	tmp1[2][1] = -sinphi;
	tmp1[2][2] = cosphi;
	zero2(tmp1[2],0,3);
	tmp1[3][3] = 1.0;
	zero3(tmp1[3],0,1,2);

	matMat2mat(lat,tmp1,tmp2);	/* PreMult */

	lat[0][0] = cosPhi;		/* RotY(-Phi) */
	lat[0][2] = -sinPhi;
	zero2(lat[0],1,3);
	lat[1][1] = 1.0;
	zero3(lat[1],0,2,3);
	lat[2][0] = sinPhi;
	lat[2][2] = cosPhi;
	zero2(lat[2],1,3);
	lat[3][3] = 1.0;
	zero3(lat[3],0,1,2);

	matMat2mat(tmp2,lat,tmp1);	/* PreMult */

	tmp2[0][0] = 1.0;		/* Trans(eyex,eyey,eyez) */
	tmp2[0][3] = eyex;
	zero2(tmp2[0],1,2);
	tmp2[1][1] = 1.0;
	tmp2[1][3] = eyey;
	zero2(tmp2[1],0,2);
	tmp2[2][2] = 1.0;
	tmp2[2][3] = eyez;
	zero2(tmp2[2],0,1);
	tmp2[3][3] = 1.0;
	zero3(tmp2[3],0,1,2);

	matMat2mat(tmp1,tmp2,lat);	/* Final Matrix */
}

	
void makeFrust()			/* xForm the SGI "UnitCube" */
{
	Pnt	tmp;

	setPnt(tmp,-1,-1,-1);
	xForm(tmp,frust[NEAR][PA]);
	make3D(frust[NEAR][PA]);
	setPnt(tmp,1,-1,-1);
	xForm(tmp,frust[NEAR][PB]);
	make3D(frust[NEAR][PB]);
	setPnt(tmp,1,1,-1);
	xForm(tmp,frust[NEAR][PC]);
	make3D(frust[NEAR][PC]);
	setPnt(tmp,-1,1,-1);
	xForm(tmp,frust[NEAR][PD]);
	make3D(frust[NEAR][PD]);

	setPnt(tmp,-1,-1,1);
	xForm(tmp,frust[FAR][PA]);
	make3D(frust[FAR][PA]);
	setPnt(tmp,1,-1,1);
	xForm(tmp,frust[FAR][PB]);
	make3D(frust[FAR][PB]);
	setPnt(tmp,1,1,1);
	xForm(tmp,frust[FAR][PC]);
	make3D(frust[FAR][PC]);
	setPnt(tmp,-1,1,1);
	xForm(tmp,frust[FAR][PD]);
	make3D(frust[FAR][PD]);
}


