#
# Makefile for the POLY3D-H hidden line remover.
#

include ../makeflag.sas

OBJS	= out-edge.o poly3d-h.o prepdata.o

all:	poly3d-h

poly3d-h:	$(OBJS)
	slink from lib:c.o $(OBJS) to poly3d-h sc $(SYMS) lib $(LIBS)\
$(MORELIBS) $(MATHLIB) lib:scnb.lib

install: poly3d-h
	mv -f poly3d-h $(BIN_DIR)
	cp poly3d-h.cfg $(BIN_DIR)


# DO NOT DELETE THIS LINE -- make depend depends on it.

out-edge.o: program.h ../include/irit_sm.h ../include/genmat.h
out-edge.o: ../include/iritprsr.h ../include/cagd_lib.h ../include/imalloc.h
out-edge.o: ../include/miscattr.h ../include/symb_lib.h ../include/trim_lib.h
out-edge.o: ../include/triv_lib.h ../include/iritgrap.h ../include/attribut.h
out-edge.o: ../include/allocate.h
poly3d-h.o: program.h ../include/irit_sm.h ../include/genmat.h
poly3d-h.o: ../include/iritprsr.h ../include/cagd_lib.h ../include/imalloc.h
poly3d-h.o: ../include/miscattr.h ../include/symb_lib.h ../include/trim_lib.h
poly3d-h.o: ../include/triv_lib.h ../include/iritgrap.h ../include/attribut.h
poly3d-h.o: ../include/allocate.h ../include/getarg.h ../include/config.h
poly3d-h.o: ../include/ip_cnvrt.h
prepdata.o: program.h ../include/irit_sm.h ../include/genmat.h
prepdata.o: ../include/iritprsr.h ../include/cagd_lib.h ../include/imalloc.h
prepdata.o: ../include/miscattr.h ../include/symb_lib.h ../include/trim_lib.h
prepdata.o: ../include/triv_lib.h ../include/iritgrap.h ../include/attribut.h
prepdata.o: ../include/allocate.h
