#
# Makefile for the IRIT solid modeler documentation (unix).
#

include ../makeflag.sas

all:	irit.tex irit.doc irit.hlp

HELP_OBJS = irithlp.o
PRGM_OBJS = progman.o

#LIBS = -lmisc -lxtra -lamg $(MORELIBS)

PROG_LIBS = prog_man/bool_lib.tex prog_man/cagd_lib.tex \
	prog_man/geom_lib.tex prog_man/misc_lib.tex \
	prog_man/prsr_lib.tex prog_man/symb_lib.tex \
	prog_man/triv_lib.tex prog_man/trim_lib.tex \
	prog_man/xtra_lib.tex

irithlp: $(HELP_OBJS)
	slink from lib:c.o $(HELP_OBJS) to irithlp sc $(SYMS) lib $(LIBS)\
$(MORELIBS) $(MATHLIB) lib:scnb.lib

install: irit.hlp
	mv irit.hlp $(BIN_DIR)

irit.tex: irithlp irit.src user_man
	./irithlp -l -o irit.tex irit.src

irit.hlp: irithlp irit.src
	./irithlp -h -o irit.hlp irit.src

irit.doc: irithlp irit.src
	./irithlp -t -o irit.doc irit.src


user_man.ps: irit.tex user_man/doc_figs.irt
	-(cd user_man && make -f makefile.unx)
	latex irit.tex
	latex irit.tex
	dvips -f irit.dvi > user_man.ps

progman: $(PRGM_OBJS)
	slink from lib:c.o $(PRGM_OBJS) to progman sc $(SYMS) lib $(LIBS)\
$(MORELIBS) $(MATHLIB) lib:scnb.lib

prog_man.ps:	$(PROG_LIBS)
	-(cd cexample && conv_c_to_tex)
	latex prog_man.tex
	makeindex prog_man.idx
	latex prog_man.tex
	dvips -f prog_man.dvi > prog_man.ps

prog_man/bool_lib.tex:	progman
	progman -l -o prog_man/bool_lib.tex ../bool_lib/*.c

prog_man/cagd_lib.tex:	progman
	progman -l -o prog_man/cagd_lib.tex ../cagd_lib/*.c

prog_man/geom_lib.tex:	progman
	progman -l -o prog_man/geom_lib.tex ../geom_lib/*.c

prog_man/misc_lib.tex:	progman
	progman -l -o prog_man/misc_lib.tex ../misc_lib/*.c

prog_man/prsr_lib.tex:	progman
	progman -l -o prog_man/prsr_lib.tex ../prsr_lib/*.c

prog_man/symb_lib.tex:	progman
	progman -l -o prog_man/symb_lib.tex ../symb_lib/*.c

prog_man/triv_lib.tex:	progman
	progman -l -o prog_man/triv_lib.tex ../triv_lib/*.c

prog_man/trim_lib.tex:	progman
	progman -l -o prog_man/trim_lib.tex ../trim_lib/*.c

prog_man/xtra_lib.tex:	progman
	progman -l -o prog_man/xtra_lib.tex ../xtra_lib/*.c


# DO NOT DELETE THIS LINE -- make depend depends on it.

irithlp.o: ../include/irit_sm.h
progman.o: ../include/irit_sm.h ../include/imalloc.h
