'\"et
.if t .TH IMXWD 3IM "October 1, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMXWD 3IM "October 1, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imxwd \- SDSC X11 XWD file translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "xwd", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "xwd", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "xwd", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "xwd", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBxwd\fR window dump image files are used by the \fBxwd\fR(1) and \fBxwud\fR(1)
tools of MIT's X Window System,
version 11 (hereafter referred to as X11).
See the X11 documentation set for details on how to use these tools.
.SH "FILE RECOGNITION"
X11 \fBxwd\fR files are recognized by the following filename
suffixes:  .xwd and .x11.
.SH NOTES
SDSC image library support of the X11 \fBxwd\fR format does not require
use of any X11 libraries and contains no proprietary code.  X11 \fBxwd\fR
format handling 
is available on any machine for which the SDSC image library is available.
.SS "Reading X11 XWD files"
The SDSC image library supports reading of \fBxwd\fR files that 
have the following file format features:
.LP
.RS 0.5i
Version 7 format (X Window system, version 11).
.LP
Z-format pixmaps only.
.LP
8-bit color index images with or without color maps and
24-bit RGB images with or without color maps.
.LP
Pixel values stored in 8-bit, 16-bit, or 32-bit bitmap units in 
MBF (most-significant byte first) or LBF (least-significant byte first)
byte order.
.RE
.LP
The SDSC image library does not support reading of \fBxwd\fR files that have
the following file format features:
.LP
.RS 0.5i
Version 6 format or older (obsolete X Window System, version 10).
.LP
XY bitmaps or XY pixmaps.  Primarily used for monochrome images.
.RE
.LP
\fBxwd\fR fields meant for use to display the image on an X display
are ignored.  These fields include the window width,
height, and (x,y) location; and border width.
.LP
Incoming 8-bit \fBxwd\fR images are mapped to image library
\fBIMVFBINDEX8\fR VFBs.  If the \fBxwd\fR file includes a color map,
the VFB contains a color lookup table (CLT).
.LP
Incomming 24-bit \fBxwd\fR images are mapped to image library
\fBIMVFBRGB\fR VFBs.  If the \fBxwd\fR file includes a color map (DirectColor
visual class), the color map is automatically applied to incoming RGB
data as pixels are stored into the VFB.  The returned VFB will not contain
the \fBxwd\fR file's color map.
.SS "Writing X11 XWD files"
The SDSC image library writes \fBIMVFBINDEX8\fR and \fBIMVFBRGB\fR
VFBs as X11 \fBxwd\fR image files.
\fBIMVFBINDEX8\fR VFBs with a CLT are written including a color map.
.LP
Other image library VFB types are converted to \fBIMVFBINDEX8\fR or
\fBIMVFBRGB\fR VFBs prior
to being written out.  See the \fBImFileWrite\fR(3IM) \fBman\fP page for
further details.
.LP
\fBxwd\fR files written by the SDSC image library are always version 7 (X11),
Z-format pixmaps.  8-bit images are written with 8-bits per pixel and an
8-bit bitmap unit.  24-bit images are written with 32-bits per pixel and
a 32-bit bitmap unit.  Byte and
bit order are always MBF (most-significant byte first).
.LP
Window display
attributes are set to use a pseudo-color (8-bit) or true-color (24-bit)
visual class, a window height and
width the same as the image height and width, a window (x,y) location of (0,0)
and a 0 border width.
The window name is set to \fBxwdump\fR if no "image name" tag is found in
the \fBdataTable\fR.
.SH ERRORS
In addition to those listed for \fBImFileWrite\fR(3IM),
X11 \fBxwd\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Syntax error in parsing \fBxwd\fR file
IMESYS	System call error in read operation
IMEUNSUPPORTED	Unsupported feature of \fBxwd\fR file format
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
X11 \fBxwd\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
\fBxwd\fP(1) and \fBxwud\fP(1) from the X11 \fBman\fP page set.
.sp
\fIXlib - C Language X Interface\fR, MIT X Window System, Version 11.
.SH SEE ALSO
\fBimconv\fR(1IM), \fBimfile\fR(1IM), \fBimformats\fR(1IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
