'\"et
.if t .TH IMRAS 3IM "September 24, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMRAS 3IM "September 24, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
imras \- SDSC Sun Rasterfile translation
.SH SYNOPSIS
.nf
\fB
#include <stdio.h>
#include "sdsc.h"
#include "im.h"
.sp 1
int ImFileRead( fd, "ras", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFRead( fp, "ras", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileWrite( fd, "ras", flagsTable, dataTable )
	int         fd;
	TagTable   *flagsTable;
	TagTable   *dataTable;
.sp 1
int ImFileFWrite( fp, "ras", flagsTable, dataTable )
	FILE         *fp;
	TagTable   *flagsTable;
	TagTable   *dataTable;
\fR
.fi
.SH DESCRIPTION
\fBras\fR image files are used by various Sun Microsystems Inc. tools,
such as \fBscreendump\fR(1) and \fBscreenload\fR(1).
See the Sun documentation set for details on how to use these tools.
.SH "FILE RECOGNITION"
Sun \fBras\fR files are recognized by any of the following filename 
suffixes: .ras, .scr, .sr, and .sun.
.SH NOTES
SDSC image library support of the Sun \fBras\fR format does not require
use of Sun's pixrect library or hardware,
and contains no proprietary code.  Sun \fBras\fR
format handling
is available on any machine for which the SDSC image library is available.
.SS "Reading Sun Rasterfiles"
The SDSC image library can read Sun \fBras\fR files 
and map them to VFBs as follows:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
\fBDepth/color	Type of compression	Mapped to VFB\fR		
1-bit monochrome	RT_OLD, RT_STANDARD, 	IMVFBMONO
	or RT_BYTE_ENCODED

8-bit color index	RT_OLD, RT_STANDARD, 	IMVFBINDEX8
	or RT_BYTE_ENCODED

24-bit RGB	RT_OLD, RT_STANDARD, 	IMVFBRGB
	or RT_BYTE_ENCODED

32-bit RGB-Alpha	RT_OLD, RT_STANDARD, 	(IMVFBRGB | IMVFBALPHA)
	or RT_BYTE_ENCODED
.TE
.if t .in -0.5i
.if n .in -5
.LP
All depths may or may not contain a color map (color lookup table, or CLT),
though, normally, only 8-bit images include one.
.LP
In SDSC image library terminology, \fBRT_STANDARD\fR and \fBRT_OLD\fR
files are uncompressed;
\fBRT_BYTE_ENCODED\fR files use runlength-encoded RLE compression.
.LP
If the file's image has a color map, the image library VFB includes
a CLT.
.SS "Writing Sun Rasterfiles"
Images to be written out are mapped from image library VFBs as follows:
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l l.
\fBMapped from VFB	Depth/color	Types of compression\fR
IMVFBMONO	1-bit monochrome	RT_STANDARD, RT_BYTE_ENCODED
IMVFBINDEX8	8-bit color index	RT_STANDARD, RT_BYTE_ENCODED
IMVFBRGB	24-bit RGB	RT_STANDARD, RT_BYTE_ENCODED
(IMVFBRGB | IMVFBALPHA)	32-bit RGB-Alpha	RT_STANDARD, RT_BYTE_ENCODED
.TE
.if t .in -0.5i
.if n .in -5
.LP
If the incoming VFB has a CLT, the image written to the raster file 
contains a color map.
.LP
In SDSC image library terminology, \fBRT_STANDARD\fR and \fBRT_OLD\fR
files are uncompressed;
\fBRT_BYTE_ENCODED\fR files use runlength-encoded RLE compression.
\fBRT_OLD\fR raster files cannot be generated.
.LP
RGB and RGB-Alpha images are always stored noninterlaced
(i.e., RGBRGBRGB...).  Scanline- and plane-interlaced modes are not
available in the \fBras\fR format.
.LP 
Other image library VFB types are converted to one of the above
types prior to being written out.   See the \fBImFileWrite\fR(3IM)
\fBman\fP page for details.
.SH ERRORS
In addition to those listed for \fBImFileRead\fR(3IM),
Sun \fBras\fR file reading returns the following error codes: 
.ne 4
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMECLTLENGTH	CLT length in file header is strange
IMEDEPTH	Unknown image depth in file header
IMEIMAGETYPE	Unknown image type in file header
IMEMAGIC	Bad magic number in image file
IMEMALLOC	Cannot allocate enough memory
IMESYNTAX	Unknown CLT type in file header
IMESYS	System call error in read operation
.TE
.if t .in -0.5i
.if n .in -5
.LP
In addition to those listed for \fBImFileWrite\fR(3IM),
Sun \fBras\fR file writing returns the following error codes: 
.ne 2
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory
IMESYS	System call error in write operation
.TE
.if t .in -0.5i
.if n .in -5
.SH DOCUMENTATION
See the comments in \fB/usr/include/rasterfile.h\fR on Sun systems.
.LP
\fIPixrect Reference Manual\fR, Sun Microsystems.
.SH SEE ALSO
\fBimconv\fR(1IM), \fBimfile\fR(1IM), \fBimformats\fR(1IM)
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
