'\"et
.if t .TH IMSCALE 1IM "September 25, 1991" "San Diego Supercomputer Center" "IMAGE TOOLS" 
.if n .TH IMSCALE 1IM "September 25, 1991" "SDSC" "IMAGE TOOLS"
.SH NAME
imscale  -  Scale an image up or down and save it in a new file
.SH SYNOPSIS
\fBimscale\fR [\fIoptions\fR] \fIinfilename\fR \fIoutfilename\fR
.SH DESCRIPTION
\fBimscale\fR scales an input image up or down to a new size and saves
the result in a new file.  If the input file contains multiple images,
each input image is scaled in the same way and written to the output file.
The input and output image file formats may be different.
.SH OPTIONS
\fBimscale\fR has a variety of options in the following five categories:
.LP
.RS +0.5i
.TS
l l.
File Selection	What input and output files to use
Format Selection	What image file format to use
Format Control	What variant of a file format to generate
Standard	Standard generic options on all SDSC tools
Manipulation	How the image can be manipulated
.TE
.RE
.LP
\fIFile Selection\fR, \fIFormat Selection\fR, \fIFormat Control\fR, and
\fIStandard\fR options are common to all SDSC image tools and are
discussed in depth in the \fBman\fP page for \fBimconv\fR(1IM).
.LP
All options can be abbreviated to the first few unique characters.
.SS "Manipulation Options"
Images may be scaled in the X (horizontal) and Y (vertical) directions
by specifying a scale factor or the new image size:
.LP
.RS +0.5i
.TS
l l.
\fB-xscale\fI xf\fR	Scale horizontally by factor
\fB-yscale\fI yf\fR	Scale vertically by factor
\fB-xsize\fI w\fR	Scale the image to a new size horizontally
\fB-ysize\fI h\fR	Scale the image to a new size vertically
.TE
.RE
.LP
\fB-xscale\fR and \fB-yscale\fR each take a floating-point scale factor.
To increase the size of an image, use a scale factor greater than 1.0.
To decrease an image's size, use a scale factor less than 1.0.  The default
scale factor is 1.0 (no change).
.LP
\fB-xsize\fR and \fB-ysize\fR each take an integer image width or height
in pixels, respectively.  The incoming image is scaled up or down,
as necessary, to make it the desired size.  The default is to
leave the image size unchanged.
.LPhe
These four arguments may be given alone, or in combination with the
others as long as \fB-xscale\fR is not given with \fB-xsize\fR,
and \fB-yscale\fR is not given with \fB-ysize\fR.
.SH NOTES
Image scaling uses bi-linear interpolation.
.LP
Image scaling can take awhile, depending upon the size of the input image
and the size of the output image.
.LP
For notes regarding file format conversion and standard image tool
options, see the \fBman\fP page on \fBimconv\fR(1IM).
.LP
Error messages are reported to \fBstderr\fR.
.SH EXAMPLES
To scale a 640x480 image up to 1280x1024 (non-uniform scaling), use any of the
following:
.RS 0.5i
.LP
.nf
\fBimscale small.pix -xscale 2.0 -yscale 2.133 large.pix\fR
    or
\fBimscale small.pix -xsize 1280 -ysize 1024 large.pix\fR
.fi
.RE
.LP
To reduce an image to 1/3 its original size in X, and scale it up or down
to 500 pixels high in Y, use the following:
.RS 0.5i
.LP
\fBimscale original.rla -xscale 0.333 -ysize 500 sized.tiff\fR
.RE
.LP
To copy an entire input GIF image to a PCX file, without scaling,
use the following:
.RS 0.5i
.LP
\fBimscale incoming.gif outgoing.pcx\fR
.RE
.LP
With no scaling arguments, the actions of \fBimscale\fR default to the
same as the SDSC image format conversion tool \fBimconv\fR(1IM), but they
take a little longer.
.SH "SEE ALSO"
\fBimconv\fR(1IM), \fBimcopy\fR(1IM), \fBimfile\fR(1IM), \fBimflip\fR(1IM),
\fBimformats\fR(1IM), \fBimgray\fR(1IM),
\fBimmono\fR(1IM), \fBimpaste\fR(1IM)
.sp 1
For information on SDSC's image library, see \fBimintro\fR(3IM). 
.sp 1
For information on the individual image file formats, see
their respective \fBman\fR pages:
\fBimeps\fR(3IM),
\fBimgif\fR(3IM),
\fBimhdf\fR(3IM),
\fBimicon\fR(3IM),
\fBimiff\fR(3IM),
\fBimmpnt\fR(3IM),
\fBimpbm\fR(3IM),
\fBimpcx\fR(3IM),
\fBimpgm\fR(3IM),
\fBimpic\fR(3IM),
\fBimpict\fR(3IM),
\fBimpix\fR(3IM),
\fBimpnm\fR(3IM),
\fBimppm\fR(3IM),
\fBimps\fR(3IM),
\fBimras\fR(3IM),
\fBimrgb\fR(3IM),
\fBimrla\fR(3IM),
\fBimrle\fR(3IM),
\fBimrpbm\fR(3IM),
\fBimrpgm\fR(3IM),
\fBimrpnm\fR(3IM),
\fBimrppm\fR(3IM),
\fBimsynu\fR(3IM),
\fBimtiff\fR(3IM),
\fBimx\fR(3IM),
\fBimxbm\fR(3IM),
\fBimxwd\fR(3IM).
.SH "KNOWN PROBLEMS"
Other interpolation schemes should be supported, such as
pixel replication for fast power-of-two scaling (if you like jaggies).
.SH AUTHOR
Dave Nadeau
.br
San Diego Supercomputer Center
.LP
See the individual file format \fBman\fR pages for the authors of the underlying
format read and write code.  The names of these \fBman\fR pages begin
with the letters "im" followed by the format name.
For example, the name of the TIFF \fBman\fR page is \fBimtiff\fR.
To display it, enter \fBman imtiff\fR.
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br
