'\"et
.if t .TH IMVFBTOINDEX8 3IM "September 24, 1991" "San Diego Supercomputer Center" "SDSC IMAGE LIBRARY"
.if n .TH IMVFBTOINDEX8 3IM "September 24, 1991" "SDSC" "SDSC IMAGE LIBRARY"
.SH NAME
ImVfbToIndex8 - Convert a virtual frame buffer to an 8-bit index image
.br
ImVfbToIndex16 - Convert a virtual frame buffer to a 16-bit index image
.br
ImVfbToRgb - Convert a virtual frame buffer to an RGB image
.br
ImVfbToGray - Convert a virtual frame buffer to a grayscale image
.br
ImVfbToGrey - Convert a virtual frame buffer to a grayscale image
.br
ImVfbToMono - Convert a virtual frame buffer to a monochrome image
.SH SYNOPSIS
\fB
.nf
#include "im.h"

ImVfb *ImVfbToIndex8( srcVfb, dstVfb )
	ImVfb *srcVfb ;
	ImVfb *dstVfb ;

ImVfb *ImVfbToIndex16( srcVfb, dstVfb )
	ImVfb *srcVfb ;
	ImVfb *dstVfb ;

ImVfb *ImVfbToRgb( srcVfb, dstVfb )
	ImVfb *srcVfb ;
	ImVfb *dstVfb ;

ImVfb *ImVfbToGray( srcVfb, dstVfb )
	ImVfb *srcVfb ;
	ImVfb *dstVfb ;

ImVfb *ImVfbToGrey( srcVfb, dstVfb )
	ImVfb *srcVfb ;
	ImVfb *dstVfb ;

ImVfb *ImVfbToMono( srcVfb, threshold, dstVfb )
	ImVfb *srcVfb ;
	int threshold ;
	ImVfb *dstVfb ;
.fi
\fR
.SH DESCRIPTION
Each of these routines convert an image stored in \fIsrcVfb\fR into an
image of a different type and store it in \fIdstVfb\fR.
A pointer to the converted destination Vfb is returned.
.LP
\fBImVfbToIndex8\fR converts a virtual frame buffer to
an 8-bit image.
.LP
\fBImVfbToIndex16\fR converts a virtual frame buffer to a
16-bit image.
.LP
\fBImVfbToRgb\fR converts a virtual frame buffer to an RGB image.
.LP
\fBImVfbToGray\fR and \fBImVfbToGrey\fR convert a virtual frame buffer
to an 8-bit gray scale image.
.LP
\fBImVfbToMono\fR converts a virtual frame buffer to a monochrome image.
Each monochromatic pixel value, queried by \fBImVfbQMono\fR (3IM),
is 0 (white) or 1 (black).
.SH NOTES
The \fIsrcVfb\fR and \fIdstVfb\fR may be the same Vfb without unpleasant
side effects.
.LP
When \fBImVfbToGray\fR is called,
the resulting gray scale values are placed in the \fBIMVFBINDEX8\fR field
of the destination virtual frame buffer.
.LP
Conversion from grayscale to monochrome uses the \fIthreshold\fR value
as the breakpoint between white and black values.  Grayscale pixels with
values less than the threshold are converted to white; those equal
to or greater than the threshold are converted to black.
.LP
Conversion from color to grayscale computes the gray value for each pixel
using the NTSC Y equation:
.sp 1
.ce
.EQ
Gray ~~=~~ 0.30*R ~+~ 0.59*G ~+~ 0.11*B
.EN
.LP
Conversion from a color index image to an RGB image uses the \fIsrcVfb\fR's
color lookup table to look up each pixel value to obtain its RGB
color.  If the \fIsrcVfb\fR has no color lookup table, a grayscale
ramp is used. 
.LP
Conversion from an RGB image to a color index image scans the RGB image to
build a color lookup table.  \fBImVfbToIndex8\fR builds a new
256-entry (or fewer) color lookup table, while \fBImVfbToIndex16\fR
builds a 65536-entry (or fewer) color lookup table.  If the RGB image
uses more colors than may be stored in such color tables, then color
approximations are made to minimize color oddities.
.SH RETURNS
Upon success, all functions return a pointer to the converted destination Vfb.
An error causes \fBIMVFBNULL\fR to be returned and the value of \fBImErrNo\fR
to be set to one of the following:
.LP
.if t .in +0.5i
.if n .in +5
.TS
l l.
IMEMALLOC	Cannot allocate enough memory for the new Vfb
IMENOTINFO	There is not enough information in \fIsrcVfb\fR
	for the operation 
.TE
.if t .in -0.5i
.if n .in -5
.SH SEE ALSO
\fBImVfbAlloc\fR (3IM)
.SH AUTHORS
Mike Bailey, Dave Nadeau
.br
San Diego Supercomputer Center
.SH CONTACT
SDSC consultants, (619)534-5100, \fBconsult@y1.sdsc.edu\fR
.br

