#include <stdio.h>
#ifdef VMS
#include <string.h>
#include <decw$include/Intrinsic.h>
#include <decw$include/Xutil.h>
#else /* UNIX */
#include <strings.h>
#include <X11/Intrinsic.h>
#include <X11/Xutil.h>
#endif
#include "defs.h"
#include "xws_defs.h"

/*	CGM Delimiter Elements processing routines		 */

extern void	exit();

static short	Compositing = -1;	/* merge frames semaphore */
static char	*Win_name=NULL;		/* window name for window title bar */


xws_begin(title, file, client)
char	*title;		/* title internal to the metafile */ 
char	*file;		/* name of the metafile */
char	*client;	/* name of the client from the command line */
{


	/* Bug: gplot is giving me a null file name. */

	/* Build the constant part of window name, to be set in xws_bpage() */
	if (Win_name == NULL)
		Win_name = (char *) malloc((unsigned) (strlen(client) + strlen(file) +
		    strlen(title) + 3));

	(void) strcpy(Win_name, client);
	if (strlen(file))
	{
		(void) strcat(Win_name, " ");
		(void) strcat(Win_name, file);
	}
	if (strlen(title))
	{
		(void) strcat(Win_name, " ");
		(void) strcat(Win_name, title);
	}

	Compositing++;
	return(GPLOT_SUCCESS);
}
/* called each time a Begin Picture CGM delimiter element is encountered */
/*ARGSUSED*/
xws_bpic(pic_name)
char *pic_name;
{
        /* Reset gplot's idea of the window size, in case the window has been
         * resized or this is the first frame.
         */
        if (XGetWindowAttributes(Dpy, Win, &window_attributes)){
              /* fill out the device info structure */
	      pDev_xws->x_size = window_attributes.width / pDev_xws->pxl_in;
              pDev_xws->y_size = window_attributes.height / pDev_xws->ypxl_in;
	      MaxX = window_attributes.width - 1;
	      MaxY = window_attributes.height - 1;
              }

	return(GPLOT_SUCCESS);
}

/* called each time a Begin Picture Body CGM delimiter element is encountered */

/*ARGSUSED*/
xws_bpage(frame_title, x_offset, y_offset, rotation, r, g, b, frame_number,
    xsize, ysize)
char	*frame_title;		/* metacode frame title - rarely set */
float	rotation;		/* not used - gplot will do rotation for me */
float	r, g, b;		/* for setting background pixel */
int	x_offset, y_offset;	/* not used - gplot will do offsets for me */
int	frame_number;		/* metafile frame counter */
int xsize, ysize;
{
Pixeltype		background_pixel;
char			*new_window_name=NULL;
char			number[8];

	/* Put the frame title and number in the window name */

	(void) sprintf(number, " #%d", frame_number);
	new_window_name = (char *) malloc((unsigned) ((strlen(Win_name) +
	    strlen(frame_title) +  strlen(number) + 2)));
	(void) strcpy(new_window_name, Win_name);
	if (strlen(frame_title))
	{	
		(void) strcat(new_window_name, " ");
		(void) strcat(new_window_name, frame_title);
	}
	(void) strcat(new_window_name, number);
	XStoreName(Dpy, Win, new_window_name);

	/* Reset all attributes at the beginning of every frame or page */

		/* line attributes: type and width */
	xws_l_type(CGMClass5->line_type);
	xws_l_width(CGMClass5->line_width.i, CGMClass5->line_width.r);

		/* marker attributes: type and size */
	xws_mk_type(CGMClass5->mk_type);
	xws_mk_size(CGMClass5->mk_size.i, CGMClass5->mk_size.r);

		/* text attributes: alignment */
	xws_t_align(CGMClass5->text_align.hor, CGMClass5->text_align.ver,
	    CGMClass5->text_align.cont_hor, CGMClass5->text_align.cont_ver);

		/* polygon fill attributes: interior style */
	xws_fl_style(CGMClass5->int_style);

		/* polygon edge attributes: type and width */
	xws_e_type(CGMClass5->edge_type);
	xws_e_width(CGMClass5->edge_width.i, CGMClass5->edge_width.r);

		/* cell array graphical primitive has no attributes */

		/* Color mode may be direct or indexed.  For indexed color,
		 * the current color index definitions will be used in setting
		 * color attributes.   The call to (*xws_bp_color)() must 
		 * preceed color attribute setting.
		 */
	if (xws_bp_color) (*xws_bp_color)();
		
		/* line color attribute */
	xws_l_colour(CGMClass5->line_colour.red, CGMClass5->line_colour.green,
	    CGMClass5->line_colour.blue, CGMClass5->line_colour.ind);

		/* marker color attribute */
	xws_mk_colour(CGMClass5->mk_colour.red, CGMClass5->mk_colour.green,
	    CGMClass5->mk_colour.blue, CGMClass5->mk_colour.ind);

		/* text color attribute */
	xws_t_colour(CGMClass5->text_colour.red, CGMClass5->text_colour.green,
	    CGMClass5->text_colour.blue, CGMClass5->text_colour.ind);

		/* fill color attribute */
	xws_fl_colour(CGMClass5->fill_colour.red, CGMClass5->fill_colour.green,
	    CGMClass5->fill_colour.blue, CGMClass5->fill_colour.ind);

		/* edge color attribute */
	xws_e_colour(CGMClass5->edge_colour.red, CGMClass5->edge_colour.green,
	    CGMClass5->edge_colour.blue, CGMClass5->edge_colour.ind);

	if (Compositing)
		return(GPLOT_SUCCESS);

	/* Set the background color in the color map, and then set the
	 * background color in the window.  Calling (*xws_ctab)() directly
	 * forces storing of these rgb values as the background pixel,
	 * rather than using any previous definition of background color.
	 */
	if (CGMClass2->c_s_mode == i_c_mode)
	{
	float	rgb[3];
		rgb[0]=r; rgb[1]=g; rgb[2]=g;
		if (xws_ctab) (*xws_ctab)(0, 1, rgb);	
			/*==> we see this, if redef of 0 */
	}
	background_pixel = (*xws_get_pixel)(r, g, b, BACK_IDX);

	/* Clear the window, repainting it in the background color */
	XSetWindowBackground(Dpy, Win, background_pixel);
	XClearWindow(Dpy, Win);		/*==> then we see this, always */

	/* So we don't watch the color table change before the window clears */
	XFlush(Dpy);
					/*==> then, if a metafile color table
					 * is loaded which redefines index 0,
					 * we see that color change as a solid
					 * background color change. 
					 */

	/* set the background pixel in all the Graphic Contexts */
	XSetBackground(Dpy, LineGC, background_pixel);
	XSetBackground(Dpy, MarkerGC, background_pixel);
	XSetBackground(Dpy, PolygonGC, background_pixel);
	XSetBackground(Dpy, EdgeGC, background_pixel);
	XSetBackground(Dpy, CellArrayGC, background_pixel);
	XSetBackground(Dpy, TextGC, background_pixel);

	/* Use a clock cursor while translation of metacode is active */
	XDefineCursor(Dpy, Win, WaitCursor);

	return(GPLOT_SUCCESS);
}
static void
xws_shutdown()
{
	/* If we have installed our own colormap, uninstall it, causing the
	 * default colormap to be installed in its place.
	 */
	if (xws_cmapout) (*xws_cmapout)();

	/* Destroy the window and release all X resources and so on */
	if (manage_own_window) XtDestroyWidget(Toplevel);
}
/*ARGSUSED*/
xws_epage(copies)
int	copies;
{
XEvent			event;
XButtonPressedEvent	*button_event;
XKeyEvent		*key_event;
int			len;
char			keybuffer[8];

	/* If there is no user interface to take care of this sort of
	 * thing, flush the output buffer and discard all events on 
	 * the queue 
	 */
	if (manage_own_window) XSync(Dpy, 1);

	if (Compositing)
		return(GPLOT_SUCCESS);

	/* Change of clock cursor to X cursor indicates translation is done */
	XDefineCursor(Dpy, Win, ReadyCursor);

#ifdef INCL_EVENT_LOOP
	/* Beep & wait for the user to press mouse button 1 or quit.
	 * Selection of events we're interested in occured in xws_setup().
	 */
	XBell(Dpy, 0);
	button_event = (XButtonPressedEvent *) &event;
	key_event = (XKeyEvent *) &event;

	while (TRUE)
	{
	        XNextEvent(Dpy, &event);
		switch (event.type)
		{
		case ButtonPress:
		    if (button_event->button == Button1)
			return(GPLOT_SUCCESS);
		    break;
		case KeyPress:
		    /* press q, Q, or ^C to abort further translation */
		    len = XLookupString(key_event, keybuffer, sizeof(keybuffer),
		        (KeySym *) NULL, (XComposeStatus *) NULL);
		    if (len == 1 && (keybuffer[0] == 'q' || keybuffer[0] == 'Q'
			|| keybuffer[0] == '\003'))
		    {
			xws_shutdown();
			exit(0);
		    }
		    break;
		case LeaveNotify:
		    if (xws_cmapout) (*xws_cmapout)();
		    break;
		case EnterNotify:
		    if (xws_cmapin) (*xws_cmapin)();
		    break;
		default:
		    break;
                } /* end switch */
	} /* end while */
#endif
        return(GPLOT_SUCCESS);
}
/*ARGSUSED*/
xws_end(frame_count)
int	frame_count;	/* number of frames translated - for accounting */
{
        /* Reset Metafile Defaults flag, just in case another CGM file
	 * follows.
	 */
        Metafile_Defaults= TRUE;

	if (Compositing >= 0) Compositing--;
	if (! Compositing) xws_shutdown();

	return(GPLOT_SUCCESS);
}
