/*****************************************************************************/
/* module logic.c							     */
/*									     */
/* Author: Markus Buchi							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

/* et logique entre ima1 et ima2 , resultat dans ima3 */

and_ima(nl,nc,ima1,ima2,ima3)
int nl,nc;
short **ima1,**ima2,**ima3;
{
    int i;
    register int j;
    short *point1,*point2,*point3;
    ima1++;                   /* pemiere ligne */
    ima2++;            
    ima3++;
    for(i=1;i<=nl;i++)
       {
	    point1 = *ima1++;
            point1++;
            point2 = *ima2++;
            point2++;
            point3 = *ima3++;
            for(j=1;j<=nc;j++)
               {
                  *point3 = *point1++ & *point2++;
                  point3++;
	       }
       }
} /* end and_ima */

/*************************************************************************************/
 
/* negation not de image1 , resultat dans image3 */

not_ima(nl,nc,image1,image3)
int nl,nc;
short **image1,**image3;
{
    int i;
    register int j;
    register short *point1,*point3;
    image1++;                   /* pemiere ligne */
    image3++;
    for(i=1;i<=nl;i++)
       {
	    point1 = *image1++;
            point1++;
            point3 = *image3++;
            point3++;
            for(j=1;j<=nc;j++)
               {
                  *point3 = ~*point1++;
                  point3++;
	       }
       }
} /* end not_ima */


/************************************************************************************/

/* ou exclusif xor de ima1 et ima2 , resultat dans ima3 */

xor_ima(nl,nc,ima1,ima2,ima3)
int nl,nc;
short **ima1,**ima2,**ima3;
{
    int i;
    register int j;
    register short *point1,*point2,*point3;
    ima1++;                   /* pemiere ligne */
    ima2++;            
    ima3++;
    for(i=1;i<=nl;i++)
       {
	    point1 = *ima1++;
            point1++;
            point2 = *ima2++;
            point2++;
            point3 = *ima3++;
            point3++;
            for(j=1;j<=nc;j++)
               {
                  *point3 = *point1++ ^ *point2++;
                  point3++;
	       }
       }
} /* end xor_ima */

/**************************************************************************************/

/* ou inclusif or entre ima1 et ima2 , resultat dans ima3 */

or_ima(nl,nc,ima1,ima2,ima3)
int nl,nc;
short **ima1,**ima2,**ima3;
{
    int i;
    register int j;
    register short *point1,*point2,*point3;
    ima1++;                   /* pemiere ligne */
    ima2++;       
    ima3++;
    for(i=1;i<=nl;i++)
       {
	    point1 = *ima1++;
            point1++;
            point2 = *ima2++;
            point2++;
            point3 = *ima3++;
            point3++;
            for(j=1;j<=nc;j++)
               {
                  *point3 = *point1++ | *point2++;
                  point3++;
	       }
       }
} /* end or_ima */

/***********************************************************************************/

/* difference - entre ima1 et ima2 , resultat dans ima3 */

diff_ima(nl,nc,ima1,ima2,ima3)
int nl,nc;
short **ima1,**ima2,**ima3;
{
    int i;
    register int j;
    register short *point1,*point2,*point3;
    ima1++;                   /* pemiere ligne */
    ima2++;       
    ima3++;
    for(i=1;i<=nl;i++)
       {
	    point1 = *ima1++;
            point1++;
            point2 = *ima2++;
            point2++;
            point3 = *ima3++;
            point3++;
            for(j=1;j<=nc;j++)
               {
                  *point3 = *point1++ & ~(*point2++);
                  point3++;
	       }
       }
} /* end diff_ima */

/***********************************************************************************/
