/*****************************************************************************/
/* module urgent.c							     */
/*									     */
/* Author: Z.Ping Hu							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
/* urgent.c added expert system, with all libs 8. Jan, 1989 */

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/textsw.h>
#include <suntool/scrollbar.h>
#include <suntool/panel.h>
#include <sys/file.h>
#include <sys/time.h>
#include <stdio.h>
#include <strings.h>
#include <math.h>
#include <pixrect/pixrect_hs.h>

#include "define.h"
#include "structure.h"
#include "global.h"

#define PI	    3.1415926
#define TAILLE	    1024

static Panel_setting lire_perct();
static Panel_setting lire_pcnt_puisan();
static Panel_setting lire_linear_filter();
static Panel_setting lire_shape();

int	lapla_ptl();
int	cre_plan_ref();
int	threshold();
int	bilinear_interpl();
int	min_max();
int	ftas();

extern  int diff_hist_thresh();   /*select threshold by sum of 
				    difference*/
extern  void refplane_binary_thresh();   /*threshold image into binary
					    by reference plane*/
extern	void winhamming();    /*generate hamming window function*/
extern	void wingauss();    /*generate gaussian window function*/

extern void hproc_puissance();
extern void hproc_couper_freq();
extern void hproc_filtre_passhaut();
extern void hproc_filtre_lin();
extern void hproc_gaussian();
extern void hproc_filter_hamming();
extern void hproc_dyna_seuil();
extern void hproc_laplacian_ptile();
extern void hproc_interpol_ordre1();

extern	Menu   mhisto;
Frame	       frame_pert, frame_linearflt, frame_energy;
Panel	       panel_pert, panel_linearflt, panel_energy;
Frame	       frame_shape;
Panel	       panel_shape;
Panel_item     pcnt_of_histo, n_of_blk, coef_high_pass, flt_lin, flt_col;
Panel_item     pcnt_of_energy, r_of_spctrm, n_of_interpl;
Panel_item     diam_window, shap_window, conv_ligne, conv_colonne;
Panel_item     pcnt_titre, gauss_titre, convol_titre, puissan_titre;

struct paddi {
    int		ligne, colonne, methode;
    float	valeur;
};

struct convol {
    int	    ligne, colonne;
    float   factmult;
    float   *masque;
};

struct convol *linea_flt_panel();

struct pertile {
    float   ptiledata;    /* parameter for laplac_p_tile histogram   */
    int	    n_block;	  /* parameter for dynamic threshold         */
    float   alpha;	  /* parameter for high_pass filter	     */
};
struct pertile *percnt_panel();

struct rayon_puissan {
    float   p_energy;	  /* percentage for keeping energy	     */
    int	    r_frequency;  /* corresponding radius in frequency domain*/
    int	    n_point;	  /* points of interpolation		     */
};
struct rayon_puissan *radius_energy();

struct gaussian_p {
    float   en_mint;	  /* ratio of en over mint		    */
    int	    mint;	  /* diameter of gaussian window	    */
};
struct gaussian_p *shape_of_gaus();

int flag_autoconvert;


/*****************************************************************************/

caddr_t proc_high_pass (m, mi)

    Menu m;
    Menu_item mi;

{
    int taille, *imagei, *img;
    int ligne, colonne, i, t, flag_conv;
    unsigned char *temp;
    struct pertile *perc, *copyperc;


    if (flag_bother) {
	hproc_filtre_passhaut();
	return;
    }
    if (flag_help) hproc_filtre_passhaut();
    if (!flag_creer){ 
	sprintf (buf, mastertabs[286]);
	write_master (buf);
    }
  
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (!flag_creer){
	sprintf (buf, "%d --> %d ", index_image[0], index_image[1]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	perc = (struct pertile*) malloc(sizeof (*perc));
	*perc = *((struct pertile *)macro_cour->param);
    }
    else perc = percnt_panel(2);
    if (flag_break || perc->alpha == 0){
	interruption();
	return;
    }
    if (flag_creer) {
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "PREENHHPF");
	com->code = 182;
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf(buf, "%s FROM %d TO %d WITH %f\n",
		com->nom, index_image[0], index_image[1],perc->alpha);
	write_macro(buf);
	copyperc = (struct pertile *) malloc(sizeof(*copyperc));
	*copyperc = *perc;
	com->param = (char *)copyperc;	
    }
    else{
	sprintf (buf, "(coeff = %.4f)\n", perc->alpha);
	write_master (buf);
	switch (dir_desc[index_image[0]].type){
	    case -1:
	    case 0:
	    case 1:flag_conv = TRUE;
		    img = (int *) conv_int (index_image[0]);
		    break;
	    case 2: flag_conv = FALSE;
		    img = (int *)dir_image[index_image[0]].image;
		    break;
	    case 3:
	    case 4:
	    case 5:flag_autoconvert = TRUE;
		    autoconvert_integer(index_image[0]);
		    img = (int *) buffer_image[0].image;
		    break;
	}
	
	dir_desc[index_image[1]] = dir_desc[index_image[0]];
	dir_desc[index_image[1]].type = 2;
	ligne = (int)dir_desc[index_image[1]].nligne;
	colonne = (int)dir_desc[index_image[1]].ncolonne;
	taille = ligne * colonne * element(dir_desc[index_image[1]].type);
	t = 1;
	temp =(unsigned char *)edg_laplace(img,colonne,ligne,t);
	imagei = (int *)temp;
	for (i = 0; i < ligne * colonne; i++){
	    *imagei = (int) *img + (int) *imagei * perc->alpha;
	    img++;
	    imagei++; 
	}
	if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
	dir_image[index_image[1]].image = (unsigned char *)temp;
	statis (dir_image[index_image[1]].image,
		dir_desc[index_image[1]].type, 
		dir_desc[index_image[1]].nligne,
		dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
		&(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
	if ((flag_conv) || (flag_autoconvert)){
	    free (img);
	    flag_conv = FALSE;
	    flag_autoconvert = FALSE;
	}
    }
}

/*****************************************************************************/
/*   use laplacian p-tile to create gray level histogram		     */
/*****************************************************************************/

int lapla_ptl (percnt, image)

    float percnt;
    int *image;

{
    int **im, *p, *new;
    int **tab, *gradi, *t;
    float sum;
    int i, j, lin, col, mx, thr, index, count;
    static struct histogr *histg;

    lin = dir_desc[index_image[0]].nligne;
    col = dir_desc[index_image[0]].ncolonne;

    mx = 30000;		    /* the maximum posssible laplacian value */
    gradi = (int *)calloc(mx, sizeof(int));
			    /* locat lapla_histogram table	     */

    im = (int **)malloc((lin + 2) * sizeof(int *));
    for (i = 0; i < lin + 2; i++)
    {
	im[i] = (int *)calloc((col + 2), sizeof(int));
    }
			    /* image space for padding prolongation  */

    t = image;
    im[0][0] = *t;
    for (j = 1; j < col + 1; j++)
    {
	im[0][j] = *t;
	t++;
    }
    im[0][col + 1] = im[0][col];
			    /* fill up first line */

    t = image;
    for (i = 1; i < lin + 1; i++)
    {
	im[i][0] = *t;
	for (j = 1; j < col + 1; j++)
	{
	    im[i][j] = *t;
	    t++;
	}
	im[i][col + 1] = im[i][col];
    }
			    /* fill left and right of the body */

    t = t - col;
    im[lin + 1][0] = *t;
    for (j = 1; j < col + 1; j++)
    {
	im[lin + 1][j] = *t;
	t++;
    }
    im[lin + 1][col + 1] = im[lin + 1][col];
			    /* fill up last line */

    tab = (int **)malloc(lin * sizeof(int *));
    for (i = 0; i < lin + 2; i++)
    {    
	tab[i] = (int *)calloc(col + 2, sizeof(int));
    }
			    /* locate space for laplacian calculation  */

    t = gradi;
    for (i = 0; i < mx; i++)
    {
	*t = 0;
	t++;
    }			  /* initialize lapla_histogram	       */

    for (i = 1; i < lin + 1; i++)
    {
	for (j = 1; j < col + 1; j++)
	{
	    tab[i][j] = (int) (abs(im[i + 1][j]
				  + im[i - 1][j]
				  + im[i][j + 1]
				  + im[i][j - 1] - im[i][j] * 4)); 
			 /* calculate laplacian value of every pixel*/ 
	    index = tab[i][j];
	    if (index < mx)
		gradi[index] = gradi[index] + 1;
	    else
		gradi[mx - 1] = gradi[mx - 1] + 1; 
		        /* calculate laplacian histogram      */
	}
    }			  
    sum = 0;
    for (i = 0; i < mx; i++)
    {
	sum = sum + (float)gradi[i] / (lin * col);
	if (sum >= percnt) goto st;
    }
    st: thr = i;

    count = 0;
    for (i = 1; i < lin + 1; i++)
    {
	for (j = 1; j < col + 1; j++)
	{
	    if (tab[i][j] >= thr) 
	    {
		tab[i][j] = 1;
		count++;
	    }
	    else tab[i][j] = 0;
	}
    }		/* count the points who have higher laplacian_value  */  

    if (dir_image[index_image[1]].image != NULL)
	free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image =
			     (unsigned char*)malloc(count * sizeof(int));
    p = (int *)dir_image[index_image[1]].image;
    for (i = 1; i < lin + 1; i++)
    {
	for (j = 1; j < col + 1; j++)
	{
	    if (tab[i][j] != 0)
	    {
		*p = im[i][j];
		p++;
	    }
	}
    }		/* transfer these pixels into intermediate plane     */
    if (count % 2 != 0) count--;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].nligne = count / 2;
    dir_desc[index_image[1]].ncolonne = 2;    
    dir_desc[index_image[1]].type = 2;
    statis( dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type,
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax),
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    free(gradi);
    for (i = 0; i < lin + 2; i++) {
	free(tab[i]);
	free(im[i]);
    }
    free(im);
    free(tab);
/*
    histg = histo_panel(index_image[1]);
    if (flag_break) interruption();
    else
	histogramme (index_image[1], histg);  
    free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = NULL;
*/
    if ((flag_exec != AUTO) && (flag_exec != PARAM_AUTO) && (flag_exec != FROMTO_AUTO) && (flag_exec != MANUEL)){
    proc_histo (mhisto, menu_get(mhisto, MENU_NTH_ITEM, 2));
    proc_histo (mhisto, menu_get(mhisto, MENU_NTH_ITEM, 3));
    }

    return(thr);
}

/*****************************************************************************/
/*   calculate laplacian histogram and get the laplacian value corresponding */
/*   to the p_tile given by the user. filter the image with the laplacian    */
/*   value, use the pixels surviving the filter to construct histogram.	     */
/*****************************************************************************/

caddr_t proc_ptile_seuil(m, mi)

    Menu m;
    Menu_item mi;

{
    struct pertile *perc, *copyperc;
    int *image, flag_conv;

    if (flag_bother) {
	hproc_laplacian_ptile();
	return;
    }
    if (flag_help) hproc_laplacian_ptile();
    if (!flag_creer){ 
	sprintf (buf, mastertabs[287]);
	write_master (buf);
    }

    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	perc = (struct pertile*) malloc(sizeof (*perc));
	*perc = *((struct pertile *)macro_cour->param);
    }
    else perc = percnt_panel(0);
    if (flag_break){
	interruption();
	return;
    }
    else if (perc->ptiledata == NULL){
	write_erreur(93);
	return;
    }
    if (flag_creer) {
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "PROATHLPH");
	com->code = 56;
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf(buf, "%s FROM %d TO %d WITH %f\n",
		com->nom, index_image[0], index_image[1],perc->ptiledata);
	write_macro(buf);
	copyperc = (struct pertile *) malloc(sizeof(*copyperc));
	*copyperc = *perc;
	com->param = (char *)copyperc;
	proc_histo (mhisto, menu_get(mhisto, MENU_NTH_ITEM, 2));
	proc_histo (mhisto, menu_get(mhisto, MENU_NTH_ITEM, 3));
    }
    else{ /* flag_creer */
	sprintf (buf, "%d --> %d ", index_image[0], index_image[1]);
	write_master (buf);
	sprintf (buf, "(coeff = %.4f)\n", perc->ptiledata);
	write_master (buf);
	switch (dir_desc[index_image[0]].type){
	    case -1:
	    case 0:
	    case 1:flag_conv = TRUE;
		   image = (int *) conv_int (index_image[0]);
		   break;
	    case 2:flag_conv = FALSE;
		   image = (int *)dir_image[index_image[0]].image;
		   break;
	    case 3:
	    case 4:
	    case 5:flag_autoconvert = TRUE;
		   autoconvert_integer(index_image[0]);
		   image = (int *) buffer_image[0].image;
		   break;
	}
/*	if (dir_desc[index_image[0]].type > 2){
	    write_erreur(11);
	    return;
	}
	else {
	    if (dir_desc[index_image[0]].type == 2) {
		flag_conv = FALSE;
		image = (int *)dir_image[index_image[0]].image;
	    }
	    flag_conv = TRUE;
	    image = (int *) conv_int (index_image[0]);
	}
*/
	lapla_ptl(perc->ptiledata, image);
	if ((flag_conv) || (flag_autoconvert)){
	    free (image);
	    flag_conv = FALSE;
	    flag_autoconvert = FALSE;
	}
    }
}

/*****************************************************************************/

caddr_t proc_dyna_seuil(m, mi)

    Menu m;
    Menu_item mi;

{
    struct pertile *perc, *copyperc;
    static struct paddi pd;
    int *imref,  *tprc, ISW, lin, col;
    int flag_conv, *imdep;

    if (flag_bother) {
	hproc_dyna_seuil();
	return;
    }
    if (flag_help) hproc_dyna_seuil();
    if (!flag_creer){ 
	sprintf (buf, mastertabs[288]);
	write_master (buf);
    }
    
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
	index_image[3] = macro_cour->to[1];
    }
    else fromto (FROMTO, REFERENC);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	perc = (struct pertile*) malloc(sizeof (*perc));
	*perc = *((struct pertile *)macro_cour->param);
    }
    else perc = percnt_panel(1);
    if (flag_break){
	interruption();
	return;
    }
    else if (perc->n_block == 0){
	write_erreur(94);
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "PROATHDTH");
	com->code = 57;
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	com->to[1] = index_image[3];
	sprintf(buf, "%s FROM %d TO %d %d WITH %d\n",
		com->nom, index_image[0], index_image[1],
		index_image[3], perc->n_block);
	write_macro(buf);
	copyperc = (struct pertile *) malloc(sizeof(*copyperc));
	*copyperc = *perc;
	com->param = (char *)copyperc;	
    }
    else { /* plan ref */
	sprintf (buf, "%d --> %d", index_image[0], index_image[1]);
	write_master(buf);
	sprintf (buf,"(ref pln--> %d)", index_image[3]);
	write_master(buf);
	sprintf (buf, mastertabs[299]);
	sprintf (buf, "= %d)\n", perc->n_block);
	write_master (buf);
	
	if (dir_image[index_image[0]].image == NULL){
	    write_erreur(0);
	    return;
	}
	switch (dir_desc[index_image[0]].type){
	    case -1:
	    case 0:
	    case 1:flag_conv = TRUE;
		   imdep = (int *) conv_int (index_image[0]);
		   break;
	    case 2:flag_conv = FALSE;
		   imdep = (int *)dir_image[index_image[0]].image;
		   break;
	    case 3:
	    case 4:
	    case 5:flag_autoconvert = TRUE;
		   autoconvert_integer(index_image[0]);
		   imdep = (int *) buffer_image[0].image;
		   break;
	}

/*    if (dir_desc[index_image[0]].type > 2)
	write_erreur(11);
	if (dir_desc[index_image[0]].type == 2) {
	    flag_conv = FALSE;
	    imdep = (int *)dir_image[index_image[0]].image;
	}
	    flag_conv = TRUE;
	    imdep = (int *) conv_int (index_image[0]);
*/
	cre_plan_ref(perc->n_block, imdep);
	    /* create threshold reference plane --> image[1] */
	pd.ligne = lin = dir_desc[index_image[0]].nligne;
	pd.colonne = col = dir_desc[index_image[0]].ncolonne;
	pd.methode = 2;
	padding_prolong(index_image[1], index_image[3], &pd);
	    /* pad image[1] to the same size of image[0]--> image[3] */
	imref = (int *)dir_image[index_image[3]].image;
	free(dir_image[index_image[1]].image);
	tprc = (int *)calloc(lin * col, sizeof(int));
	ISW = 2;
	refplane_binary_thresh(imdep, imref, tprc, lin, col, ISW);
	if (dir_image[index_image[1]].image != NULL)
	    free (dir_image[index_image[1]].image);
	dir_image[index_image[1]].image = (unsigned char *)tprc;
	dir_desc[index_image[1]].nligne = lin;
	dir_desc[index_image[1]].ncolonne = col;
	statis (dir_image[index_image[1]].image,
                dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));

	if ((flag_conv) || (flag_autoconvert)){
	    free (imdep);
	    flag_conv = FALSE;
	    flag_autoconvert = FALSE;
	}
    }
}


/****************************************************************************/
/*  create a reference plane of dynamic threshold, save in index_image[1]   */
/*  for time being							    */
/****************************************************************************/

int cre_plan_ref(d, imdep)
    int d, *imdep;

{
    int *block_c, *t, *bc, *bcr;
    int verticl, horizon, l, c, lin, col, stpoint;
    int mnn, mxx, modval, value;
    int h_num, v_num;
    float thr_array[256][256], *interp, *p;
    int **DHIST;
    int  range;



    lin =  dir_desc[index_image[0]].nligne;
    v_num = lin / d;	    /* num. of blocks per column */
    col =  dir_desc[index_image[0]].ncolonne;
    h_num = col / d;	    /* num. of blocks per line   */   

    block_c = (int *)calloc(d * d, sizeof(int));
    interp = (float *)calloc((d + 1) * (d + 1), sizeof(float));  

    bc = imdep;
    bcr = (int *)calloc((lin - d) * (col - d), sizeof(int));
    for (verticl = 0; verticl < v_num; verticl++)
    {
	for (horizon = 0; horizon < h_num; horizon++)
	{
	    stpoint = verticl * col * d + horizon * d;
	    t = block_c;
	    for (l = 0; l < d; l++)	   /* extract one block into block_c*/
	    {
		for (c = 0; c < d; c++)
		{
		    *t = bc[stpoint + c];
		    t++; 
		}
	        stpoint = stpoint + col;
	    }
	    min_max(block_c, d, d, &mnn, &mxx); 
					  /* calculate its min & max */
	if (mxx <= 255) range = 256; else range = mxx + 1;
	modval = 1;
	value = diff_hist_thresh(block_c, d, d, &DHIST, range,
				 mnn, mxx, modval);
					   /* select local threshold */
	    thr_array[verticl][horizon] = (float)value;
	}
    }

    for (verticl = 0; verticl < v_num - 1; verticl++)  /*create thresh plane */
    {
	for (horizon = 0; horizon < h_num - 1; horizon++)
	{
	 stpoint = verticl * (col - d) * d + horizon * d;
	 p = interp;		     /* create one block by interpolation */
	 bilinear_interp(thr_array[verticl][horizon],
			 thr_array[verticl][horizon + 1],
			 thr_array[verticl + 1][horizon + 1],
			 thr_array[verticl + 1][horizon],
			 d,
			 d,
			 interp);
         for (l = 0; l < d; l++)  /*insert the block into thresh plane*/
	 {
	    for (c = 0; c < d; c++)
	     {
		bcr[stpoint + c] = (int)*p;
		p++; 
	     }
	     p++;
	     stpoint = stpoint + col - d;
	 }
	}
    }
    free(block_c);
    free(interp);
    dir_image[index_image[1]].image = (unsigned char *)bcr;
    dir_desc[index_image[1]].type = 2;
    dir_desc[index_image[1]].nligne = lin - d;
    dir_desc[index_image[1]].ncolonne = col - d;
    statis( dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type,
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax),
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));    
}

/*****************************************************************************/


min_max(image, lin, col, mmin, mmax)
int *image, lin, col, *mmin, *mmax;
{
    int *i, size, f, n;

    size = lin * col;
    i = image;
    *mmin = *mmax = *i;
    i++;

    for (n = 1 ; n < size; n++)
    {
	f = *i;
	if (f > *mmax) *mmax = f;
	if (f < *mmin) *mmin = f;
	i++;
    }
}

/*****************************************************************************/

bilinear_interp(a1, a2, a3, a4, dx, dy, p)
    float a1, a2, a3, a4, *p;
    int dx, dy;
{
    float vx1, vx2, *t;
    int i, j;

    t = p;

    for (j = 0; j <= dy; j++)
    {
	for (i = 0; i<= dx; i++)
	{
	    {
		vx1 = a1 + (a2 - a1) / dx * i;
		vx2 = a4 + (a3 - a4) / dx * i;
		*t = vx1 + (vx2 - vx1) / dy * j;
		t++;
	    }
	}
    }
}

/****************************************************************************/

struct pertile *percnt_panel(flg)
short flg;
{
    char repstrg[10], titrestrg[40];
    struct pertile *perc;


    frame_pert = window_create (frame, FRAME,
			        WIN_X, 500,
			        WIN_Y, 500,
				FRAME_NO_CONFIRM, TRUE,
				0);
    panel_pert = window_create (frame_pert, PANEL, 
				0);
    switch (flg){
	case 0: strcpy(titrestrg, paneltabs[492]);
		break;
	case 1: strcpy(titrestrg, paneltabs[493]);
		break;
	case 2: strcpy(titrestrg, paneltabs[491]);
		break;
    }
    pcnt_titre = panel_create_item(panel_pert, PANEL_MESSAGE,
			       PANEL_LABEL_X, ATTR_COL(0),
			       PANEL_LABEL_Y, ATTR_ROW(0),
			       PANEL_LABEL_STRING, titrestrg,
			       PANEL_LABEL_BOLD, TRUE,
			       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	perc = (struct pertile *)(macro_cour->param);
    else perc = NULL;

    pcnt_of_histo = panel_create_item (panel_pert, PANEL_TEXT,
		PANEL_SHOW_ITEM, FALSE,
		PANEL_ITEM_X, ATTR_COL(1),
		PANEL_ITEM_Y, ATTR_ROW (1),
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 8,
		PANEL_LABEL_STRING, paneltabs[481],
		PANEL_VALUE,(perc != NULL ? 
		      (char *)sprintf(repstrg,"%d",perc->ptiledata) : ""), 
		PANEL_NOTIFY_STRING, "\n\r\03",
		PANEL_NOTIFY_PROC, lire_perct, 
		0);
    n_of_blk = panel_create_item (panel_pert, PANEL_TEXT,
		PANEL_SHOW_ITEM, FALSE,
		PANEL_ITEM_X, ATTR_COL(1),
		PANEL_ITEM_Y, ATTR_ROW(2),
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 8,
		PANEL_LABEL_STRING, paneltabs[482],
		PANEL_VALUE,(perc != NULL ? 
		    (char *)sprintf(repstrg,"%d",perc->n_block) : ""), 
		PANEL_NOTIFY_STRING, "\n\r\03",
		PANEL_NOTIFY_PROC, lire_perct, 
		0);
    coef_high_pass = panel_create_item (panel_pert, PANEL_TEXT,
		PANEL_SHOW_ITEM, FALSE,
		PANEL_ITEM_X, ATTR_COL(1),
		PANEL_ITEM_Y, ATTR_ROW(3),
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 8,
		PANEL_LABEL_STRING, paneltabs[483],
		PANEL_VALUE,(perc != NULL ? 
		    (char *)sprintf(repstrg,"%d",perc->alpha) : ""), 
		PANEL_NOTIFY_STRING, "\n\r\03",
		PANEL_NOTIFY_PROC, lire_perct, 
		0);
    window_fit (panel_pert);
    window_fit (frame_pert);
    switch (flg) {
    case 0:
	panel_set(pcnt_of_histo, PANEL_SHOW_ITEM, TRUE, 0);
	window_set (panel_pert, PANEL_CARET_ITEM, pcnt_of_histo, 0);
	break;
    case 1:
	panel_set(n_of_blk, PANEL_SHOW_ITEM, TRUE, 0);
	window_set (panel_pert, PANEL_CARET_ITEM, n_of_blk, 0);
	break;
    case 2:
	panel_set(coef_high_pass, PANEL_SHOW_ITEM, TRUE, 0);
	window_set (panel_pert, PANEL_CARET_ITEM, coef_high_pass, 0);
	break;
    }
    perc = (struct pertile *)window_loop(frame_pert); 
    return (perc);
}

/*****************************************************************************/

static Panel_setting lire_perct (item, event)

    Panel_item item;
    Event *event;

{
    static struct pertile perc = {0, 0, 0};
    char rep[20];

    if (event_id(event) == CTRLC) {
       /*  demande d'interruption de l'interaction par l'utilisateur */ 
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_pert);
        return;
    }
    else { 
        strcpy (rep, (char *) panel_get (item, PANEL_VALUE));
	if (item == pcnt_of_histo) {
	    perc.ptiledata = atof(rep);
	    if (perc.ptiledata > 0 && perc.ptiledata < 1) {
		window_return (&perc);
		window_destroy (frame_pert);
		return;
	    }
	    else {
	    panel_set_value (item, "");
	    return;
	    }
	}
	else if (item == n_of_blk) {
		 perc.n_block = atoi(rep);
		 if (perc.n_block != 0 &&
		    dir_desc[index_image[0]].nligne % perc.n_block == 0 &&
		    dir_desc[index_image[0]].ncolonne % perc.n_block == 0){
		    window_return (&perc);
		    window_destroy (frame_pert);
		    return;
		 }
		 else {
		    panel_set_value (item, "");
		    return;
		 }
	}
	     else if (item == coef_high_pass) {
		      perc.alpha = atof(rep);
		      if (perc.alpha > 0 && perc.alpha < 1) {
			  window_return (&perc);
			  window_destroy (frame_pert);
			  return;
		      }
		      else {
			  panel_set_value (item, "");
			  return;
		      }
	     }
    }
}

/*****************************************************************************/

caddr_t proc_linear_filter(m, mi)

    Menu m;
    Menu_item mi;

{
    struct convol *cnv, *copycnv;
    static struct paddi pd;
    static struct description_memoire tmp;
    float *pt, *pt1, *ori_image, *pr1, *pr2, *pi2, *pi1;
    float *br1, *bi1, *br2, *bi2, *bz;
    int size, i, j, lin, col, isxf, isyf;
    float *im;
    int flag_conv;


    if (flag_bother) {
	hproc_filtre_lin();
	return;
    }
    if (flag_help) hproc_filtre_lin();
    if (!flag_creer){ 
	sprintf (buf, mastertabs[290]);
	write_master (buf);
    }
    
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
	index_image[3] = macro_cour->to[1];
    }
    else fromto (FROMTO, REFERENC);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	cnv = (struct convol*) malloc(sizeof (*cnv));
	*cnv = *((struct convol *)macro_cour->param);
    }
    else cnv = linea_flt_panel(); /* lin and col of filter */
    if (flag_break){
	interruption();
	return;
    }
    else if (cnv->ligne==0 || cnv->colonne==0){ 
	write_erreur(92);
	return;
    }


    if (flag_creer){
	struct commande *com;
	com = (struct commande *)new_commande (&macro_cour);
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	com->to[1] = index_image[3];
	sprintf (com->nom, "PRECBA");
	com->code = 185;
	sprintf(buf, "%s FROM %d TO %d %d WITH %d %d\n",
		com->nom, index_image[0], index_image[1],
		index_image[3], cnv->colonne, cnv->ligne);
	write_macro (buf);
	cnv->factmult = 1.0;
	cnv->masque = NULL;
	copycnv = (struct convol *) malloc(sizeof(*copycnv));

	*copycnv = *cnv;
	
	com->param = (char *)copycnv; 
	
    }
    else{ /* !flag_creer */
	sprintf (buf," (%dx%d):%d --> %d", cnv->colonne, cnv->ligne, 
				      index_image[0], index_image[1]);
	write_master (buf);
	sprintf(buf, mastertabs[291], index_image[3]);
	write_master (buf);
	if (dir_image[index_image[0]].image == NULL){
	    write_erreur(0);
	    return;
	}
	if (dir_desc[index_image[0]].type == 3){
	    im = (float *)dir_image[index_image[0]].image;
	    flag_conv = FALSE;
	}
	else{

	    im = (float *)conv_float(index_image[0]);
	    flag_conv = TRUE;
	}
        if (power_2(dir_desc[index_image[0]].nligne) == FALSE ||
            power_2(dir_desc[index_image[0]].ncolonne) == FALSE){
		write_erreur(15);
		return;
	    }
	else { /* all fine */
	    size = cnv->ligne * cnv->colonne;	   /* size of filter */
	    cnv->factmult = (float) 1 / size;

	    lin = dir_desc[index_image[0]].nligne;
	    col = dir_desc[index_image[0]].ncolonne;
	    if (size < lin * col /16) {
		pt1 = (float *)malloc(lin * col * sizeof(float)); 
		dir_image[index_image[3]].image = (unsigned char *)pt1;
		pt = im;  /* [0] */
		for (i = 0; i < lin * col; i++) {
		    *pt1 = *pt;
		    pt1++; pt++;
		}
		dir_desc[index_image[3]] = dir_desc[index_image[0]];
		dir_desc[index_image[3]].type = 3;
	    }		/* copy index_image[0] to index_image[3] */
	    else { /* size > 16 */
		while (col < dir_desc[index_image[0]].ncolonne + cnv->colonne) 
		    col = col * 2;
		while (lin < dir_desc[index_image[0]].nligne + cnv->ligne) 
		    lin = lin * 2;
		pd.ligne = lin;
		pd.colonne = col;
		pd.methode = 2;
		ori_image = (float *)dir_image[index_image[0]].image;
		tmp = dir_desc[index_image[0]];
		dir_image[index_image[0]].image = (unsigned char *)im;
		dir_desc [index_image[0]].type = 3;
		padding_prolong(index_image[0], index_image[3], &pd);    
		dir_image[index_image[0]].image = (unsigned char *)ori_image;
		dir_desc [index_image[0]] = tmp;
	    }		/* padding image[0]  --> image[3]*/

	    bz = (float *)calloc(col*lin, sizeof(float)); /* calloc */

	    four_2d((float *)dir_image[index_image[3]].image, bz, 
		    &br1, &bi1, lin, col, 2);
			/* fourier transformation of image */
	    ori_image = (float *)dir_image[index_image[0]].image;
	    tmp = dir_desc[index_image[0]];
			/*  save the original image[0] --> ori_image */
	    pt = (float *)malloc(size * 4);
	    dir_image[index_image[0]].image = (unsigned char *)pt;
	    for (i = 0; i < size; i++)
	    {
		*pt = cnv->factmult;	
		 pt++;			/* set the elements of filter*/
	    }
	    dir_desc[index_image[0]].nligne = (short)cnv->ligne;
	    dir_desc[index_image[0]].ncolonne = (short)cnv->colonne;
	    dir_desc[index_image[0]].type = 3;
	    pd.ligne = lin;
	    pd.colonne = col;
	    pd.valeur = 0;
	    pd.methode = 1;
	    padding_const(index_image[0], index_image[1], &pd);
		/* padding filter to the same size of index_image[3] */

	    free(bz);
	    bz = (float *)calloc(col*lin, sizeof(float)); /* calloc */
	    four_2d((float *)dir_image[index_image[1]].image, bz, 
		    &br2, &bi2, lin, col, 2);
				/* fourier transformation of filter */
	    pt1 = bz;
	    pt = (float *)dir_image[index_image[3]].image;
	    pr2 = br2;
	    pi2 = bi2;
	    pr1 = br1;
	    pi1 = bi1;
	    for (i = 0; i < lin; i++) 
	    {
		for (j = 0; j < col; j++)
		{
		    *pt = *pr1 * *pr2 - *pi1 * *pi2;	/* real part */
		    *pt1 = *pr1 * *pi2 + *pr2 * *pi1;	/* imaginary */
		    pt++; pt1++; pr1++; pi1++; pr2++; pi2++;
		}
	    }		/* FT_of_image multiply FT_of_filter */

	    four_2d((float *)dir_image[index_image[3]].image, bz, 
		    &br2, &bi2, lin, col, -2);
	            /* inverse FT to get background */
	    free(dir_image[index_image[0]].image);
	    free(dir_image[index_image[1]].image);
	    free(dir_image[index_image[3]].image);
	    free(br1);
	    free(bi1);
	    free(bi2);
	    free(bz);

	    dir_image[index_image[0]].image = (unsigned char *)ori_image;
	    dir_desc[index_image[0]] = tmp;
	    isyf = dir_desc[index_image[0]].nligne;
	    isxf = dir_desc[index_image[0]].ncolonne;
	    if (lin > isyf || col > isxf) {
		pt1 = (float *)malloc(isxf * isyf * sizeof(float));
		dir_image[index_image[3]].image = (unsigned char *)pt1;
		pt = br2 + col*(lin - isyf)/2 + (col - isxf)/2;
		for (i = 0; i < isyf; i++) {
		    for (j = 0; j < isxf; j++) {
			*pt1 = *pt;
			pt++; pt1++;
		    }
		    pt = pt + (col - isxf);
		}
		free(*br2);
	    }	/* make background same size as original image */
	    else 
		dir_image[index_image[3]].image = (unsigned char *)br2;

	    pt = (float *)malloc(isxf * isyf * sizeof(float));
	    dir_image[index_image[1]].image = (unsigned char *)pt;
	    pt1 = (float *)dir_image[index_image[3]].image;
	    ori_image = im;
	    for (i = 0; i < isxf *isyf; i++)
	    {
		*pt = *ori_image - *pt1;
		pt++; pt1++; ori_image++;
	    }	/* subtract background from original image */

	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[1]].type = 3;
	    statis( dir_image[index_image[1]].image,
		    dir_desc[index_image[1]].type,
		    dir_desc[index_image[1]].nligne,
		    dir_desc[index_image[1]].ncolonne,
		    &(dir_desc[index_image[1]].mmin),
		    &(dir_desc[index_image[1]].mmax),
		    &(dir_desc[index_image[1]].mu),
		    &(dir_desc[index_image[1]].ecart));   

	    dir_desc[index_image[3]] = dir_desc[index_image[0]];
	    dir_desc[index_image[3]].type = 3;
	    statis( dir_image[index_image[3]].image,
		    dir_desc[index_image[3]].type,
		    dir_desc[index_image[3]].nligne,
		    dir_desc[index_image[3]].ncolonne,
		    &(dir_desc[index_image[3]].mmin),
		    &(dir_desc[index_image[3]].mmax),
		    &(dir_desc[index_image[3]].mu),
		    &(dir_desc[index_image[3]].ecart));
	    }
	    if ((flag_conv ) || (flag_autoconvert)) {
		free (im);
		flag_conv = FALSE;
		flag_autoconvert = FALSE;
	    }
    }
}

/*****************************************************************************/

struct convol *linea_flt_panel()

{
    char *repfloat;
    char stitre[30];
    struct convol *conv;

    repfloat = (char *)malloc(20);
    frame_linearflt = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_linearflt = window_create (frame_linearflt, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);

    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	conv = (struct convol *)(macro_cour->param);
    else conv = NULL;
    convol_titre = panel_create_item(panel_linearflt, PANEL_MESSAGE,
			       PANEL_LABEL_X, ATTR_COL(0),
			       PANEL_LABEL_Y, ATTR_ROW(0),
			       PANEL_LABEL_STRING, paneltabs[494],
			       0);
    conv_ligne = panel_create_item (panel_linearflt, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(1),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[484],
		       PANEL_VALUE,(conv != NULL ? 
		     (char *)sprintf(repfloat,"%d",conv->ligne) : ""), 
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_linear_filter,
                       0);
    conv_colonne = panel_create_item (panel_linearflt, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[485],
		       PANEL_VALUE,(conv != NULL ? 
		    (char *)sprintf(repfloat,"%d",conv->colonne) : ""),
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_linear_filter,
                       0);
    window_fit (panel_linearflt);
    window_fit (frame_linearflt);
    window_set (panel_linearflt, PANEL_CARET_ITEM, conv_ligne, 0);
    conv = (struct convol*)window_loop(frame_linearflt);
    return (conv);
}

/*****************************************************************************/

static Panel_setting lire_linear_filter (item, event)
    Panel_item item;
    Event *event;

{
    int f;
    static struct convol conv = {0, 0, 1};

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_linearflt);
        return;
    }
    else { 
        f = atoi ((char *) panel_get (item, PANEL_VALUE));
        if (item==conv_ligne) {
	   conv.ligne = f;
	   if (conv.ligne % 2 != 0 || conv.ligne == 0) {
	       panel_set_value (item, "");
	       return;
	   }
	}	     
	else if (item==conv_colonne) {
	   conv.colonne = f;
	   if (conv.colonne % 2 != 0 || conv.colonne == 0) {
	       panel_set_value (item, "");
	       return;
	   }
	}
        if (event_id(event) == '\t') 
	    return(PANEL_NEXT);
	else {
            window_return(&conv);
	    window_destroy (frame_linearflt);
	    return;
	}
    }
}

/*****************************************************************************/

caddr_t proc_puissance (m, mi)

    Menu m;
    Menu_item mi;

{
    float angle, pi, *cosine, *sine, p, step;
    int i, j, side, k, n, size_file, size_table, r;
    int lup, ldn, clft, crgt;
    float  **tab, *bp, sum, sum1;
    struct rayon_puissan *r_p, *copyr_p;
    float *im;
    int flag_conv;


    if (flag_bother) {
	hproc_puissance();
	return;
    }
    if (flag_help)  hproc_puissance();
    if (!flag_creer){ 
	sprintf (buf, mastertabs[292]);
	write_master (buf);
    }
    
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto(FROM, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	r_p = (struct rayon_puissan*) malloc(sizeof (*r_p));
	*r_p = *((struct rayon_puissan *)macro_cour->param);
    }
    else r_p = radius_energy(0);
    if (flag_break){
	interruption();
	return;
    }
    if (r_p->p_energy == 0){
	write_erreur(95);
	return;
    }

    if (flag_creer){
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "MEAPOWCPO");
	com->code = 33;
	com->from[0] = index_image[0];
	sprintf(buf, "%s FROM %d WITH %f\n",
		com->nom, index_image[0], r_p->p_energy);
	write_macro(buf);
	copyr_p = (struct rayon_puissan *) malloc(sizeof(*copyr_p));
	*copyr_p = *r_p;
	com->param = (char *)copyr_p;	
    }
    else {
	sprintf (buf, "--> %d ", index_image[0]);
	write_master (buf);
	if (dir_image[index_image[0]].image == NULL){
	    write_erreur(0);
	    return;
	}

	if (dir_desc[index_image[0]].type == 3){
	    im = (float *)dir_image[index_image[0]].image;
	    flag_conv = FALSE;
	}
	else{
	    im = (float *)conv_float(index_image[0]);
	    flag_conv = TRUE;
	}
	if (dir_desc[index_image[0]].nligne != dir_desc[index_image[0]].ncolonne){
	    write_erreur(19);
	    return;
	}
	    
	else if (power_2(dir_desc[index_image[0]].nligne) == FALSE){
	    write_erreur(15);
	    return;
	}

	sprintf (buf, "(%.4f)\n", r_p->p_energy);
	write_master(buf);
	p = r_p->p_energy;
	pi = PI;
	side = (int)dir_desc[index_image[0]].nligne;
	step = (float)1 / side;   /* angle step for sine & cosine table */
	size_table = (int)(pi / 2/ step) + 1; 
	cosine = (float *)malloc(size_table * 4);
	sine = (float *)malloc(size_table * 4);
	angle = 0;
	n = 0;
	while (angle < pi / 2) {
	    cosine[n] = (float)cos(angle);
	    sine[n] = (float)sin(angle);
	    angle = angle + step;
	    n++;
	}			     /* create sine & cosine table */

	tab = (float **)calloc(side, sizeof(float *));
	for (i = 0; i < side ; i++)
	    tab[i] = (float *)calloc(side, sizeof(float));
	sum = 0;
        bp = im;    
	for (i = 0; i < side; i++){
	    for (j = 0; j < side; j++){
		tab[i][j] = (*bp) * (*bp);
		sum = sum + tab[i][j];
		bp++;
	    }
	}		    /* calculate energy of the whole module*/

	sum1 = 0;
	for (j = 0; j < side; j++) {
	    sum1 += tab[0][j];
	    tab[0][j] = 0; 
	}
	r = side / 2;
	for (n = 0; n < size_table ; n++)
	{
	    i = (int)(r * (float)sine[n]);
	    j = (int)(r * (float)cosine[n]);
	    crgt = side / 2 + j;
	    clft = side / 2 - j;
	    lup = side / 2 - i;
	    ldn = side / 2 + i;
	    if (ldn < side) {
		if (crgt < side) {
		    for (k = crgt; k < side; k++) {
			sum1 = sum1 + tab[ldn][k];
			tab[ldn][k] = 0;
		    }
	    }				/* right, down */
	    for (k = clft; k >= 0; k--) {
	        sum1 = sum1 + tab[ldn][k];
	        tab[ldn][k] = 0; 
	    }				/* left, down  */
	}
	if (crgt < side) {
	    for (k = crgt; k < side; k++) {
	        sum1 = sum1 + tab[lup][k];
	     	tab[lup][k] = 0;	/* right, up */
	    }
	}
        for (k = clft; k >= 0; k--) {
	    sum1 = sum1 + tab[lup][k];
	    tab[lup][k] = 0;		/* left, up  */
	}
    }
    if (sum1 >= sum - sum * p) goto found;
 
    for (r = side / 2 - 1; r > 0; r--) {
        for (n = 0; n < size_table ; n++){
	    i = (int)(r * (float)sine[n]);
	    j = (int)(r * (float)cosine[n]);
	    crgt = side / 2 + j;
	    clft = side / 2 - j;
	    lup = side / 2 - i;
	    ldn = side / 2 + i;
	    if (ldn < side) {
		if (crgt < side) {
		    for (k = crgt; k < side; k++) {
			sum1 = sum1 + tab[ldn][k];
			tab[ldn][k] = 0;
			}
		}			/* right, down */
		for (k = clft; k >= 0; k--) {
		    sum1 = sum1 + tab[ldn][k];
		    tab[ldn][k] = 0; 
		}			/* left, down  */
	    }
	    if (crgt < side) {
		for (k = crgt; k < side; k++) {
		    sum1 = sum1 + tab[lup][k];
		    tab[lup][k] = 0;	
		}			/* right, up */
	    }
	    for (k = clft; k >= 0; k--) {
		sum1 = sum1 + tab[lup][k];
		tab[lup][k] = 0;
	    }				/* left, up  */
	}
	if (sum1 >= sum - sum * p) goto found;
    }
    found:  free(cosine);
	    free(sine);
	    for (i = 0; i < side + 1; i++)
		free(tab[i]);
	    free(tab);
    sprintf (buf,  mastertabs[293],r - 1);
    write_master (buf);
    if ((flag_conv) || (flag_autoconvert)){
	    free (im);
	    flag_conv = TRUE;
	    flag_autoconvert = TRUE;
    }
    }
}

/*****************************************************************************/

caddr_t proc_cut_frequncy(m, mi)

    Menu m;
    Menu_item mi;

{
    float angle, pi, *cosine, *sine, step;
    int n, i, j, side, k, size_table, r2, r;
    int lup, ldn, clft, crgt;
    struct rayon_puissan *r_p, *copyr_p;
    float *br, *bi, **tabr, **tabi, *brr, *bri;


    if (flag_bother) {
	 hproc_couper_freq();
	return;
    }
    if (flag_help) hproc_couper_freq();
    if (!flag_creer){ 
	sprintf (buf, mastertabs[294]);
	write_master (buf);
    }
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
	index_image[2] = macro_cour->from[1];
	index_image[3] = macro_cour->to[1];
    }
    else fromto (FROMTO, COMPL1);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	r_p = (struct rayon_puissan*) malloc(sizeof (*r_p));
	*r_p = *((struct rayon_puissan *)macro_cour->param);
    }
    else r_p = radius_energy(1);
    if (flag_break){
	interruption();
	return;
    }
/*    if (r_p->p_energy == 0){
	write_erreur(95);
	return;
    } */
    if (flag_creer){
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "MEAPOWCFR");
	com->code = 34;
	com->from[0] = index_image[0];
	com->from[1] = index_image[2];
	com->to[0] = index_image[1];
	com->to[1] = index_image[3];
	sprintf(buf, "%s FROM %d %d TO %d %d WITH %d\n",
		com->nom, index_image[0], index_image[2],
		index_image[1], index_image[3], r_p->r_frequency);
	write_macro(buf);
	copyr_p = (struct rayon_puissan *) malloc(sizeof(*copyr_p));
	*copyr_p = *r_p;
	com->param = (char *)copyr_p;	
    }
    else{ /* !flag_creer */
	sprintf (buf, "(%d,%d)-->(%d,%d)", index_image[0], 
		index_image[2], index_image[1], index_image[3]);
	write_master (buf);
	if (dir_desc[index_image[0]].type !=3 
	  || dir_desc[index_image[2]].type !=3)
	    write_erreur(14);
	else if	(dir_desc[index_image[0]].nligne != 
		dir_desc[index_image[2]].nligne
	    || dir_desc[index_image[0]].ncolonne != 
	       dir_desc[index_image[2]].ncolonne)
	    write_erreur(2);
	else if (power_2(dir_desc[index_image[0]].nligne) == 
		 FALSE 
	      || power_2(dir_desc[index_image[0]].ncolonne) == 
		 FALSE)
	    write_erreur(15);
	else if (dir_desc[index_image[0]].nligne != 
		 dir_desc[index_image[0]].ncolonne)
	    write_erreur(19);
	else { /* tout est bon */
	    sprintf (buf,mastertabs[295], r_p->r_frequency);
	    write_master(buf);
	    r2 = r_p->r_frequency;
	    side = (int)dir_desc[index_image[0]].nligne;

	    pi = PI;
	    step = (float)1 / side; 
	    size_table = (int)(pi / 2 / step) + 1; 
	    cosine = (float *)malloc(size_table * 4);
	    sine = (float *)malloc(size_table * 4);
	    angle = 0;
	    n = 0;
	    while (angle < pi / 2) {
		cosine[n] = (float)cos(angle);
		sine[n] = (float)sin(angle);
		angle = angle + step;
		n++;
	    }		    /* create sine & cosine table */
	
	    tabr = (float **)calloc(side, sizeof(float *));
	    tabi = (float **)calloc(side, sizeof(float *));
	    for (i = 0; i < side; i++){
		tabr[i] = (float *)calloc(side, sizeof(float));
		tabi[i] = (float *)calloc(side, sizeof(float));
	    }
	    br = (float *)dir_image[index_image[0]].image;
	    bi = (float *)dir_image[index_image[2]].image;
	    for (i = 0; i < side; i++)
		for (j = 0; j < side; j++) {
		    tabr[i][j] = *br;
		    tabi[i][j] = *bi;
		    bi++; br++;
		}

	    for (j = 0; j < side; j++) {
		tabr[0][j] = 0;
		tabi[0][j] = 0;
	    }
	    if (r2 <= side / 2) {
		for (r = side / 2; r > r2; r--) {
		    for (n = 0; n < size_table ; n++) {
			i = (int)(r * (float)sine[n]);
			j = (int)(r * (float)cosine[n]);
			crgt = side / 2 + j;
			clft = side / 2 - j;
			lup = side / 2 - i;
			ldn = side / 2 + i;
			if (ldn < side) {
			    if (crgt < side) {
				for (k = crgt; k < side; k++) {
				    tabr[ldn][k] = 0;
				    tabi[ldn][k] = 0;
				}
			    }			/* right, down */
			    for (k = clft; k >= 0; k--) {
				tabr[ldn][k] = 0;
				tabi[ldn][k] = 0;
			    }			/* left, down  */
			}
			if (crgt < side) {
			    for (k = crgt; k < side; k++) {
				tabr[lup][k] = 0;	
				tabi[lup][k] = 0;	
			    }			/* right, up */
			}
			for (k = clft; k >= 0; k--) {
			    tabr[lup][k] = 0;
			    tabi[lup][k] = 0;
			}	/* left, up  */
		    }
		}
	    }
	    brr = (float *)calloc(side * side, sizeof(float));
	    bri = (float *)calloc(side * side, sizeof(float));

	    dir_image[index_image[1]].image = (unsigned char *)brr;
	    dir_image[index_image[3]].image = (unsigned char *)bri;
	    for (i = 0; i < side; i++)
		for (j = 0; j < side; j++) {
		    *brr = tabr[i][j];
		    *bri = tabi[i][j];
		    brr++; bri++;
		}

	    free(sine); free(cosine);
	    for (i = 0; i < side; i++) {
		free(tabr[i]);  free(tabi[i]);
	    }
	    free(tabr); free(tabi); 

	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[3]] = dir_desc[index_image[2]];
	    statis (dir_image[index_image[1]].image,
		dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
	    statis (dir_image[index_image[3]].image,
        	dir_desc[index_image[3]].type, 
	        dir_desc[index_image[3]].nligne,
	        dir_desc[index_image[3]].ncolonne,
		&(dir_desc[index_image[3]].mmin),
		&(dir_desc[index_image[3]].mmax), 
	        &(dir_desc[index_image[3]].mu),
		&(dir_desc[index_image[3]].ecart));
	}
    }
}

/*****************************************************************************/

caddr_t proc_hamming(m, mi)

    Menu m;
    Menu_item mi;

{
    int i, j, lin, col, diamet, inv;
    struct rayon_puissan *r_p, *copyr_p;
    float *bc, *rp, *ip, *rp1, *ip1;


    inv = ((int)menu_get(mi, MENU_VALUE)); 
    if (flag_bother) {
	if (inv == 1) hproc_filtre_hamming();
	else hproc_filtre_hanning();
	return;
    }
    if (flag_help){
	if (inv == 1) hproc_filtre_hamming();
	else hproc_filtre_hanning();
    }
    if (!flag_creer){
	if (inv == 1) sprintf (buf, mastertabs[296]);
	else sprintf (buf, mastertabs[300]);
	write_master (buf);
    }
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[2] = macro_cour->from[1];
	index_image[1] = macro_cour->to[0];
	index_image[3] = macro_cour->to[1];
    }
    else fromto (FROMTO, COMPL1);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	r_p = (struct rayon_puissan *) malloc(sizeof (*r_p));
	*r_p = *((struct rayon_puissan *)macro_cour->param);
    }
    else {
	if (inv == 1) r_p = radius_energy(3);
	else r_p = radius_energy(4);
    }
    if (flag_break){
	interruption();
	return;
    }
    if (flag_creer){	
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	if (inv == 1){ 
	   strcpy(com->nom, "PREENHFFDHAM");
	   com->code = 183;
	}
	else {
	   strcpy(com->nom, "PREENHFFDHAN");
	   com->code = 184;
	}
	com->from[0] = index_image[0];
	com->from[1] = index_image[2];
	com->to[0] = index_image[1];
	com->to[1] = index_image[3];
	sprintf(buf, "%s FROM %d %d TO %d %d WITH %d\n",
		com->nom, index_image[0], index_image[2],
		index_image[1], index_image[3],r_p->r_frequency);
	write_macro(buf);
	copyr_p = (struct rayon_puissan *) malloc(sizeof(*copyr_p));
	*copyr_p = *r_p;
	com->param = (char *)copyr_p;
	
    }
    else { /*flag_creer */
	sprintf (buf, "(%d,%d)-->(%d,%d)", 
             index_image[0], index_image[2], index_image[1],
	     index_image[3]);
	write_master (buf);
	if (dir_desc[index_image[0]].type !=3 || dir_desc[index_image[2]].type !=3)
	    write_erreur(14);
	else if (dir_desc[index_image[0]].nligne != dir_desc[index_image[2]].nligne
	    || dir_desc[index_image[0]].ncolonne != dir_desc[index_image[2]].ncolonne)
	write_erreur(2);
	else if (power_2(dir_desc[index_image[0]].nligne) == FALSE ||
             power_2(dir_desc[index_image[0]].ncolonne) == FALSE)
	    write_erreur(15);
	else 
	if (dir_desc[index_image[0]].nligne != dir_desc[index_image[0]].ncolonne)
	    write_erreur(19);
    else {
	
	sprintf (buf, mastertabs[295], r_p->r_frequency);
	write_master(buf);
	diamet = r_p->r_frequency * 2;
	dir_desc[index_image[1]] = dir_desc[index_image[0]];
	dir_desc[index_image[3]] = dir_desc[index_image[2]];
	lin = col = (int)dir_desc[index_image[0]].nligne;
	bc = (float *)calloc(lin * col, sizeof(float));
	if (inv == 1) winhamming(bc, col, lin, diamet);
	else winhanning(bc, col, lin, diamet);
	rp = (float *)calloc(lin * col, sizeof(float));
	ip = (float *)calloc(lin * col, sizeof(float));
	rp1 = (float *)dir_image[index_image[0]].image;
	ip1 = (float *)dir_image[index_image[2]].image;
	for (i = 0; i < lin; i++)
	{
	    for (j = 0; j < col; j++)
	    {
		rp[i * col + j] = rp1[i * col + j] * bc[i * col + j];
		ip[i * col + j] = ip1[i * col + j] * bc[i * col + j];
	    }
	}   /*multiply hamming window with real&imagenary plane respectively*/

        dir_image[index_image[1]].image = (unsigned char *)rp;
        dir_image[index_image[3]].image = (unsigned char *)ip;
	free (bc);
        statis (dir_image[index_image[1]].image,
		dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
        statis (dir_image[index_image[3]].image,
		dir_desc[index_image[3]].type, 
	        dir_desc[index_image[3]].nligne,
	        dir_desc[index_image[3]].ncolonne,
		&(dir_desc[index_image[3]].mmin),
		&(dir_desc[index_image[3]].mmax), 
	        &(dir_desc[index_image[3]].mu),
		&(dir_desc[index_image[3]].ecart));
       }
    }
}

/*****************************************************************************/

caddr_t proc_gaussian(m, mi)

    Menu m;
    Menu_item mi;

{
    int i, j, lin, col, MINT;
    struct gaussian_p *gp, *copygp;
    float *bc, *rp, *ip, *rp1, *ip1, EN;


    if (flag_bother) {
	 hproc_filtre_gauss();
	return;
    }
    if (flag_help) hproc_filtre_gauss();
    if (!flag_creer){ 
	sprintf (buf, mastertabs[297]);
	write_master (buf);
    }
  
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[2] = macro_cour->from[1];
	index_image[1] = macro_cour->to[0];
	index_image[3] = macro_cour->to[1];
    }
    else fromto (FROMTO, COMPL1);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	gp = (struct gaussian_p *) malloc(sizeof (*gp));
	*gp = *((struct gaussian_p *)macro_cour->param);
    }
    else gp = shape_of_gaus();	  /* parameters of gaussian window */
    if (flag_break){
	interruption();
	return;
    }
    if ((gp->mint == 0) || gp->en_mint == 0){
	write_erreur(97);
	return;
    }
    if (flag_creer){	
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "PREENHFFDGAU");
	com->code = 186;
	com->from[0] = index_image[0];
	com->from[1] = index_image[2];
	com->to[0] = index_image[1];
	com->to[1] = index_image[3];
	sprintf(buf, "%s FROM %d %d TO %d %d WITH %d %f\n",
		com->nom, index_image[0], index_image[2],
		index_image[1], index_image[3],gp->mint, gp->en_mint);
	write_macro(buf);
	copygp = (struct gaussian_p *) malloc(sizeof(*copygp));
	*copygp = *gp;
	com->param = (char *)copygp;
	
    }
    else{ /* !flag_creer */	    
	sprintf (buf, " (%d,%d)-->(%d,%d)", 
			index_image[0], index_image[2], 
			index_image[1], index_image[3]);
	write_master (buf);
	if (dir_image[index_image[0]].image == NULL)
	    write_erreur(1);
	else if (dir_image[index_image[0]].image == NULL)
	    write_erreur(2);
	else if (dir_desc[index_image[0]].type !=3 
	    || dir_desc[index_image[2]].type !=3)
	    write_erreur(14);
	else if (dir_desc[index_image[0]].nligne 
		!= dir_desc[index_image[2]].nligne
	    || dir_desc[index_image[0]].ncolonne 
		!= dir_desc[index_image[2]].ncolonne)
	    write_erreur(2);
	else if (power_2(dir_desc[index_image[0]].nligne) == FALSE 
	    || power_2(dir_desc[index_image[0]].ncolonne) == FALSE)
	    write_erreur(15);
	else if (dir_desc[index_image[0]].nligne 
		!= dir_desc[index_image[0]].ncolonne)
	    write_erreur(19);
	else { /* tout est bon */
	    sprintf (buf, "diam=%d,param=%.4f\n", gp->mint, gp->en_mint);
	    write_master (buf);
	    MINT = gp->mint;
	    EN = gp->mint * gp->en_mint;
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    dir_desc[index_image[3]] = dir_desc[index_image[2]];
	    lin = col = (int)dir_desc[index_image[0]].nligne;
	    bc = (float *)calloc(lin * col, sizeof(float));
	    wingauss(bc, col, lin, EN, MINT);
	    rp = (float *)calloc(lin * col, sizeof(float));
	    ip = (float *)calloc(lin * col, sizeof(float));
	    rp1 = (float *)dir_image[index_image[0]].image;
	    ip1 = (float *)dir_image[index_image[2]].image;
	    for (i = 0; i < lin; i++)
	    {
		for (j = 0; j < col; j++)
		{
		    rp[i * col + j] = rp1[i * col + j] * bc[i * col + j];
		    ip[i * col + j] = ip1[i * col + j] * bc[i * col + j];
		}
	    }  /*multiply gaussian window with real&imagenary plane respectively*/

	    dir_image[index_image[1]].image = (unsigned char *)rp;
	    dir_image[index_image[3]].image = (unsigned char *)ip;
	    free (bc);
	    statis (dir_image[index_image[1]].image,
		dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
	    statis (dir_image[index_image[3]].image,
		dir_desc[index_image[3]].type, 
	        dir_desc[index_image[3]].nligne,
	        dir_desc[index_image[3]].ncolonne,
		&(dir_desc[index_image[3]].mmin),
		&(dir_desc[index_image[3]].mmax), 
	        &(dir_desc[index_image[3]].mu),
		&(dir_desc[index_image[3]].ecart));
	}
    }
}

/*****************************************************************************/

caddr_t proc_ordr1_interp(m, mi)

    Menu m;
    Menu_item mi;
{
    float **bc, *bcr, *interp, *p;
    int d, lin, col, nlin, ncol, stpoint, i, j, l, c, llm, clm;
    struct rayon_puissan *r_p, *copyr_p;
    float *im;
    int flag_conv;

    if (flag_bother) {
	 hproc_interpol_ordre1();
	return;
    }
    if (flag_help) {
	 hproc_interpol_ordre1();
    }
    if (!flag_creer){ 
	sprintf (buf, mastertabs[298]);
	write_master (buf);
    }
    
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto(FROMTO, DEFAUT);
    if (flag_break){
	interruption();
	return;
    }
    if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	r_p = (struct rayon_puissan*) malloc(sizeof (*r_p));
	*r_p = *((struct rayon_puissan *)macro_cour->param);
    }
    else r_p = radius_energy(2);
    if (flag_break){
	interruption();
	return;
    }
    else if (r_p->n_point == 0){
	write_erreur(97);
	return;
    }
    if (flag_creer){
	struct commande *com;
	com = (struct commande *) new_commande(&macro_cour);
	strcpy(com->nom, "AUXMODENL1OI");
	com->code = 1252;
	com->from[0] = index_image[0];
	com->to[0] = index_image[1];
	sprintf(buf, "%s FROM %d TO %d WITH %d \n",
		com->nom, index_image[0], index_image[1],
		r_p->n_point);
	write_macro(buf);
	copyr_p = (struct rayon_puissan *) malloc(sizeof(*copyr_p));
	*copyr_p = *r_p;
	com->param = (char *)copyr_p;
    }
    else { /* !flag_creer */
	sprintf (buf, "%d --> %d", index_image[0], index_image[1]);
	write_master (buf);
	if (dir_desc[index_image[0]].type == 3){
	    im = (float *)dir_image[index_image[0]].image;
	    flag_conv = FALSE;
	}
	else{
	    im = (float *)conv_float(index_image[0]);
	    flag_conv = TRUE;
	}
	sprintf (buf, ", fact= %d\n", r_p->n_point);
	write_master (buf);    
	d = r_p->n_point;
	lin = (int)dir_desc[index_image[0]].nligne;
	col = (int)dir_desc[index_image[0]].ncolonne;
	bc = (float **)calloc(lin, sizeof(float *));
	for (i = 0; i < lin; i++) {
	    bc[i] = (float *)calloc(col, sizeof(float));
	}
	p = im;
	for (i = 0; i < lin; i++)
	    for (j = 0; j < col; j++) {
		bc[i][j] = *p;
		p++;
	    }

	nlin = lin * (d + 1);		    /* new lin */
	ncol = col * (d + 1);		    /* new col */
	bcr = (float *)calloc(nlin * ncol, sizeof(float));
	dir_image[index_image[1]].image = (unsigned char *)bcr;
	interp = (float *)calloc((d + 2) * (d + 2), sizeof(float)); 
			    /* buffer of interpolation */ 
	for (i = 0; i < lin - 1; i++) {
	    for (j = 0; j < col - 1; j++) {
		stpoint = i * ncol * (d + 1) + j * (d + 1);
		p = interp;
		bilinear_interp(bc[i][j],
				bc[i][j + 1],
				bc[i + 1][j + 1],
				bc[i + 1][j],
				d + 1,
				d + 1,
				interp);	/* create one block */
		if (j == col - 2) clm = d + 2;
		else clm = d + 1;
		if (i == lin - 2) llm = d + 2;
		else llm = d + 1;
		for (l = 0; l < llm; l++) {	/* insert this block */
		    for (c = 0; c < clm; c++) {
			bcr[stpoint + c] = *p;
			p++; 
		    }
		    if (j != col - 2) p++;
		    stpoint = stpoint + ncol;
		}
	    }
	}
	free(interp);
	for (i = 0; i < lin; i++)
	    free(bc[i]);
	free(bc);
	dir_desc[index_image[1]].nligne = nlin;
	dir_desc[index_image[1]].ncolonne = ncol;
	dir_desc[index_image[1]].type = 3;
        statis (dir_image[index_image[1]].image,
		dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
    if (flag_conv) free (im);
    }
}

/****************************************************************************/

struct rayon_puissan *radius_energy(flg)
short flg;
{
    char repstrg[10], titrestrg[50];
    struct rayon_puissan *r_en;

    strcpy (repstrg, "");
    frame_energy = window_create (frame, FRAME,
			        WIN_X, 500,
			        WIN_Y, 500,
				FRAME_NO_CONFIRM, TRUE,
				0);
    panel_energy = window_create (frame_energy, PANEL, 
				0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	r_en = (struct rayon_puissan *)(macro_cour->param);
    else r_en = NULL;

    switch (flg){
	case 0: strcpy(titrestrg, paneltabs[495]);
		break;
	case 1: strcpy(titrestrg, paneltabs[496]);
		break;
	case 2: strcpy(titrestrg, paneltabs[497]);
		break;
	case 3: strcpy(titrestrg, paneltabs[498]);
		break;
	case 4: strcpy(titrestrg, paneltabs[499]);
		break;
    }

    puissan_titre = panel_create_item(panel_energy, PANEL_MESSAGE,
			       PANEL_LABEL_X, ATTR_COL(0),
			       PANEL_LABEL_Y, ATTR_ROW(0),
			       PANEL_LABEL_STRING, titrestrg,
			       PANEL_LABEL_BOLD, TRUE,
			       0);
    pcnt_of_energy = panel_create_item (panel_energy, PANEL_TEXT,
		PANEL_SHOW_ITEM, FALSE,
		PANEL_ITEM_X, ATTR_COL(1),
		PANEL_ITEM_Y, ATTR_ROW (1),
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 8,
		PANEL_LABEL_STRING, paneltabs[486],
		PANEL_VALUE,(r_en != NULL ? 
		   (char *)sprintf(repstrg,"%d",r_en->p_energy) : ""), 
		PANEL_NOTIFY_STRING, "\n\r\03",
		PANEL_NOTIFY_PROC, lire_pcnt_puisan, 
		0);
    r_of_spctrm = panel_create_item (panel_energy, PANEL_TEXT,
		PANEL_SHOW_ITEM, FALSE,
		PANEL_ITEM_X, ATTR_COL(1),
		PANEL_ITEM_Y, ATTR_ROW(2),
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 8,
		PANEL_LABEL_STRING, paneltabs[487],
		PANEL_VALUE,(r_en != NULL ? 
		   (char *)sprintf(repstrg,"%d",r_en->r_frequency) : ""), 
		PANEL_NOTIFY_STRING, "\n\r\03",
		PANEL_NOTIFY_PROC, lire_pcnt_puisan, 
		0);
    n_of_interpl = panel_create_item (panel_energy, PANEL_TEXT,
		PANEL_SHOW_ITEM, FALSE,
		PANEL_ITEM_X, ATTR_COL(1),
		PANEL_ITEM_Y, ATTR_ROW(3),
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 8,
		PANEL_LABEL_STRING, paneltabs[488],
		PANEL_VALUE,(r_en != NULL ? 
		   (char *)sprintf(repstrg,"%d",r_en->n_point) : ""), 
		PANEL_NOTIFY_STRING, "\n\r\03",
		PANEL_NOTIFY_PROC, lire_pcnt_puisan, 
		0);
    window_fit (panel_energy);
    window_fit (frame_energy);
    switch (flg) {
    case 0:
	panel_set(pcnt_of_energy, PANEL_SHOW_ITEM, TRUE, 0);
	window_set (panel_energy, PANEL_CARET_ITEM, pcnt_of_energy, 0);
	break;
    case 1: case 3: case 4:
	panel_set(r_of_spctrm, PANEL_SHOW_ITEM, TRUE, 0);
	window_set (panel_energy, PANEL_CARET_ITEM, r_of_spctrm, 0);
	break;
    case 2:
	panel_set(n_of_interpl, PANEL_SHOW_ITEM, TRUE, 0);
	window_set (panel_energy, PANEL_CARET_ITEM, n_of_interpl, 0);
	break;
    }
    r_en = (struct rayon_puissan *)window_loop(frame_energy); 
    return (r_en);
}

/*****************************************************************************/

static Panel_setting lire_pcnt_puisan (item, event)

    Panel_item item;
    Event *event;

{
    static struct rayon_puissan r_p = {0, 0, 0};
    char rep[20];

    if (event_id(event) == CTRLC) {
       /*  demande d'interruption de l'interaction par l'utilisateur */ 
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_energy);
        return;
    }
    else { 
        strcpy (rep, (char *) panel_get (item, PANEL_VALUE));
	if (item == pcnt_of_energy) {
	    r_p.p_energy = atof(rep);
	    if (r_p.p_energy > 0 && r_p.p_energy < 1) {
		window_return (&r_p);
		window_destroy (frame_energy);
		return;
	    }
	    else {
		panel_set_value (item, "");
		return;
	    }
	}
	else if (item == r_of_spctrm) {
		 r_p.r_frequency = (int) atoi(rep);
	/*	 printf("%d\n",r_p.r_frequency); */
		 if (r_p.r_frequency != 0 &&
		    r_p.r_frequency <= dir_desc[index_image[0]].nligne/2){
		     window_return (&r_p);
		     window_destroy (frame_energy);
		     return;
		 }
		 else {
		 panel_set_value (item, "");
		 return;
		 }
	}
	else if (item == n_of_interpl) {
		r_p.n_point = atoi(rep);
		window_return (&r_p);
		window_destroy (frame_energy);
		return;
	}
    }
}
/****************************************************************************/

struct gaussian_p *shape_of_gaus()
{
    char repstrg[10];
    struct gaussian_p *gp;

    strcpy (repstrg, "");
    frame_shape = window_create (frame, FRAME,
			        WIN_X, 500,
			        WIN_Y, 500,
				FRAME_NO_CONFIRM, TRUE,
				0);
    panel_shape = window_create (frame_shape, PANEL, 
				0);
    gauss_titre = panel_create_item(panel_shape, PANEL_MESSAGE,
			       PANEL_LABEL_X, ATTR_COL(0),
			       PANEL_LABEL_Y, ATTR_ROW(0),
			       PANEL_LABEL_STRING, paneltabs[500],
			       PANEL_LABEL_BOLD, TRUE,
			       0);
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	gp = (struct gaussian_p *)(macro_cour->param);
    else gp = NULL;
    diam_window = panel_create_item (panel_shape, PANEL_TEXT,
		PANEL_SHOW_ITEM, TRUE,
		PANEL_ITEM_X, ATTR_COL(1),
		PANEL_ITEM_Y, ATTR_ROW (1),
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 8,
		PANEL_LABEL_STRING, paneltabs[489],
		PANEL_VALUE,(gp != NULL ? 
		(char *)sprintf(repstrg,"%d",gp->mint) : ""), 
		PANEL_NOTIFY_STRING, "\r\n\t\03",
		PANEL_NOTIFY_PROC, lire_shape, 
		0);
    shap_window = panel_create_item (panel_shape, PANEL_TEXT,
		PANEL_SHOW_ITEM, TRUE,
		PANEL_ITEM_X, ATTR_COL(1),
		PANEL_ITEM_Y, ATTR_ROW(2),
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 8,
		PANEL_LABEL_STRING, paneltabs[490],
		PANEL_VALUE,(gp != NULL ? 
		(char *)sprintf(repstrg,"%d",gp->en_mint) : ""), 
		PANEL_NOTIFY_STRING, "\r\n\t\03",
		PANEL_NOTIFY_PROC, lire_shape, 
		0);
    window_fit (panel_shape);
    window_fit (frame_shape);
    window_set (panel_shape, PANEL_CARET_ITEM, diam_window, 0);
    gp = (struct gaussian_p *)window_loop(frame_shape); 
    return (gp);
}

/*****************************************************************************/

static Panel_setting lire_shape (item, event)
    Panel_item item;
    Event *event;

{
    char rep[20];
    static struct gaussian_p gp = {0, 0};

    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_shape);
        return;
    }
    else { 
        strcpy (rep, (char *) panel_get (item, PANEL_VALUE));
        if (item==diam_window) {
	   gp.mint = atoi(rep);
	   if (gp.mint==0 || gp.mint > dir_desc[index_image[0]].nligne) {
	       panel_set_value (item, "\0");
	       return;
	   }
	}
	else if (item==shap_window) {
	   gp.en_mint = atof(rep);
	   if (gp.en_mint == 0) {
	       panel_set_value (item, "\0");
	       return;
	   }
	}
        if (event_id(event) == '\t') 
	    return(PANEL_NEXT);
	else {
            window_return(&gp);
	    window_destroy (frame_shape);
	    return;
	}
    }
}

