/*
 * $Id: fzk.h,v 1.2.2.1 1999/02/08 03:10:59 yamasita Exp $
 */

/*
 * FreeWnn is a network-extensible Kana-to-Kanji conversion system.
 * This file is part of FreeWnn.
 * 
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991, 1992
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991, 1992, 1999
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991, 1992
 *
 * Author: OMRON SOFTWARE Co., Ltd. <freewnn@rd.kyoto.omronsoft.co.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Emacs; see the file COPYING.  If not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Commentary:
 *
 * Change log:
 *
 * Last modified date: 8,Feb.1999
 *
 * Code:
 *
 */
/*	Version 4.0
 */
/*
 * fzk.h
 */

#define	YOMI_L	8		/* °ɤߤĹκ */

#define STRK_L	128		/* °ϤΤκΰ礭 */
				/* 줬°ʸĹκ */

/* °٥ȥι¤ */
struct	fzkvect	{
	int	no;			/* °٥ȥֹ */
	int	vector[VECT_L];		/* °٥ȥ */
};

/* °쥨ȥ꡼ι¤ */
struct	fzkentry {
	w_char	yomi[YOMI_L];		/* °ɤߤʸ */
	int	yomi_su;		/* °ɤߤʸĹ */
	int	kosu;			/* °٥ȥθĿ */
	struct	fzkvect	*pter;		/* °٥ȥؤΥݥ */
	struct	fzkentry *link;		/* °쥨ȥ꡼ؤΥݥ */
};

/* °θ̤ξι¤ */
struct	fzkken {
	struct	fzkentry *ent_ptr;	/* °쥨ȥ꡼ؤΥݥ */
	int	vector[VECT_L];		/* °٥ȥ */
};

/* °ϤΤκΰι¤ */
struct	fzkwork {
	int	vector[VECT_L];		/* °٥ȥ */
};


/*
	structure of FZK TABLE
 */
struct FT {
#ifndef NO_FZK
	struct	fzkvect		*vect_area;
#endif
	struct	kangovect	*kango_vect_area;
#ifndef NO_FZK
	struct	fzkentry	*tablefuzokugo;
#endif
	int			*kango_hinsi_area;
	int	fzkvect_l;			/* ³٥Ĺ * 32 bit */
	int	kango_vect_l;			/* ٥Ĺ * 32 bit */
#ifndef NO_FZK
	int	fzklength;			/* ° */
#endif
};
