/* copyright 1987, 1988, 1989. 1990 Phil Andrews */
/* Pittsburgh Supercomputing Center, all rights reserved */
/* the controlling module for the gplot program on a sun
   note that this is mostly a shell so that the main CGM module can be
   considered callable by other programs (inclusion of graphics with text) 
   */
#include <stdio.h>
#include <suntool/sunview.h> 
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <suntool/alert.h>
#define max_str 128
#define  version_str "4.3"
#define CANVAS_DEFAULT_SIZE 512
/* action procedures */
static void quit_proc();
static void format_proc(), next_proc(), redraw_proc(), prev_proc();
extern void sv_resize(); /* in sv.c */
static Panel_setting filename_proc();
/* Global SunView vairables */
extern Frame frame;		/* in sv.c */
extern Canvas canvas;		/* in sv.c */
extern Pixwin *pw, *frame_pw, *panel_pw;	/* in sv.c */
Panel my_panel;
static Pixfont *bold;
/* make the icon */
static Icon gplot_icon;
static short icon_image[] = {
#include "testicon"
};
mpr_static(testsv, 64, 64, 1, icon_image);
/* make the cursor */
static short cursor_image[] = {
#include "testcursor"
};
mpr_static(my_cursor, 16, 16, 1, cursor_image);
static Cursor old_cursor;
/* a few statics */
#define BINARY_FORMAT 0
#define CLEAR_FORMAT 1
static int cgm_format, file_open;
/* interface to wint.c */
extern int wint_initialise();
extern int wopen_file();
extern int wdraw_next_page();
/* interface to the device */
extern sv_setup();		/* in sv.c */
main(argc, argv)
     int argc;
     char **argv;
{
  if (!wint_initialise(argc, argv)) exit(0);

  if (!open_fonts(&bold)) {
    (void) fprintf(stderr, "couldn't open fonts !\n");
    exit(1);
  }
  /* make the icon */
  gplot_icon = icon_create(ICON_IMAGE, &testsv,
			   0);
  /* make the base frame */
  frame = window_create(NULL, FRAME,
			FRAME_LABEL, "Gplot",
			FRAME_ICON, gplot_icon,
			WIN_ERROR_MSG,  "Can't create a window.",
			FRAME_ARGS, argc, argv,
			FRAME_INHERIT_COLORS, TRUE,
			0);
  /* make the panel subwindow */
  make_panel_subwindow(&frame);
  /* make the canvas */
  canvas = window_create(frame, CANVAS,
			 WIN_X, 0,
			 WIN_BELOW, my_panel,
			 WIN_WIDTH, CANVAS_DEFAULT_SIZE,
			 WIN_HEIGHT, CANVAS_DEFAULT_SIZE,
			 CANVAS_WIDTH, CANVAS_DEFAULT_SIZE,
			 CANVAS_HEIGHT, CANVAS_DEFAULT_SIZE,
			 CANVAS_RETAINED, FALSE,
			 CANVAS_AUTO_EXPAND, TRUE,
			 CANVAS_AUTO_SHRINK, TRUE,
			 CANVAS_RESIZE_PROC, sv_resize,
			 0);
  /* make the pix window */
  pw = canvas_pixwin(canvas);
  panel_pw = (Pixwin *) window_get(my_panel, WIN_PIXWIN);
  frame_pw = (Pixwin *) window_get(frame, WIN_PIXWIN);
  window_fit(frame);
  window_set(canvas, WIN_WIDTH, WIN_EXTEND_TO_EDGE,
	     WIN_HEIGHT, WIN_EXTEND_TO_EDGE, 0);
  
  /* start the main loop */
  window_main_loop(frame);
  return(1);				/* may not get here */
  
}
static Panel_setting filename_proc(item, event)
     Panel_item item;
     Event *event;
{
  char got_name[max_str];
  /* open the input file */
  got_name[0] = '\0';
  strcpy(got_name, (char *) panel_get_value(item));
  file_open = wopen_file(got_name, cgm_format, sv_setup);
  return(1);
}
/* do the next picture */
static void next_proc()
{
  /* play with the cursor, show them we're working */
  old_cursor = window_get(my_panel, WIN_CURSOR);
  window_set(my_panel, WIN_CURSOR, cursor_create(CURSOR_IMAGE, &my_cursor, 0),
    0);
  /* draw the picture */
  wdraw_next_page(0);
 
  /* put the old cursor back */
  window_set(my_panel, WIN_CURSOR, old_cursor, 0);
}  
/* redraw picture */
static void redraw_proc()
{
  int win_wd, win_ht;
  /* play with the cursor, show them we're working */
  old_cursor = window_get(my_panel, WIN_CURSOR);
  window_set(my_panel, WIN_CURSOR, cursor_create(CURSOR_IMAGE, &my_cursor, 0),
    0);
  /* draw the picture */
  wdraw_next_page(-1);
 
  /* put the old cursor back */
  window_set(my_panel, WIN_CURSOR, old_cursor, 0);
}  
/* do the previous picture */
static void prev_proc()
{
  int win_wd, win_ht;
  /* play with the cursor, show them we're working */
  old_cursor = window_get(my_panel, WIN_CURSOR);
  window_set(my_panel, WIN_CURSOR, cursor_create(CURSOR_IMAGE, &my_cursor, 0),
    0);
  /* draw the picture */
  wdraw_next_page(-2);
 
  /* put the old cursor back */
  window_set(my_panel, WIN_CURSOR, old_cursor, 0);
}  


static void quit_proc()
{
  window_set(frame,
	     FRAME_NO_CONFIRM, TRUE,
	     0);
  window_destroy(frame);
}
static void format_proc(item, value, event)
     Panel_item item;
     int value;
     Event *event;
{
  switch(value) {
  case 0: cgm_format = BINARY_FORMAT; break;
  case 1: cgm_format = CLEAR_FORMAT; break;
  default: (void) fprintf(stderr, "unknown value %d\n", value); break;
  }
}

open_fonts(font1)
     Pixfont **font1;
{
#define FONT1 "/usr/lib/fonts/fixedwidthfonts/screen.b.12"
  
  if (!(*font1 = pf_open(FONT1))) {
    (void) fprintf(stderr, "can't pf_open font file %s !\n", FONT1);
    return(0);
  }
  return(1);
}
#undef FONT1

make_panel_subwindow(this_frame)
     Frame *this_frame;
{
  /* make the window */
  my_panel = window_create(*this_frame, PANEL,
			   WIN_FONT, bold,
			   PANEL_LAYOUT, PANEL_HORIZONTAL,
			   0);
  /* now populate it */
  panel_create_item(my_panel, PANEL_TEXT,
		    PANEL_LABEL_STRING, "File:",
		    PANEL_VALUE_DISPLAY_LENGTH, 40,
		    PANEL_NOTIFY_PROC, filename_proc,
		    0);
  panel_create_item(my_panel, PANEL_BUTTON,
		    PANEL_LABEL_IMAGE, panel_button_image
		    (my_panel, "Quit", 0, 0),
		    PANEL_NOTIFY_PROC, quit_proc,
		    0);
  panel_create_item(my_panel, PANEL_BUTTON,
		    PANEL_LABEL_IMAGE, panel_button_image
		    (my_panel, "Next Pic", 0, 0),
		    PANEL_NOTIFY_PROC, next_proc,
		    0);
  panel_create_item(my_panel, PANEL_BUTTON,
		    PANEL_LABEL_IMAGE, panel_button_image
		    (my_panel, "Prev Pic", 0, 0),
		    PANEL_NOTIFY_PROC, prev_proc,
		    0);
  panel_create_item(my_panel, PANEL_BUTTON,
		    PANEL_LABEL_IMAGE, panel_button_image
		    (my_panel, "Redraw", 0, 0),
		    PANEL_NOTIFY_PROC, redraw_proc,
		    0);
  panel_create_item(my_panel, PANEL_CYCLE,
		    PANEL_LABEL_STRING, "File Format",
		    PANEL_CHOICE_STRINGS, "Binary", "Clear Text", 0,
		    PANEL_NOTIFY_PROC, format_proc,
		    0);
  window_fit(my_panel); 
  return(1);
}
/* routine to handle informational/error message */
info_error(instr)
     char *instr;
{
  int alert_ret;
  alert_ret = alert_prompt(frame, (Event *) NULL,
			   ALERT_MESSAGE_STRINGS, 
			   instr,
			   0,
			   ALERT_BUTTON_YES, "OK",
			   ALERT_BUTTON_NO, "Quit",
			   0);
  switch(alert_ret) {
  case ALERT_YES: return;
  case ALERT_NO:  quit_proc();
  case ALERT_FAILED: quit_proc();
  }
}
