.TH XvGetPortAttribute __libmansuffix__ __vendorversion__
.SH Name
XvGetPortAttribute \- return current port attribute value
.\"
.SH Syntax
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "XvGetPortAttribute(Display *" dpy ", XvPortID " port ",
.BI "                   Atom " attribute ", int " p_value ");"
.fi
.SH Arguments
.\"
.IP \fIdpy\fR 12
Specifies the connection to the X server.
.IP \fIport\fR 12
Specifies the port, associated with the given display, for
which the attribute values are to be returned. 
.IP \fIattribute\fR 12
An atom that identifies the attribute to be queried by this
request.  Control atoms are obtained using the XInternAtom
request with a string from the following table.
.IP \fIp_value\fR 12
Pointer to the location where the attribute value is written on
return.
.\"
.SH Description
.\"
.PP
XvGetPortAttribute(__libmansuffix__) returns the current value of the requested
port attribute in the integer pointed to by \fIp_value\fR.  
The attribute is identified using an Atom that equates to the attribute name.  
The XInternAtom request can be used with one of the strings
below to return a matching Atom.
.bp
.PP
.\" .TS
.\" tab(@);
.\" lfHB lfHB lfHB
.\" lfR  lfR  lfR .
.\" _
.\" .PP
.\" .sp 4p
.\" Attribute String@Type@Default
.\" .sp 6p
.\" _
.\" .sp 6p
.\" "XV_ENCODING"@XvEncodingID@Server dependent
.\" "XV_HUE"@[-1000...1000]@0
.\" "XV_SATURATION"@[-1000...1000]@0
.\" "XV_BRIGHTNESS"@[-1000...1000]@0
.\" "XV_CONTRAST"@[-1000...1000]@0
.\" .sp 6p
.\" .TE
.nf
Attribute String        Type             Default

"XV_ENCODING"           XvEncodingID     Server dependent
"XV_HUE"                [-1000...1000]   0
"XV_SATURATION"         [-1000...1000]   0
"XV_BRIGHTNESS"         [-1000...1000]   0
"XV_CONTRAST"           [-1000...1000]   0
.fi
.SH Returned Values
.IP [Success] 8
Returned if XvGetPortAttribute(__libmansuffix__) completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if XvGetPortAttribute(__libmansuffix__) failed to allocate memory to process
the request.
.SH Diagnostics
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadMatch] 8
Generated if the requested attribute atom does not specify an attribute 
supported by the adaptor.
.SH See Also
.\"
XvSetPortAttribute(__libmansuffix__), XvPortNotify(__libmansuffix__)
.br

