char *helpmessage[] =
{
  "O(a^b)=o(a^b)=p-adic or power series zero with precision given by b",
  "abs(x)=absolute value (or modulus) of x",
  "acos(x)=inverse cosine of x",
  "acosh(x)=inverse hyperbolic cosine of x",
  "addell(e,z1,z2)=sum of the points z1 and z2 on elliptic curve e",
  "adj(x)=adjoint matrix of x",
  "agm(x,y)=arithmeticogeometric mean of x and y",
  "algdep(x,n)=algebraic relations up to degree n of x",
  "algdep2(x,n,bit)=algebraic relations up to degree n of x where bit is as in \nlindep2",
  "anell(e,n)=computes the first n Fourier coefficients of the L-function of the elliptic curve e",
  "apell(e,p)=computes a_p for the elliptic curve e using Shanks-Mestre's method",
  "apell2(e,p)=computes a_p for the elliptic curve e using Jacobi symbols",
  "apprpadic(x,a)=p-adic roots of the polynomial x congruent to a mod p",
  "arg(x)=argument of x,such that -pi<arg(x)<=pi",
  "asin(x)=inverse sine of x",
  "asinh(x)=inverse hyperbolic sine of x",
  "assmat(x)=associated matrix to polynomial x",
  "atan(x)=inverse tangent of x",
  "atanh(x)=inverse hyperbolic tangent of x",
  "base(x)=integral basis of the field Q[a], where a is a root of the polynomial x",
  "bernreal(x)=Bernoulli number B_x, as a real number with the current precision",
  "bernvec(x)=Vector of rational Bernoulli numbers B_0, B_2,... up to B_(2x)",
  "bezout(x,y)= gives a 3-dimensional line vector [u,v,d] such that\nd=gcd(x,y) and u*x+v*y=d",
  "bigomega(x)=number of repeated prime divisors of x",
  "bin(x,y)=binomial coefficient x*(x-1)...*(x-y+1)/y! defined for y in Z and any x",
  "binary(x)=gives the vector formed by the binary digits of x (x C-integer)",
  "bittest(x,n)=gives bit number n (coefficient of 2^n) of the integer x",
  "boundcf(x,lmax)=continued fraction expansion of x with at most lmax terms",
  "boundfact(x,lim)=partial factorization of the integer x (using primes up to lim)",
  "ceil(x)=ceiling of x=smallest integer>=x",
  "cf(x)=continued fraction expansion of x (x rational,real or rational function)",
  "cf2(b,x)=continued fraction expansion of x (x rational,real or rational\nfunction), where b is the vector of numerators of the continued fraction",
  "changevar(x,y)=change variables of x according to the vector y",
  "char(x,y)=det(y*I-x)=characteristic polynomial of the matrix x",
  "char2(x,v)=characteristic polynomial of the matrix x expressed with variable v,\nusing the Hessenberg form. Can be much faster or much slower than char, depending on the base ring",
  "chell(x,y)=change data on elliptic curve according to y=[u,r,s,t]",
  "chinese(x,y)=x,y being integers modulo mx and my,finds z such that\nz is congruent to x mod mx and y mod my",
  "chptell(x,y)=change data on point or vector of points x on an elliptic curve\n according to y=[u,r,s,t]",
  "classno(x)=class number of discriminant x",
  "classno2(x)=class number of discriminant x",
  "coeff(x,s)=coefficient of degree s of x, or the s-th component for vectors or matrices\n(for which it is simpler to use x[])",
  "compo(x,s)=the s'th component of the internal representation of x.\nFor vectors or matrices, it is simpler to use x[]",
  "compose(x,y)=Gaussian composition of the binary quadratic forms x and y",
  "concat(x,y)=concatenation of x and y",
  "conj(x)=the algebraic conjugate of x",
  "content(x)=gcd of all the components of x, when this makes sense",
  "convol(x,y)=convolution (or Hadamard product) of two power series",
  "cos(x)=cosine of x",
  "cosh(x)=hyperbolic cosine of x",
  "cvtoi(x)=truncation of x, without taking into account loss of integer part precision",
  "denom(x)=denominator of x (or lowest common denominator in case of an array).",
  "deriv(x,y)=derivative of x with respect to the main variable of y",
  "det(x)=determinant of the matrix x",
  "det2(x)=determinant of the matrix x (better for integer entries)",
  "detr(x)=determinant of the matrix x having real entries",
  "dilog(x)=dilogarithm of x",
  "disc(x)=discriminant of the polynomial x",
  "discf(x)=discriminant of the number field defined by the polynomial x",
  "divisors(x)=gives a vector formed by the divisors of x in increasing order",
  "divres(x,y)=euclidean division of x by y giving in a 2-dimensional column vector\nthe quotient and the remainder",
  "divsum(n,X,expr)=sum of expression expr, X running over the divisors of n",
  "eigen(x)=eigen vectors or the matrix x",
  "eint1(x)=exponential integral E1(x)",
  "erfc(x)=complementary error function",
  "eta(x)=eta function without the q^(1/24)",
  "euler=euler()=euler's constant with current precision",
  "eval(x)=evaluation of x, replacing variables by their value",
  "exp(x)=exponential of x",
  "extract(x,y)=extraction of the components of the vector x according to the mask y,\nfrom left to right (1,2,4,8,...for the first,second,third,fourth,...component",
  "fact(x)=x!=factorial of x (x C-integer)",
  "factfq(x,p,a)=factorization of the polynomial x in the finite field\nF_p[X]/a(X)F_p[X]",
  "factmod(x,p)=factorization mod p of the polynomial x",
  "factor(x)=factorization of x",
  "factoredbase(x,p)=integral basis of the maximal order defined by the polynomial x,\nwhere p is the matrix of the factorization of the discriminant of x",
  "factoreddiscf(x,p)=discriminant of the maximal order defined by the polynomial x,\nwhere p is the matrix of the factorization of the discriminant of x",
  "factoredpolred(x,p)=reduction of the polynomial x, where p is the matrix of the\nfactorization of the discriminant of x",
  "factpadic(x,p,r)=p-adic factorization of the polynomial x to precision r",
  "factpol(x,l)=factorization over Z of the polynomial x up to degree l (complete if l=0)\nusing Hensel lift",
  "factpol2(x,l)=factorization over Z of the polynomial x up to degree l (complete if l=0)\nusing root finding",
  "fibo(x)=fibonacci number of index x (x C-integer)",
  "floor(x)=floor of x=largest integer<=x",
  "for(X=a,b,seq)=the sequence is evaluated, X going from a up to b",
  "fordiv(n,X,seq)=the sequence is evaluated, X running over the divisors of n",
  "forprime(X=a,b,seq)=the sequence is evaluated, X running over the primes between a and b",
  "forstep(X=a,b,s,seq)=the sequence is evaluated, X going from a to b in steps of s",
  "frac(x)=fractional part of x=x-floor(x)",
  "gamh(x)=gamma of x+1/2 (x integer)",
  "gamma(x)=gamma function at x",
  "gauss(a,b)=gaussian solution of ax=b (a matrix,b vector)",
  "gcd(x,y)=greatest common divisor of x and y",
  "globalred(e)=e being an elliptic curve, returns [N, [u, r, s, t]], where N\nis the conductor of e and [u, r, s, t] leads to the standard model for e",
  "hclassno(x)=Hurwitz-Kronecker class number of x>0",
  "hell(e,x)=archimedean height of point x on elliptic curve E defined by datavector e\ncomputed using theta-functions",
  "hell2(e,x)=archimedean height of point x on elliptic curve E defined by datavector e\ncomputed using Tate's method",
  "hell3(e,x)=archimedean height of point x on elliptic curve E defined by datavector e\ncomputed using theta-functions (for debugging only)",
  "hermite(x)=(upper triangular) Hermite normal form of x",
  "hess(x)=Hessenberg form of x",
  "hilb(x,y,p)=Hilbert symbol at p of x,y (integers or fractions)",
  "hilbert(n)=Hilbert matrix of order n (n C-integer)",
  "hilbp(x,y)=Hilbert symbol of x,y (where x or y is integermod or p-adic)",
  "hvector(n,X,expr)=horizontal vector with n components of expression expr,the variable X goes from 1 to n",
  "hyperu(a,b,x)=U-confluent hypergeometric function",
  "i=i()=square root of -1",
  "idmat(n)=identity matrix of order n (n C-integer)",
  "if(a,seq1,seq2)= if a is nonzero, seq1 is evaluated, otherwise seq2",
  "imag(x)=imaginary part of x",
  "image(x)=basis of the image of the matrix x",
  "image2(x)=basis of the image of the matrix x",
  "incgam(s,x)=incomplete gamma function",
  "incgam1(s,x)=incomplete gamma function (for debugging only)",
  "incgam2(s,x)=incomplete gamma function (for debugging only)",
  "incgam3(s,x)=incomplete gamma function (for debugging only)",
  "indsort(x)=indirect sorting of the vector x",
  "initell(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector:\n[a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j,e1,e2,e3,w1,w2,q,area]",
  "integ(x,y)=formal integration of x with respect to the main variable of y",
  "intgen(X=a,b,s)=general numerical integration of s from a to b with respect to X, to be used after removing singularities",
  "intinf(X=a,b,s)=numerical integration of s from a to b with respect to X, where a or b can be plus or minus infinity (1.0e4000), but of same sign",
  "intnum(X=a,b,s)=numerical integration of s from a to b with respect to X",
  "intopen(X=a,b,s)=numerical integration of s from a to b with respect to X, where s has only limits at a or b",
  "isfund(x)=true(1) if x is a fundamental discriminant (including 1), false(0) if not",
  "isoncurve(e,x)=true(1) if x is on elliptic curve e, false(0) if not",
  "isprime(x)=true(1) if x is a strong pseudoprime for 10 random bases, false(0) if not",
  "ispsp(x)=true(1) if x is a strong pseudoprime, false(0) if not",
  "isqrt(x)=integer square root of x (x integer)",
  "issqfree(x)=true(1) if x is squarefree, false(0) if not",
  "issquare(x)=true(1) if x is a square, false(0) if not",
  "jacobi(x)=eigenvalues and orthogonal matrix of eigenvectors of the real symmetric matrix x",
  "jbesselh(n,x)=J-bessel function of index n+1/2 and argument x, where n is a non\n negative integer",
  "jell(x)=elliptic j invariant of x",
  "kbessel(nu,x)=K-bessel function of index nu and argument x (x positive real\nof type real,nu of any scalar type)",
  "kbessel2(nu,x)=K-bessel function of index nu and argument x (x positive real\nof type real,nu of any scalar type)",
  "ker(x)=basis of the kernel of the matrix x",
  "keri(x)=basis of the kernel of the matrix x with integer entries",
  "kerr(x)=basis of the kernel of the matrix x with real or nonexact complex entries",
  "kill(x)= kills the present value of the variable or function x. Returns new value or 0",
  "kro(x,y)=kronecker symbol (x/y)",
  "laplace(x)=replaces the power series sum of a_n*x^n/n! by sum of a_n*x^n",
  "lcm(x,y)=least common multiple of x and y=x*y/gcd(x,y).",
  "length(x)=number of non code words in x",
  "legendre(n)=legendre polynomial of degree n (n C-integer)",
  "lift(x)=lifts every element of Z/nZ to Z or Z[x]/PZ[x] to Z[x]",
  "lindep(x)=Z-linear dependencies between components of x (Hastad et al)",
  "lindep2(x,bit)=Z-linear dependencies between components of x using LLL, where\nbit should be about one half the number of bits of precision",
  "lll(x)=lll reduction of the vectors forming the matrix x",
  "lllgram(x)=lll reduction of the lattice whose gram matrix is x",
  "lllrat(x)=lll reduction of the vectors forming the matrix x,computations done with rational numbers",
  "ln(x)=log(x)=natural logarithm of x",
  "lngamma(x)=logarithm of the gamma function of x",
  "localred(e, p)= e being an ellliptic curve, returns [f, kod, [u, r, s, t]],\nwhere f is the conductor's exponent and kod is the kodaira type for e at p",
  "log(x)=ln(x)=natural logarithm of x",
  "logagm(x)=natural logarithm of x, computed using agm (faster than log for more\nthan a few hundred decimal digits)",
  "mat(x)=transforms any GEN x into a matrix",
  "matell(e,x)=gives the height matrix for vector of points x on elliptic curve e\nusing theta functions",
  "matextract(x,y,z)=extraction of the components of the matrix x according to the masks\ny (for the lines) and z (for the columns) from left to right (1,2,4,8,...for the first,\nsecond,third,fourth,...lines or columns",
  "matinvr(x)=inverse of the real matrix x",
  "matrix(m,n,X,Y,expr)=mXn matrix of expression expr, the row variable X going \nfrom 1 to m and the column variable Y going from 1 to n",
  "max(x,y)=maximum of x and y",
  "min(x,y)=minimum of x and y",
  "minim(x)=number of minimal vectors and minimum on Z of the integral and definite quadratic form x",
  "mod(x,y)=creates the integer x modulo y on the PARI stack",
  "modp(x,y)=creates the integer x modulo y as a permanent object (on the heap)",
  "mu(x)=Moebius function of x",
  "newtonpoly(x,p)=Newton polygon of polynomial x with respect to the prime p",
  "nextprime(x)=smallest prime number>=x",
  "norm(x)=norm of x",
  "norml2(x)=square of the L2-norm of the vector x",
  "numdiv(x)=number of divisors of x",
  "numer(x)=numerator of x.",
  "o(a^b)=O(a^b)=p-adic or power series zero with precision given by b",
  "omega(x)=number of unrepeated prime divisors of x",
  "ordell(e,x)=y-coordinates corresponding to x-ordinate x on elliptic curve e",
  "order(x)=order of the integermod x in (Z/nZ)*",
  "ordred(x)=reduction of the polynomial x, staying in the same order",
  "pascal(n)=pascal triangle of order n (n C-integer)",
  "pf(x,p)=returns the prime form whose first coefficient is p, of discriminant x",
  "phi(x)=Euler's totient function of x",
  "pi=pi()=the constant pi, with current precision",
  "plot(X=a,b,expr)=crude plot of expression expr, X goes from a to b",
  "ploth(X=a,b,expr)=plot of expression expr, X goes from a to b in high resolution",
  "ploth2(X=a,b,[expr1,expr2])=plot of points [expr1,expr2], X goes from a to b in high resolution",
  "pnqn(x)=[p_n,p_{n-1};q_n,q_{n-1}] corresponding to the continued fraction x",
  "polint(xa,ya,x)=polynomial interpolation at x according to data vectors xa, ya",
  "polred(x)=reduction of the polynomial x",
  "polredreal(x)=reduction of the totally real polynomial x. more efficient than\n polred when x is totally real",
  "polsym(x,n)=vector of symmetric powers of the roots of x up to n",
  "poly(x,v)=convert x (usually a vector or a power series) into a polynomial with variable v,\nstarting with the leading coefficient",
  "polylog(m,x)=m-th polylogarithm of x",
  "polylogd(m,x)=dm-modified m-th polylog of x",
  "polylogp(m,x)=pm-modified m-th polylog of x",
  "powell(e,n,x)=n times the point x on elliptic curve e (n in Z)",
  "pprint(a)=outputs a in beautified format ending with newline",
  "pprint1(a)=outputs a in beautified format without ending with newline",
  "prec(x,n)=change the precision of x to be n (n C-integer)",
  "prime(n)=returns the n-th prime (n C-integer)",
  "primes(n)=returns the vector of the first n primes (n C-integer)",
  "primroot(n)=returns a primitive root of n (n a power of a prime)",
  "print(a)=outputs a in raw format ending with newline",
  "print1(a)=outputs a in raw format without ending with newline",
  "prod(x,X=a,b,expr)=x times the product (X runs from a to b) of expression",
  "prodeuler(X=a,b,expr)=Euler product (X runs over the primes between a and b) of real or complex expression",
  "prodinf(X=a,expr)=infinite product (X goes from a to infinity) of real or complex expression",
  "prodinf1(X=a,expr)=infinite product (X goes from a to infinity) of real or complex 1+expression",
  "psi(x)=psi-function at x",
  "qfi(a,b,c)=binary quadratic form a*x^2+b*x*y+c*y^2 with b^2-4*a*c<0",
  "qfr(a,b,c,d)=binary quadratic form a*x^2+b*x*y+c*y^2 with b^2-4*a*c>0 and distance d",
  "quadgen(x)=standard generator of quadratic order of discriminant x",
  "quadpoly(x)=quadratic polynomial corresponding to the discriminant x",
  "rank(x)=rank of the matrix x",
  "real(x)=real part of x",
  "recip(x)=reciprocal polynomial of x",
  "redcomp(x)=reduction of the binary quadratic form x with D<0",
  "redreal(x)=reduction of the binary quadratic form x with D>0",
  "regula(x)=regulator of the real quadratic field of discriminant x",
  "reorder(x)=reorder the variables for output according to the vector x",
  "resultant(x,y)=resultant of the polynomials x and y",
  "reverse(x)=reversion of the power series x",
  "rhoreal(x)=single reduction step of the binary quadratic form x of positive discriminant",
  "rndtoi(x)=take the nearest integer to all the coefficients of x,without taking into account loss of integer part precision",
  "rootmod(x,p)=roots mod p of the polynomial x",
  "rootmod2(x,p)=roots mod p of the polynomial x, when p is small",
  "rootpadic(x,p,r)=p-adic roots of the polynomial x to precision r",
  "roots(x)=roots of the polynomial x",
  "round(x)=take the nearest integer to all the coefficients of x",
  "series(x,v)=convert x (usually a vector) into a power series with variable v, starting with\nthe constant coefficient",
  "setprecision(n)=set the current precision to n decimal digits if n>0, or\nreturn the current precision if n<=0",
  "setserieslength(n)=set the default length of power series to n if n>0, or\nreturn the current default length if n<=0",
  "sigma(x)=sum of the divisors of x",
  "sigmak(k,x)=sum of the k-th powers of the divisors of x (k C-integer)",
  "sign(x)=sign of x, of type integer, real or fraction",
  "signat(x)=signature of the symmetric matrix x",
  "sin(x)=sine of x",
  "sinh(x)=hyperbolic sine of x",
  "smallbase(x)=integral basis of the field Q[a], where a is a root of the polynomial x where one\nassumes that no square of a prime>500000 divides the discriminant of x",
  "smalldiscf(x)=discriminant of the number field defined by the polynomial x where one assumes that\n no square of a prime>500000 divides the discriminant of x",
  "smallfact(x)=partial factorization of the integer x (using only the stored primes)",
  "smallinitell(x)=x being the vector [a1,a2,a3,a4,a6], gives the vector:\n[a1,a2,a3,a4,a6,b2,b4,b6,b8,c4,c6,delta,j]",
  "smallpolred(x)=partial reduction of the polynomial x",
  "smith(x)=Smith normal form (i.e. elementary divisors) of the matrix x, expressed as a vector",
  "solve(X=a,b,expr)=real root of expression expr (X between a and b), where expr(a)*expr(b)<=0",
  "sort(x)=sort in ascending order of the vector x",
  "sqr(x)=square of x. NOT identical to x*x",
  "sqred(x)=square reduction of the (symmetric) matrix x ( returns a square matrix whose i-th\ndiagonal term is the coefficient of the i-th square in which coeff of i-th variable is 1)",
  "sqrt(x)=square root of x",
  "srgcd(x,y)=polynomial gcd of x and y using the subresultant algorithm",
  "sturm(x)=number of real roots of the polynomial x",
  "sturmpart(x,a,b)=number of real roots of the polynomial x in the interval (a,b]",
  "subell(e,z1,z2)=difference of the points z1 and z2 on elliptic curve e",
  "subst(x,y,z)=substitute z for y in x",
  "sum(x,X=a,b,expr)=x plus the sum (X goes from a to b) of expression expr",
  "sumalt(X=a,expr)=euler's acceleration of alternating series expr, X starting at a",
  "suminf(X=a,expr)=infinite sum (X goes from a to infinity) of real or complex expression expr",
  "sumpos(X=a,expr)=sum of positive series expr, the formal variable\n X starting at a",
  "supplement(x)=supplement the columns of the matrix x to an invertible matrix",
  "tan(x)=tangent of x",
  "tanh(x)=hyperbolic tangent of x",
  "taylor(x,y)=taylor expansion of x with respect to the main variable of y",
  "tchebi(n)=tchebitcheff polynomial of degree n (n C-integer)",
  "teich(x)=teichmuller character of p-adic number x",
  "texprint(a)=outputs a in TeX format",
  "theta(q,z)=Jacobi sine theta-function",
  "thetanullk(q,k)=k'th derivative at z=0 of theta(q,z)",
  "trace(x)=trace of x",
  "trans(x)=x~=transpose of x",
  "trunc(x)=truncation of x;when x is a power series,take away the O(X^)",
  "type(x)=internal type number of the GEN x",
  "unit(x)=fundamental unit of the quadratic field of discriminant x;\n x must be positive",
  "until(a,seq)=evaluate the expression sequence seq until a is nonzero",
  "valuation(x,p)=valuation of x with respect to p",
  "vec(x)=transforms the object x into a vector. Used mainly if x is\na polynomial or a power series",
  "vector(n,X,expr)=horizontal vector with n components of expression expr (X goes from 1 to n)",
  "vvector(n,X,expr)=vertical vector with n components of expression expr (X goes from 1 to n)",
  "wf(x)=weber's f function of x (j=(f^24-16)^3/f^24)",
  "wf2(x)=weber's f2 function of x (j=(f2^24+16)^3/f2^24)",
  "while(a,seq)= while a is nonzero evaluate the expression sequence seq. Otherwise 0",
  "zell(e,z)=In the complex case, lattice point corresponding to the point z on\nthe elliptic curve e",
  "zeta(s)=Riemann zeta function at s",
  "zzzz(...)=can be any function which is being tested. For developing purposes only."
};


char *errmessage[]=
{  
  "what's going on ?",/* Should not occur */
  
  /*              ERREURS  DE  MP.S               */
  
  "impossible assignment S-->I",
  "impossible assignment I-->S",
  "impossible assignment I-->I",
  "impossible assignment R-->S",
  "impossible assignment R-->I",
  "impossible exchange I<-->I",
  "forbidden exchange I<-->R",
  "overflow in integer shift",
  "overflow in real shift",
  "overflow in truncation",
  
  "precision loss in truncation",
  "overflow in S+I",
  "overflow in I+I",
  "overflow in I+R",
  "overflow in R+R",
  "underflow in R+R",
  "overflow in I*I",
  "overflow in S*R",
  "overflow in S*I",
  "overflow in R*R",
  
  "underflow in R*R",
  "overflow in I*R (R=0)",
  "division by zero in S/S",
  "division by zero in S/I",
  "division by zero in S/R",
  "division by zero in I/S",
  "division by zero in I/R",
  "division by zero in R/S",
  "underflow in R/S",
  "division by zero in R/I",
  
  "division by zero in R/R",
  "underflow in R/R",
  "overflow in R/R",
  "underflow in R/I (R=0)",
  "forbidden division R/R-->I or I/R-->I or R/I-->I",
  "division by zero in dvmdii",
  "result defined as type R in dvmdz",
  "zero modulus in modss",
  "result defined as type R in modz",
  "division by zero in resss",
  
  "result defined as type R in resz",
  "forbidden type in an arithmetic function",
  "third operand of type real",
  "the PARI stack overflows !!!",
  "underflow or overflow in a R->dbl conversion",
  "significant pointers are lost in gerepile !!! (please report)",
  "quotient greater than or equal to 2^32 in divll",
  
  /*              ERREURS  DE  ALGLIN.C           */
  
  "not vector or matrix type in gtrans",
  "not a square matrix in gaddmat",
  "not a square matrix in gaddsmat",
  "impossible concatenation in concat",
  "not a vector or matrix type in extract",
  "mask is not of type I or is zero in extract or matextract",
  "too large mask in extract or matextract",
  "non matrix type in matextract",
  "non invertible matrix in gauss",
  "non inversible matrix in invmat",
  
  "non square matrix in caract, caradj, sqred, carhess, or hess",
  "non polynomial type or zero polynomial in assmat",
  "incorrect type in trace",
  "incompatible matrix dimensions in invmulmat",
  "non square matrix in gauss",
  "not a matrix in ker or rank, sqred, suppl or image",
  "empty matrix in suppl",
  "not linearly independent columns in suppl",

  /*              ERREURS  DE  ANAL.C          */
  
  "expected character: ",
  "non rectangular matrix",
  ";or ] expected",
  "unknown identifier: ",
  "unexpected character: ",
  "not a simple variable in numvar",
  "variable number out of range",
  "I can't remember before the big bang",
  "I can't see into the future",
  "unknown identifier valence",
  
  "no more variables available",
  "unknown function or error in formal parameters",
  "unexpected end of input",
  "variable name expected",
  "can't kill that",
  "array index out of range",
  "too many parameters in user-defined function call",
  "some argument is not of type integer at it should",
  
  /*              ERREURS  DE  ARITH.C            */
  
  "arithmetic functions want integer arguments",
  "zero argument in arithmetic function",
  "negative argument in factorial function",
  "non invertible argument",
  "impossible inverse modulo",
  "incorrect type for a continued fraction",
  "non significant integral part in sfcont",
  "insuffcient precision for p=2 in hil",
  "impossible or incompatible types in hil",
  "incompatible arguments in chinois",

  "not a positive type I argument in fundunit",
  "discriminant not congruent to 0 or 1 mod 4 in fundunit",
  "not able to factor this number",
  "discriminant too large in classno",
  "discriminant not congruent to 0 or 1 mod 4 in classno",
  "non integral argument in qf",
  "incorrect characters or length of a quadratic form",
  "not an element of (Z/nZ)* in order",
  "not a power of a prime in gener",
  "not enough precalculated primes",
  
  "incorrect type in issquarefree",
  "square argument in regula",
  "incorrect type in pnqn",
  "incorrect size in pnqn",

  /*              ERREURS  DE  BASE.C          */

  "not a matrix in Hermite or Smith reduction hnf",
  "more lines than columns in Hermite reduction hnf or nonsquare matrix in Smith",
  "Internal error in Hermite reduction hnf",
  "not a k by 2 matrix as factorization in factoredbase",
  "the given factorization is incorrect in factoredbase",

  /*              ERREURS  DE  BIBLI.C          */
  
  "not a series type in laplace",
  "negative valuation in laplace",
  "not a series type in convol",
  "zero series in convol",
  "non significant result in convol",
  "incorrect argument in O()",
  "non series or p-adic type in truncation",
  "precision<=0 in gprec",
  "quadratic discriminant is still undefined",
  "incorrect indices in somme",
  
  "incorrect indices in produit",
  "non polynomial type in polrecip",
  "incorrect type or sign in vector",
  "incorrect type or sign in matrix",
  "incorrect indices in rec",
  "rec cannot be called recursively!",
  "not a matrix type in lll or lllrat",
  "not a matrix type in lllgram",
  "not a square matrix in lllgram",
  "not a definite matrix in lllgram",
  "not a vector type in lindep",
  
  "more than 20 numbers in lindep",
  "not a scalar type in algdep",
  "not enough prime numbers",
  "incorrect second argument in changevar",
  "variable number too large in changevar",
  "reorder wants a vector",
  "indeterminate out of range in reorder",
  "duplicated indeterminates in reorder",
  "too many iterations for desired precision in integration routine",
  "sort wants a vector",
  
  "not vectors or different lengths in polint",
  "two abcissas are equal in polint",
  "roots must be bracketed in zbrent",
  "too many iterations in zbrent",
  "too many iterations in summation method",
  "index nesting level too large in",
  "dimensions must be nonnegative",
  "forbidden type in for or forstep",
  "step equal to zero in forstep",

  /*           ERREURS DANS ELLIPTIC.C            */

  "bad argument for an elliptic curve related function",
  "valuation of j must be negative in p-adic initell",
  "singular curve in initell",
  "point not on elliptic curve",
  "forbidden type in zell",
  "too large prime in jacobi apell2, use apell instead",
  "internal error in apell",
  "f^(com*s) = 1 ???: internal error in appell1",
  "inconsistency in Tate's algorithm (please report)",

  /*              ERREURS  DE  ES.C               */
  
  "variable number too large in impvar",
  "discriminant not congruent to 0 or 1 mod 4",
  "inexistent format",
    
  /*             ERREUR DANS GEN1.C                */

  "incorrect types in addition",
  "forbidden addition R+Imod",
  "forbidden addition Imod+Cx",
  "forbidden addition scalar+vector/matrix",
  "forbidden addition polynomial+vector/matrix",
  "forbidden addition series+polynomial/vector/matrix",
  "forbidden addition polmod+vector/matrix",
  "forbidden addition fraction+vector/matrix",
  "impossible addition vector+matrix",
  "forbidden addition type+Cx",

  "impossible addition Quad+Quad",
  "impossible addition p-adic+p-adic",
  "incorrect types in gmul",
  "forbidden multiplication R*Imod",
  "forbidden multiplication Imod*Cx",
  "forbidden multiplication series*polmod",
  "impossible multiplication vector*vector",
  "impossible multiplication vector*matrix",
  "impossible multiplication matrix*vector",
  "impossible multiplication matrix*matrix",

  "forbidden multiplication type*Cx",
  "impossible multiplication Quad*Quad",
  "impossible multiplication p-adic*p-adic",
  "incorrect type in gdiv",
  "division by zero",
  "forbidden division R/Imod",
  "forbidden division Imod/R",
  "forbidden division Imod/Cx",
  "forbidden division Cx/Imod",
  "forbidden division scalar/vector",

  "division scalar/non square matrix",
  "forbidden division polynomial/vector or matrix",
  "forbidden division series/polmod",
  "forbidden division series/vector or matrix",
  "forbidden division polmod/series",
  "forbidden division polmod/vector or matrix",
  "forbidden division ratfun/vector or matrix",
  "division vector or matrix/vector or non square matrix",
  "impossible division Quad/Quad",
  "impossible division p-adic/p-adic",
  
  /*        ERREURS  DE  GEN2.C ET GEN3.C         */
  
  "non polynomial type in greffe",
  "error in mnet",
  "forbidden type in gexpo",
  "exact and zero argument in gexpo",
  "forbidden type in a comparison",
  "forbidden type in gtolong",
  "zero argument in gval",
  "forbidden or conflicting type in gval",
  "forbidden type in gabs",
  "impossible assignment S-->vector",

  "impossible assignment S-->matrix",
  "incorrect type in gaffect",
  "impossible assignment S-->",
  "forbidden assignment R-->",
  "forbidden assignment Imod-->",
  "impossible assignment Imod-->Imod",
  "forbidden assignment Imod-->p-adic",
  "impossible assignment Frac-->I",
  "impossible assignment Cx-->",
  "impossible assignment Quad-->",

  "forbidden assignment p-adic-->",
  "impossible assignment p-adic-->Imod",
  "impossible assignment p-adic-->p-adic",
  "forbidden assignment generic-->scalar",
  "impossible assignment polynomial-->polynomial",
  "forbidden assignment polynomial-->vector/matrix",
  "forbidden assignment series-->",
  "forbidden assignment Polmod-->",
  "impossible assignment Polmod-->Polmod",
  "forbidden addition p-adic+Quad",

  "forbidden assignment rational function-->polynomial/vector/matrix",
  "impossible assignment vector/matrix-->vector/matrix",
  "impossible assignment Quad-->Quad",
  "type error in gpui",
  "non zero exponent in gpui",
  "zero to a non positive exponent in gpui",
  "underflow or overflow in gpui",
  "incorrect type in gdivent or gdiventres",
  "incorrect type in gdivmod",
  "different types in gbezout",

  "incorrect type in gbezout",
  "incorrect type in ginvmod",
  "forbidden type in gmul2n",
  "inverse of a vector is forbidden",
  "not a series or pol type in normalize or normalizepol",
  "type mod I forbidden in gmod",
  "type mod polynomial forbidden in gmod",
  "modulus type forbidden in gmod",
  "forbidden substitution in a scalar type",
  "forbidden substitution by a vector",

  "forbidden substitution by a non square matrix",
  "non polynomial or series type substituted in a series",
  "valuation non positive in a series substitution",
  "reversion of a non series or of a series of valuation not equal to 1",
  "forbidden derivation of a polmod",
  "forbidden type in integration",
  "a log appears in the integration, I don\'t know how to handle that yet",
  "forbidden type in gfloor",
  "forbidden type in ground",
  "forbidden type in gcvtoi",

  "not an integer modulus in cvtop or gcvtop",
  "forbidden type in cvtop",
  "forbidden type in grndtoi",
  "forbidden type in gceil",
  "forbidden type in gtrunc",
  "nonexistent component",
  "forbidden type in degree",
  "forbidden type in gsigne",
  "forbidden type in iscomplex",
  "forbidden type in denom",

  "forbidden type in numer",
  "forbidden type in negation",

  /*              ERREURS DE GP.C             */

  "too many include files",
  "error opening input file",
  "error opening output file",
  "error opening log file pari.log",

  /*              ERREURS DE INIT.C             */
  
  "not enough memory",
  "user interrupt",
  "no more blocks available",
  "function already exists in install",
  
  /*              ERREURS  DE  POLARIT.C          */
  
  "non polynomial type in eucl. div. (gdeuc)",
  "non polynomial type in eucl. div. (gres)",
  "non polynomial type in eucl. div. (poldivres)",
  "eucl. div. by zero (gdeuc)",
  "eucl. div  by zero (gres)",
  "eucl. div. by zero (poldivres)",
  "non polynomial type in roots",
  "zero polynomial in roots",
  "too many iterations in roots",
  "INTERNAL ERROR: incorrect result in roots",
  
  "deg(x)<deg(y) in euclidean pseudodiv",
  "incorrect type in bezoutpol",
  "incorrect type or zero polynomial in factmod",
  "non invertible fraction in a gcd with Imod",
  "forbidden gcd polynomial with vector/matrix",
  "forbidden gcd rational function with vector/matrix",
  "gcd vector/matrix with a forbidden type",
  "non polynomial in resultant",
  "different variables in resultant",
  "incorrect type in discsr",

  "non polynomial type in polgcd",
  "non polynomial or zero in polynomial function",
  "not a squarefree polynomial in sturm",
  "not a nonzero polynomial in factpol",
  "internal error: bug in factpol",
  "internal error: bug in Hensel lift",
  "not a polynomial in newtonpoly",
  "incorrect type(s) or zero polynomial in rootpadic or factorpadic",
  "root does not exist in rootpadic",
  "nonzero valuation for f'(x0) in approxp",

  "nonpositive precision in rootpadic",

  /*              ERREURS  DE  TRANS.C            */
  
  "not a Quad/Cx type in gnorm",
  "not a vector type in gnorml2",
  "incorrect type in gconj",
  "incorrect type in greal",
  "incorrect type in gimag",
  "not a type R in mpsqrt",
  "negative argument in mpsqrt",
  "forbidden type in gsqrt",
  "infinite precision in gsqrtz",
  "non quadratic residue in gsqrt",
  
  "odd exponent in gsqrt",
  "not a type R in mpexp1",
  "forbidden type in gexp",
  "infinite precision in gexpz",
  "negative exponent in gexp",
  "not a type R in mplog",
  "non positive argument in mplog",
  "forbidden type in glog",
  "infinite precision in glogz",
  "negative exponent in glog",
  
  "not a type R in mpsc1",
  "loss of precision in mpsc1",
  "not a type R in mpcos",
  "forbidden type in gcos",
  "infinite precision in gcosz",
  "negative exponent in gcos",
  "nor a type R in mpsin",
  "forbidden type in gsin",
  "infinite precision in gsinz",
  "negative exponent in gsin",
  
  "not a type R in mpsincos",
  "forbidden type in gsincos",
  "non zero exponent in gsincos",
  "forbidden type in gtan",
  "infinite precision in gtanz",
  "negative exponent in gtan",
  "not a type R in mpatan",
  "forbidden type in gatan",
  "infinite precision in gatanz",
  "negative exponent in gatan",
  
  "not a type R in mpasin",
  "forbidden argument in mpasin",
  "forbidden type in gasin",
  "infinite precision in gasinz",
  "negative exponent in gasin",
  "not a type R in mpacos",
  "forbidden argument in mpacos",
  "forbidden type in gacos",
  "infinite precision in gacosz",
  "negative exponent in gacos",
  
  "not a type R in mparg",
  "zero argument in mparg",
  "forbidden type in gch",
  "infinite precision in gchz",
  "not a type R in mpch",
  "forbidden type in gsh",
  "infinite precision in gshz",
  "not a type R in mpsh",
  "not a type R in mpth",
  "forbidden type in gth",
  
  "infinite precision in gthz",
  "not a type R in mpash",
  "forbidden type in gash",
  "infinite precision in gashz",
  "negative exponent in gash",
  "not a type R or<1 in mpach",
  "forbidden type in gach",
  "infinite precision in gachz",
  "negative exponent in gach",
  "not a type R in mpath",
  
  "forbidden type in gath",
  "infinite precision in gathz",
  "negative exponent in gath",
  "not a type R in mpgamma",
  "negative or zero integer argument in mpgamma",
  "forbidden type in ggamma",
  "infinite precision in ggammaz",
  "argument too large in gammademi",
  "forbidden type in ggamd",
  "infinite precision in ggamdz",
  
  "forbidden type in gpsi",
  "infinite precision in gpsiz",
  "zero argument in palog",
  "not a p-adic argument in teicher",
  "p-adic argument out of range for exponentiation",
  "agm of two vector/matrices",
  "binary quadratic forms cannot be used in transcendental functions",
  "q>=1 in theta",
  "not an integer index in jbesselh",
  "argument equal to one in zeta",
  "forbidden type in zeta",
  "infinite precision in gzetaz",

  /*             BARATIN GENERAL                */

  "",
  
  /*             ERREUR PAS ENCORE IMPLEMENTE   */
  
  "sorry, the function"
};
