;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



;(define machine-type ((*value t-implementation-env 'machine-type)
;		      ((*value t-implementation-env 'local-machine))))
;
;
;(cond ((eq? machine-type 'sun)
;;       (load '(tsystem hangup) t-implementation-env)
;;       (*require nil '(tsystem system) imps-implementation-env)
;       )
;      ((eq? machine-type 'sparc)
;       (*define t-implementation-env '*maximum-number-of-arguments* 512)))

;(define exec (*value t-implementation-env 'unix-system))
(set (load-noisily?) '#f)
;(*require nil '(resources robust-table) imps-implementation-env)
;(*require nil '(resources load-mod) t-implementation-env)
;(*require nil '(resources lisp-supplements) imps-implementation-env)
;(*require nil '(resources sets) imps-implementation-env)
;(*require nil '(resources numerical-objects) imps-implementation-env)
(set (load-out-of-date-action) 'binary)
(set (gc-noisily?) '#t)

;(*require nil '(imps imps) imps-implementation-env)

;(import t-implementation-env
;	posq						;descriptor-hash already there
;	unix-chdir unix-getenv sort;; copy-table
;	file-loaded? compile-if-outdated maybe-compile-if-outdated)

(set (user) (unix-getenv "USER"))
  
(let ((rt (make-read-table standard-read-table 'imps-read-table)))
  (set (read-table-entry rt #\)
       (lambda (port ch rt)
	 (ignore port ch rt)
	 eof))
  (set (port-read-table (standard-input)) rt))

(define imps-tmp-dir "/tmp")

(define dg-file-name (format nil "~A/~A-dg-file.dg" imps-tmp-dir (user)))
(define sqn-file-name (format nil "~A/~A-dg-file.sqn" imps-tmp-dir (user)))
(define cmpn-file-name (format nil "~A/~A-dg-file.cmpn" imps-tmp-dir (user)))
(define sqn-edit-file-name
  (format nil "~A/~A-sqn-edit-file.sqn" imps-tmp-dir (user)))
(define imps-commands-file
  (format nil "$IMPS/../etc/imps-commands"))
(define imps-theorems-file
  (format nil "~A/~A-imps-theory-theorems" imps-tmp-dir (user)))
(define imps-macetes-file
  (format nil "~A/~A-imps-theory-macetes" imps-tmp-dir (user)))
(define imps-definitions-file
  (format nil "~A/~A-imps-theory-definitions" imps-tmp-dir (user)))
(define imps-recursive-definitions-file
  (format nil "~A/~A-imps-theory-recursive-definitions" imps-tmp-dir (user)))
(define imps-theory-interpretations-file
  (format nil "~A/~A-imps-theory-interpretations" imps-tmp-dir (user)))

(load '(imps patch))
(reset-sections-already-transmitted)

'user-imps-init-done 
