;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald TRANSFORMS)


;;Procedures in this file apply THEORY TRANSFORMS

;;a transform is a procedure of 3 args: 
;;a CONTEXT, an EXPRESSION and a PERSISTENCE.
;;It returns two values:a simplified expression and a list of formulas.

;;The following procedure returns two values:a simplified expression and a list of formulas.

(define (INSISTENTLY-APPLY-MATCHING-TRANSFORMS-IN-CONTEXT context expr persist)
  (if (formal-symbol? expr)
      (return expr '() '#f)
      (receive (expr1 reqs1 any?)
	(apply-matching-transforms-in-context context expr persist)
	(if (alpha-equivalent? expr1 expr)
	    ;;
	    ;;No changes are being made,
	    ;;so ignore requirements
	    ;;
	    (return expr '() any?)
	    (receive (expr2 reqs2 ())
	      (insistently-apply-matching-transforms-in-context
	       context
	       expr1
	       persist)
	      (return expr2 (set-union reqs2 reqs1) '#t))))))

(define (THEORY-INSTALL-TRANSFORM theory constructor lead transform)
  (let* ((transform-table (theory-transform-table theory)))
    (set (two-d-table-entry transform-table constructor lead)
	 (add-set-element
		 transform
		 (two-d-table-entry transform-table constructor lead)))
    (return transform)))

(define (RETRIEVE-TRANSFORMS-BY-CONSTRUCTOR-AND-LEAD theory constr lead)
  (let ((table (theory-transform-table theory)))
    (if (expression? lead)
	(append (two-d-table-entry table constr lead)
		(two-d-table-entry table constr 'no-lead-constant))
	(two-d-table-entry table constr lead))))

(define RETRIEVE-TRANSFORMS-BY-QUASI-CONSTRUCTOR-OR-CONSTRUCTOR-AND-LEAD
  retrieve-transforms-by-constructor-and-lead)

(define (context-has-equality-transform? context)
  (not (null?
	(retrieve-transforms-by-constructor-and-lead
	 (context-theory context)
	 equality
	 'no-lead-constant))))

;;;This procedure applies in succession all transforms applicable to an EXPRESSION

;;; I'm moving this procedure to $EXPRESSIONS/some-constructors.t which is
;;; where I think it most naturally belongs. --Josh
;
;(define (UNDEFINED-OR-FALSELIKE expr)
;  (if (term-or-fn? expr) (undefined (expression-sorting expr))
;      (falselike (expression-sorting expr))))

;;The following procedure returns two values:a simplified expression and a list of formulas.

(define (APPLY-MATCHING-TRANSFORMS-IN-CONTEXT context expr persist)
  (let ((EXPR-MATCHES-LEAD? (lambda (expr lead)
			      (if (expression? lead)
				  (eq? expr lead)
				  '#t)))
	(constr (expression-quasi-constructor-or-constructor expr))
	(lead (expression-lead-constant expr)))
	 

    (iterate loop ((transforms (retrieve-transforms-by-constructor-and-lead
				(context-theory context)
				constr
				lead))
		   (expr expr)
		   (reqs '())
		   (any? '#f))
      (if (null? transforms)
	  (return expr reqs any?)
	  (receive (simp reqs1 this?)
	    ((car transforms) context expr persist)
	    (if (and (expr-matches-lead? (expression-lead-constant simp) lead)
		     (eq? constr (expression-quasi-constructor-or-constructor simp)))
		(loop (cdr transforms) simp (set-union reqs1 reqs) (or any? this?))
		(return simp (set-union reqs1 reqs) (or any? this?))))))))
		
(define (JOIN-THEORY-TRANSFORM-TABLES tables)
  (let ((new (make-table)))
    (walk
     (lambda (tab)
       (walk-two-d-table
	(lambda (k1 k2 val)
	  (set (two-d-table-entry new k1 k2)
	       (append (two-d-table-entry new k1 k2) (copy-list val))))
	tab))
     tables)
    new))
  


;; (iterate loop ((new (make-table))
;; 		 (keys '())
;; 		 (tables tables))
;;     (if (null? tables)
;; 	new
;; 	(block
;; 	  (walk-two-d-table
;; 	   (lambda (k1 k2 val)
;; 	     (push keys key)
;; 	     (set (two-d-table-entry new k1 k2)
;; 		  (append (two-d-table-entry new k1 k2) (copy-list val))))
;; 	   (car tables))
;; 	  (loop new keys (cdr tables)))))
