;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald sort-constructors)

(define-operation (SORT-CONSTRUCTOR? sort-constructor))

;;;a sort constructor is essentially a procedure PROC
;;;which takes arguments THEORY NAME SORTS


(define (MAKE-SORT-CONSTRUCTOR proc symbol-form)
  (object proc
    ((sort-constructor? soi) '#t)
    ((print soi port)
     (format port "#{SORT-CONSTRUCTOR ~A}" symbol-form))))


(define (decode-sort-spec language sort-spec)
  (if (string? sort-spec)
      (string->sort language sort-spec)
      (list->sort language sort-spec)))


(define (CARTESIAN-PRODUCT-PROC theory sort-name sort-forms)
  (let* ((sorts (map (lambda (x) (decode-sort-spec (theory-language theory) x)) sort-forms))
	 (vars1 (sorts->new-variables sorts '%x '()))
	 (vars2 (sorts->new-variables sorts '%y vars1))
	 (enclosing-sort (build-maximal-higher-sort sorts unit%sort))
	 (var-f (new-variable enclosing-sort 'f (set-union vars1 vars2)))
	 (membership-predicate
	  (imps-lambda (apply forsome
			      
			      (equality
			       var-f 
			       (apply imps-lambda
				      (if-term
				       (apply
					conjunction
					(map (lambda (x y) (equality y x))
					     vars1 vars2))
				       arbitrary-individual
				       (undefined unit%sort))

				      vars1))


			      vars2)
		       var-f)))


    (sort-definition-sort
     (theory-build-sort-definition-without-checking-nonemptyness
      theory
      sort-name
      membership-predicate))))

(define (CARTESIAN-PRODUCT-BUILDER theory sort-forms)
  (let* ((sorts (map (lambda (x) (decode-sort-spec (theory-language theory) x)) sort-forms))
	 (vars1 (sorts->new-variables sorts '%x '()))
	 (vars2 (sorts->new-variables sorts '%y vars1))
	 (builder
	  (apply lambda
		 (apply imps-lambda
			(if-term
			 (apply
			  conjunction
			  (map (lambda (x y) (equality y x))
			       vars1 vars2))
			 arbitrary-individual
			 (undefined unit%sort))

			vars1)
		 vars2)))
    builder))

(define (CARTESIAN-PRODUCT-BUILDER-AND-SELECTORS
	 product-sort
	 sorts
	 builder-name
	 accessor-names)
  (let* ((n (length sorts))
	 (vars1 (sorts->new-variables sorts '%x '()))
	 (vars2 (sorts->new-variables sorts '%y vars1))
	 (var-f (new-variable product-sort 'v (set-union vars1 vars2)))
	 (builder
	  (if builder-name
	      (apply lambda

		     (apply imps-lambda
			    (if-term
			     (apply
			      conjunction
			      (map (lambda (x y) (equality y x))
				   vars1 vars2))
			     arbitrary-individual
			     (undefined unit%sort))

			    vars1)

		     vars2)
	      '#f))
	 (selectors
	  (if accessor-names
	      (block

		(or (and (list? accessor-names)
			 (= (length accessor-names) n))
		    (imps-error "CARTESIAN-PRODUCT-BUILDER-AND-SELECTORS: wrong number of accessor names."))

		(iterate loop ((i 0) (selectors nil))
		  (if (<= n i)
		      (reverse! selectors)
		
		      (let* ((ith-var (nth vars1 i))
			     (other-vars (delq ith-var vars1))
			     (ith-projection
			      (imps-lambda
			       (iota 
				(apply forsome
				       (equality
					var-f 
					(apply
					 imps-lambda
					 (if-term
					  (apply
					   conjunction
					   (map (lambda (x y) (equality y x))
						vars1 vars2))
					  arbitrary-individual
					  (undefined unit%sort))
					 vars2))
				       other-vars)
				ith-var)
			       var-f)))
			(loop (1+ i) (cons ith-projection selectors))))))
	      '#f)))
    (return builder selectors)))

(define (CARTESIAN-PRODUCT-BUILDER-AND-SELECTORS-BUILD-DEFINITIONS
	 theory
	 product
	 sort-forms
	 builder-name
	 accessor-names)
  (let* ((product-sort (decode-sort-spec (theory-language theory) product))
	 (sorts (map (lambda (x) (decode-sort-spec (theory-language theory) x)) sort-forms)))
    (receive (builder selectors)
      (cartesian-product-builder-and-selectors
       product-sort
       sorts
       builder-name
       accessor-names)
      (receive (constructor accessors)
	(return
	 (if builder-name
	     (definition-constant
	       (theory-build-definition
		theory
		builder-name
		builder
		(expression-sorting builder)
		'()))
	     '#f)
	 (if accessor-names
	     (map (lambda (name selector)
		    (definition-constant
		      (theory-build-definition
		       theory
		       name
		       selector
		       (expression-sorting selector)
		       '())))
		  accessor-names selectors)
	     '#f))

	(if (and constructor accessors)
	    (block (walk
		    (lambda (theorem)
		      (theory-add-theorem
		       theory
		       theorem
		       (theorem-name theorem)))
		    (make-record-axioms
		     (theory-language theory)
		     product-sort
		     constructor
		     accessors))
		   (record-theory-make-theorems theory product-sort constructor accessors)))
	(return constructor accessors)))))

(define CARTESIAN-PRODUCT 
  (make-sort-constructor cartesian-product-proc 'prod))


(define (POWER-SET-PROC theory sort-name sort-forms)
  (let* ((sorts (map (lambda (x) (decode-sort-spec (theory-language theory) x)) sort-forms))
	 (enclosing-sort (build-maximal-higher-sort sorts unit%sort))
	 (var-f (new-variable enclosing-sort 'f '()))
	 (membership-predicate
	  (imps-lambda truth var-f))
	 (sort-definition
	  (build-sort-definition
	   theory
	   sort-name
	   membership-predicate)))
    (theory-add-theorem
     theory
     (nonemptyness-formula sort-definition)
     (symbol-append 'nonemptyness-for-defined-sort sort-name))
    (theory-add-sort-definition
     theory
     sort-definition)
    (sort-definition-sort sort-definition)))


(define POWER-SET
  (make-sort-constructor power-set-proc 'power-set))
