;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald GENERAL-STRATEGIES)


(define DEDUCTION-GRAPH-STRATEGY-SIMPLIFICATION-PROCEDURE
  (make-simple-switch
   'deduction-graph-strategy-simplification-procedure
   procedure?
   dg-primitive-inference-simplification))

(define (inference-node-simplify-minor-hypotheses infn)
  (if (succeed-without-grounding? infn)
      (walk
       dg-primitive-inference-simplification
       (cdr (inference-node-hypotheses infn))))
  (return))

(define (DEDUCTION-GRAPH-DIRECT-INFERENCE-TO-SATISFACTION pred sqn)
;;;returns two values:
  
;;; (a) last successful inference to an assertion satisfying pred or (fail).
;;; (b) a sequent node hypothesis to this last inference if it succeeds and an 
;;;unspecified sequent node otherwise. 
  (iterate loop ((last-inference (fail)) (sqn sqn))
    (if (pred (sequent-node-assertion sqn))
	(return last-inference sqn)	;arrived to a match.
	(let ((new-inference (dg-primitive-inference-direct-inference sqn)))
	  (if (fail? new-inference)
	      (return last-inference sqn)
	      (iterate march ((hyps (inference-node-hypotheses new-inference)))
		(cond ((null? hyps) (return (fail) sqn))
			 ;;it should never get here,
			 ;;if sequent-assertion of sqn contains a match.
		      ((subexpression-satisfies?
			pred
			(sequent-node-assertion (car hyps)))
		       (loop new-inference (car hyps)))
		      (else (march (cdr hyps))))))))))


(define (DEDUCTION-GRAPH-DIRECT-INFERENCE-TO-MATCH matcher sqn strict?)
  (deduction-graph-direct-inference-to-satisfaction
   (lambda (x) (expression-matches? matcher x strict?))
   sqn))

;;;(define (DEDUCTION-GRAPH-COERCE-SUBSTITUTIONS sqn substitution)
;;;  (let ((substitution1 '()))
;;;    (walk (lambda (x) (if (true? x) (push substitution1 x))) substitution)
;;;    (let* ((targets (map target substitution1))
;;;	   (replacements (map replacement substitution1))
;;;	   (assertion (sequent-node-assertion sqn))
;;;	   (list-of-locations (map (lambda (target) (paths-to-occurrences assertion target -1))
;;;				   targets))
;;;
;;;	   ;;A list of list of paths: One list for each target specifying where it
;;;	   ;;occurs.
;;;
;;;	   (multiple-replacements
;;;	    (map (lambda (locations replacement)
;;;		   (map (lambda (location) (ignore location) replacement)
;;;			locations))
;;;		 list-of-locations replacements))
;;;	   ;;take each entry x in replacements and replace it by a list all of whose
;;;	   ;;entries are x and whose length is the length of locations.
;;;
;;;	   (locations (apply append list-of-locations))
;;;	   (copied-replacements (apply append multiple-replacements)))
;;;      (let ((inference
;;;	     (dg-primitive-inference-force-substitution sqn locations copied-replacements)))
;;;	(if (succeed? inference)
;;;	    (walk (deduction-graph-strategy-simplification-procedure)
;;;		  (cdr (inference-node-hypotheses inference))))
;;;	inference))))

;;;(define (FORCE-EQUATIONS-STRATEGY sqn eqns)
;;;  (let ((substitutions (map (lambda (x)
;;;			      (if (or (equation? x) (biconditional? x))
;;;				  (cons (expression-lhs x)
;;;					(expression-rhs x))
;;;				  '#f))
;;;			    (ultimate-conjuncts
;;;			     (list (sequent-node-assertion eqns))))))
;;;    (if (null? substitutions)
;;;	(fail)
;;;	(deduction-graph-coerce-substitutions sqn substitutions))))


;;;(define (DEDUCTION-GRAPH-COERCE-IMPLICATIONS sqn eqns)
;;;  (let ((substitutions (map (lambda (x)
;;;			      (if (implication? x)
;;;				  (cons (expression-rhs x)
;;;					(expression-lhs x))
;;;				  '#f))
;;;			    (ultimate-conjuncts
;;;			     (list (sequent-node-assertion eqns))))))
;;;    (if (null? substitutions)
;;;	(fail)
;;;	(deduction-graph-coerce-substitutions sqn substitutions))))

;;;(define (EQUATE-ARGUMENTS-STRATEGY sqn)
;;;  (let ((assertion (universal-matrix (sequent-node-assertion sqn) '())))
;;;    (if (or (and (quasi-equation? assertion)
;;;		 (application? (quasi-equation-lhs assertion))
;;;		 (application? (quasi-equation-rhs assertion)))
;;;	    (and (or (equation? assertion) (biconditional? assertion))
;;;		 (application? (expression-lhs assertion))
;;;		 (application? (expression-rhs assertion))))
;;;	
;;;	(let ((args-left (if (quasi-equation? assertion)
;;;			     (arguments (quasi-equation-lhs assertion))
;;;			     (arguments (expression-lhs assertion))))
;;;	      (args-right (if (quasi-equation? assertion)
;;;			      (arguments (quasi-equation-rhs assertion))
;;;			      (arguments (expression-rhs assertion)))))
;;;	  (let ((substitutions (map (lambda (x y) (cons x y)) args-left args-right)))
;;;	    (if (null? substitutions)
;;;		(fail)
;;;		(deduction-graph-coerce-substitutions
;;;		 sqn substitutions)))))))

(define (DEDUCTION-GRAPH-UNIVERSAL-AND-IMPLICATION-DIRECT-INFERENCES-FOR-CF sqn-node)

  (iterate loop ((sqn sqn-node) (last-inference (fail)))
    (if (or (universal? (sequent-node-assertion sqn))
	    (implication? (sequent-node-assertion sqn)))
	;;implication direct inference should be done before cross fertilization.
	(let ((inf (dg-primitive-inference-direct-inference sqn)))
	  (if (succeed-without-grounding? inf)
	      (loop (inference-node-1st-hypothesis inf) inf)
	      last-inference))
	last-inference)))

(define (DEDUCTION-GRAPH-CONJUNCTIVE-AND-EXISTENTIAL-ANTECEDENT-INFERENCES sqn-node)

  (iterate loop ((sqn sqn-node)
		 (last-inference (fail)))
    (let ((inf (any
		  (lambda (x)
		    (and
		     (or (conjunction? x) (existential? x))
		     (let
			 ((inf (dg-primitive-inference-antecedent-inference sqn x)))
		       (if (succeed-without-grounding? inf)
			   inf
			   '#f))))
		  (sequent-node-assumptions sqn))))
      (if inf
	  (loop (inference-node-1st-hypothesis inf) inf)
	  last-inference))))

(define (DEDUCTION-GRAPH-INFERENCES-FOR-CROSS-FERTILIZATION sqn)

  (let* ((inf1 (deduction-graph-universal-and-implication-direct-inferences-for-cf sqn))
	 (sqn1 (if (succeed-without-grounding? inf1)
		   (inference-node-1st-hypothesis inf1)
		   sqn)))
    (let ((inf2 (deduction-graph-conjunctive-and-existential-antecedent-inferences sqn1)))
      (if (succeed-without-grounding? inf2)
	  inf2
	  inf1))))

(define (DEDUCTION-GRAPH-CROSS-FERTILIZE sqn)
  (let* ((inf (deduction-graph-inferences-for-cross-fertilization sqn))
	 (sqn (if (succeed? inf) (inference-node-1st-hypothesis inf) sqn)))
    (iterate iter ((sqn sqn)
		   (infn (fail))
		   (assumptions (sequent-node-assumptions sqn)))
      (if (null? assumptions)
	  infn
	  (let ((new-infn
		 (if (backchain-equivalence? (car assumptions))
		     (dg-primitive-inference-backchain-inference sqn (car assumptions))
		     (fail))))
	    (if (succeed-without-grounding? new-infn)
		(iter (inference-node-1st-hypothesis new-infn)
		      new-infn
		      (cdr assumptions))
		(iter sqn
		      infn
		      (cdr assumptions))))))))



;;some basic strategy constructors

(define (SERIES-STRATEGY-CONSTRUCTOR procs)
  (lambda (sqn)
    (iterate loop ((procs procs) (last-inference (fail)) (sqn sqn))
      (if (null? procs) last-inference
	  (let* ((next-inference ((car procs) sqn))
		 (sqn-1 (if (succeed-without-grounding? next-inference)
			    (inference-node-1st-hypothesis next-inference)
			    sqn)))
	    (if (immediately-grounded? sqn-1);;stop applying procs
		next-inference
		(loop (cdr procs)
		      (if (succeed? next-inference)
			  next-inference
			  last-inference)
		      sqn-1)))))))

(define (REPEAT-STRATEGY-CONSTRUCTOR procs)
  (lambda (sqn)
    (let ((series
	   (lambda (sqn)
	     (iterate loop ((procs procs) (last-inference (fail)) (sqn sqn))
	       (if (null? procs) last-inference
		   (let* ((next-inference ((car procs) sqn))
			  (sqn-1 (if (succeed-without-grounding? next-inference)
				     (inference-node-1st-hypothesis next-inference)
				     sqn)))
		     (if (immediately-grounded? sqn-1);;stop applying procs
			 next-inference
			 (loop (cdr procs)
			       (if (succeed? next-inference)
				   next-inference
				   last-inference)
			       sqn-1))))))))
      (iterate loop ((sqn sqn) (last-inference (fail)))
	(let ((inf (series sqn)))
	  (if (succeed? inf)
	      (loop (inference-node-1st-hypothesis inf) inf)
	      last-inference))))))

(define (SEQUENTIAL-STRATEGY-CONSTRUCTOR procs)
  (lambda (sqn)
   (iterate loop ((sqn sqn) (last-inference (fail)) (procs procs))
     (cond ((null? procs) last-inference)
	   (else (let ((new-inf ((car procs) sqn)))
		   (if (succeed-without-grounding? new-inf)
		       (loop (inference-node-1st-hypothesis new-inf)
			     new-inf
			     (cdr procs))
		       last-inference)))))))


(define (PARALLEL-STRATEGY-CONSTRUCTOR procs)
  (lambda (sqn)
    (iterate loop ((procs procs))
     ;;keep doing until something changes
     (if (null? procs) (fail)
	 (let ((new-inf ((car procs) sqn)))
	   (if (succeed? new-inf) new-inf 
	       (loop (cdr procs))))))))


(define (DEDUCTION-GRAPH-APPLY-IN-SEQUENCE procs sqn)
  ((series-strategy-constructor procs) sqn))

;;(build-universal-command procedure the-name arg-check . retrieval-protocol)

;;;Terminal Strategies.

(define GLOBAL-STRATEGY-PERSISTENCE
    (make-simple-switch 'global-strategy-persistence number? 3))

(define-structure-type STRATEGY-PARAMETERS
  node-list 
  persistence 
  do-simplification?
  weaken
  avoid-assumptions)

(set (strategy-parameters-node-list (stype-master strategy-parameters-stype)) '())
(set (strategy-parameters-weaken (stype-master strategy-parameters-stype)) '())
(set (strategy-parameters-do-simplification? (stype-master strategy-parameters-stype)) '#t)
(set (strategy-parameters-persistence (stype-master strategy-parameters-stype))
     (global-strategy-persistence))
(set (strategy-parameters-avoid-assumptions (stype-master strategy-parameters-stype)) '())

(define (set-strategy-persistence new-value)
  (set (strategy-parameters-persistence (stype-master strategy-parameters-stype)) new-value))

;;;given an inference inf sees if all its hypotheses are already in PARAMS.
;;;If not, PARAMS  is modified.

(define (FAILED-OR-REDUNDANT-INFERENCE? inf params)
  (cond ((fail? inf) '#t)
	((null? (inference-node-hypotheses inf)) '#f)
	(else
	 (let ((hyps (inference-node-hypotheses inf)))
	   (if (or (subset? hyps (strategy-parameters-node-list params))
		   (any?
		    (lambda (sqn) (falsehood? (sequent-node-assertion sqn)))
		    hyps))
	       '#t
	       '#f)))))

(define (MARK-AS-VISITED sqn params)
  (set (strategy-parameters-node-list params)
       (add-set-element sqn (strategy-parameters-node-list params)))
  sqn)

(define (INFERENCE-ULTIMATELY-SUCCEEDS-FOR-STRATEGY? proc sqn inf params)
  (mark-as-visited sqn params)
  (cond ((immediately-grounded? sqn) '#t)
	((failed-or-redundant-inference? inf params) '#f)
	(else (every?
	       (lambda (x)
		 (proc x params))
	       (inference-node-hypotheses inf)))))	


(define (PROVE-BY-RAISING-CONDITIONALS-AND-SIMPLIFICATION sqn params)
  (cond ((immediately-grounded? sqn))
	((memq? sqn (strategy-parameters-node-list params)) '#f)
	((and (strategy-parameters-do-simplification? params)
	      (bind (((strategy-parameters-do-simplification? params) '#f))
		(inference-ultimately-succeeds-for-strategy?
		 prove-by-raising-conditionals-and-simplification
		 sqn
		 ((deduction-graph-strategy-simplification-procedure) sqn)
		 params))))
	  
	((inference-ultimately-succeeds-for-strategy?
	  prove-by-raising-conditionals-and-simplification
	  sqn
	  (dg-primitive-inference-direct-inference sqn)
	  params))
	(else 
	 (bind (((strategy-parameters-do-simplification? params) '#t))
	   (inference-ultimately-succeeds-for-strategy?
	    prove-by-raising-conditionals-and-simplification
	    sqn
	    (deduction-graph-raise-conditional-and-direct-inference sqn)
	    params)))))

(build-universal-command
 (lambda (sqn persistence)
    (let ((params (make-strategy-parameters)))
      (set (strategy-parameters-persistence params) persistence)
      (prove-by-logic-and-simplification sqn params)))
 'prove-by-logic-and-simplification
 (always '#t)
 'persistence-request-retrieval-protocol)

(define (PROVE-BY-LOGIC-AND-SIMPLIFICATION sqn params)
  (let ((assumptions (sequent-node-assumptions sqn)))
    (cond
     ;;before computing any inferences see if sqn obviously fails or succeeds.

     ((immediately-grounded? sqn))
     ((memq? sqn (strategy-parameters-node-list params)) '#f)

     ((and (strategy-parameters-do-simplification? params)
	   (bind (((strategy-parameters-do-simplification? params) '#f))
	     (inference-ultimately-succeeds-for-strategy?
	      prove-by-logic-and-simplification
	      sqn
	      ((deduction-graph-strategy-simplification-procedure) sqn)
	      params))))
	  
     ((and (> (strategy-parameters-persistence params) 0)
	   (any? (lambda (x);;try backchaining through-formula first
		   (bind (((strategy-parameters-do-simplification? params) '#t)
			  ((strategy-parameters-persistence params)
			   (fx- (strategy-parameters-persistence params) 1)))
		     (inference-ultimately-succeeds-for-strategy?
		      prove-by-logic-and-simplification
		      sqn
		      (dg-primitive-inference-backchain-through-formula-inference sqn x)
		      params)))
		 assumptions)))
	  
     ((any? (lambda (antecedent-formula)
	      (and 
	       (or (existential? antecedent-formula)
		   (conjunction? antecedent-formula))
	       (inference-ultimately-succeeds-for-strategy?
		prove-by-logic-and-simplification
		sqn
		(dg-primitive-inference-antecedent-inference
		 sqn
		 antecedent-formula)
		params)))
	    assumptions))
     ((inference-ultimately-succeeds-for-strategy?
       prove-by-logic-and-simplification
       sqn
       (dg-primitive-inference-direct-inference sqn)
       params))
     ((bind (((strategy-parameters-do-simplification? params) '#t))
	(any? (lambda (antecedent-formula)
		(and (not (existential? antecedent-formula))
		     (not (conjunction? antecedent-formula))
		     (inference-ultimately-succeeds-for-strategy?
		      prove-by-logic-and-simplification
		      sqn
		      (dg-primitive-inference-antecedent-inference
		       sqn
		       antecedent-formula)
		      params)))
	      assumptions)))
     ((and (> (strategy-parameters-persistence params) 0)
	   (any? (lambda (x);;try backchaining next
		   (bind (((strategy-parameters-do-simplification? params) '#t)
			  ((strategy-parameters-persistence params)
			   (fx- (strategy-parameters-persistence params) 1)))
		     (inference-ultimately-succeeds-for-strategy?
		      prove-by-logic-and-simplification
		      sqn
		      (dg-primitive-inference-backchain-inference sqn x)
		      params)))
		 assumptions)))
     ((inference-ultimately-succeeds-for-strategy?
       prove-by-logic-and-simplification
       sqn
       (dg-primitive-inference-sort-definedness sqn)
       params))
     ((inference-ultimately-succeeds-for-strategy?
       prove-by-logic-and-simplification
       sqn
       (dg-primitive-inference-definedness sqn)
       params))
     ((bind (((strategy-parameters-do-simplification? params) '#t))
	(inference-ultimately-succeeds-for-strategy?
	 prove-by-logic-and-simplification
	 sqn
	 (dg-primitive-inference-extensionality sqn)
	 params)))
     (else 
      (bind (((strategy-parameters-do-simplification? params) '#t))
	(inference-ultimately-succeeds-for-strategy?
	 prove-by-logic-and-simplification
	 sqn
	 (deduction-graph-raise-conditional-and-direct-inference sqn)
	 params))))))

;;;(define (prove-without-backchaining sqn params)
;;;  (let ((assumptions (sequent-node-assumptions sqn)))
;;;    (cond ((immediately-grounded? sqn))
;;;	  ((memq? sqn (strategy-parameters-node-list params)) '#f)
;;;	  ((and (strategy-parameters-do-simplification? params)
;;;		(bind (((strategy-parameters-do-simplification? params) '#f))
;;;		  (inference-ultimately-succeeds-for-strategy?
;;;		   prove-without-backchaining
;;;		   sqn
;;;		   ((deduction-graph-strategy-simplification-procedure) sqn)
;;;		   params))))
;;;	  
;;;	  ((any? (lambda (antecedent-formula)
;;;		   (and 
;;;		    (or (existential? antecedent-formula)
;;;			(conjunction? antecedent-formula))
;;;		    (inference-ultimately-succeeds-for-strategy?
;;;		     prove-without-backchaining
;;;		     sqn
;;;		     (dg-primitive-inference-antecedent-inference
;;;		      sqn
;;;		      antecedent-formula)
;;;		     params)))
;;;		 assumptions))
;;;	  
;;;	  ((inference-ultimately-succeeds-for-strategy?
;;;	    prove-without-backchaining
;;;	    sqn
;;;	    (dg-primitive-inference-direct-inference sqn)
;;;	    params))
;;;	  ((bind (((strategy-parameters-do-simplification? params) '#t))
;;;	     (any? (lambda (antecedent-formula)
;;;		     (and (not (existential? antecedent-formula))
;;;			  (not (conjunction? antecedent-formula))
;;;			  (inference-ultimately-succeeds-for-strategy?
;;;			   prove-without-backchaining
;;;			   sqn
;;;			   (dg-primitive-inference-antecedent-inference
;;;			    sqn
;;;			    antecedent-formula)
;;;			   params)))
;;;		   assumptions)))
;;;	  ((inference-ultimately-succeeds-for-strategy?
;;;	    prove-without-backchaining
;;;	    sqn
;;;	    (dg-primitive-inference-sort-definedness sqn)
;;;	    params))
;;;	  ((inference-ultimately-succeeds-for-strategy?
;;;	    prove-without-backchaining
;;;	    sqn
;;;	    (dg-primitive-inference-definedness sqn)
;;;	    params))
;;;	  ((bind (((strategy-parameters-do-simplification? params) '#t))
;;;	     (inference-ultimately-succeeds-for-strategy?
;;;	      prove-without-backchaining
;;;	      sqn
;;;	      (dg-primitive-inference-extensionality sqn)
;;;	      params)))
;;;	  (else 
;;;	   (bind (((strategy-parameters-do-simplification? params) '#t))
;;;	     (inference-ultimately-succeeds-for-strategy?
;;;	      prove-without-backchaining
;;;	      sqn
;;;	      (deduction-graph-raise-conditional-and-direct-inference sqn)
;;;	      params))))))

;;;(build-universal-command 
;;;  (lambda (sqn)
;;;    (let ((params (make-strategy-parameters)))
;;;      (prove-without-backchaining sqn params)))
;;;  'prove-without-backchaining
;;;  (always '#t))

(define (DEDUCTION-GRAPH-RAISE-CONDITIONAL-AND-DIRECT-INFERENCE sqn)
  (let* ((inf (deduction-graph-raise-conditional sqn))
	 (sqn-1
	  (if (succeed-without-grounding? inf)
	      (inference-node-1st-hypothesis inf)
	      '#f))
	 (inf-1 (if sqn-1
		    (dg-primitive-inference-direct-inference sqn-1)
		    (fail))))
    (if sqn-1 (if (succeed? inf-1) inf-1 inf) (fail))))
    


(define (SORT-EXPRESSION-LIST-BY-CONSTRUCTOR exprs constructors)
  (let* ((EXPRESSION-WEIGHT
	  (lambda (expr)
	    (length (memq (expression-constructor expr) constructors))))
	 (PROC (lambda (a b) (> (expression-weight a) (expression-weight b)))))
    (sort exprs proc)))

;;;(define (MULTIPLE-INSTANTIATION-STRATEGY sqn aux-sqn)
;;;  (let* ((1st-inf (generalize-existential-assertion sqn (sequent-node-assertion aux-sqn)))
;;;	 (sqn-1 (if (succeed? 1st-inf) (inference-node-1st-hypothesis 1st-inf)
;;;		    sqn))
;;;	 (weaken (make-strategy-parameters)))
;;;    (iterate loop ((sqn-k sqn-1)
;;;		   (last-inference (fail))
;;;		   (instances (set-difference (sequent-node-assumptions aux-sqn)
;;;					      (sequent-node-assumptions sqn-1))))
;;;      
;;;      (if (null? instances) ;;terminates when instances have been exhausted.
;;;	  
;;;	  (let ((next-to-final (if (succeed? last-inference)
;;;				  last-inference
;;;				  1st-inf)))
;;;	    (if (succeed? next-to-final)
;;;		(let ((last-if-succeeds
;;;		       (dg-primitive-inference-weakening
;;;			(inference-node-1st-hypothesis next-to-final)
;;;			(strategy-parameters-weaken weaken))))
;;;		  (if (succeed? last-if-succeeds)
;;;		      last-if-succeeds
;;;		      next-to-final))
;;;		next-to-final))
;;;	  (let ((next-inference (instantiate-universal-assumption
;;;				 sqn-k
;;;				 (car instances)
;;;				 weaken)))
;;;	    (if (succeed? next-inference)
;;;		(loop (inference-node-1st-hypothesis next-inference)
;;;		      next-inference
;;;		      (cdr instances))
;;;		(loop sqn-1 last-inference (cdr instances))))))))


(define (GENERALIZE-EXISTENTIAL-ASSERTION sqn generalize)
  (let* ((assert (sequent-node-assertion sqn))
	 (graph (sequent-node-graph sqn))
	 (subst (existential-generalization? sqn assert generalize)))
    (if (succeed? subst)
	(let ((sqn (precede-by-direct-or-antecedent-inferences sqn subst)))
	  (let* ((seq (build-sequent (sequent-node-context sqn) generalize))
		 (new-sqn (post seq graph))
		 (generalization-inference
		  (dg-primitive-inference-existential-generalization
		   sqn
		   new-sqn )))
	    (if (succeed? generalization-inference)
		(walk (lambda (x) ((deduction-graph-strategy-simplification-procedure) x))
		      (cdr (inference-node-hypotheses generalization-inference))))
	    generalization-inference))
	(fail))))

;;; Doesn't seem to occur anywhere:    
     
;;;(define (INSTANTIATE-UNIVERSAL-ASSUMPTION sqn instance weaken)
;;;  (let ((graph (sequent-node-graph sqn)))
;;;    (receive (assumption subst)
;;;      (iterate iter ((asses (sequent-node-assumptions sqn)))
;;;	(if (null? asses)
;;;	    (return '#f (fail))
;;;	    (let ((subst (universal-instantiation? sqn (car asses) instance)))
;;;	      (if (succeed? subst)
;;;		  (return (car asses) subst)
;;;		  (iter (cdr asses))))))
;;;      (if
;;;       (not assumption)
;;;       (fail)
;;;       (let ((sqn (precede-by-direct-or-antecedent-inferences sqn subst)))
;;;	 (set (strategy-parameters-weaken weaken)
;;;	      (add-set-element assumption
;;;			       (strategy-parameters-weaken weaken)))
;;;	 (invoke-if-necessary
;;;	  (dg-primitive-inference-cut
;;;	   sqn 
;;;	   (post (build-sequent
;;;		  (context-add-assumption
;;;		   (sequent-node-context sqn)
;;;		   instance)
;;;		  (sequent-node-assertion sqn))
;;;		 graph))
;;;	  (lambda (cut-infn)
;;;	    ;; (selective-antecedent-inferences-strategy
;;;	    ;;  (major-premise cut-infn)
;;;	    ;;  (list instance))
;;;	    (invoke-if-necessary
;;;	     (dg-primitive-inference-universal-instantiation
;;;	      (inference-node-2nd-hypothesis cut-infn)
;;;	      (post
;;;	       (build-sequent (sequent-node-context sqn) assumption)
;;;	       graph))
;;;	     (lambda (ui-infn)
;;;	       ;;
;;;	       ;; First simplify the sort-definedness conditions.
;;;	       ;; 
;;;	       (map (deduction-graph-strategy-simplification-procedure)
;;;		    (cdr (inference-node-hypotheses ui-infn)))
;;;	       ;;
;;;	       ;; Then knock off the universal assertion, which should belong to the context
;;;	       ;;
;;;	       (dg-primitive-inference-weak-simplification (major-premise ui-infn))
;;;	       cut-infn)))))))))

;; (define (INSTANTIATE-UNIVERSAL-ASSUMPTION sqn instance weaken)
;;   (let ((generalization
;; 	 (any
;; 	  (lambda (y)
;; 	    (let ((subst (universal-instantiation? sqn y instance)))
;; 	      (if (succeed? subst) (cons subst y) '#f)))
;; 	  (sequent-node-assumptions sqn)))
;; 	;;find a context assumption which generalizes INSTANCE.
;; 	(graph (sequent-node-graph sqn)))
;;     (if generalization
;; 	(let ((sqn
;; 	       (precede-by-direct-or-antecedent-inferences sqn (car generalization)))
;; 	      (generalizing-assumption
;; 	       (cdr generalization)))
;; 	  
;; 	  (set (strategy-parameters-node-list weaken)
;; 	       (add-set-element generalizing-assumption
;; 				(strategy-parameters-node-list weaken)))
;; 	  (let* ((seq-a (build-sequent
;; 			 (context-add-assumption
;; 			  (sequent-node-context sqn)
;; 			  instance)
;; 			 (sequent-node-assertion sqn)))
;; 		 (seq-b (build-sequent
;; 			 (sequent-node-context sqn)
;; 			 generalizing-assumption))
;; 		 (sqn-a (post seq-a graph))
;; 		 (sqn-b (post seq-b graph))
;; 		 (cut-inference
;; 		  (dg-primitive-inference-cut
;; 		    sqn sqn-a))
;; 		 (cut-obligation
;; 		  (inference-node-2nd-hypothesis cut-inference))
;; 		 (generalization-inference
;; 		  (dg-primitive-inference-universal-instantiation
;; 		   cut-obligation
;; 		   sqn-b)))
;; 	  
;; 	    (if (succeed? generalization-inference)
;; 		(block
;; 		  (map (deduction-graph-strategy-simplification-procedure)
;; 		       (cdr (inference-node-hypotheses generalization-inference)))
;; 		  ;;These are the sort-definedness conditions.
;; 		  ;;Next comes the sequent which contains is assertion as an assumption.
;; 		  (let* ((hyp1 (inference-node-1st-hypothesis generalization-inference))
;; 			 (weakening (dg-primitive-inference-weakening
;; 				     hyp1
;; 				     (delete-set-element
;; 				      generalizing-assumption
;; 				      (sequent-node-assumptions hyp1))))
;; 			 (sqn1 (if (succeed? weakening)
;; 				   (inference-node-1st-hypothesis weakening)
;; 				   hyp1)))
;; 		    ((deduction-graph-strategy-simplification-procedure) sqn1))))
;; 
;; ;;; The following was commented out so that multiple instantiations would be possible.
;; ;;;
;; ;;;	  (dg-primitive-inference-weakening
;; ;;;	   (inference-node-1st-hypothesis cut-inference)
;; ;;;	   (list generalizing-assumption))
;; 
;; 	    cut-inference))
;; 	  
;; 	(fail))))

(define (DEDUCTION-GRAPH-UNIVERSAL-DIRECT-INFERENCES sqn)
  ;;If sqn has a universal assertion, returns an inference. Otherwise returns (fail).
  (iterate loop ((sqn sqn) (last-inference (fail)))
    (if (let ((assertion (sequent-node-assertion sqn)))
	  (or (universal? assertion)

	      ;;The following will strengthen the sequent with definedness assertions.

	      (and (implication? assertion)
		   (or (convergence? (implication-antecedent assertion))
		       (convergence-in-sort? (implication-antecedent assertion))))))
	(let ((next-inference (dg-primitive-inference-direct-inference sqn)))
	  (if (succeed? next-inference)
	      (loop (inference-node-1st-hypothesis next-inference) next-inference)
	      last-inference))
	last-inference)))

(define (DEDUCTION-GRAPH-EXISTENTIAL-ANTECEDENT-INFERENCES assum sqn)
  ;;If assum is existential, always returns an inference. Otherwise returns (fail).
  (iterate loop ((sqn sqn) (assum assum) (last-inference (fail)))
    (if (and (formula? assum) (existential? assum))
	(let* ((next-inference (dg-primitive-inference-antecedent-inference sqn assum))
	       ;;it had better succeed.
	       (next-sqn (inference-node-1st-hypothesis next-inference))
	       (next-assum (car
			    (set-difference
			     (sequent-node-assumptions next-sqn)
			     (sequent-node-assumptions sqn)))))
	  
	  ;;It is possible that the sequent node assumptions of
	  ;;next-sqn be contained in those of sqn.
	  ;;In this case it is easiest to terminate, rather than reconstruct the
	  ;;appropriate assumption (see FORSOME-ANTECEDENT-INFERENCE
	  ;;in constructor-inferences.) Termination is assured by the entry condition
	  ;;of the recursive call.
	  ;;In fact this is justified by the application below.
	  
	  (loop (inference-node-1st-hypothesis next-inference)
		next-assum
		next-inference))
	last-inference)))

(define (PRECEDE-BY-DIRECT-OR-ANTECEDENT-INFERENCES sqn subst)

  ;;An inference (forall-direct or forsome-antecedent) frees a variable
  ;;iff the variable does not occur freely in the
  ;;conclusion sequent but does occurs freely in the inference hypothesis.
  ;;This procedure returns a sequent-node in which no forall-direct-inference or
  ;;existential-antecedent-inference can free any variables in subst.

  ;;First find those variables in subst which do not occur freely in sequent.

  (let* ((vars (set-difference
		(big-u
		 (map (lambda (x) (free-variables (replacement x))) subst))
		(sequent-free-variables (sequent-node-sequent sqn))))
					   
	 (assums '())
	 (assertion
	  (let ((formula (sequent-node-assertion sqn)))
	    (if (and (universal? formula)
		     (set-intersection
		      (nested-quantified-variables formula)
		      vars))
		formula
		'#f))))
    (walk (lambda (x) (if (and (existential? x)
			       (set-intersection
				(nested-quantified-variables x)
				vars))
			  (push assums x)))
	  (sequent-node-assumptions sqn))

    ;;do universal direct inferences if possible.
    
    (let* ((direct-inference
	    (if assertion
		(deduction-graph-universal-direct-inferences sqn)
		(fail)))
	   (sqn1 (if (succeed? direct-inference)
		      (inference-node-1st-hypothesis direct-inference)
		      sqn)))

      ;;starting from sqn1 do antecedent inferences.
      (iterate loop ((sqn* sqn1) (last-inference (fail)) (assums assums))
	(if (null? assums)
	    (if (fail? last-inference)
		sqn1
		(inference-node-1st-hypothesis last-inference))
	    (let ((next-inference
		   (deduction-graph-existential-antecedent-inferences
		    (car assums)
		    sqn*))) ;;must succeed!
	      (loop (inference-node-1st-hypothesis next-inference)
		    next-inference
		    (cdr assums))))))))

;;;returns a substitution if f2 generalizes (in the case of existential) or
;;;instantiates (in the case of universal). Otherwise returns (fail).
	
(define (EXISTENTIAL-GENERALIZATION? sqn f1 f2)
  (if (existential? f1)
      (match-under-exoscopes
       (existential-matrix f2 '())
       (existential-matrix
	f1 
	;;
	;; Guttman -- doesn't this make more sense than '(), which is what is was?  
	;;
	(sequent-free-variables (sequent-node-sequent sqn)))
       (set-difference (sequent-free-variables (sequent-node-sequent sqn))
		       (newly-bound-variables f1)))
      (fail)))

(define (UNIVERSAL-INSTANTIATION? sqn f1 f2)
  (if (universal? f1)
      (match-under-exoscopes
       (universal-matrix f2 '())
       (universal-matrix
	f1 
	;;
	;; Guttman -- doesn't this make more sense than '(), which is what is was?  
	;;
	(sequent-free-variables (sequent-node-sequent sqn)))
       (set-difference (sequent-free-variables (sequent-node-sequent sqn))
		       (newly-bound-variables f1)))
      (fail)))

;;;(build-universal-command 
;;; multiple-instantiation-strategy
;;; 'instantiate-multiply
;;; (always '#t)
;;; 'one-sequent-argument-retrieval-protocol)

(define (instantiate-existential-strategy sqn term-or-term-strings)
  (let ((terms (map
		(lambda (str)
		  (sqn-coerce-to-expression sqn str))
		term-or-term-strings)))
    (instantiate-existential sqn terms)))

(build-universal-command 
 instantiate-existential-strategy
 'instantiate-existential
 (always '#t)
 'instantiate-existential-retrieval-protocol)

(define (instantiate-universal-antecedent-multiply-strategy
	 sqn
	 assum-str-or-num
	 term-or-term-strings-s)
  (let  ((assumption (sqn-coerce-to-assumption sqn assum-str-or-num))
	 (terms-s (map
		   (lambda (term-strings)
		     (map
		      (lambda (str)
			 (sqn-coerce-to-expression sqn str))
		      term-strings))
		   term-or-term-strings-s)))
      (instantiate-universal-antecedent-multiply sqn assumption terms-s)))

(build-universal-command 
  instantiate-universal-antecedent-multiply-strategy
  'instantiate-universal-antecedent-multiply
  (always '#t)
  'instantiate-universal-multiply-retrieval-protocol)

(define (instantiate-universal-antecedent-strategy sqn assum-str-or-num term-or-term-strings)
  (let ((terms (map
		(lambda (str)
		  (sqn-coerce-to-expression sqn str))
		term-or-term-strings)))

    (let ((assumption
	   (sqn-coerce-to-assumption sqn assum-str-or-num)))
      (instantiate-universal-antecedent-once sqn assumption terms))))	

(build-universal-command 
  instantiate-universal-antecedent-strategy
  'instantiate-universal-antecedent
  (always '#t)
  'instantiate-universal-retrieval-protocol)

(define (SIMPLIFY-ANTECEDENT-STRATEGY sqn assum-str-or-num)
  (let ((assumption
	 (sqn-coerce-to-assumption sqn assum-str-or-num)))
    (let ((infn (dg-primitive-inference-contraposition
		 sqn
		 assumption)))
    
      ;;(nth (sequent-node-assumptions sqn) assumption-no)

      (if (fail? infn)
	  (fail)
	  (let ((infn2 ((deduction-graph-strategy-simplification-procedure)
			(car (inference-node-hypotheses infn)))))
	    (if (fail? infn2)
		(fail)
		(if (succeed-without-grounding? infn2)
		    (let ((sqn2 (car (inference-node-hypotheses infn2))))
		      (dg-primitive-inference-contraposition
		       sqn2
		       (nth (sequent-node-assumptions sqn2) 0)))
		    infn2)))))))

(build-universal-command 
 simplify-antecedent-strategy
 'simplify-antecedent
 (always '#t)
 'simplify-antecedent-retrieval-protocol)

(define (BETA-REDUCE-ANTECEDENT-STRATEGY sqn assum-str-or-num)
  (let ((assumption
	 (sqn-coerce-to-assumption sqn assum-str-or-num)))
  (beta-reduce-antecedent-strategy-aux-1 
   sqn 
   assumption)))

(define (BETA-REDUCE-ANTECEDENT-STRATEGY-AUX-1 sqn assumption)
  (let ((infn (dg-primitive-inference-implication-elimination sqn assumption)))
    (if (fail? infn)
	(fail)
	(let ((infn2 (deduction-graph-beta-reduce-repeatedly
		      (car (inference-node-hypotheses infn)))))
	  (if (fail? infn2)
	      (fail)
	      (if (succeed-without-grounding? infn2)
		  (let ((sqn2 (car (inference-node-hypotheses infn2))))
		    (dg-primitive-inference-direct-inference sqn2))
		  infn2))))))

(define (BETA-REDUCE-ANTECEDENT-STRATEGY-AUX-2 sqn assumption)
  (let ((assertion (sequent-node-assertion sqn))
	(infn (dg-primitive-inference-contraposition sqn assumption)))
    (if (fail? infn)
	(fail)
	(let ((infn2 (deduction-graph-beta-reduce-repeatedly
		      (car (inference-node-hypotheses infn)))))
	  (if (fail? infn2)
	      (fail)
	      (if (succeed-without-grounding? infn2)
		  (let ((sqn2 (car (inference-node-hypotheses infn2))))
		    (dg-primitive-inference-contraposition sqn2 (push-not assertion)))
		  infn2))))))

(build-universal-command 
 beta-reduce-antecedent-strategy
 'beta-reduce-antecedent
 (always '#t)
 'simplify-antecedent-retrieval-protocol)

;; (define (INSTANTIATE-THEOREM sqn theorem terms)
;;   (let ((formula (theorem-formula theorem)))
;;     (if
;;      (universal? formula)
;;      (let* ((subst (map cons (binding-variables formula) terms))
;; 	    (sqn (precede-by-direct-or-antecedent-inferences sqn subst)))
;;        (labels 
;; 	   ((instance (apply-substitution subst (binding-body formula)))
;; 	    (context (sequent-node-context sqn))
;; 	    (assertion (sequent-node-assertion sqn))
;; 	    ((do-ui-etc infn)
;; 	     (if
;; 	      (not (inference-node? infn))
;; 	      (fail)
;; 	      (let ((cut-minor (cadr (inference-node-hypotheses infn))))
;; 		(do-td-and-simplification
;; 		 (dg-primitive-inference-universal-instantiation
;; 		  cut-minor
;; 		  (post
;; 		   (build-sequent context formula)
;; 		   (sequent-node-graph sqn))))
;; 		infn)))
;; 	    ((do-td-and-simplification infn)
;; 	     (if
;; 	      (not (inference-node? infn))
;; 	      (fail)
;; 	      (let ((major (car (inference-node-hypotheses infn)))
;; 		    (minors (cdr (inference-node-hypotheses infn))))
;; 		(let ((theorem-discharge
;; 		       (dg-primitive-inference-theorem-assumption major formula)))
;; 		  (if (not (inference-node? theorem-discharge))
;; 		      (block (imps-warning
;; 			      "instantiate-theorem: discharge of \"theorem\" ~S failed:  what gives?"
;; 			      theorem)
;; 			     (fail))
;; 		      (block
;; 			(walk (deduction-graph-strategy-simplification-procedure) minors)
;; 			((deduction-graph-strategy-simplification-procedure)
;; 			 (car (inference-node-hypotheses theorem-discharge)))
;; 			infn)))))))
;; 
;; 	 (do-ui-etc
;; 	  (dg-primitive-inference-cut
;; 	   sqn
;; 	   (post
;; 	    (build-sequent
;; 	     (context-add-assumption context instance)
;; 	     assertion)
;; 	    (sequent-node-graph sqn))))))
;;      (dg-primitive-inference-theorem-assumption sqn formula))))


(define (instantiate-theorem-strategy sqn thm-or-thm-name term-or-term-strings)
  (let ((terms (map
		(lambda (str)
		  (sqn-coerce-to-expression sqn str))
		term-or-term-strings)))
    (instantiate-theorem sqn (coerce-to-theorem thm-or-thm-name) terms)))

(build-universal-command 
 instantiate-theorem-strategy
 'instantiate-theorem
 (always '#t)
 'theorem-instantiation-retrieval-protocol)

;; (define (instantiate-universal-antecedent sqn assumption terms)
;;   (imps-enforce universal? assumption)
;;   (let ((subst (targets-and-replacements->subst (binding-variables assumption) terms)))
;;     ;;;may fail because terms aren't of the right type
;;     (if (succeed? subst) 
;; 	(multiple-instantiation-strategy
;; 	 sqn
;; 	 (post
;; 	  (build-sequent
;; 	   (context-add-assumption
;; 	    (context-omit-assumption
;; 	     (sequent-node-context sqn)
;; 	     assumption)
;; 	    (apply-substitution-fastidiously
;; 	     subst 
;; 	     (binding-body assumption)))
;; 	   (sequent-node-assertion sqn))
;; 	  (sequent-node-graph sqn)))
;; 	(fail))))

;;;(define (instantiate-universal-antecedent sqn assumption-no terms)
;;;  (let ((context (sequent-node-context sqn)))
;;;    (if (< (length (context-assumptions context)) assumption-no)
;;;	(imps-error "instantiate-universal-antecedent: Not enough assumptions for index ~D."
;;;		    assumption-no))
;;;    (let ((universal
;;;	   (imps-enforce
;;;	    universal?
;;;	    (nth (context-assumptions context) assumption-no))))
;;;      (multiple-instantiation-strategy
;;;       sqn
;;;       (post
;;;	(build-sequent
;;;	 (context-add-assumption
;;;	  (context-omit-assumption
;;;	   (sequent-node-context sqn)
;;;	   universal)
;;;	  (apply-substitution
;;;	   (targets-and-replacements->subst (binding-variables universal) terms)
;;;	   (binding-body universal)))
;;;	 (sequent-node-assertion sqn))
;;;	(sequent-node-graph sqn))))))
      
(define (TRANSPORT-AND-INSTANTIATE-THEOREM-STRATEGY 
	 sqn thm-or-thm-name trans-or-trans-name terms-or-term-strings)
  (let ((terms (map
		(lambda (str) (sqn-coerce-to-expression sqn str))
		terms-or-term-strings))
	(thm (coerce-to-theorem thm-or-thm-name)))
    (if trans-or-trans-name
	(let ((translation (coerce-to-translation trans-or-trans-name)))
	    
	  (instantiate-theorem
	   sqn
	   (transport-theorem translation thm)
	   terms))
	(auto-transport-and-instantiate-theorem-strategy sqn thm terms))))
	

(build-universal-command 
 transport-and-instantiate-theorem-strategy
 'instantiate-transported-theorem
 (always '#t)
 'instantiate-transported-theorem-retrieval-protocol)

(define (AUTO-TRANSPORT-AND-INSTANTIATE-THEOREM-STRATEGY sqn theorem terms)
  (let* ((vars (binding-variables (theorem-formula theorem)))
	 (source-theory (theorem-home-theory theorem))
	 (target-theory (sequent-theory (sequent-node-sequent sqn)))
	 (translation (translation-match-variables
		       (theorem-home-theory theorem)
		       target-theory
		       the-empty-set
		       (select-common-sub-theories
			source-theory
			target-theory
			(fixed-theories-set))
		       vars
		       terms)))
    (if (translation? translation)
	(instantiate-theorem		; TRANSLATION is a theory interpretation
	 sqn
	 (bind (((omit-theorem-usage-hooks) '#t))
	   (transport-theorem translation theorem))
	 terms)
	(fail))))

;;;(build-universal-command 
;;; auto-transport-and-instantiate-theorem-strategy
;;; 'instantiate-auto-transported-theorem
;;; (always '#t)
;;; 'instantiate-auto-transported-theorem-retrieval-protocol)

(build-universal-command
 (lambda (sqn)
   (prove-by-direct-inference sqn (make-strategy-parameters)))
 'direct-inference-strategy
 (always '#t))

(build-universal-command
 (lambda (sqn)
   (prove-by-insistent-direct-inference sqn (make-strategy-parameters)))
 'insistent-direct-inference-strategy
 (always '#t))

(define (prove-by-direct-inference sqn params)
  (cond ((immediately-grounded? sqn))
	((memq? sqn (strategy-parameters-node-list params)) '#f)
	((inference-ultimately-succeeds-for-strategy?
	  prove-by-direct-inference
	  sqn
	  (dg-primitive-inference-direct-inference sqn)
	  params))
	(else '#t)))

(define (prove-by-insistent-direct-inference sqn params)
  (cond ((immediately-grounded? sqn))
	((memq? sqn (strategy-parameters-node-list params)) '#f)
	((inference-ultimately-succeeds-for-strategy?
	  prove-by-insistent-direct-inference
	  sqn
	  (dg-primitive-inference-insistent-direct-inference sqn)
	  params))

	(else '#t)))

(define (selective-antecedent-inferences sqn params)
  (let ((assumptions (sequent-node-assumptions sqn)))
    (cond ((immediately-grounded? sqn))
	  ((memq? sqn (strategy-parameters-node-list params)) '#f)
	  ((any? (lambda (antecedent-formula)
		   (inference-ultimately-succeeds-for-strategy?
		    selective-antecedent-inferences
		    sqn
		    (dg-primitive-inference-antecedent-inference
		     sqn
		     antecedent-formula)
		    params))
		 (set-difference assumptions (strategy-parameters-avoid-assumptions params))))
	  (else '#t))))

(define (selective-antecedent-inferences-strategy sqn assumptions-assumption-strings-or-indices)
  (let ((assumptions (map (lambda (x) (sqn-coerce-to-assumption sqn x))
			  assumptions-assumption-strings-or-indices)))
    (let ((params (make-strategy-parameters)))
      (set (strategy-parameters-avoid-assumptions params)
	   (set-difference
	    (sequent-node-assumptions sqn)
	    assumptions))
      (selective-antecedent-inferences sqn params))))

(build-universal-command
 selective-antecedent-inferences-strategy
 'antecedent-inference-strategy
 (always '#t)
 'selective-antecedent-inference-rp)

(define (TRANSPORT-AND-ASSUME-THEOREM-STRATEGY
	 sqn
	 thm-or-thm-name
	 trans-or-trans-name)
  (let ((formula
	 (theorem-formula
	  (transport-theorem
	   (coerce-to-translation trans-or-trans-name)
	   (coerce-to-theorem thm-or-thm-name)))))
    (dg-primitive-inference-theorem-assumption sqn formula)))
	

(build-universal-command
  transport-and-assume-theorem-strategy
  'assume-transported-theorem
  (always '#t)
  'assume-transported-theorem-retrieval-protocol)


(define (CASE-SPLIT sqn assertions-or-assertion-strings)
  (let ((assertions (map (lambda (x) (sqn-coerce-to-expression sqn x))
			 assertions-or-assertion-strings)))
    (if
     (null? assertions)
     (fail)
     (let* ((assertion-negation-pairs (map (lambda (x) (list x (negation x))) assertions))
	    (list-of-conjunction-components (big-product assertion-negation-pairs))
	    (big-disjunction
	     (apply disjunction (map (lambda (x)
				       (conjunction-simplifier x))
				     list-of-conjunction-components)))
	    (new-sqn
	     (post
	      (build-sequent
	       (sequent-node-context sqn)
	       big-disjunction)
	      (sequent-node-graph sqn))))
       (dg-primitive-inference-simplification new-sqn)
       (dg-primitive-inference-disjunction-elimination sqn new-sqn)))))


(define CASE-SPLIT-STRATEGY CASE-SPLIT)

(build-universal-command
 case-split-strategy
 'case-split
 (always '#t)
 'case-split-retrieval-protocol)

(define (local-definition-strategy sqn var-name val-string)
  (let* ((sequent (sequent-node-sequent sqn))
	 (context (sequent-context sequent))
	 (assertion (sequent-assertion sequent))
	 (value (sequent-read sequent val-string))
	 (var (find-variable var-name (expression-sorting value)))
	 (existential (forsome (equality var value) var)))
    ;; (crawl (the-environment))
    (let ((cut-infn
	   (dg-primitive-inference-cut
	    sqn
	    (post
	     (build-sequent
	      (context-add-assumption context existential)
	      assertion)
	     (sequent-node-graph sqn)))))
      (if (fail? cut-infn)
	  (fail)
	  (destructure (((cut-major cut-minor) (inference-node-hypotheses cut-infn)))
	    (let ((exist-infn
		   (dg-primitive-inference-existential-generalization
		    cut-minor
		    (post (build-sequent
			   context
			   (equality value value))
			  (sequent-node-graph sqn)))))
	      
	      (if (fail? exist-infn)
		  (fail)
		  (walk
		   (deduction-graph-strategy-simplification-procedure)
		   (inference-node-hypotheses exist-infn))))
	    (dg-primitive-inference-antecedent-inference cut-major existential))))))

;;;(build-universal-command
;;; local-definition-strategy
;;; 'local-definition
;;; (always '#t)
;;; 'local-definition-retrieval-protocol)

(define (INSTANTIATE-THEOREM-WITH-SEQUENT-FREE-VARIABLES sqn thm)
  (if (and (universal? thm)
	   (= (length (binding-variables thm)) 1))
      (let ((terms (sequent-free-variables (sequent-node-sequent sqn)))
	    (sort (expression-sorting (car (binding-variables thm)))))
	(iterate loop ((terms terms) (sqn sqn) (last-inference (fail)))
	  (if (null? terms)
	      last-inference
	      (let ((next-inference
		     (if (eq? (expression-sorting (car terms)) sort)
			 (instantiate-theorem sqn thm (list (car terms)))
			 (fail))))
		(if (succeed-without-grounding? next-inference)
		    (loop (cdr terms)
			  (inference-node-1st-hypothesis next-inference)
			  next-inference)
		    (loop (cdr terms) sqn last-inference))))))
      (fail)))


;;;(define (DEDUCTION-GRAPH-CONTRAPOSITION-AND-SIMPLIFICATION sqn antecedent-formula)
;;;  (let ((inf (deduction-graph-contraposition sqn antecedent-formula)))
;;;    (if (fail? inf)
;;;	(fail)
;;;	((deduction-graph-strategy-simplification-procedure) 
;;;	 (inference-node-1st-hypothesis inf)))))


(define (USE-DEFINITIONS sqn def-names)
  (let* ((theory (context-theory (sequent-node-context sqn)))
	 (graph (sequent-node-graph sqn))
	 (defs (map (lambda (x) (theory-get-definition theory x)) def-names))
	 (assums '()))
    (walk
     (lambda (x) (if (not (null? x)) (push assums (definition-axiom x))))
     defs)
    (let* ((new-sqn (post
		     (build-sequent
		      (context-add-assumptions (sequent-node-context sqn) assums)
		      (sequent-node-assertion sqn))
		     graph))
	   (inf (dg-primitive-inference-cut sqn new-sqn)))
      inf)))

(build-universal-command
 use-definitions
 'use-definitions
 (always '#t)
 'definition-names-retrieval-protocol)

(define (CASE-SPLIT-ON-CONDITIONALS sqn occurrences)
  (let* ((assertion (sequent-node-assertion sqn))
	 (sorted-paths (sort-paths!
			(paths-to-satisfying-virtual-occurrences
			 assertion
			 conditional-term? -1))))
    (if (null? sorted-paths)
	(fail)
	(invoke-if-necessary
	 (case-split
	  sqn
	  (map
	   (lambda (path)
	     (conditional-test (follow-virtual-path assertion path)))
	   (choose-list-entries sorted-paths occurrences)))
	 (lambda (infn)
	   (map
	    dg-primitive-inference-simplification
	    (inference-node-hypotheses infn)))))))

(build-universal-command
 case-split-on-conditionals
 'case-split-on-conditionals
 (always '#t)
 'locations-in-formula-retrieval-protocol)

(define (direct-and-antecedent-inference-strategy sqn)
  (let ((original-assumptions (sequent-node-assumptions sqn)))
    (iterate iter ((sqn sqn) (params (make-strategy-parameters)))
      (let ((assumptions (sequent-node-assumptions sqn)))
	(cond ((immediately-grounded? sqn))
	      ((memq? sqn (strategy-parameters-node-list params)) '#f)
	      ((inference-ultimately-succeeds-for-strategy?
		iter 
		sqn
		(dg-primitive-inference-direct-inference sqn)
		params))
	      ((any?
		(lambda (antecedent-formula)
		  (inference-ultimately-succeeds-for-strategy?
		   iter 
		   sqn
		   (dg-primitive-inference-antecedent-inference
		    sqn
		    antecedent-formula)
		   params))
		(set-difference assumptions original-assumptions)))
	      (else '#t))))))

(define (insistent-direct-and-antecedent-inference-strategy sqn)
  (let ((original-assumptions (sequent-node-assumptions sqn)))
    (iterate iter ((sqn sqn) (params (make-strategy-parameters)))
      (let ((assumptions (sequent-node-assumptions sqn)))
	(cond ((immediately-grounded? sqn))
	      ((memq? sqn (strategy-parameters-node-list params)) '#f)
	      ((inference-ultimately-succeeds-for-strategy?
		iter 
		sqn
		(dg-primitive-inference-insistent-direct-inference sqn)
		params))
	      ((any?
		(lambda (antecedent-formula)
		  (inference-ultimately-succeeds-for-strategy?
		   iter 
		   sqn
		   (dg-primitive-inference-antecedent-inference
		    sqn
		    antecedent-formula)
		   params))
		(set-difference assumptions original-assumptions)))
	      (else '#t))))))

(define (direct-and-antecedent-inference-strategy-with-simplification sqn)
  (continue-terminal-command-with-command
   direct-and-antecedent-inference-strategy
   sqn
   '()
   dg-primitive-inference-simplification))
	       
(build-universal-command
 direct-and-antecedent-inference-strategy
 'direct-and-antecedent-inference-strategy
 (always '#t))

(build-universal-command
 insistent-direct-and-antecedent-inference-strategy
 'insistent-direct-and-antecedent-inference-strategy
 (always '#t))

(build-universal-command
 direct-and-antecedent-inference-strategy-with-simplification 
 'direct-and-antecedent-inference-strategy-with-simplification 
 (always '#t))


(define (sort-definedness-and-conditionals sqn)
  (invoke-if-necessary
   (dg-primitive-inference-sort-definedness sqn)
   (lambda (infn)
     (let ((infn2
	    (dg-primitive-inference-macete-application-at-paths
	     (major-premise infn)
	     '(())
	     *beta-reduce-repeatedly-macete*)))
       (let ((major (major-premise
		     (if (succeed-without-grounding? infn2)
			 infn2
			 infn))))
	 (continue-terminal-command-with-command
	  prove-by-insistent-direct-inference
	  major
	  (list (make-strategy-parameters))
	  (lambda (sqn)
	    (let ((infn2
		   (dg-primitive-inference-macete-application-at-paths
		    sqn
		    '(())
		    *beta-reduce-repeatedly-macete*)))
	      (let ((major (if (succeed-without-grounding? infn2)
			       (major-premise infn2)
			       sqn)))
		(continue-terminal-command-with-command
		 case-split-on-conditionals
		 major
		 '((0))
		 dg-primitive-inference-simplification))))))))))
	    
	   
(build-universal-command
 sort-definedness-and-conditionals
 'sort-definedness-and-conditionals
 (always '#t))


(define (DEDUCTION-GRAPH-ELIMINATE-DEFINED-IOTA-EXPRESSION sqn iota-expr-index new-var-name)
  (or (name->theory 'pure-generic-theory-1)
      (imps-error "DEDUCTION-GRAPH-ELIMINATE-DEFINED-IOTA-EXPRESSION: ~A"
		  "The theory PURE-GENERIC-THEORY-1 is not loaded."))
  (let* ((sequent (sequent-node-sequent sqn))
	 (assertion (sequent-node-assertion sqn))
	 (paths 
	  (sort-paths! 
	   (paths-to-satisfying-virtual-occurrences assertion iota-expression? -1)))
	 (iota-expression
	  (if (<= (length paths) iota-expr-index)
	      (imps-error "DEDUCTION-GRAPH-ELIMINATE-DEFINED-IOTA-EXPRESSION: ~A ~D ~A."
			  "the index" iota-expr-index "is too big")
	      (follow-virtual-path assertion (nth paths iota-expr-index))))
	 (iota-variable (car (binding-variables iota-expression)))
	 (predicate (imps-lambda (binding-body iota-expression) iota-variable))
	 (ind-1-sort (name->sort (theory-language pure-generic-theory-1) 'ind_1))
	 (new-j-variable (find-variable new-var-name ind-1-sort))
	 (subst (list (cons (find-variable 'i ind-1-sort) 
			    (find-variable (name iota-variable) ind-1-sort))
		      (cons (find-variable 'j ind-1-sort) new-j-variable)
		      (cons (find-variable 'j_1 ind-1-sort) 
			    (find-variable 
			     (concatenate-symbol new-var-name '_1) ind-1-sort))))
	 (theorem 
	  (apply-variable-renaming 
	   subst 
	   (name->theorem 'defined-iota-expression-full-existence)))
	 (fixed-theories 
	  (select-common-sub-theories 
	   pure-generic-theory-1 (sequent-theory sequent) (fixed-theories-set)))
	 (translation (build-translation
		       pure-generic-theory-1
		       (sequent-theory sequent)
		       the-empty-set
		       fixed-theories
		       (list (cons ind-1-sort (expression-sorting iota-variable)))
		       '() '#f '#f '#t))
	 (new-variable (translate-expression translation new-j-variable))
	 (new-theorem (transport-theorem translation theorem))
	 (inf1 (instantiate-theorem
		sqn
		new-theorem
		(list predicate)
		'no-antecedent-infs))
	 (instance 
	  (apply-substitution 
	   (list (cons (car (binding-variables new-theorem)) predicate))
	   (binding-body new-theorem)))
	 (beta-reduced-instance 
	  (context-beta-reduce (theory-null-context (sequent-theory sequent)) instance))
	 (instance-conjunction (binding-body (expression-rhs beta-reduced-instance)))
	 (instance-first-conjunct (car (expression-components instance-conjunction))))
    (if 
     (fail? inf1)
     (fail)
     (let ((inf2 
	    (beta-reduce-antecedent-strategy-aux-2
	     (inference-node-1st-hypothesis inf1)
	     instance)))
       (if 
	(fail? inf2)
	(fail)
	(let ((inf3 
	       (dg-primitive-inference-antecedent-inference
		(inference-node-1st-hypothesis inf2)
		beta-reduced-instance)))
	  (if 
	   (fail? inf3)
	   inf2
	   (let ((inf4 
		  (dg-primitive-inference-antecedent-inference
		   (inference-node-2nd-hypothesis inf3)
		   (expression-rhs beta-reduced-instance))))
	     (if 
	      (fail? inf4)
	      inf3
	      (let ((inf5 
		     (dg-primitive-inference-antecedent-inference
		      (inference-node-1st-hypothesis inf4)
		      instance-conjunction)))
		(if 
		 (fail? inf5)
		 inf4
		 (let* ((hyp-sqn (inference-node-1st-hypothesis inf5))
			(assert (sequent-node-assertion hyp-sqn))
			(iota-expr-paths
			 (paths-to-satisfying-virtual-occurrences 
			  assert 
			  (lambda (expr) (eq? expr iota-expression))
			  -1))
			(inf6 
			 (deduction-graph-force-substitution-at-virtual-paths
			  hyp-sqn
			  new-variable
			  iota-expr-paths)))
		   (if 
		    (fail? inf6)
		    inf5
		    (block
		      (let ((inf7 
			     (dg-primitive-inference-contraposition
			      (inference-node-1st-hypothesis inf3)
			      (expression-lhs beta-reduced-instance))))
			(if 
			 (fail? inf7)
			 (fail)
			 (dg-primitive-inference-simplification
			  (inference-node-1st-hypothesis inf7))))
		      (walk dg-primitive-inference-simplification
			    (cdr (inference-node-hypotheses inf6)))
		      (let ((inf8 
			     (dg-primitive-inference-weakening
			      (inference-node-1st-hypothesis inf6)
			      (list instance-first-conjunct))))
			(if 
			 (fail? inf8)
			 inf6
			 inf8))))))))))))))))



(build-universal-command
 deduction-graph-eliminate-defined-iota-expression
 'eliminate-defined-iota-expression
 (always '#t)
 'eliminate-defined-iota-expression-retrieval-protocol)

(define (backchain-repeatedly sqn formulas-formula-strings-or-indices)
  (let ((assumptions
	 (map (lambda (x) (sqn-coerce-to-assumption sqn x))
	      formulas-formula-strings-or-indices)))
    (let ((do-backchain
	   (lambda (sqn)
	     (any
	      (lambda (a)
		(let ((infn (dg-primitive-inference-backchain-inference
			     sqn
			     a)))
		  (and (succeed? infn) infn)))
	      assumptions))))
      (iterate iter ((sqn sqn)
		     (last-infn (fail)))
	(let ((infn-or-nil (do-backchain sqn)))
	  (if infn-or-nil
	      (iter (major-premise infn-or-nil) infn-or-nil)
	      last-infn))))))

(build-universal-command
 backchain-repeatedly
 'backchain-repeatedly
 (always '#t)
 'repeated-backchain-rp)


