;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SOME-SECTIONS)


;;; Pre-reals

(def-section PRE-REALS
  (auxiliary-file (theories auxiliary-files/pre-reals aux))
  (files (imps theories/reals/reals)
	 (imps theories/reals/pre-reals)
	 (imps theories/reals/mutual-interp)))


;;; Foundation sections

(def-section REALS
  (auxiliary-file (theories auxiliary-files/reals aux))
  (files 
   (imps theories/reals/reals)
   (imps theories/reals/some-elementary-macetes)
   (imps theories/reals/arithmetic-strategies)))

(def-section BASIC-REAL-ARITHMETIC
  (auxiliary-file (theories auxiliary-files/basic-real-arithmetic aux))
  (component-sections reals)
  (files 
   (imps theories/reals/some-lemmas)
   (imps theories/reals/arithmetic-macetes)
   (imps theories/reals/number-theory)))

(def-section PURE-GENERIC-THEORIES
  (auxiliary-file (theories auxiliary-files/pure-generic-theories aux))
  (files 
   (imps theories/generic-theories/pure-generic-theories)
   (imps theories/generic-theories/iota)))

(def-section GENERIC-THEORIES
  (auxiliary-file (theories auxiliary-files/generic-theories aux))
  (component-sections basic-real-arithmetic pure-generic-theories)
  (files 
   (imps theories/generic-theories/generic-theories)))

(def-section INDICATORS
  (auxiliary-file (theories auxiliary-files/indicators aux))
  (files 
   (imps theories/generic-theories/indicators)
   (imps theories/generic-theories/indicator-lemmas)))

(def-section MAPPINGS
  (auxiliary-file (theories auxiliary-files/mappings aux))
  (component-sections indicators pure-generic-theories)
  (files 
   (imps theories/generic-theories/mappings)
   (imps theories/generic-theories/mapping-lemmas)
   (imps theories/generic-theories/inverse-lemmas)))

(def-section FOUNDATION
  (auxiliary-file (theories auxiliary-files/foundation aux))
  (component-sections generic-theories mappings)
  (files 
   (imps theories/reals/reals-supplements)
   (imps theories/reals/some-obligations)
   ))

(def-section NUMBER-THEORY
  (component-sections foundation)
  (files
   (imps theories/reals/primes)
   (imps theories/reals/modular-arithmetic)))

;;; Real mathematics

(def-section CALCULUS-OVER-THE-REALS
  (auxiliary-file 
   (theories auxiliary-files/calculus-over-the-reals aux))
  (component-sections foundation)
  (files 
   (imps theories/reals/limits)
   (imps theories/reals/examples)))


;;; Generic theories

(def-section PAIRS
  (auxiliary-file (theories auxiliary-files/pairs aux))
  (component-sections foundation)
  (files 
   (imps theories/generic-theories/pairs)))

(def-section SEQUENCES
  (auxiliary-file (theories auxiliary-files/sequences aux))
  (component-sections foundation)
  (files 
   (imps theories/generic-theories/sequences)))

(def-section BINARY-RELATIONS
  (auxiliary-file (theories auxiliary-files/binary-relations aux))
  (component-sections foundation)
  (files 
   (imps theories/generic-theories/binary-relations)))

;;; Cardinality

(def-section BASIC-CARDINALITY
  (auxiliary-file (theories auxiliary-files/basic-cardinality aux))
  (component-sections foundation)
  (files 
   (imps theories/cardinality/cardinality)
   (imps theories/cardinality/finite-cardinality)
   (imps theories/cardinality/partition-lemmas)
   (imps theories/cardinality/omega-embedding-supplements)))

(def-section SCHROEDER-BERNSTEIN-THEOREM
  (auxiliary-file 
   (theories auxiliary-files/schroeder-bernstein-theorem aux))
  (component-sections foundation)
  (files 
   (imps theories/cardinality/cardinality)
   (imps theories/cardinality/schroeder-bernstein-theorem)))


;;; Groups

(def-section BASIC-GROUP-THEORY
  (auxiliary-file 
   (theories auxiliary-files/basic-group-theory aux))
  (component-sections foundation)
  (files 
   (imps theories/groups/groups)
   (imps theories/groups/subgroups)
   (imps theories/groups/group-actions)
   (imps theories/groups/group-lemmas)
   (imps theories/groups/cosets)
   (imps theories/groups/normal-subgroups)))

(def-section FUNDAMENTAL-COUNTING-THEOREM
  (auxiliary-file (theories auxiliary-files/fundamental-counting-theorem aux))
  (component-sections basic-cardinality basic-group-theory)
  (files 
   (imps theories/groups/group-cardinality)
   (imps theories/groups/counting-theorem)))

(def-section COUNTING-THEOREMS-FOR-GROUPS
  (auxiliary-file (theories auxiliary-files/counting-theorems-for-groups aux))
  (component-sections fundamental-counting-theorem)
  (files 
   (imps theories/groups/little-counting-theorem)))

(def-section GROUP-INTERPRETATIONS
  (auxiliary-file (theories auxiliary-files/group-translations aux))
  (component-sections basic-group-theory)
   (files 
    (imps theories/groups/group-to-field-interpretations)))


;;; Orders and relations

(def-section PARTIAL-ORDERS
  (auxiliary-file (theories auxiliary-files/partial-orders aux))
  (component-sections foundation)
  (files 
   (imps theories/partial-orders/partial-order)
   (imps theories/partial-orders/real-order-properties)
   (imps theories/partial-orders/convergence-and-order)
   (imps theories/partial-orders/misc-convergence-and-order)
   (imps theories/partial-orders/real-order-properties)))

(def-section KNASTER-FIXED-POINT-THEOREM
   (auxiliary-file (theories auxiliary-files/knaster aux))
   (component-sections  partial-orders)
   (files
    (imps theories/partial-orders/knaster-fixed-point-theorem)
    (imps theories/partial-orders/applications)
    (imps theories/partial-orders/schroeder-bernstein)))

(def-section BASIC-MONOIDS
  (auxiliary-file (theories auxiliary-files/basic-monoids aux))
  (component-sections foundation)
  (files 
   (imps theories/algebra/monoids)
   (imps theories/algebra/monoids-supplements)))

(def-section AUXILIARY-MONOIDS
  (auxiliary-file (theories auxiliary-files/auxiliary-monoids aux))
  (component-sections basic-monoids)
  (files 
   (imps theories/algebra/monoids-and-cardinality)
   (imps theories/algebra/monoids-examples)))

(def-section GROUPS-AS-MONOIDS
  (auxiliary-file (theories auxiliary-files/groups-as-monoids aux))
  (component-sections basic-monoids basic-group-theory)
  (files 
   (imps theories/algebra/groups-as-monoids)
   (imps theories/reals/telescoping)))

(def-section BASIC-FIELDS
  (auxiliary-file (theories auxiliary-files/basic-fields aux))
  (component-sections foundation)
  (files 
   (imps theories/algebra/fields)
   (imps theories/algebra/fields-supplements)))

(def-section BINOMIAL-THEOREM
  (auxiliary-file (theories auxiliary-files/binomial-theorem aux))
  (component-sections basic-fields)
  (files 
   (imps theories/reals/comb-ident)
   (imps theories/algebra/recursive-formulas)))

(def-section COUNTING-THEOREMS-FOR-SUBSETS
  (auxiliary-file (theories auxiliary-files/counting-theorems-for-subsets aux))
  (component-sections basic-cardinality)
  (files
   (imps theories/reals/comb-ident)
   (imps theories/cardinality/combinatorics)))
  
;;; Metric spaces

(def-section METRIC-SPACES
  (auxiliary-file (theories auxiliary-files/metric-spaces aux))
  (component-sections foundation)
  (files 
   (imps theories/metric-spaces/metric-spaces)
   (imps theories/metric-spaces/metric-space-supplements)))

(def-section METRIC-SPACE-CONVERGENCE
  (auxiliary-file (theories auxiliary-files/metric-space-convergence aux))
  (component-sections partial-orders metric-spaces)
  (files 
   (imps theories/metric-spaces/criteria-for-convergence)))
   
(def-section METRIC-SPACE-PAIRS
  (auxiliary-file (theories auxiliary-files/metric-space-pairs aux))
  (component-sections metric-spaces)
  (files 
   (imps theories/metric-spaces/metric-space-pairs)
   (imps theories/metric-spaces/metric-space-pairs-supplements)
   (imps theories/metric-spaces/metric-space-self-mappings)))

(def-section METRIC-SPACE-SUBSPACES
  (auxiliary-file (theories auxiliary-files/metric-space-subspaces aux))
  (component-sections metric-space-pairs)
  (files 
   (imps theories/metric-spaces/subspaces)))

(def-section METRIC-SPACE-CONTINUITY
  (auxiliary-file (theories auxiliary-files/metric-space-continuity aux))
  (component-sections metric-space-pairs)
  (files 
   (imps theories/metric-spaces/metric-space-triples)
   (imps theories/metric-spaces/examples-of-continuity)
   (imps theories/metric-spaces/examples-of-uniform-continuity)
   (imps theories/metric-spaces/mappings-from-an-interval)
   (imps theories/metric-spaces/inequalities-and-continuity)))

(def-section MAPPING-SPACES
  (auxiliary-file (theories auxiliary-files/mapping-spaces aux))
  (component-sections partial-orders metric-space-pairs)
  (files 
   (imps theories/metric-spaces/pointed-metric-spaces)
   (imps theories/metric-spaces/mappings-into-pointed-metric-spaces)
   (imps theories/metric-spaces/continuous-mapping-spaces)
   (imps theories/metric-spaces/ptwise-continuous-mapping-spaces)
   (imps theories/metric-spaces/uniformly-continuous-mapping-spaces)))

(def-section BANACH-FIXED-POINT-THEOREM
  (auxiliary-file 
   (theories auxiliary-files/banach-fixed-point-theorem aux))
  (component-sections partial-orders metric-spaces)
  (files 
   (imps theories/metric-spaces/fixed-point-theorem)))


;;; Normed spaces

(def-section ABSTRACT-CALCULUS
  (auxiliary-file 
   (theories auxiliary-files/abstract-calculus aux))
  (component-sections banach-fixed-point-theorem)
  (files
   (imps theories/normed-spaces/normed-spaces)
   (imps theories/normed-spaces/derivatives)
   (imps theories/normed-spaces/integrals)
   (imps theories/normed-spaces/open-mapping)
   (imps theories/normed-spaces/derivatives-supplements)))

;;; Machine arithmetic

(def-section MACHINE-ARITHMETIC
  (auxiliary-file 
   (theories auxiliary-files/machine-arithmetic aux))
  (files
   (imps theories/machine-arithmetic/machine-arithmetic)
   (imps theories/machine-arithmetic/gcd)))


;;; Complete initial theory library

(def-section INITIAL-THEORY-LIBRARY
  (auxiliary-file (theories auxiliary-files/initial-theory-library aux))
  (component-sections pre-reals
		      foundation
		      calculus-over-the-reals
		      pairs
		      sequences
		      counting-theorems-for-groups
		      partial-orders
		      groups-as-monoids
		      binomial-theorem
		      metric-space-convergence
		      metric-space-subspaces
		      metric-space-continuity
		      mapping-spaces
		      abstract-calculus))

