;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SUBSTITUTION-APPLICATION)


; It should be emphasized that the procedures in this file do not check for the
; definedness of their arguments and are thus not generally valid.  They may
; legitimately be called only in contexts where it is known that substituends
; will in fact be well-defined.  


; Definition of:  A term being free for a variable in an expression.
; IE, (FREE-FOR? t v e) is true if no FREE occurrences of v in e is within the
; scope of an operator that binds any variable occurring free in t.  

(define (FREE-FOR? t v e)
  (let ((t-variables (free-variables t)))
    (or (not (memq? v (free-variables e)))
	(null-intersection? t-variables (bound-variables e))
	(and (null-intersection? t-variables (newly-bound-variables e))
	     (every?
	      (lambda (c)
		(free-for? t v c))
	      (expression-components e))))))

(define (VAR-NAMES-DISJOINT? expr1 expr2)
  (let ((vars1 (variables expr1))
	(vars2 (variables expr2)))
    (every?
     (lambda (v1)
       (let ((n (name v1)))
	 (every?
	  (lambda (v2)
	    (not (eq? n (name v2))))
	  vars2)))
     vars1)))

(define (FREE-BY-NAME-FOR? t v e)
  (and (free-for? t v e)
       (or (not (memq? v (free-variables e)))
	   (var-names-disjoint? e t))))
	

(define (FREE-AND-BOUND-VARIABLES-DISJOINT? expr)
  (null-intersection?
   (free-variables expr)
   (bound-variables expr)))

(define (canonicalize expr)
  (if (any?
       canonical-variable? 
       (free-variables expr))
      '#f
      (iterate iter ((expr expr)
		     (back 0))
	(cond ((formal-symbol? expr) expr)
	      ((not (binding-expression? expr))
	       (let ((constr (expression-constructor expr))
		     (comps  (expression-components expr)))
		 (apply constr
			(map
			 (lambda (expr) (iter expr back))
			 comps))))
	      (else
	       (let ((constr (expression-constructor expr))
		     (body  (binding-body expr))
		     (subst (make-canonical-substitution
			     (binding-variables expr)
			     back)))
		 (apply constr
			(apply-substitution
			 subst
			 (iter body (1+ back)))
			(map cdr subst))))))))

(define (canonical-variable? var)
  (and (variable? var)
       (canonical-symbol? (name var))))

(define (make-canonical-substitution vars back)
  (enforce is-set? vars)
  (iterate iter ((over 0)
		 (vars vars)
		 (subst the-empty-substitution))
    (if (null? vars)
	(reverse! subst)
	(iter (fx+ over 1)
	      (cdr vars)
	      (cons (cons (car vars)
			  (make-canonical-variable
			   back over
			   (expression-sorting (car vars))))
		    subst)))))
			  
	  
	  
(define (make-canonical-variable back over sorting)
  (find-variable (make-canonical-symbol back over)
		 sorting))

(define (make-canonical-symbol n1 n2)
  (string->symbol
   (format nil "v~D_~D" n1 n2)))

(define (canonical-symbol? sym)
  (let ((str (symbol->string sym)))
    (and (or (char= (string-elt str 0) #\v)
	     (char= (string-elt str 0) #\V))
	 (let ((un-pos (string-posq #\_ str))
	       (len (string-length str)))
	   (and un-pos
		(iterate iter ((i 1))
		  (cond ((fx= i len) '#t)
			((fx= i un-pos) (iter (fx+ i 1)))
			((digit? (string-elt str i) 10) (iter (fx+ i 1)))
			(else '#f))))))))
		    

(define (APPLY-SUBSTITUTION-FASTIDIOUSLY sub expr)
  (if (every-subst-component?				;check no b-v clashes
       (lambda (comp)					;return nil if clash
	 (let ((r (replacement comp))
	       (t (target comp)))	   
	   (or (eq? r t)
	       (free-by-name-for? r t expr))))
       sub)
      (apply-subst-to-exp-with-exoscopes sub expr '())
      (;;
       ;;would really prefer to do:
       ;; apply-substitution-fastidiously
       ;;but it makes an infinite loop.
       ;;
       apply-subst-to-exp-with-exoscopes
       sub
       (change-bound-variables
	expr
	(set-union					;at the very least!
	 (free-variables expr)
	 (collect-set free-variables (map-substitution replacement sub))))
       '())))

(define (APPLY-SUBSTITUTION-AT-PATH subst expr path)
  (let ((effective-subst
	 (substitution-filter-relevance
	  subst
	  expr
	  (bound-variables-on-path expr path))))
    (substitution-at-path
     expr
     (apply-substitution-fastidiously
      effective-subst
      (follow-path expr path))
     path)))

;;; APPLYING SUBSTITUTIONS TO EXPRESSIONS

(define (APPLY-SUBSTITUTION sub expr)
  (if (every-subst-component?				;check no b-v clashes
       (lambda (comp)					;return nil if clash
	 (free-for? (replacement comp)
		    (target comp)
		    expr))
       sub)
      (apply-subst-to-exp-with-exoscopes sub expr '())
      (apply-subst-to-exp-with-exoscopes
       sub
       (change-bound-variables
	expr
	(set-union (collect-set free-variables (map-substitution replacement sub))
		   (free-variables expr)))
       '())))
      

(define (APPLY-SUBST-TO-EXP-WITH-EXOSCOPES sub exp exoscopes)
  ;;sub is a substitution, exp is an expression, 
  ;;and exoscopes is a set of variables.
  (cond ((constant? exp) exp)
	((subset? (free-variables exp) exoscopes) exp)
	((variable? exp)				;not in exoscopes--see previous case
	 (let ((repl (substitution-find-replacement sub exp)))
	   (or repl exp)))
	(else						;necessarily compound
	 (let ((sub sub))
	   ;;
	   ;; Used to be 
	   ;;
	   ;; (substitution-filter-relevance sub exp exoscopes)
	   ;;
	   ;; 
	   (cond ((empty-substitution? sub) exp)
		 ((binding-expression? exp)
		   (apply-subst-to-binding-exp-with-exoscopes sub exp exoscopes))
		 (else					;non-binding
		  (apply-subst-to-non-binding-exp-with-exoscopes sub exp exoscopes)))))))
	       
	 
(define (APPLY-SUBST-TO-BINDING-EXP-WITH-EXOSCOPES sub exp exoscopes)
  ;; sub is a substitution, exp is a binding expression which is
  ;; not a target of sub, and exoscopes is a set of variables.
  (apply (expression-constructor exp)			;same constructor 
	 (apply-subst-to-exp-with-exoscopes
	  sub						;substituted body
	  (car (expression-components exp))
	  (set-union (newly-bound-variables exp)
		     exoscopes))
	 (cdr (expression-components exp))))		;same newly-bound-variables 
    

(define (APPLY-SUBST-TO-NON-BINDING-EXP-WITH-EXOSCOPES sub exp exoscopes)
  ;; sub is a substitution, exp is a non-binding, compund expression
  ;; which is not a target of sub, and exoscopes is a set of variables.
	 
  (apply (expression-constructor exp)			;same constructor 
	 (map (lambda (x)
		(apply-subst-to-exp-with-exoscopes	;substituted components 
		 sub x exoscopes))		
	      (expression-components exp))))

(define (filter-substitution filter? subst)
  (iterate iter ((subst-comps subst)
		 (val '()))
    (cond ((null? subst-comps) (reverse! val))
	  ((filter? (car subst-comps))
	   (iter (cdr subst-comps)
		 (cons (car subst-comps) val)))
	  (else
	   (iter (cdr subst-comps)
		 val)))))

(define (SUBSTITUTION-FILTER-RELEVANCE sub exp exoscopes)
  (iterate rel-sub ((sub-comps sub) (val nil))
    (if (empty-substitution? sub-comps)
	val
	(let ((first (first-subst-component sub-comps))
	      (rest (rest-of-subst sub-comps)))
	  (if (relevant-subst-component? first exp exoscopes)
	      (rel-sub rest (cons first val))
	      (rel-sub rest val))))))

(define (RELEVANT-SUBST-COMPONENT? sub-comp exp exoscopes)
  (let ((target (target sub-comp)))
    (and (not (memq? target exoscopes))
	 (memq? target (free-variables exp)))))

(define (FREE-UNDER-EXOSCOPES? exp exoscopes)
  (null-intersection? (free-variables exp) exoscopes))

;;; (FREE-OCCURRENCE? exp1 exp2 exoscopes) is true if exp1 has any occurrence
;;; in exp2 which is free with respect to the current exoscopes and any
;;; introduced along the path to the occurrence.   

(define (FREE-OCCURRENCE? exp1 exp2 exoscopes)
  (let ((f-vs (free-variables exp1))
	(b-vs (bound-variables exp1))
	(cs (constants exp1))
	(h (expression-height exp1)))
    (iterate iter ((big-exp exp2)
		   (exoscopes exoscopes))
      (or (eq? exp1 big-exp)
	  (and (< h (expression-height big-exp))
	       (null-intersection? f-vs exoscopes)
	       (subset? f-vs (free-variables big-exp))
	       (subset? b-vs (bound-variables big-exp))
	       (subset? cs (constants big-exp))
	       (let ((new-exoscopes
		      (set-union (newly-bound-variables exp2)
				 exoscopes))
		     (components
		      (if (binding-expression? exp2)
			  (car (expression-components exp2))
			  (expression-components exp2))))
		 (any?
		  (lambda (exp)
		    (iter exp new-exoscopes))
		  components)))))))

(define (match-by-leading-constants? expr pattern)
  (or (variable? pattern)
      (and (eq? (expression-constructor expr)
		(expression-constructor pattern))
	   (or (not (lead-constant? (expression-lead-constant pattern)))
	       (eq? (expression-lead-constant expr)
		    (expression-lead-constant pattern)))
	   (or (not (lead-constant? (expression-second-lead-constant pattern)))
	       (eq? (expression-second-lead-constant expr)
		    (expression-second-lead-constant pattern))))))

;; Quick necessary condition for there to be a match anywhere within the host
;; expression EXPR to the PATTERN (leaving EXOSCOPES undisturbed).  

(define (MATCH-CHECK-WITHIN-HOST? expr pattern exoscopes)
  (cond ((eq? expr pattern) '#t)			;already won?
	((< (expression-height expr)			;pattern too big?
	    (expression-height pattern))
	 '#f)
	((not (subset? (expression-constants pattern)
		       (expression-constants expr)))
	 '#f)
	((or (constant? pattern)			;no matching to be done?
	     (subset? (free-variables pattern)
		      exoscopes))
	 (eq? expr pattern))
	(else '#t)))

;;; MATCHING EXPRESSIONS
;;; The next few functions are currently not in use.
;;; 
;;; See (substitutions alpha-equivalence) for the current versions, which
;;; allows matching to succeed if a syntactic substitution followed by a
;;; renaming of bound variables transforms the pattern into the expression.
;;;
;;; 
;(define (MATCH expr pattern)
;  (match-under-exoscopes expr pattern nil))
;
;(define (MATCH-UNDER-EXOSCOPES expr pattern exoscopes)
;  (if (match-check? expr pattern exoscopes)
;      (match-with-exoscopes-and-subst expr pattern
;				      the-empty-substitution
;				      exoscopes)
;      (fail)))
;
;(define (MATCH-WITH-EXOSCOPES-AND-SUBST expr pattern substitution exoscopes)
;  (cond ((eq? expr pattern)
;	 (join-two-substitutions			;already won?
;	  substitution
;	  (identity-substitution (free-variables expr))))
;
;	((fail? substitution)				;already losing?
;	 (fail))
;
;	((or (constant? pattern)			;no matching to be done?
;	     (subset? (free-variables pattern)
;		      exoscopes))
;	 (if (eq? expr pattern)
;	     substitution
;	     (fail)))
;
;	((variable? pattern)				;necessarily not in exoscopes (see above)
;	 (add-subst-component				;fail or enrich substitution 
;	  (make-subst-component pattern expr)		;as appropriate 
;	  substitution))
;
;	(else						;necessarily compound...
;	 (let ((expr-constructor (expression-constructor expr))
;	       (pattern-constructor (expression-constructor pattern)))
;	   (cond ((not (eq? expr-constructor pattern-constructor))
;		  (fail))
;		 ((binding-constructor? pattern-constructor)
;		  (let ((expr-components (expression-components expr))
;			(pattern-components (expression-components pattern)))
;		    (if (equal? (cdr expr-components)
;				(cdr pattern-components))
;			(match-with-exoscopes-and-subst
;			 (car expr-components)
;			 (car pattern-components)
;			 substitution
;			 (set-union (cdr pattern-components) exoscopes))
;			(fail))))
;		 (else					;equal non-binding constructors
;		  (match-components-with-exoscopes-and-subst
;		   (expression-components expr)
;		   (expression-components pattern)
;		   exoscopes substitution)))))))
;
;(define (MATCH-CHECK? expr pattern exoscopes)
;  (cond ((eq? expr pattern) '#t)			;already won?
;	((< (expression-height expr)			;pattern too big?
;	    (expression-height pattern))
;	 '#f)
;	((not (subset? (expression-constants pattern)
;		       (expression-constants expr)))
;	 '#f)
;	((or (constant? pattern)			;no matching to be done?
;	     (subset? (free-variables pattern)
;		      exoscopes))
;	 (eq? expr pattern))
;	((variable? pattern)
;	 (sorting-skeletons-match?
;	  (expression-sorting expr)
;	  (expression-sorting pattern)))
;	((not (match-by-leading-constants? expr pattern))
;	 '#f)	      
;	(else						;necessarily compound...
;	 (let ((expr-constructor (expression-constructor expr))
;	       (pattern-constructor (expression-constructor pattern)))
;	   (and (eq? expr-constructor pattern-constructor)
;		(let ((expr-components (expression-components expr))
;		      (pattern-components (expression-components pattern)))
;		  (if (binding-constructor? pattern-constructor)
;		      (match-check?
;		       (car expr-components)
;		       (car pattern-components)
;		       (set-union (cdr pattern-components) exoscopes))
;		      (every?
;		       (lambda (expr pattern)
;			 (match-check? expr pattern exoscopes))
;		       expr-components
;		       pattern-components))))))))
;
;
;
;(define (MATCH-COMPONENTS-WITH-EXOSCOPES-AND-SUBST
;	  expr-components
;	  pattern-components
;	  exoscopes substitution)
;  (if (not (= (length expr-components)			;immediate loser
;	      (length pattern-components)))
;      (fail) 
;      (iterate
;	  iter ((expr-components expr-components)
;		(pattern-components pattern-components)
;		(substitution substitution))
;	(cond ((fail? substitution) (fail))		;check if losing
;	      ((null? expr-components) substitution)	;check if winning
;	      (else
;	       (iter (cdr expr-components)		;use first components to enrich 
;		     (cdr pattern-components)		;substitution
;		     (match-with-exoscopes-and-subst
;		      (car expr-components)
;		      (car pattern-components)
;		      substitution exoscopes)))))))
;
;; Fails if there is no match anywhere within the host EXPR that matches the
;; PATTERN.  Otherwise returns a successful subsititution.  Flag TRIVIALITY-OK?
;; if true means that the empty-substitution is ok;

(define (MATCH-WITHIN-HOST-UNDER-EXOSCOPES expr pattern exoscopes triviality-ok?)
  (if (match-check-within-host? expr pattern exoscopes)
      (let ((subst (match-under-exoscopes expr pattern exoscopes)))
	(cond ((and triviality-ok? (succeed? subst)) subst)
	      ((and (succeed? subst)
		    (not (identity-substitution? subst)))
	       subst)
	      ((binding-expression? expr)
	       (let ((nbvs (binding-variables expr))
		     (body (binding-body expr)))
		 (match-within-host-under-exoscopes body pattern
						    (set-union nbvs exoscopes)
						    triviality-ok?)))
	      (else
	       (iterate iter ((comps (expression-components expr)))
		 (if (null? comps)
		     (fail)
		     (let ((subst
			    (match-within-host-under-exoscopes (car comps) pattern
							      exoscopes triviality-ok?)))
		       (if (succeed? subst)
			   subst
			   (iter (cdr comps)))))))))
      (fail)))
  


(define (MATCH-PATTERN-WITHIN-HOST-UNDER-EXOSCOPES expr host exoscopes triviality-ok?)
  (let ((paths (paths-to-satisfaction
		host
		(lambda (subexpr)
		  (match-by-leading-constants? expr subexpr))
		-1)))
    (iterate iter ((paths paths)
		   (substs nil))
      (if (null? paths)
	  substs
	  (let* ((path 	    (car paths))
		 (exoscopes (set-union (bound-variables-on-path host path)
				       exoscopes))
		 (pattern   (follow-path host path))
		 (subst	    (match-under-exoscopes expr pattern exoscopes)))
	    (if (and (succeed? subst)
		     (or triviality-ok?
			 (not (identity-substitution? subst)))
		     (not (any?
			   (lambda (subst2)
			     (substitutions-equal? subst subst2))
			   substs)))
		(iter (cdr paths)
		      (cons subst substs))
		(iter (cdr paths)
		      substs)))))))


(define (EXPRESSION-CHANGE-FREE-VARIABLES expression avoid-vars)
  (apply-substitution
   (iterate iter ((remaining avoid-vars)
		  (new-vars  '())
		  (avoid-all avoid-vars))
     (if (null? remaining)
	 (targets-and-replacements->subst avoid-vars (reverse! new-vars))
	 (let ((new-var (new-variable
			 (expression-sorting (car remaining))
			 (expression-name (car remaining))
			 avoid-all)))
	   (iter (cdr remaining)
		 (cons new-var new-vars)
		 (cons new-var avoid-all)))))
   expression))

;;; RENAMINGS


; MAKE-VARIABLE-RENAMING constructs a renaming substitution whose domain
; is VARS and whose range is a set of variables having names different
; from the variables in VARS and in AVOID-VARS.

(define (MAKE-VARIABLE-RENAMING vars avoid-vars)
  (iterate loop ((vars vars)
		 (subst '())
		 (big-avoid-vars (set-union vars avoid-vars))) 
    (if (null? vars)
	subst
	(let* ((var (car vars))
	       (new-var (new-variable
			 (expression-sorting var)
			 (expression-name var)
			 big-avoid-vars)))
	  (loop (cdr vars)
		(cons (cons var new-var) subst)
		(cons new-var big-avoid-vars))))))

; APPLY-VARIABLE-RENAMING applies the renaming substitution SUBST to
; the free and bound variables of EXPR.

(define (APPLY-VARIABLE-RENAMING subst expr)
  (cond ((assq expr subst) => cdr)
	((formal-symbol? expr) expr)
	(else 
	 (apply (expression-constructor expr)
		(map 
		 (lambda (comp) 
		   (apply-variable-renaming subst comp))
		 (expression-components expr))))))

; CHANGE-AMBIGUOUSLY-NAMED-VARIABLES renames all ambiguously named
; variables in EXPR, avoiding the names of the variables in EXPR 
; and AVOID-VARS.

(define (CHANGE-AMBIGUOUSLY-NAMED-VARIABLES expr avoid-vars)
  (if (is-set? (map name (variables expr)))
      expr
      (let* ((vars (ambiguously-named-variables expr))
	     (subst (make-variable-renaming 
		     vars 
		     (set-union (variables expr) avoid-vars))))
	(apply-variable-renaming subst expr))))

(define (AMBIGUOUSLY-NAMED-VARIABLES expr)
  (let ((original-vars (variables expr)))
    (iterate loop ((vars (variables expr))
		   (an-vars '()))
      (if (null? vars)
	  an-vars
	  (let ((var (car vars)))
	    (if (memq? (name var)
		       (map name (delq var original-vars)))
	      (loop (cdr vars) (cons var an-vars))
	      (loop (cdr vars) an-vars)))))))

(define (CHANGE-BOUND-VARIABLES expr avoid-vars)
  (let ((subst (make-variable-renaming
		(bound-variables expr)
		(set-union (free-variables expr) avoid-vars))))
    (apply-bound-variable-renaming subst expr)))

;;  (let ((rename-vars (set-intersection (bound-variables expr) avoid-vars))
;;	(avoid-vars  (set-union (variables expr) avoid-vars)))
;;    (apply-bound-variable-renaming
;;     (substitution-extend-with-identity
;;      (make-variable-renaming rename-vars avoid-vars)
;;      (set-difference (bound-variables expr) rename-vars))
;;     expr))

(define (APPLY-BOUND-VARIABLE-RENAMING subst expr)
  ;;subst is assumed to contain ALL bound variables.
  (iterate loop ((expr expr) (bound '()))
    (cond ((memq? expr bound) (cdr (assq expr subst)));;
	  ((formal-symbol? expr) expr)
	  (else (apply (expression-constructor expr)
		       (let ((bound (if (binding-expression? expr)
					(set-union bound (binding-variables expr))
					bound)))
			 (map (lambda (x) (loop x bound)) (expression-components expr))))))))

(define (change-bound-variables-as-needed expr avoid-vars)
  (let ((rename-vars (set-intersection (bound-variables expr) avoid-vars))
	(avoid-vars  (set-union (bound-variables expr) avoid-vars)))
    (apply-bound-variable-renaming-as-needed
     (make-variable-renaming rename-vars avoid-vars)
     expr)))

(define (APPLY-BOUND-VARIABLE-RENAMING-AS-NEEDED subst expr)
  (let ((domain (map car subst)))
    (iterate loop ((expr expr)
		   (bound '()))
      (cond ((null-intersection? (bound-variables expr) domain)
	     expr)
	    ((memq? expr bound)
	     (or (cdr (assq expr subst))		;apply subst 
		 expr))					;or leave unchanged 
	    ((formal-symbol? expr)
	     expr)
	    (else
	     (apply
	      (expression-constructor expr)
	      (let ((bound (if (binding-expression? expr)
			       (set-union bound (binding-variables expr))
			       bound)))
		(map
		 (lambda (x) (loop x bound))
		 (expression-components expr)))))))))


(define (CHANGE-BOUND-VARIABLES-SELECTIVELY expr do-vars avoid-vars)
  (let ((subst (make-variable-renaming
		(bound-variables expr)
		(set-union (variables expr) avoid-vars))))
    (apply-bound-variable-renaming-selectively subst do-vars expr)))

(define (APPLY-BOUND-VARIABLE-RENAMING-SELECTIVELY subst do-vars expr)
  ;;subst is assumed to contain ALL bound variables.
  (iterate loop ((expr expr) (bound '()))
    (cond ((memq? expr (intersection bound do-vars)) (cdr (assq expr subst)))
	  ((formal-symbol? expr) expr)
	  (else
	   (apply
	    (expression-constructor expr)
	    (let ((bound (if (binding-expression? expr)
			     (set-union bound (binding-variables expr))
			     bound)))
	      (map
	       (lambda (x) (loop x bound))
	       (expression-components expr))))))))


;; This procedure assumes that previous-renaming is a renaming -- that is, that
;; it is a one-one mapping from variables to variables.  This procedure is
;; intended for the case in which expr has been produced by applying the old
;; renaming and then simplifying or such-like.  It restores the original
;; variables where doing so will obviously not cause a free variable capture.   

(define (restore-bound-variables-where-possible previous-renaming expr)
  (let ((fvs (expression-free-variables expr)))
    (apply-bound-variable-renaming-as-needed
     ;;
     ;; Compute substitution by inverting those components where the target
     ;; does not now occur free in the expression.
     ;; 
     (iterate iter ((previous-renaming previous-renaming)
		    (subfunction-of-inverse '()))
       (if (null? previous-renaming)
	   subfunction-of-inverse
	   (destructure (((target . replacement) (car previous-renaming)))
	     ;;
	     ;; Would inverting component cause a fv capture?
	     ;; 
	     (if (memq? target fvs)
		 (iter (cdr previous-renaming) subfunction-of-inverse)
		 (iter (cdr previous-renaming)
		       (cons (cons replacement target)
			     subfunction-of-inverse))))))
     expr)))

(define (MAKE-BOUND-VARIABLES-UNIQUE expr avoid-vars)
  (cond ((formal-symbol? expr) expr)
	((not (binding-expression? expr))
	 (let ((constr (expression-constructor expr))
	       (comps  (expression-components  expr)))
	   (apply
	    constr
	    (iterate iter ((comps      comps)
			   (new-comps  '())
			   (avoid-vars avoid-vars))
	      (if (null? comps)
		  (reverse! new-comps)
		  (let ((new
			 (make-bound-variables-unique (car comps) avoid-vars)))
		    (iter (cdr comps)
			  (cons new new-comps)
			  (set-union (bound-variables new) avoid-vars))))))))
	(else
	 (let ((expr (change-bound-variables expr avoid-vars)))
	   (let ((constr (expression-constructor expr))
		 (body   (binding-body		 expr))
		 (nbvs   (binding-variables      expr)))
	     (apply
	      constr
	      (make-bound-variables-unique body (set-union nbvs avoid-vars))
	      nbvs))))))

(define (BOUND-VARIABLES-UNIQUE? expr avoid-vars)
  (eq? expr (make-bound-variables-unique expr avoid-vars)))


		



