;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SAFE-RELATIVE-CONSTRUCTORS)


; Suppose EXPRESSION is one and BASE-LIST is a set of expressions, none of
; which is a subexpression of another expression in BASE-LIST.  Then
; SAFE-RELATIVE-CONSTRUCTOR returns a function.  If the function is called on an
; alist A that assigns expressions as values to the members of BASE-LIST (i.e.,
; such that BASE-LIST is included (as a set) in (MAP CAR A)), then it will
; return an expression like EXPRESSION, except that occurrences of expressions
; in BASE-LIST are replaced by their associates in A.  In particular, if A
; pairs each member of BASE-LIST with itself, the resulting expression is just
; EXPRESSION.  Note that bound variables are not distinguished from free
; variables (nor from constants) in the procedures.   

; For efficiency, we cache these values in a table when we compute them. 

(define (SAFE-RELATIVE-CONSTRUCTOR expression base-list)
  (let ((entry (table-entry *safe-relative-constructors* expression)))
    (cond ((ass set-equal? base-list entry)
	   => cdr)
	  (else
	   (let ((rel-constr (compute-safe-relative-constructor expression base-list)))
	     (set 
	      (table-entry *safe-relative-constructors* expression)
	      (cons
	       (cons base-list rel-constr)
	       entry))
	     rel-constr)))))

(define-operation safe-relative-constructor-pattern)
(define-operation safe-relative-constructor-base-list)
(define-predicate safe-relative-constructor?)
; The procedure to compute the safe-relative constructor.  

(define (COMPUTE-SAFE-RELATIVE-CONSTRUCTOR expression base-list)
  (let ((proc
	 (cond
	  ((memq? expression base-list)	;reached a base--
	   (lambda (subst)		;function must return
	     (cond ((fail? subst)(fail))
		   ((substitution-find-replacement subst expression))
		   (else expression))))
	  ((and (any?
		 (lambda (base)
		   (proper-subexpression? base expression))
		 base-list)		;base occurs, and
		(expression-components expression)) ;compound expr--
	   =>				;get the rcs
	   (lambda (components)		;for the 
	     (let ((constructor		;components.
		    (expression-constructor expression)) 
		   (nbvs (newly-bound-variables expression))
		   (safe-relatives (map
				    (lambda (c) (safe-relative-constructor c base-list))
				    components)))
	       (lambda (subst)
		 (cond ((fail? subst) (fail)) ; fail? 
		       ((rc-capture? subst nbvs) (fail)) ; ensure no capture
		       (else
			(let ((comps (map-fns safe-relatives subst)))
			  (if (any? fail? comps)
			      (fail)
			      (apply	;fn must apply the 
			       constructor ;constructor after
			       comps))))))))) ;the component rcs

	  (else
	   (lambda (()) expression)))))	;no occurrence--return
					;constant fn.
    (object proc
      ((safe-relative-constructor? self) '#t)
      ((safe-relative-constructor-pattern self) expression)
      ((safe-relative-constructor-base-list self) base-list))))

(lset *SAFE-RELATIVE-CONSTRUCTORS* (make-table '*safe-relative-constructors*))


(define (rc-capture? subst nbvs)
  (let ((images
	 (map-set
	  (lambda (nbv)
	    (apply-substitution subst nbv))
	  nbvs))) 
    (any?
     (lambda (comp)
       (and (not (memq? (target comp) nbvs))
	    (non-null-intersection? images (free-variables (replacement comp)))))
     subst)))

