;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald table_util
  (env tsys))

;;;                      UTILITIES
;;;============================================================================

;;; Do (PROC <key> <value>) for every (<key> <value>) in TABLE.

(define (table-walk table proc)
  (let ((table (enforce %table? table)))
    (if (%table-active-walker?  table)
	(let* ((vec (%table-vector table))
	       (len (%table-next table)))
	  (do ((i 0 (fx+ i 2)))
	      ((fx>= i len))
	    (cond ((vref vec i)
		   => (lambda (v)
			(proc (vref vec (fx+ i 1)) v)))))
	  (return))
	(unwind-protect
	 (block (set (%table-active-walker? table) '#t)
		(table-walk table proc))
	 (let ((deferred (%table-deferred  table)))
	   (set (%table-active-walker?  table) '#f)
	   (set (%table-deferred  table) '())
	   (walk
	    (lambda (pair)
	      (set (table-entry table (car key)) (cdr value)))
	    deferred))))))
	  

(define-integrable (walk-table proc table)
    (table-walk table proc))

;;; This returns the first KEY and VALUE for which (PRED KEY VALUE) => true.

(define (find-table-entry table pred)
  (let* ((table (enforce %table? table))
         (vec (%table-vector table))
         (len (%table-next table)))
    (iterate loop ((i 0))
      (cond ((fx>= i len)
             (return nil nil))
            ((vref vec i)
             => (lambda (v)
                  (if (pred (vref vec (fx+ i 1)) v)
                      (return (vref vec (fx+ i 1)) v)
                      (loop (fx+ i 2)))))
            (else
             (loop (fx+ i 2)))))))

;;; Copy a table.  This gets its %table from the pool.

(define (copy-table table id . copy-proc)
  (let* ((table (enforce %table? table))
         (vec (%table-vector table))
         (len (vector-length vec))
         (copy-proc (if (null? copy-proc) identity (car copy-proc)))
         (new (copy-structure! (obtain-from-pool *table-pool*) table)))
    (let ((new-vec (if (fx= len '2) 
                       empty-vec
                       (obtain-from-pool (table-vector-pool len)))))
      (set (%table-id     new) id)
      (set (%table-vector new) new-vec)
      (cond ((eq? copy-proc identity)
             (vector-replace new-vec vec (vector-length vec)))
            (else
             (iterate loop ((i 0))
               (cond ((fx>= i len) nil)
                     ((vref vec i)
                      => (lambda (v)
                           (set (vref new-vec i) (copy-proc v))
                           (set (vref new-vec (fx+ 1 i)) (vref vec (fx+ i 1)))
                           (loop (fx+ i 2))))
                     (else
                      (set (vref new-vec i) nil)
                      (set (vref new-vec (fx+ i 1)) (vref vec (fx+ i 1)))
                      (loop (fx+ i 2)))))))
      new)))

;;; This stuff is used by the post-gc-hook for weak tables.

;;; Same as CLEAN-AND-SHRINK-TABLE except the vector is not reused

(define (clean-and-shrink-table table update)
  (really-clean-and-shrink-table table update t))

(define (post-gc-clean-and-shrink-table table update)
  (really-clean-and-shrink-table table update nil))

(define (really-clean-and-shrink-table table update recycle?)
  (let* ((table (enforce %table? table))
         (new-count (clean-table-vector! (%table-vector table) update)))
    (set (%table-count table) new-count)
    (if recycle?
        (table-rehash table new-count)
        (really-table-rehash table new-count))
    table))

(define (clean-table-vector! vec update)
  (let ((len (vector-length vec)))
    (iterate loop ((i 0) (count 0))
      (cond ((fx>= i len)
             count)
            (else
             (let ((v (vref vec i)))
               (receive (k v)
                        (if (not v)
                            (return nil nil)
                            (receive (k v)
                                     (update (vref vec (fx+ i 1)) v)
                              (if v (return k v) (return nil nil))))
                 (set (vref vec i) v)
                 (set (vref vec (fx+ i 1)) k)
                 (loop (fx+ i 2) (if v (fx+ 1 count) count)))))))))




