;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald pp-list)

;;;; a pretty-printer

(define (pp-list x port)
  (enforce list? x)
  (cond ((read-macro-inverse x)
	 => (lambda (inverse)
	      (writes port inverse)
	      (pretty-print (cadr x) port)))
	((> (+ (print-width x) (hpos port))
	    (line-length port))
	 (pp-list-vertically x port))
	(else
	 (pp-list-horizontally x port))))

(define (pp-list-vertically   x port)
  (maybe-pp-list-vertically t x port))

(define (pp-list-horizontally x port)
  (maybe-pp-list-vertically nil x port))

(define (pp-maybe-list x port)
  ((if (list? x)
       pp-list
       pretty-print)
   x port))

(define (maybe-pp-list-vertically vertical? list port)
  (writec port #\()
  (if (null? list)
      (writec port #\))
      (let ((old-hpos (hpos port)))
	(pp-maybe-list (car list) port)
	(iterate tail ((l (cdr list)))
	  (cond ((pair? l)
		 (cond (vertical? (indent-newline old-hpos port))
		       (else (writec port #\space)))	; not (space port)!
		 (pp-maybe-list (car l) port)
		 (tail (cdr l)))
		(else
		 (cond ((not (null? l))
			(format port " . ")
			(if vertical? (indent-newline old-hpos port))
			(pp-maybe-list l port)))
		 (writec port #\))))))))

;;; utility: go to given column on a new line.

(define (indent-newline x port)
  (newline port)
  (write-spaces port x))

;;; find printed representation for internal representation of read
;;; macro.

(define (read-macro-inverse x)
  (cond ((and (pair? x)
              (pair? (cdr x))
              (null? (cddr x)))
         (case (car x)
           ((quote)            "'")
           ((quasiquote)       "`")
           ((unquote)          ",")
           ((unquote-splicing) ",@")
           (else nil)))
        (else nil)))

