;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SCHEMATIC-PROOF-PRESENTATION)


(define (dg-history-entry-superfluous? entry)
  (and (= 0 (dg-history-entry-added-nodes entry))
       (null? (dg-history-entry-nodes-grounded entry))))

(define (xview-history-entry entry seen-sequents seen-formulas seen-contexts) '#t)

(define (XVIEW-PRESCRIPTIVE-PROOF dg port)
  (let ((last-sequent 0)
	(avoid-repetition? '#f)
	(context-sequent-alist '())
	(assertion-sequent-alist '())
	(dg-no (deduction-graph-emacs-number dg))
	(claim-mentioned? '#f)
	(begin? '#t))
    (labels (((ENUMERATE-A-LIST-OF-SEQUENT-NUMBERS the-list)
	      (xtv-format port " the sequent~p " (length the-list))
	      (iterate loop ((n (length the-list)) (the-list the-list))
		      (cond ((= n 0) '())
			    ((= n 1)
			     (xtv-format port " ~a"
					 (filter-sequent-number (car the-list))))
			    ((= n 2)
			     (xtv-format port "~a  and ~a"
					 (filter-sequent-number (car the-list))
					 (filter-sequent-number (cadr the-list))))
			    (else (xtv-format port " ~a, "
					      (filter-sequent-number (car the-list)))
				  (loop  (subtract1 n) (cdr the-list))))))

	     ((FILTER-SEQUENT-NUMBER n)
	      (if claim-mentioned?
		  n
		  (if (= n 1)
		      (block (set claim-mentioned? '#t)
			     (format nil "~a (the claim of the theorem)" n))
		      n)))
		       
	     (XVIEW-SCHEMATIC-PROOF-STEP
	      (lambda (step port)
		(if (sequent-posting? step)
		    (if (proof-step-new-sequents step)
			(block
			  (if avoid-repetition?
			      (xtv-format port "Next, post ")
			      (xtv-format port "Post "))
			  (xtv-format port "the following sequent to the deduction graph:~%")
			  (if (not (null? (proof-step-new-sequents step)))
			      (block
				(set avoid-repetition? '#f)
				(walk (lambda (x) (show-sequent x '#f))
				      (proof-step-new-sequents step)))
			      (set avoid-repetition? '#t))
			  (set last-sequent (if (null? (proof-step-new-sequents step))
						 0
						 (last (proof-step-new-sequents step))))))
		    (block (if avoid-repetition?
			       (xtv-format port "Next, use ")
			       (xtv-format port "Apply "))
			   (xtv-format
			    port
			    "the ~a ~a"
			    (proof-step-command-name step)
			    (proof-step-name step))
			   (if avoid-repetition?
			       (xtv-format
				port
				" applied to")
			       (xtv-format port " to"))
		 
			   (cond (begin?
				  (xtv-format port " the claim of the theorem. ")
				  (set begin? '#f))
				 ((and (= (length (proof-step-arguments step)) 1)
				       (= (car (proof-step-arguments step))
					  last-sequent))
				  (xtv-format port " the previous sequent. "))
				 (else (enumerate-a-list-of-sequent-numbers
					(proof-step-arguments step))
				       (xtv-format port ".~%")))
			   (set last-sequent (if (null? (proof-step-new-sequents step))
						 0
						 (last (proof-step-new-sequents step))))
			   (if (not (null? (proof-step-new-sequents step)))
			       (block
				 (set avoid-repetition? '#f)
				 (xtv-format
				  port
				  "This yields the following new subgoal~p:~%"
				  (length (proof-step-new-sequents step)))
				 (walk (lambda (x) (show-sequent x '#f))
				       (proof-step-new-sequents step)))
			       (set avoid-repetition? '#t))))))
	     (SHOW-SEQUENT
	      (lambda (no first?)
		(if (not first?) (xtv-format port " \\subsection* \{Sequent ~a. \}" no))
		(let ((sqn (sequent-unhash-in-graph no dg-no)))
		  (let ((seen-context-look-up
			 (assq (sequent-node-context sqn) context-sequent-alist))
			(seen-assertion-look-up
			 (assq (sequent-node-assertion sqn)
			       assertion-sequent-alist)))
		    (if seen-context-look-up

			;;We have already listed the assumptions of this context. We will
			;;now simply refer to it.

			(block
			  (xtv-format port
				      "Under the same assumptions as sequent ~A, we have"
				      (sequent-node-number (cdr seen-context-look-up)))
		      
			  (let ((expr (sequent-node-assertion sqn)))
			    (if (small-expression? expr)
				(bind
				    (((maximum-nesting-for-logical-expressions) 0))
			      ;;;this forces in-line printing for logical expressions.
				  (xtv-format port " ")
				  (xview-object expr port))
				(block
				  (xtv-format port ":~%~%")
				  (xview-single-formula expr port)))))

			;;Otherwise we list the context and then the assertion.

			(let ((assums (sequent-node-assumptions sqn)))
			  (if assums
			      (block 
				(push context-sequent-alist
				      (cons (sequent-node-context sqn)
					    sqn))

				;;If we have already seen the sequent assertion, and refer to
				;;it by pointing to its first occurrence, the assumptions are
				;;presented differently.

				(if seen-assertion-look-up
				
				    (xtv-format
				     port
				     "~%The conclusion of sequent ~A holds, provided"
				     (sequent-node-number
				      (cdr seen-assertion-look-up)))

					;(xtv-format port " \\subsection* \{Assume:\}")
				    (xtv-format port "~%~% \\noindent Assume")
				    )
			    
				(if (null? (cdr assums))
				

				    (if (small-expression? (car assums))


					;;if there is only one assumption and it is small,
					;;leave a space and present it in-line; do this
					;;regardless of whether the sequent assertion is
					;;referenced indirectly or not

					(bind
					    (((maximum-nesting-for-logical-expressions) 0))
					  (xtv-format port " ")
					  (xview-object (car assums) port))

					;;otherwise, put in a colon and start a new paragraph.
				    
				    
					(block
					  (xtv-format port ":~%~%")
					  (xview-single-formula (car assums) port)))

				    (block
				      (xtv-format port ":~%~%")

				      (xview-expression-list assums port)))
			    
				(if (not seen-assertion-look-up)

				    ;;Consider now the case when the assertion is to be
				    ;;presented explicitly.

				    (block
				      ;;first and foremost let us make a note for
				      ;;future reference that we are stating the assertion.

				      (push assertion-sequent-alist
					    (cons (sequent-node-assertion sqn) sqn))
				    
					;(xtv-format port "\\subsection* \{Then:\}")

				      ;;if there is only one small assumption, continue
				      ;;in-line presentation:

				      (if (and (null? (cdr assums))
					       (small-expression? (car assums)))
					  (xtv-format port " Then")
					  (xtv-format port "~%~% \\noindent Then"))


				  

				      ;;Again we will go into the same rigamarole to
				      ;;determine whether to print the assertion in-line.

				  
				      (let ((expr (sequent-node-assertion sqn)))
					(if (small-expression? expr)
					    (bind
						(((maximum-nesting-for-logical-expressions) 0))
					      ;;this forces in-line printing for logical expressions.
					      (xtv-format port " ")
					      (xview-object expr port))
					    (block
					      (xtv-format port ":~%~%")
					      (xview-single-formula expr port))))
				      )))

			  
			      (xview-object (sequent-node-assertion sqn) port)))))
			  
		  (xtv-format port " \\begin\{center\} \\rule\{30mm\}\{.1mm\} \\end\{center\}")))))

      (bind (((dont-list-free-variables?) '#t))
	(xtv-format port " \\subsection* \{Theorem \}")
	(show-sequent 1 '#t)
	(if (deduction-graph-grounded? dg)
	    (xtv-format port " \{ \\sc Proof: \} ")
	    (xtv-format port " \{ \\sc Partial proof: \} "))

	(let ((proof-sequence (schematic-proof-sequence dg)))
	  (xview-schematic-proof-step (car proof-sequence) port)
	  (walk 
	   (lambda (step) (xview-schematic-proof-step step port))

	   (cdr proof-sequence))
	  (if (deduction-graph-grounded? dg)
	      (xtv-format port "This completes the proof.")))))))

(define DEDUCTION-GRAPH-TEX-FORMATTER
  (make-simple-switch 'deduction-graph-tex-formatter procedure?
		      xview-prescriptive-proof))


(define (TOGGLE-DEDUCTION-GRAPH-FORMATTER)
  (if (eq? (deduction-graph-tex-formatter) xview-schematic-proof-sequence)
      (set (deduction-graph-tex-formatter) xview-deduction-graph)
      (set (deduction-graph-tex-formatter) xview-schematic-proof-sequence)))
