;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald read-interface)

(define (IMPLODE char-list)
  (let ((port (string->input-port (list->string char-list))))
    (set (port-read-table port) *vanilla-read-table*)
    (read port)))

(define (dot? char) (char= char #\.))
(define (minus? char) (char= char #\-))
(define (underscore? char) (char= char #\_))
(define (vertical? char) (char= char #\|))
(define (decimal-digit? x) (digit? x 10))
(define (quotient? char) (char= char #\/))
(define (DOLLAR? char) (char= char #\$))
(define (percent? char) (char= char #\%))
;;(define (backslash? char) (char= char #\\))
(define (ampersand? char) (char= char #\&))
(define (left-bracket? char) (char= char #\[))
(define (right-bracket? char) (char= char #\]))

(define (text-char? char)
  (or ;;(backslash? char)
      (underscore? char) (percent? char) (dollar? char) (alphabetic? char) (ampersand? char)))

(define (READ-IDENTIFIER-TOKEN port)
  (iterate collect-chars ((current-token '()))
    (cond ((or (eof? (peek-char port))
	       (not (or (decimal-digit? (peek-char port))
			(text-char? (peek-char port)))))
	   (implode (reverse! current-token)))
	  (else (collect-chars (cons (read-char port) current-token))))))

(define (READ-DECIMAL-PART partial-char-sequence port)
  (iterate loop ((current-token partial-char-sequence))
    (let ((peek (peek-char port)))
      (cond ((or (eof? peek) (not (decimal-digit? peek)))
	     (implode (reverse! current-token)))
	    (else (loop (cons (read-char port) current-token)))))))

(define (READ-MODULAR-BASE partial-char-sequence port)
  (iterate loop ((current-token '()))
    (let ((peek (peek-char port)))
      (cond ((or (eof? peek) (not (decimal-digit? peek)))
	     (modular (implode (reverse! partial-char-sequence))
		      (implode (reverse! current-token))))
	    (else (loop (cons (read-char port) current-token)))))))

(define (READ-NUMERICAL-TOKEN port)
  (iterate loop ((current-token '()))
    (let ((peek (peek-char port)))
      (cond ((dot? peek) (read-decimal-part (cons (read-char port) current-token) port))
	    ((vertical? peek)
	     (read-char port)
	     (read-modular-base current-token port))
	    ((or (eof? peek) (not (decimal-digit? peek)))
	     (implode (reverse! current-token)))
	    (else (loop (cons (read-char port) current-token)))))))

(define (PEEK-NON-WHITESPACE-CHAR port)
  (let ((n (peek-char port)))
    (if (whitespace? n)
	(block (read-char port)
	       (peek-non-whitespace-char port))
	n)))

(define (READ-BRACKETED-TOKEN port)
  (if (start-reading-expression-list?)
      (block (set (start-reading-expression-list?) '#f)
	     (let ((c (read-char port)))
	       (implode `(,c))))
      (let ((c (read-char port))
	    (n (peek-non-whitespace-char port)))
	(if (or (minus? n) (decimal-digit? n))
	    (iterate loop ((current-token '()))
	      (let ((peek (peek-char port)))
		(cond ((eof? peek)
		       (imps-error "Tokenizer: End of file encountered with unmatched [."))
		      ((right-bracket? peek)
		       (read-char port)
		       (let ((token (implode (reverse! current-token))))
			 (imps-enforce number? token)
			 token))
		      (else (loop (cons (read-char port) current-token))))))
	    (implode `(,c))))))

	

;;;(define (READ-MINUS-TOKEN port)
;;;  (read-char port)
;;;  (let ((peek (peek-char port)))
;;;    (cond ((decimal-digit? peek) (unread-char port) (read-numerical-token port))
;;;	  (else (unread-char port) (read-significant-char-sequence port)))))

(define (READ-SIGNIFICANT-CHAR-SEQUENCE port)
  (let ((c1 (read-char port)))
    (if (eof? c1)
	'\;
	(let ((c2 (read-char port)))
	  (cond ((eof? c2) (implode `(,c1)))
		((significant-char-sequence? port `(,c1 ,c2))
		 (look-for-extension (implode `(,c1 ,c2)) port))
		(else (unread-char port) (look-for-extension (implode `(,c1)) port)))))))

;; Was formerly:
;; 
;;  (let ((c1 (read-char port))
;;	(c2 (read-char port)))
;;    (cond ((eof? c2) (implode `(,c1)))
;;	  ((significant-char-sequence? port `(,c1 ,c2))
;;	   (look-for-extension (implode `(,c1 ,c2)) port))
;;	  (else (unread-char port) (look-for-extension (implode `(,c1)) port))))

(define (LOOK-FOR-EXTENSION partial-token port)
  (if (underscore? (peek-char port))
      (let ((next-token (read port)))
	(symbol-append partial-token next-token))
      partial-token))

(define-operation (SIGNIFICANT-CHAR-SEQUENCE? port chars))
(define-operation (MAKE-SIGNIFICANT-CHAR-SEQUENCE port chars))
(define-operation (SEEN-CHARS soi))
(define-operation (FLUSH-SEEN-CHARS soi))

(define (MAKE-TOKENIZER-GENERATOR)
  (let ((significant-char-sequences '()))
    (object
	(lambda (port)
	  (let ((read-chars '()))

	    (join
	      (object nil
		((read soi)
		 (let ((peek (peek-char soi)))
		   (cond ((eof? peek);;(read-char soi)
			  '\;)
			 ((decimal-digit? peek) (read-numerical-token soi))
			 ((dot? peek) (read-numerical-token soi))
			 ((left-bracket? peek) (read-bracketed-token soi))
			 ((whitespace? peek) (read-char soi) (read soi))
			 ((text-char? peek) (read-identifier-token soi))
			 (else (read-significant-char-sequence soi)))))
		((peek-char soi)
		 (let ((c (peek-char port)))
		   (if (eof? c)
		       #\;
		       c)))
		((read-char soi) (let ((c (read-char port)))
				   (if (eof? c)
				       #\;
				       (block
					 (push read-chars c)
					 c))))
		((unread-char soi) (let ((c (unread-char port)))
				     (pop read-chars)
				     c))
		((flush-seen-chars soi) (set read-chars '()))
		((seen-chars soi) read-chars)
		((significant-char-sequence? soi chars)
		 (mem? equal? chars significant-char-sequences))
		((print soi pt) (format pt "{Tokenizer-port ~a}" (object-hash soi))))
	      port)))
      ((make-significant-char-sequence soi symbol)
       (let ((chars (string->list (string-downcase! (symbol->string symbol)))))
	 (if (or (text-char? (car chars))
		 (> (length chars) 2))
	     (imps-error "MAKE-SIGNIFICANT-CHAR-SEQUENCE:Invalid significant character sequence ~a" symbol))
	 (push significant-char-sequences chars)
	 symbol)))))

(define (POSSIBLE-SIGNIFICANT-CHAR-SEQUENCE symbol)
  (let ((str (symbol->string symbol)))
    (not (or (text-char? (string-head str))
	     (decimal-digit? (string-head str))))))
	 
(define-settable-operation (PARSER-TOKENIZER parser))
(define-operation (PARSER-OPERATOR-TABLE soi))
(define-predicate PARSER?)
  
(define (MAKE-PARSER)
  (let ((operator-table (make-table 'string-parser-operator-table))
	(port->tokenizer '()))
    (object nil
      ((parser-tokenizer soi) port->tokenizer)
      (((setter parser-tokenizer) soi new-val) (set port->tokenizer new-val))
      ((parser-operator-table soi) operator-table)
      ((parser? soi) (true))
      ((print soi pt) (format pt "#{Parser ~a}" (object-hash soi))))))

(define (postpend-semicolon-to-port port)
  (let ((empty? '#f))
    (join
      (object '()
	((read-char self)
	 (if empty?
	     eof
	     (let ((ch (read-char port)))
	       (if (eof? ch)
		   (block
		     (set empty? '#t)
		     #\;)
		   ch))))
	((unread-char self)
	 (if empty?
	     (set empty? '#f)
	     (unread-char port))))
      port)))

(define (PARSE-TOP-LEVEL parser input)
  (let ((p1 (input-port->stream-parser
	     (if (string? input)
		 (string->input-port (string-append input ";"))
		 (postpend-semicolon-to-port input))
	     parser)))
    (if (char= (peek-non-whitespace-char p1) #\;)
	(block (read-char p1)
	       eof)
	(read p1))))

(define (INPUT-STRING->EXPRESSION parser language input)
  (let ((sexp (parse-top-level parser input)))
    (sexp->expression
     language
     (if (use-old-apply-operator-form?)
	 sexp
	 (insert-apply-operators-in-sexp sexp)))))

(define (APPARENT-SORT-ARGUMENT-FOR-CONSTRUCTOR? symbol)
  (memq? symbol '(falselike undefined is-defined-in-sort)))

(define (INSERT-APPLY-OPERATORS-IN-SEXP sexp)
  (if (atom? sexp) 
      sexp
      (if (list? sexp)
	  (if (symbol-means-constructor-or-quasi-constructor? (car sexp))
	      (if (symbol-means-binding-constructor? (car sexp))
		  (if (apparent-sort-argument-for-constructor? (car sexp))
		      (block
			(let ((s1 (reverse! sexp)))
			  (set (cdr s1) (map! insert-apply-operators-in-sexp (cdr s1)))
			  (reverse! s1)))
		      (block
			(let ((s1 (reverse! sexp)))
			  (set (car s1) (insert-apply-operators-in-sexp (car s1)))
			  (reverse! s1))))
		  (map! insert-apply-operators-in-sexp sexp))

	      (cons 'apply-operator (map! insert-apply-operators-in-sexp sexp)))
	  (imps-error "Ca n'a ni queue ni tete! ~A" sexp))))

(define (COPY-PARSER parser)
  (let* ((new-parser (make-parser))
	 (operator-table (parser-operator-table new-parser)))
    (set (parser-tokenizer new-parser) (parser-tokenizer parser))
    (walk-table (lambda (key val) (set (table-entry operator-table key) val))
		(parser-operator-table parser))
    new-parser))

(define-operation (INPUT-NEXT-TOKEN port))
(define-operation (NEXT-TOKEN port))
(define-operation (RETURN-TOKEN port token))
(define-operation REPORT-ERROR)

(define (INPUT-PORT->TOKEN-READER port)
  (let ((look-ahead '()))
    (join
      (object  nil
	((input-next-token soi) (if look-ahead
				    (pop look-ahead)
				    (read port)))
	((next-token soi) (if look-ahead (car look-ahead)
			      (block (push look-ahead (read port))
				     (car look-ahead))))
	((return-token soi token) (push look-ahead token) token))
      port)))

(define (INPUT-PORT->STREAM-PARSER port parser)
  (let ((operator-table (parser-operator-table parser))
	(p1 (input-port->token-reader ((parser-tokenizer parser) port))))
    (join
      (object nil	
	((parser-operator-table soi) operator-table)
	((read soi) (block0 (parse-matching-binding soi '\;) (input-next-token soi)))
	((report-error parser format-string . args)
	 (let ((left (line-left p1))
	       (right (line-right p1)))
	   (flush-seen-chars p1)
	   (apply imps-error
		  (format '()
			  "Parsing error: ~A ~%~%~A <<== ~A."
			  format-string
			  left
			  right)
		  args)))
	((print soi pt) (format pt "#{IMPS-stream-parser ~a}" (object-hash soi))))
      p1)))

(define (LINE-RIGHT port)
  (iterate loop ((accum '()))
    (let ((c (read-char port)))
      (if (or (eof? c)
	      (char= c '#\;)
	      (char= c '#\newline))
	  (block (list->string (reverse! accum)))
	  (loop (cons c accum))))))

(define (LINE-LEFT port)
  (iterate loop ((accum '()) (rest (seen-chars port)))
    (if (or (null? rest) (eof? (car rest)) (char= (car rest) '#\newline))
	(list->string accum)
	(loop (cons (car rest) accum) (cdr rest)))))


(define (COERCE-SYMBOL-TO-TOKEN tokenizer token)
  (if (symbol? token)
      (let ((port (tokenizer (string->input-port (symbol->string token)))))
	(if (not (eq? (read port) token))
	    (make-significant-char-sequence tokenizer token))
	'#t)
      (if (proper-list? token)
	  (map (lambda (x) (coerce-symbol-to-token tokenizer x)) token)
	  (imps-error "COERCE-SYMBOL-TO-TOKEN: not an s-expression"))))
  
  

