;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald overloading)

(lset *overloaded-names-table* (make-table '*overloaded-names-table*))

(lset *formal-symbol-overloaded-names-table* (make-table '*formal-symbol-overloaded-names-table* ))

;;an alist of entries key= name value= ((sorts . new-names) (sorts1 . new-names1) ..)


(define (INSTALL-OVERLOADED-NAME-FOR-FORMAL-SYMBOL overloaded-name formal-symbol)
  (or (formal-symbol? formal-symbol)
      (imps-error "MAKE-OVERLOADED-NAME-FOR-FORMAL-SYMBOL: ~A is not a formal symbol." formal-symbol))
  (let* ((language (home-language formal-symbol))
	 (sort (expression-sorting formal-symbol))
	 (key (cons language sort))
	 (key-expr-alist (table-entry *overloaded-names-table* overloaded-name))
	 (look-up (ass equal? key key-expr-alist)))
    (if look-up (or (eq? (cdr look-up) formal-symbol)
		    (imps-error "MAKE-OVERLOADED-NAME-FOR-FORMAL-SYMBOL: There is already an identically sorted formal-symbol in language ~A with the overloaded name ~A." language overloaded-name))
	(block
	  (set (table-entry *overloaded-names-table* overloaded-name)
	       (if key-expr-alist
		   (cons (cons key formal-symbol) key-expr-alist)
		   (list (cons key formal-symbol))))
	  (set (table-entry *formal-symbol-overloaded-names-table* formal-symbol)
	       overloaded-name)))))

(define (INSTALL-OVERLOADED-NAME-FOR-SYMBOL-NAMES
	 overloaded-name language-name-symbol-name-alist)
  (walk (lambda (x)
	  (install-overloaded-name-for-formal-symbol
	   overloaded-name
	   (let ((lan (or (name->language (car x))
			  (theory-language (name->theory (car x))))))
	     (or (language? lan)
		 (imps-error "INSTALL-OVERLOADED-NAME-FOR-SYMBOL-NAMES: There is no language or theory with name ~A:" (car x)))
	     (find-constant lan (cadr x)))))
	language-name-symbol-name-alist)
  overloaded-name)

(define (REMOVE-OVERLOADED-NAME name)
  (if (and (symbol? name)
	   (table-entry *overloaded-names-table* name))
      (set (table-entry *overloaded-names-table* name) '#f)
      '#f))

(define (POSSIBLE-SYMBOL-FORMS overloaded-name argument-sorts language)
  (let ((key-expr-alist (table-entry *overloaded-names-table* overloaded-name)))
    (or 
     (possible-symbol-forms-by-comparison eq? key-expr-alist argument-sorts language)
     (possible-symbol-forms-by-comparison sorting-leq key-expr-alist argument-sorts language)
     (possible-symbol-forms-by-comparison sorts-may-overlap? key-expr-alist argument-sorts language))))

(define (possible-symbol-forms-by-comparison pred key-expr-alist argument-sorts language)
  (let ((candidate-exprs '()))
    (walk (lambda (entry)
	    (let ((possible-language (caar entry))
		  (sort (cdar entry)))
	      (if (and (sub-language? possible-language language)
		       (every? pred argument-sorts (higher-sort-domains sort)))
		  (push candidate-exprs (cdr entry)))))
	  key-expr-alist )
    candidate-exprs))


(define (LANGUAGE-FIND-CONSTANTS language const-name)
  (if (overloaded-name-for-formal-symbol? const-name)
      (let ((key-expr-alist (table-entry *overloaded-names-table* const-name))
	    (candidate-exprs '()))
	
	(walk (lambda (entry)
	    (let ((possible-language (caar entry)))
	      (if (sub-language? possible-language language)
		  (push candidate-exprs (cdr entry)))))
	  key-expr-alist )
	candidate-exprs)
      (find-constant language const-name)))


(define (DISAMBIGUATE-OVERLOADED-NAME-FROM-ARGUMENTS overloaded-name argument-sorts language)
  (let ((candidate-exprs (possible-symbol-forms overloaded-name argument-sorts language)))
    (cond ((null? candidate-exprs)
	   (imps-error "DISAMBIGUATE-OVERLOADED-NAME-FROM-ARGUMENTS: No language constant with overloaded name ~A consistent with sorts ~A." overloaded-name argument-sorts))
	  
;;;	  ((> (length candidate-exprs) 1)
;;;	   (imps-error "DISAMBIGUATE-OVERLOADED-NAME-FROM-ARGUMENTS: Too many language constants with overloaded name ~A~%~%~A" overloaded-name candidate-exprs))
	   
	  (else (last candidate-exprs)))));;If there is any ambiguity, use the first one entered.

(define (OVERLOADED-NAME-FOR-FORMAL-SYMBOL? name)
  (and (symbol? name) (table-entry  *overloaded-names-table* name)))

(define (UNAMBIGOUSLY-CONSTRUCTIBLE-FROM-ARGUMENTS-IN-LANGUAGE?
	 overloaded-name formal-symbol arguments language)
  (let ((candidates
	 (possible-symbol-forms
	  overloaded-name
	  (map expression-sorting arguments)
	  language)))
    (and candidates ;; (= (length candidates) 1)
	 (eq? (last candidates) formal-symbol))))

;;;(define (UNAMBIGOUSLY-CONSTRUCTIBLE-FROM-ARGUMENTS-IN-LANGUAGE-USING-TYPES?
;;;	 overloaded-name formal-symbol arguments language)
;;;  (let ((candidates
;;;	 (possible-symbol-forms-by-type
;;;	  overloaded-name
;;;	  (map expression-sorting arguments)
;;;	  language)))
;;;    (and (= (length candidates) 1)
;;;	 (eq? (car candidates) formal-symbol))))
;;;


(define (FORMAL-SYMBOL-OVERLOADED-NAME formal-symbol)
  (table-entry *formal-symbol-overloaded-names-table* formal-symbol))

(define (THEORY-ENSEMBLE-INSTALL-OVERLOADINGS-FOR-DEFINED-CONSTANTS ensemble n)
  (iterate loop ((j 1))
    (if (> j n) '#t
	(let ((constants (translatable-natively-defined-constants-in-theory-multiple ensemble j))
	      (instances (theory-ensemble-instances ensemble j)))
	  (walk (lambda (constant)
		  (let ((overloaded-name (name constant)))
		    (install-overloaded-name-for-formal-symbol
		     overloaded-name
		     constant)))
		constants)
	  (walk (lambda (instance)
		  (walk
		   (lambda (constant)
		     (let ((overloaded-name 
			    (name constant))
			   (formal-symbol (translate-constant instance constant)))
		       (if (formal-symbol? formal-symbol)

			   (install-overloaded-name-for-formal-symbol
			    overloaded-name
			    formal-symbol))))
		   constants))
		instances)
	  (loop (1+ j))))))

(define (INSTALL-OVERLOADINGS-FOR-NAME-IN-THEORY-ENSEMBLE-INSTANCES theory constant-name)
  (destructure (((ensemble . n) (table-entry *multiple-ensemble-table* theory)))
    (let ((constant (find-constant (theory-language multiple) constant-name)))
      (let ((instances (theory-ensemble-instances ensemble n)))
	(install-overloaded-name-for-formal-symbol
	 constant-name
	 constant)
	(walk (lambda (instance)
		(let ((formal-symbol (translate-constant instance constant)))
		  (if (formal-symbol? formal-symbol)
		      (install-overloaded-name-for-formal-symbol
		       constant-name
		       formal-symbol))))
	      instances)
	'#t))))

(define (APPLY-OPERATOR-SEXP-DECODER sexp language name-formal-symbol-alist)
  (if (overloaded-name-for-formal-symbol? (cadr sexp)) 
      (let* ((arguments 
	        (map
		 (lambda (c)
		   (sexp->expression-1 c language name-formal-symbol-alist))
		 (cddr sexp)))
	     (argument-sorts (map expression-sorting arguments))
	     (operator
	      (disambiguate-overloaded-name-from-arguments
	       (cadr sexp) argument-sorts language)))
	(cons operator arguments))
      (rec-descent-sexp-decoder sexp language name-formal-symbol-alist)))

(define (APPLY-OPERATOR-BUILDER expr)
  (if (fully-parenthesize)
      (default-builder expr)
      (let ((constr (expression-constructor expr))
	    (comps (expression-components expr)))
	(let ((overload
	       (formal-symbol-overloaded-name (car comps)))
	      (tentative-sexp
	       (default-builder expr)))
	  (if (and overload
		   (unambigously-constructible-from-arguments-in-language?
		    overload
		    (car comps)
		    (cdr comps)
		    (current-language)))
	      (cons (name constr)
		    (cons overload
			  (cddr				;omit constructor name and
							;operator name
			   tentative-sexp)))
	      tentative-sexp)))))

(define USE-OVERLOADED-NAMES?
  (let ((val '#f))
    (object
	(lambda () val)
      ((setter self)
       (lambda (nv)
	 (imps-enforce boolean? nv)
	 (set val nv)
	 (if nv
	     (block
	       (set-sexp-builder apply-operator apply-operator-builder)
	       (set-sexp-decoder apply-operator apply-operator-sexp-decoder))
	     (block
	       (set-sexp-builder apply-operator default-builder)
	       (set-sexp-decoder apply-operator rec-descent-sexp-decoder))))))))
