;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald (presentation dg-emacs))


(*require nil '(resources emacs-buffers) imps-implementation-env)
(*require nil '(resources pp-list) imps-implementation-env)

;;; Support for the emacs deduction-graph interface from the T side.  

;;; Alist of deductions graphs with a pair of two names, those of the dg-buff
;;; and the sqn-buff associated with the dg.  

(define DG-FILE-PREFIX "dg-")
(define *dg-interface-table* (make-table '*dg-interface-table*))
(define *dg-buffer-root-name* "*Deduction-")
(define *sqn-buffer-root-name* "*Sequent-nodes-")

(define save-windows?
  (make-simple-switch 'save-windows? boolean? '#f))
   
(define (START-EMACS-DEDUCTION goal dgrv-index . theory)
  (let ((theory (or (car theory)
		    (current-theory))))
    (set-up-dg-interface
     dgrv-index
     (start-deduction (cond ((null? goal) '())
			    ((formula? goal)
			     (or (contains-expression? (theory-language theory) goal)
				 (imps-error "START-EMACS-DEDUCTION: ~A is not a formula in the theory ~A." goal theory))
			     goal)
			    ((sequent? goal)
			     (or (subtheory? (sequent-theory goal) theory)
				 (imps-error "START-EMACS-DEDUCTION: ~A is not a sequent in the theory ~A." goal theory))
			     goal)			 
			    ((string? goal)
			     (qr goal (theory-language theory)))
			    ((list? goal)
			     (qr-sexp goal (theory-language theory)))
			    (t goal))
		      theory))))
  
(define dgrv-index->dg
  (settable-alist integer?
		  (lambda (d)(or (null? d) (deduction-graph? d)))))

;;; NAME is a string here
(define (SET-UP-DG-INTERFACE dgrv-index dg)
  (let* ((name (format nil "~A~D*" *dg-buffer-root-name* dgrv-index))
	 (sqn-name (format nil "~A~D*" *sqn-buffer-root-name* dgrv-index))
	 (dg-port (emacs-port name 'out))
	 (sqn-port (emacs-port sqn-name 'out)))
    (set (dgrv-index->dg dgrv-index) dg)
    (emacs-eval "(dgrv-initialize-dgr ~D
  (get-buffer ~S)
  (get-buffer ~S)
  ~D
  ~S)"
		dgrv-index
		sqn-name
		name
		(object-hash dg)
		(theory-name-string (deduction-graph-theory dg)))		
    (emacs-buffer-eval name
		       "(dg-mode ~S)" dgrv-index)
    (emacs-buffer-eval sqn-name
		       "(sqn-mode ~S)" dgrv-index)
    (set (table-entry *dg-interface-table* dg)
	 (list dg-port sqn-port nil nil dgrv-index name))
    (emacs-verbose-update-dg dg)
    (emacs-add-all-new-sqns dg)
    (if (not (save-windows?))
	(block 
	  ;; (emacs-eval "(pop-to-buffer ~S)" name)
	  (emacs-eval "(progn (pop-to-buffer ~S)(top-level))" sqn-name)))
    repl-wont-print))

(define (DG-PORT dg)
  (nth (table-entry *dg-interface-table* dg) 0))

(define (SQN-PORT dg)
  (nth (table-entry *dg-interface-table* dg) 1))

(define DG-SQNS-SENT
  (operation
      (lambda (dg)
	(nth (table-entry *dg-interface-table* dg) 2))
    ((setter self)
     (lambda (dg new-value)
       (set (nth (table-entry *dg-interface-table* dg) 2)
	    new-value)))))

(define DG-SQNS-GROUNDED
  (operation
      (lambda (dg)
	(nth (table-entry *dg-interface-table* dg) 3))
    ((setter self)
     (lambda (dg new-value)
       (set (nth (table-entry *dg-interface-table* dg) 3)
	    new-value)))))

(define (DG->DGRV-INDEX dg)
  (nth (table-entry *dg-interface-table* dg) 4))

(define (DG->BUFFER-NAME dg)
  (nth (table-entry *dg-interface-table* dg) 5))

(define ALLOW-DG-UPDATES?
  (make-simple-switch 'dg-updates boolean? '#t))

(define (EMACS-UPDATE-DG dg)
  (cond ((not (allow-dg-updates?))
	 (emacs-message "Calling Tea... returned. However, dg-display has not been updated"))
	(else
	 (with-open-ports ((dg-f (open dg-file-name '(out))))
	   ;; Formerly:
	   ;;
	   ;; (set (line-length dg-f) 60)
	   ;; (pp-list (deduction-graph->list dg) dg-f)
	   ;; 
	   (print-dg dg dg-f))
	 (emacs-port-eval (dg-port dg) "(dg-read-from-file ~S ~S)"
			  (dg->buffer-name dg)
			  dg-file-name)
	 (if (xdg?) 
	     (emacs-port-eval (dg-port dg)
			      "(xdg-write-buffer ~S)"
			      (dg->buffer-name dg)))
	 (emacs-port-eval (dg-port dg) "(goto-char (point-max))")
	 (emacs-message "Calling Tea... returned"))))

(define (EMACS-VERBOSE-UPDATE-DG dg)
  ;;
  ;; Had formerly been:
  ;; 
  ;; (with-open-ports ((dg-f (open dg-file-name '(out))))
  ;;   (set (line-length dg-f) 60)
  ;;   (pp-list (verbose-deduction-graph->list dg) dg-f))
  ;; (emacs-port-eval (dg-port dg) "(dg-read-from-file ~S ~S)"
  ;; 	   (dg->buffer-name dg)
  ;; 	   dg-file-name)
  ;; (emacs-port-eval (dg-port dg) "(goto-char (point-max))")
  ;; (emacs-message "Calling Tea... returned")
  ;; 
  
  (bind ((*list-details-for-grounded-nodes* '#t))
    (emacs-update-dg dg)))
    
(define (DG-ADD-NEW-SQNS-SENT dg new-sqns)
  (set (dg-sqns-sent dg)
       (set-union new-sqns (dg-sqns-sent dg))))

    
(define (DG-ADD-NEW-SQNS-GROUNDED dg new-sqns)
  (set (dg-sqns-grounded dg)
       (set-union new-sqns (dg-sqns-grounded dg))))

(define (EMACS-ADD-SQNS dg new-sqns newly-grounded-sqns)
  (with-open-ports ((sqn-f (open sqn-file-name '(out))))
    (do ((sqns (set-union new-sqns (set-difference newly-grounded-sqns new-sqns)) (cdr sqns)))
	((null? sqns) repl-wont-print)
      (let ((current (car sqns)))
	(format sqn-f "~S~%~A~%~A~%~A"
		(if (use-sequent-node-numbers?)
		    (sequent-node-number current)
		    (object-hash current))
		(if (sequent-node-grounded? current) "t" "nil")
		(sequent-node->string current)
		#\form))))
  (emacs-port-eval (sqn-port dg)
		   "(sqn-add-from-file ~D ~S)"
		   (dg->dgrv-index dg)
		   sqn-file-name)
  (dg-add-new-sqns-sent dg new-sqns)
  (dg-add-new-sqns-grounded dg newly-grounded-sqns)
  repl-wont-print)

(define (EMACS-SUPPLEMENT-SQNS dg already-there already-grounded)
  (emacs-add-sqns
   dg
   (set-difference
    (deduction-graph-sequent-nodes dg)
    already-there)
   (set-difference
    (deduction-graph-grounded-sqns dg)
    already-grounded)))

(define (EMACS-ADD-ALL-NEW-SQNS dg)
  (emacs-add-sqns dg
		  (set-difference
		   (deduction-graph-sequent-nodes dg)
		   (dg-sqns-sent dg))
		  (set-difference
		   (deduction-graph-grounded-sqns dg)
		   (dg-sqns-grounded dg))))

(define (READ-SEQUENT context-string assertion-string dg)
  (let* ((language (theory-language (deduction-graph-theory dg)))
	 (assumptions 	 (string->assumptions language context-string))
	 (context (build-context (deduction-graph-theory dg)

				 ;;changed by FARMER and JT.

				 assumptions))
	 (assertion (qr assertion-string language))
	 (vars (set-union (big-u (map free-variables (context-assumptions context)))
			  (free-variables assertion))))

    ;; This WAS a hack to allow proofs with instantiate-universal-antecedent 
    ;; which reference assumptions by their index as last read, regardless
    ;; of how they are internally represented.
    ;; Of course you will read in the wrong assumption if 
    ;; (last-read-sequent-assumptions) is modified.

;;  (set (last-read-sequent-assumptions) assumptions)

    (iterate loop ((vars vars) (seen '()))
      (if vars
	  (let ((find (mem (lambda (x y) (eq? (name x) (name y)))
			   (car vars)
			   seen)))
	    (if find
		(imps-warning "~%~%;;BEWARE: Posted sequent contains at least two distinct but identically named free variables:~%   ~A ~%  ~A." (car find) (car vars))
		(loop (cdr vars) (cons (car vars) seen))))))
    (build-sequent context assertion)))
    
(define (READ-SEQUENT-AND-POST context-string assertion-string dg)
  (post (read-sequent context-string assertion-string dg) dg))

(define (READ-SEQUENT-AND-START-EMACS-DEDUCTION context-string assertion-string dgrv-index)
  (bind (((save-windows?) '#t))
    (start-emacs-deduction
     (build-sequent
      (build-context (current-theory)
		     (string->assumptions (current-language) context-string))
      (qr assertion-string))
     dgrv-index)))

(define (READ-SEQUENT-AND-START-DEDUCTION context-string
					  assertion-string
					  theory-name)
  (start-deduction
   (build-sequent
    (build-context (current-theory)
		   (string->assumptions (current-language) context-string))
    (qr assertion-string))
   (name->theory theory-name)))

(define (EMACS-SEND-SQN-TO-EDIT dg-number sqn fully?)
  (bind (((fully-parenthesize) fully?))
    (with-open-ports ((sqn-f (open sqn-edit-file-name '(out))))
      (format sqn-f "~A~%"
	      (sequent-node->string sqn))))
  (emacs-eval "(sqn-edit-from-file ~D ~D ~S)"
	      dg-number
	      (sequent-node-number sqn)
	      sqn-edit-file-name)
  repl-wont-print)

(define (EMACS-DISPLAY-SQN dg-number sqn)
  (and 
   (sequent-node? sqn)
   (emacs-eval "(sqn-select ~D ~D)"
	       dg-number
	       (sequent-node-number sqn))))


(define (SEQUENT-UNHASH sqn-number)
  (if (use-sequent-node-numbers?)
      (sequent-unhash-in-graph sqn-number (emacs-dg))
      (object-unhash sqn-number)))

(define (SEQUENT-UNHASH-IN-GRAPH sqn-number dg)
  (let ((sqns (deduction-graph-sequent-nodes dg)))
    (or (any (lambda (sqn) (and (= (sequent-node-number sqn) sqn-number)
				sqn))
	     sqns)
	(imps-error "SEQUENT-UNHASH-IN-GRAPH: didn't find sqn number ~D in dg ~S"  sqn-number dg))))

(define (SEQUENT-UNHASH-IN-GRAPH-BY-NUMBER sqn-number dg-index)
  (sequent-unhash-in-graph sqn-number (dgrv-index->dg dg-index)))

(define emacs-dg
  (make-simple-switch 'emacs-dg (always '#t)))

(define use-sequent-node-numbers?
  (make-simple-switch 'use-sequent-node-numbers? boolean? '#t))

(define (sequent-read sequent input)
  (if (and (string? input)
	   (string-empty? input))
      (imps-error "sequent-read:  Null string supplied."))
  (let* ((language (theory-language (context-theory (sequent-context sequent))))
	 (var-sort-list
	  (iterate loop
	      ((accum '())
	       (vars (append
		      (free-variables (sequent-assertion sequent))
		      (append
		       (context-assumption-variables (sequent-context sequent))
		       (bound-variables (sequent-assertion sequent))))))
	    (cond ((null? vars) (reverse! accum))
		  ;;
		  ;;if a name occurs as a constant, then use it as such.
		  ;;
		  ((find-constant language (name (car vars)))
		   (loop accum (cdr vars)))		 
		  (else (loop (cons (cons (name (car vars))
					  (expression-sorting (car vars)))
				    accum)
			      (cdr vars)))))))
    (bind (((language-default-sortings language)
	    (append! var-sort-list
		     (language-default-sortings language))))
      (qr input language))))

(define (sequent-node-read sequent input) (sequent-read (sequent-node-sequent sequent) input))

;;;(define (sequent-read sequent input)
;;;  (let ((language (theory-language (context-theory (sequent-context sequent))))
;;;	(var-sort-list
;;;	 (map
;;;	  (lambda (v)
;;;	    (cons (name v) (expression-sorting v)))
;;;	  (append
;;;	   (free-variables (sequent-assertion sequent))
;;;	   (append
;;;	    (context-assumption-variables (sequent-context sequent))
;;;	    (bound-variables (sequent-assertion sequent)))))))
;;;	   
;;;    (bind (((language-default-sortings language)
;;;	    (append! var-sort-list
;;;		     (language-default-sortings language))))
;;;      (qr input language))))
    
(define (SEQUENT-READ-SEQUENT-AND-POST sequent context-string assertion-string dg)
  (let ((language (theory-language (context-theory (sequent-context sequent))))
	(var-sort-list
	 (map
	  (lambda (v)
	    (cons (name v) (expression-sorting v)))
	  (set-union (free-variables sequent) (bound-variables sequent)))))
    (bind (((language-default-sortings language)
	    (append! var-sort-list
		     (language-default-sortings language))))
      (read-sequent-and-post context-string assertion-string dg))))

(define (imps-post-read-and-post context-string assertion-string dg sqn-no)
  (let ((sequent
	 (sequent-node-sequent
	  (if (use-sequent-node-numbers?)
	      (let ((sqns (deduction-graph-sequent-nodes dg)))
		(or (any (lambda (sqn) (and (= (sequent-node-number sqn) sqn-no)
					    sqn))
			 sqns)
		    (imps-error "imps-post-read-and-post: didn't find sqn number ~D in dg ~S"  sqn-number (emacs-dg))))
	      (object-unhash sqn-no)))))
    (sequent-read-sequent-and-post sequent context-string assertion-string dg)))

;;;(define (DG-EMACS-FORCE-BY-OCCURRENCE sqn-no target-input
;;;				      replacement-input occurrence)
;;;  (let* ((sqn (sequent-unhash sqn-no))
;;;	 (sequent (sequent-node-sequent sqn)))
;;;    (deduction-graph-force-substitution-by-occurrence
;;;     sqn
;;;     (sequent-read sequent target-input)
;;;     (sequent-read sequent replacement-input)
;;;     occurrence)))
;;;
;;;(define (dg-emacs-instantiate-theorem sqn-no thm-name term-strings)
;;;  (let* ((sqn (sequent-unhash sqn-no))
;;;	 (sequent (sequent-node-sequent sqn))
;;;	 (terms (map
;;;		 (lambda (str)
;;;		   (sequent-read sequent str))
;;;		 term-strings)))
;;;    (instantiate-theorem sqn (name->theorem thm-name) terms)))
;;;
;;;(define (dg-emacs-instantiate-existential sqn-no term-strings)
;;;  (let* ((sqn (sequent-unhash sqn-no))
;;;	 (sequent (sequent-node-sequent sqn))
;;;	 (terms (map
;;;		 (lambda (str)
;;;		   (sequent-read sequent str))
;;;		 term-strings)))
;;;    (instantiate-existential sqn terms)))
;;;
;;;(define (dg-emacs-instantiate-universal-antecedent sqn-no assumption-no term-strings)
;;;  (let* ((sqn (sequent-unhash sqn-no))
;;;	 (sequent (sequent-node-sequent sqn))
;;;	 (terms (map
;;;		 (lambda (str)
;;;		   (sequent-read sequent str))
;;;		 term-strings)))
;;;    (instantiate-universal-antecedent sqn assumption-no terms)))
	

(define (enable-qcs qc-names)
  (walk
   (lambda (x) (let ((qc (name->quasi-constructor x)))
		 (if qc (enable-quasi-constructor qc))))
   qc-names)
  (return))

(define (disable-qcs qc-names)
  (walk
   (lambda (x) (let ((qc (name->quasi-constructor x)))
		 (if qc (disable-quasi-constructor qc))))
   qc-names)
  (return))

(define (execute-call-from-emacs-and-update dg-index sexp . qc-names)
  (ignore qc-names)					;for now
  (block (format t " ; Call to Tea from Emacs...")
	 (time
	  (bind (((emacs-dg) (dgrv-index->dg dg-index)))
	    (let ((result (eval sexp imps-implementation-env)))
	      (emacs-add-all-new-sqns (emacs-dg))
	      (emacs-update-dg (emacs-dg))
	      (if (sequent-node? result)
		  (emacs-display-sqn dg-index result)
		  result))))))

(define (sequent-unhash-currently sqn-no)
  (sequent-unhash-in-graph sqn-no (current-dg)))

(define sqn-u-h sequent-unhash-currently)


(define (dg-emacs-install-theorem dg-index sqn-no thm-name usage-list)
  (bind (((emacs-dg) (dgrv-index->dg dg-index)))
    (let ((sqn (sequent-unhash sqn-no))
	  (thm-name-str (string-downcase (symbol->string thm-name))))
      (if (sequent-node-grounded? sqn)
	  (block
	    (apply theory-add-theorem
		   (deduction-graph-theory (emacs-dg))
		   (sequent->sentence
		    (sequent-node-sequent sqn))
		   thm-name
		   usage-list)
	    (emacs-eval
	     (format nil "(progn (intern ~S imps-obarray)
				 (message \"Theorem %s installed.\" ~S))"
		     thm-name-str thm-name-str)))
	  (imps-error
	   "dg-emacs-install-theorem: Ungrounded node ~S" sqn)))))

(define cmpn-expr-separator (format nil "~%~%"))
(define cmpn-expr-list-separator
  (format nil "== == == == == == == == == == == == == == == ==~%~%"))

(define (emacs-display-cmpn cmpn)
  (let ((expr-list-list (partition-computation-node cmpn))
	(dgrv-index (dg->dgrv-index (computation-node-graph cmpn)))
	(index (computation-node-number cmpn))
	(print-exprs
	 (lambda (exprs port)
	   (walk
	    (lambda (expr)
	      (display (qp expr) port)
	      (display cmpn-expr-separator port))
	    exprs))))	   
    (with-open-ports ((cmpn-f (open cmpn-file-name '(out))))
      (format cmpn-f "~A~%~A~%" index (map sequent-node-number (computation-node-sqns cmpn)))
      (and
       expr-list-list
       (iterate iter ((expr-list-list expr-list-list))
	 (print-exprs (car expr-list-list) cmpn-f)
	 (and (cdr expr-list-list)
	      (block 
		(display cmpn-expr-list-separator cmpn-f)
		(iter (cdr expr-list-list)))))))
    (emacs-eval "(cmpn-add-from-file ~D ~S)"
		dgrv-index
		cmpn-file-name)
    (emacs-eval "(pop-to-buffer ~S)" (format nil "*Computations-~D-~D*" dgrv-index index))))
		
	   
(define (computation-node-read dg-number cmpn-index string)
  (let ((cmpn (deduction-graph-find-cmpn (dgrv-index->dg dg-number) cmpn-index)))
    (emacs-display-cmpn
     (computation-node-add-expressions
      cmpn
      (list 
       (sequent-read (sequent-node-sequent (last (computation-node-sqns cmpn)))
		     string))))))
    
(define (computation-node-simplify dg-number cmpn-index string)
  (let ((cmpn (deduction-graph-find-cmpn (dgrv-index->dg dg-number) cmpn-index)))
    (emacs-display-cmpn
     (computation-node-add-expressions
      cmpn
      (receive (simplified ())
	(simplify-with-minor-premises
	 (computation-node-context cmpn)
	 (sequent-read (sequent-node-sequent (last (computation-node-sqns cmpn)))
		       string))
	(list simplified))))))
      
(define (computation-node-apply-macete dg-number cmpn-index string macetes)
  (let ((cmpn (deduction-graph-find-cmpn (dgrv-index->dg dg-number) cmpn-index))
	(macete (car macetes))
	(paths '(())))
    (let ((context (computation-node-context cmpn))
	  (target (sequent-read (sequent-node-sequent (last (computation-node-sqns cmpn)))
				string)))
      (emacs-display-cmpn
       (computation-node-add-expressions
	cmpn
	(list
	 (apply-macete macete context target)))))))
	  
       
      
(define (sqn-univeral-assumptions-with-variable-sorts sqn)
  (iterate loop ((collect '()) (assums (sequent-node-assumptions sqn)) (n 0))
    (if (null? assums)
	(reverse! collect)
	(if (universal? (car assums))
	    (loop (cons (cons n (apply append (map (lambda (var)
				   (list (name var)
					 (sort-list->string (sort->list (expression-sorting var)))))
				 (newly-bound-variables (car assums)))))
			collect)
		  (cdr assums)
		  (1+ n))
	    (loop collect (cdr assums) (1+ n))))))


(define (sqn-existential-with-variable-sorts sqn)
  (let ((assert (sequent-node-assertion sqn)))
    (if (existential? assert)
	(apply append (map (lambda (var)
			     (list (name var)
				   (sort-list->string (sort->list (expression-sorting var)))))
			   (newly-bound-variables assert)))
	'())))


(define (sqn-antecedent-inference-assumptions sqn)
  (iterate loop ((collect '()) (assums (sequent-node-assumptions sqn)) (n 0))
    (if (null? assums)
	(reverse! collect)
	(let ((expr (car assums)))
	  (if (or (implication? expr)
		  (existential? expr)
		  (conjunction? expr)
		  (disjunction? expr)
		  (biconditional? expr)
		  (conditional-formula? expr))
	      (loop (cons n collect) (cdr assums) (1+ n))
	      (loop collect (cdr assums)  (1+ n)))))))

(define (sqn-backchain-inference-assumptions sqn)
  (iterate loop ((collect '()) (assums (sequent-node-assumptions sqn)) (n 0))
    (if (null? assums)
	(reverse! collect)
	(if (backchainable? sqn (car assums))
	    (loop (cons n collect) (cdr assums) (1+ n))
	    (loop collect (cdr assums)  (1+ n))))))

(define (sqn-backchain-backwards-inference-assumptions sqn)
  (iterate loop ((collect '()) (assums (sequent-node-assumptions sqn)) (n 0))
    (if (null? assums)
	(reverse! collect)
	(if (backwards-backchainable? sqn (car assums))
	    (loop (cons n collect) (cdr assums) (1+ n))
	    (loop collect (cdr assums)  (1+ n))))))

(define (defined-constants-in-assertion sqn)
  (let ((theory (deduction-graph-theory (sequent-node-graph sqn)))
	(assertion (sequent-node-assertion sqn)))
    (let ((pre (iterate loop ((expr assertion))
      (if (and (constant? expr)
	       (theory-defined-constant? theory expr))
	  (list expr)
	  (big-u (map loop (expression-quasi-components-or-components expr)))))))
      (map (lambda (x) (cons (string-downcase (symbol->string (name x))) 
			     (virtual-paths-to-occurrences assertion x -1)))
	   pre))))


(define (enabled-quasi-constructors-in-sequent sqn)
  (labels ((quasi-constructors-in-expr
	    (lambda (expr)
	      (let ((qc (expression-quasi-constructor-if-enabled expr))
		    (sub (big-u (map quasi-constructors-in-expr
				     (expression-quasi-components-if-enabled-or-components expr)))))
		(if qc (add-set-element qc sub) sub)))))
  (map (lambda (x) (list (string-downcase (symbol->string (name x)))))
       (big-u (map quasi-constructors-in-expr (cons (sequent-node-assertion sqn)
					       (sequent-node-assumptions sqn)))))))

(define (disabled-quasi-constructors sqn)
  (ignore sqn)
  (let ((quasi-constructors 
	 (delq lambda-application *disabled-quasi-constructors*)))
    (map 
     (lambda (x) (list (string-downcase (symbol->string (name x)))))
     quasi-constructors)))
	

(define (quasi-constructors-in-sequent sqn)
  (labels ((quasi-constructors-in-expr
	    (lambda (expr)
	      (let ((qcs (expression-quasi-constructors expr))
		    (sub (big-u (map quasi-constructors-in-expr
				     (expression-components expr)))))
		(set-union qcs sub)))))
  (map (lambda (x) (list (string-downcase (symbol->string (name x)))))
       (big-u (map quasi-constructors-in-expr (cons (sequent-node-assertion sqn)
					       (sequent-node-assumptions sqn)))))))


(define (determine-applicable-inductors sqn)
  (let ((inductors '())
	(sequent-variables
	 (set-union
	  (universally-quantified-at-positive-locations (sequent-node-assertion sqn))
	  (sequent-free-variables (sequent-node-sequent sqn)))))
    (walk-table (lambda (k v)
		  (let ((induction-vars '())
			(inductor-sorts
			 (map expression-sorting
			      (inductor-induction-variables v))))
		    (walk (lambda (var)
			    (if (mem? sorting-leq (expression-sorting var)
				      inductor-sorts)
				(push induction-vars var)))
			  sequent-variables)
		    (if induction-vars
			(push inductors (cons (string-downcase (symbol->string k))
					      (map (lambda (var)
						     (list (string-downcase (symbol->string (name var)))
							   (sort-list->string (sort->list (expression-sorting var)))))
						   induction-vars))))))
		*imps-inductors*)
    inductors))


(define (universally-quantified-at-positive-locations assertion)
  (let ((univeral-paths
	 (paths-to-satisfying-virtual-occurrences assertion universal? -1))
	(vars '()))
    (walk (lambda (virtual-path)
	    (if (virtual-path-to-positive-location? assertion virtual-path)
		(push vars (binding-variables (follow-virtual-path assertion virtual-path)))))
	  univeral-paths)
    (big-u vars)))
