;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



(herald other-forms)

(define-syntax (VIEW-EXPR expr-string . expr-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form expr-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(fully-parenthesize fully no-quasi-constructors no-qcs tex) 
     '(language syntax) 
     '())
    (let ((fully? (or (memq? 'fully-parenthesize modifiers)
		      (memq? 'fully modifiers)))
	  (qcs? (not (or (memq? 'no-quasi-constructors modifiers)
			 (memq? 'no-qcs modifiers))))
	  (tex? (memq? 'tex modifiers))
	  (language-or-theory-name (cadr (assq 'language keyword-args)))
	  (syntax-name (cadr (assq 'syntax keyword-args))))
      `(bind (((fully-parenthesize) ',fully?)
	      ((use-quasi-constructor-form?) ',qcs?))
	 (let* ((language
		 (and ',language-or-theory-name
		      (or (name->language ',language-or-theory-name)
			  (theory-language (name->theory ',language-or-theory-name)))))
		(expression 
		 (if language
		     (qr ,expr-string language)
		     (qr ,expr-string))))
	   (if ',syntax-name
	       (bind (((use-string-form?) (eq? ',syntax-name 'string))
		      ((use-sexp-syntax?) (eq? ',syntax-name 'sexp)))
		 (if ',tex? 
		     (xview expression)
		     (format (standard-output) "~S" expression)))
	       (if ',tex? 
		   (xview expression)
		   (format (standard-output) "~S" expression)))
	   repl-wont-print)))))

(define-syntax (LOAD-SECTION section-name . expr-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form expr-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(reload-files-only reload quick-load) 
     '() 
     '())
    (let ((reload-files-only? (memq? 'reload-files-only modifiers))
	  (reload? (memq? 'reload modifiers))
	  (quick? (memq? 'quick-load modifiers)))
      `(load-imps-section 
	',section-name 
	',reload-files-only? 
	',reload? 
	',quick?))))

(define-syntax (INCLUDE-FILES . expr-forms)
  (receive (modifiers keyword-args)
    (collect-modifier-and-keyword-arguments-for-def-form expr-forms)
    (modifier-and-keyword-check-for-def-form
     modifiers
     keyword-args
     '(reload quick-load) 
     '(files) 
     '(files))
    (let ((reload? (memq? 'reload modifiers))
	  (quick? (memq? 'quick-load modifiers))
	  (filespecs (cdr (assq 'files keyword-args))))
      `(bind (((quick-load?) ',quick?))
	 (LOAD-IMPS-FILES ',filespecs ',reload?)))))

(define-syntax (ENSEMBLE-DONT-TRANSLATE-CONSTANT  ensemble-name expr-string)
  `(dont-translate-constant
    (name->theory-ensemble ',ensemble-name) 
    (qr ,expr-string
	(theory-language 
	 (theory-ensemble-base-theory (name->theory-ensemble ',ensemble-name))))))
