;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald scripts)

(define (sqn-coerce-to-expression sqn term-or-term-string)
  (cond ((expression? term-or-term-string) term-or-term-string)
	((string? term-or-term-string)
	 (sequent-read (sequent-node-sequent sqn) term-or-term-string))
	(else (imps-error "~A is neither an expression nor a string." term-or-term-string ))))

(define (coerce-to-theorem thm-or-thm-name)
  (cond ((theorem? thm-or-thm-name)  thm-or-thm-name)
	((symbol? thm-or-thm-name) (name->theorem thm-or-thm-name))
	(else (imps-error "~A is neither a formula nor a symbol." thm-or-thm-name))))

(define (coerce-to-translation trans-or-trans-name)
  (cond ((translation? trans-or-trans-name)  trans-or-trans-name)
	((symbol? trans-or-trans-name) (name->translation trans-or-trans-name))
	(else (imps-error "~A is neither a translation nor a symbol." trans-or-trans-name))))

(define (coerce-to-macete macete-or-macete-name)
  (cond ((macete? macete-or-macete-name)  macete-or-macete-name)
	((symbol? macete-or-macete-name) (name->macete macete-or-macete-name))
	(else (imps-error "~A is neither a formula nor a symbol." macete-or-macete-name))))

;;;(define last-read-sequent-assumptions
;;;  (make-simple-switch 'last-read-sequent list? '()))

(define (dg-coerce-to-sequent-node dg x)
  (cond ((sequent-node? x) x)
	((number? x) (sequent-unhash-in-graph x dg))
	((and (list? x)
	      (= (length x) 2)
	      (string? (car x))
	      (string? (cadr x))
	      (read-sequent-and-post (car x) (cadr x) dg)))
	(else "DG-COERCE-TO-SEQUENT-NODE: ~A is neither a sequent-node, an index of one or a list of a context string and an assertio string." x)))

(define (sqn-coerce-to-assumption sqn assum-str-or-num)
  (cond ((formula? assum-str-or-num)
	 (if (mem? alpha-equivalent? assum-str-or-num (sequent-node-assumptions sqn))
	     assum-str-or-num
	     (or (any (lambda (ass) (if (quick-match? ass assum-str-or-num)
					ass
					'#f))
		      (sequent-node-assumptions sqn))
		 (imps-error "SQN-COERCE-TO-ASSUMPTION: ~A is neither an assumption, a formula which matches an assumption, a string representing one, or an index." assum-str-or-num))))

	((string? assum-str-or-num)
	 (sqn-coerce-to-assumption sqn (sequent-read (sequent-node-sequent sqn) assum-str-or-num)))
	((number? assum-str-or-num)
	 (if (>= assum-str-or-num (length (sequent-node-assumptions sqn)))
	     (imps-error "SQN-COERCE-TO-ASSUMPTION: Not enough assumptions for index ~D."
			       assum-str-or-num)
	     (nth (sequent-node-assumptions sqn) assum-str-or-num)))
	(else (imps-error "SQN-COERCE-TO-ASSUMPTION: ~A is neither an assumption, a formula which matches an assumption, a string representing one, or an index." assum-str-or-num))))

(lset *interactive-command-applier*
      (lambda (sqn command-name args)
	(deduction-graph-apply-command-interface
	 (sequent-node-graph sqn)
	  (name->command command-name)
	  (list sqn)
	  args
	  '())))

(lset *script-command-applier*
      (lambda (sqn command-name args)
	(apply (name->command command-name)
	       sqn
	       args)))

(define (interpret-command-sequence sqn command-applier command-script)
        
  ;;Each entry in the command script is
  
  ;; (a) The name of a single proof command.
  ;; (b) A list (proof-command-name args)
  ;; (c) A list (control-command-name args)
  (bind (((imps-raise-error?) '#f))
    (let ((goal sqn))
      (iterate loop ((sqn goal) (command-script command-script))
	(cond ((or (null? command-script);; No more commands left
		   (immediately-grounded? goal) ;;grounded so stop!
		   (not (sequent-node? sqn)));; sqn isn't a sequent node 
	       (return
		(immediately-grounded? goal)
		sqn))
	      ((symbol? (car command-script))
	       (command-applier sqn (car command-script) '())
	       (loop
		(sequent-node-first-unsupported-relative sqn)
		(cdr command-script)))
	      ((command-sequence-keyword? (caar command-script))
	       (loop (interpret-keyword
		      sqn
		      (caar command-script)
		      (cdar command-script))
		     (cdr command-script)))
	      (else 
	       (command-applier sqn (caar command-script) (cdar command-script))
	       (loop
		(sequent-node-first-unsupported-relative sqn)
		(cdr command-script))))))))
 
(define (execute-command-sequence-for-scripts sqn command-script)
  (interpret-command-sequence sqn *script-command-applier* command-script))

(define (execute-command-sequence dg-or-sqn command-script)
  (or (deduction-graph? dg-or-sqn)
      (sequent-node? dg-or-sqn)
      (imps-error "EXECUTE-COMMAND-SEQUENCE: ~A is not a deduction graph or sequent node."
		  dg-or-sqn))
  (let ((sqn (if (deduction-graph? dg-or-sqn)
		 (deduction-graph-goal dg-or-sqn)
		 dg-or-sqn)))
    (receive (() sqn)
      (interpret-command-sequence sqn *interactive-command-applier* command-script)
      sqn)))

(let ((keyword-proc-alist '()))
  (define (command-sequence-keyword? word)
    (assq? word keyword-proc-alist))

  (define (add-command-keyword word proc)
    (push keyword-proc-alist (cons word proc)))

  (define (interpret-keyword sqn word arg)
    (apply (cdr (assq word keyword-proc-alist)) sqn arg)))

(add-command-keyword 'move-to-ancestor nth-ancestor)

(define (history-entry-jump history-entry)
  (let ((previous (dg-history-entry-previous-entry history-entry))
	(sqn (dg-history-entry-sequent-node history-entry)))
    (cond ((null? previous) '())
	  ((eq? (dg-history-entry-first-unsupported-relative previous)
		sqn) '())
	  ((sequent-node? (dg-history-entry-first-unsupported-relative previous))
	   (receive (index path)
	     (relative-position-in-dg
	      (dg-history-entry-first-unsupported-relative previous)
	      sqn)
	     (cons index path)))

	  ;; if (dg-history-entry-first-unsupported-relative previous) is
	  ;; nil, we better signal that fact without raising an error or
          ;; otherwise interrupting the computation.

	  (else (cons 'jump-undefined (dg-history-entry-sequent-node previous))))))
	   

(define (deduction-graph-readable-history-list dg)
  ;; The deduction-graph-history is built backwards, that is the latest
  ;; command is always consed on to the front of the last.
  (let ((command-forms '()))
    (walk
     (lambda (history-entry)
       
       (let ((args (dg-history-entry-arguments history-entry))
	     (comments (dg-history-entry-comments history-entry)))
	 (if comments (set command-forms
			   (cons (build-readable-comment-form comments)
				 command-forms)))
	 (set command-forms
	      (cons
	       (if args (cons (dg-command-name (dg-history-entry-command history-entry))
			      (build-readable-form args))
		   (dg-command-name (dg-history-entry-command history-entry)))
	       command-forms)))

       (let ((jump (history-entry-jump history-entry)))
	 (if jump
	     (set command-forms
		  (append! (build-readable-jump-form jump) command-forms)))))
     (deduction-graph-history dg))
    command-forms))

(define (build-readable-jump-form jump)

  ;; First deal with the case jump is undefined. 
  ;; Warn the user and inform him which sequent node has the problem.
  ;; The most reliable way seems to insert this as a comment in the script.

  (if (eq? (car jump) 'jump-undefined)
      `(,(build-readable-comment-form
	  (list (format nil
			"Warning: FIRST-UNSUPPORTED-RELATIVE is undefined for sequent node ~A."
			(sequent-node-number (cdr jump))))))

      ;; Next deal with the normal case.

      (destructure (((up . down) jump))
	(cond ((and (= up 1)
		    (= (length down) 1)
		    (not (pair? (car down))))
	       `((move-to-sibling ,(car down))))
	      ((null? down) `((move-to-ancestor ,up)))
	      (else `((move-to-ancestor ,up) (move-to-descendent ,down)))))))

(add-command-keyword 'move-to-descendent deduction-graph-follow-path)
(add-command-keyword 'move-to-sibling deduction-graph-find-sibling)


;;;(define (sqn-matches? sqn assums assert)
;;;  (and (every? 
;;;	  (lambda (x)
;;;	    (sqn-coerce-to-assumption sqn x '#t))
;;;	  assums)
;;;	 (quick-match? (sequent-node-assertion sqn) (sqn-coerce-to-expression sqn assert))))


(define (script-comment sqn comment-string)
  (let* ((dg (sequent-node-graph sqn))
	 (entry (car (deduction-graph-history dg))))
    (set (dg-history-entry-comments entry)
	 (cons comment-string (dg-history-entry-comments entry)))
  sqn))

(add-command-keyword 'script-comment script-comment)


(define (build-readable-comment-form comments)
  `(script-comment ,(apply string-append (reverse comments))))
