;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald schemata-for-quasi-constructors)

(define (BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA
	 symbol-form
	 schema-components
	 schema
	 fixed-sorts)
  
  (or (list? schema-components)
      (imps-error "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: schema-components must be a list"))
  (or (symbol? symbol-form)
      (imps-error "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: ~A is not a symbol" symbol-form))
  (or (every? sort? fixed-sorts)
      (imps-error "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: Bad list of fixed sorts."))
  (or (expression? schema)
      (imps-error "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: ~A is not an expression." schema))
  (or (every? variable? schema-components)
      (imps-error "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: Every schema component must be a variable."))
  (or (is-set? schema-components)
      (imps-error "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: Duplicated schema variables."))

  (let ((constr-proc
	 (build-qc-constructor-proc
	  schema-components
	  schema
	  fixed-sorts))

	(inverse-proc
	 (build-qc-inverse-proc
	  schema-components
	  schema
	  fixed-sorts)))
    
    (make-quasi-constructor constr-proc inverse-proc symbol-form)))

(define-integrable (return-error-string str) str)

(define (BUILD-QC-CONSTRUCTOR-PROC
	 schema-components
	 schema
	 fixed-sorts)
  (let ((len (length schema-components)))
    (lambda (components)
      (or (= len (length components))
	  (return-error-string "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: Wrong number of components."))

      (let* ((combined-sort-alist
	      (iterate loop ((schema-components schema-components)
			     (components components)
			     (combined-sort-alist '()))
		(if (null? components)
		    combined-sort-alist
		    (let ((combined-sort-alist
			   (increment-qc-sort-alist
			    (car schema-components)
			    (car components)
			     fixed-sorts 
			     combined-sort-alist)))
		      (if (fail? combined-sort-alist) (fail)
			  (loop (cdr schema-components)
				(cdr components)
				combined-sort-alist))))))
		    
	     (sort-alist
	      (if (succeed? combined-sort-alist)
		  (build-sort-substitution
		   fixed-sorts
		   combined-sort-alist)
		  (return-error-string "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: Schema sorting skeletons do not match."))))
	       
	(if (succeed? sort-alist)
	    (let ((translated-schema
		   (expression-substitute-sorts sort-alist schema))
		  (subst
		   (map (lambda (var component)
			  (cons (expression-substitute-sorts sort-alist var)
				component))
			schema-components
			components)))
	      (if (and (expression? translated-schema)
		       (substitution? subst))
		  (apply-substitution-fastidiously subst translated-schema)
		  (return-error-string "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: Bad components (1)")))
	    (return-error-string "BUILD-QUASI-CONSTRUCTOR-FROM-SCHEMA: Bad components (2)"))))))


(define (BUILD-QC-INVERSE-PROC
	 schema-components
	 schema
	 fixed-sorts)
  (let* ((free-vars (expression-free-variables schema))
	 (schema-components (map (lambda (var) (if (not (memq? var free-vars))
						   (undefined-of-sort var var)
						   var))
				 schema-components)))
    (lambda (expr)
      (receive (sort-alist subst)
	(schematic-match expr schema fixed-sorts)
      
	(if (and (succeed? sort-alist)
		 (succeed? subst))
	    (let ((comps
		   (catch stop
		     (map (lambda (comp)
			    (let ((new-comp
				   (expression-substitute-sorts sort-alist comp)))
			      (if (expression? new-comp)
				  (apply-substitution-fastidiously subst new-comp)
				  (stop '#f))))
			  schema-components))))
	      comps)
	    '#f)))))

(define (BUILD-QUASI-CONSTRUCTOR-FROM-LAMBDA-EXPRESSION
	 symbol-form
	 lambda-expression
	 fixed-sorts)
  (imps-enforce lambda-expression? lambda-expression)
  (build-quasi-constructor-from-schema
   symbol-form
   (binding-variables lambda-expression)
   (binding-body lambda-expression)
   fixed-sorts))




