;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald QUASI-SORTS)


;;; A "quasi-sort" is a unary predicate.

(define (QUASI-SORT? expr)		; Quasi-sorts no longer need to be closed.
  (unary-predicate? expr))

(define (THEORY-QUASI-SORT? theory expr)
  (and (quasi-sort? expr)
       (contains-expression? (theory-language theory) expr)))

;;;(define (QUASI-SORT? expr)
;;;  (and (unary-predicate? expr)
;;;       (closed? expr)))

(define (SORT-OR-QUASI-SORT? arg)
  (or (sort? arg)
      (quasi-sort? arg)))

(define (THEORY-SORT-OR-QUASI-SORT? theory arg)
  (or (theory-sort? theory arg)
      (theory-quasi-sort? theory arg)))

(define (QUASI-SORT-DOMAIN expr)
  (or (quasi-sort? expr)
      (imps-error "QUASI-SORT-DOMAIN: ~S ~A."
		  expr "is not a quasi-sort"))
  (unary-predicate-domain expr))

(define (SORT-OR-QUASI-SORT-DOMAIN arg)
  (if (sort? arg)
      arg
      (quasi-sort-domain arg)))

(define (TYPE-OF-SORT-OR-QUASI-SORT-DOMAIN arg)
  (type-of-sort (sort-or-quasi-sort-domain arg)))

(define (VARIABLES-OF-SORT-OR-QUASI-SORT arg)
  (if (sort? arg)
      the-empty-set
      (variables arg)))

;;; DOMAINS is a list whose members are sorts or quasi-sorts, and RANGE is
;;; a sort or quasi-sort.  BUILD-QUASI-SORT constructs a quasi-sort whose 
;;; domain is the set of functions which maps tuples in DOMAINS to elements
;;; in RANGE.

(define (BUILD-QUASI-SORT domains range)
  (or (and (every? sort-or-quasi-sort? domains)
	   (sort-or-quasi-sort? range))
      (imps-error "BUILD-QUASI-SORT: bad arguments ~S ~S." domains range))
  (let* ((avoid-vars (set-union 
		      (variables-of-sort-or-quasi-sort range)
		      (big-u (set-map variables-of-sort-or-quasi-sort domains))))
	 (d-sorts (map sort-or-quasi-sort-domain domains))
	 (d-vars (sorts->new-variables d-sorts 'x avoid-vars))
	 (r-sort (sort-or-quasi-sort-domain range))
	 (sort (build-maximal-higher-sort d-sorts r-sort))
	 (sort-var (new-variable sort 'f avoid-vars))
	 (conditions 
	  (iterate iter ((domains domains) (d-vars d-vars) (conditions '()))
	    (if (null? domains)
		(reverse conditions)
		(if (sort? (car domains))
		    (iter (cdr domains) (cdr d-vars) conditions)
		    (let ((condition (beta-reduce 
				      (apply-operator (car domains) (car d-vars)))))
		      (iter (cdr domains) (cdr d-vars) (cons condition conditions)))))))
	 (app (apply apply-operator sort-var d-vars))
	 (tested-app (or (sort? range)
			 (beta-reduce (apply-operator range app))))
	 (body (cond ((and (null? conditions)
			   (sort? range))
		      truth)

		     ((and (ind-sorting? r-sort)
			   (null? conditions)
			   (quasi-sort? range))
		      (implication (is-defined app) tested-app))
		     ((and (ind-sorting? r-sort)
			   conditions
			   (sort? range))
		      (implication (is-defined app) (conjunction-simplifier conditions)))
		     ((and (ind-sorting? r-sort)
			   conditions
			   (quasi-sort? range))
		      (if-form
		       (conjunction-simplifier conditions)
		       (implication (is-defined app) tested-app)
		       (negation (is-defined app))))

		     ((and (prop-sorting? r-sort)
			   (null? conditions)
			   (quasi-sort? range))
		      tested-app)
		     ((and (prop-sorting? r-sort)
			   conditions
			   (sort? range))
		      (implication 
		       (negation (equality app (falselike r-sort)))
		       (conjunction-simplifier conditions)))
		     ((and (prop-sorting? r-sort)
			   conditions
			   (quasi-sort? range))
		      (if-form
		       (conjunction-simplifier conditions)
		       tested-app
		       (equality app (falselike r-sort)))))))
    (imps-lambda 
     (apply forall body d-vars)
     sort-var)))

(define (MAKE-NONEMPTYNESS-FORMULA quasi-sort)
  (let ((var (new-variable 
	      (quasi-sort-domain quasi-sort) 
	      'x 
	      (variables quasi-sort))))
    (forsome 
     (beta-reduce (apply-operator quasi-sort var))
     var)))

(define (MAKE-ENCLOSURE-FORMULA arg1 arg2)
  (or (and (sort-or-quasi-sort? arg1)
	   (sort-or-quasi-sort? arg2))
      (imps-error "MAKE-ENCLOSURE-FORMULA: bad arguments ~S ~S." arg1 arg2))
  (let* ((sort1 (sort-or-quasi-sort-domain arg1))
	 (var (new-variable sort1 'x (set-union (if (sort? arg1)
						    the-empty-set
						    (variables arg1))
						(if (sort? arg2)
						    the-empty-set
						    (variables arg2)))))
	 (body (cond ((and (sort? arg1)
			   (sort? arg2))
		      (defined-in var arg2))
		     ((and (sort? arg1)
			   (quasi-sort? arg2))
		      (beta-reduce (apply-operator arg2 var)))
		     ((and (quasi-sort? arg1)
			   (sort? arg2))
		      (implication
		       (beta-reduce (apply-operator arg1 var))
		       (defined-in var arg2)))
		     ((and (quasi-sort? arg1)
			   (quasi-sort? arg2))
		      (implication
		       (beta-reduce (apply-operator arg1 var))
		       (beta-reduce (apply-operator arg2 var)))))))
    (forall body var)))
