##############################################################################
##
##    nq.g                      31 July 1992                     Werner Nickel
##
##    This file contains the interface to my NQ program. GAP 3.1 does not have
##    the  ability  to  handle  infinite  polycyclic  groups  in  terms  of  a
##    polycyclic  presentation.  Therefore the only  information obtained from
##    the NQ standalone  is the  structure of the factors in the lower central
##    series of the given group.
##    

##
##    Global variables in this file.
##
NqLowerCentralSeries := [];
NqLocation := "./src/nq";

##
##    The function ElementaryDivisorsMat() only returns the non-zero
##    elementary divisors of a Matrix. Here the zeroes are added in order
##    to make it easier to recognize the isomorphism type of the abelian
##    group presented by the integer matrix. At the same time strip 1's
##    from the list of elementary divisors.
##
NqElementaryDivisors := function( M )

	local	ed, i;

	ed := ElementaryDivisorsMat( M );
	ed := Concatenation(ed, List( [Length(ed)+1..Length(M[1])], x->0 ));
	i := 1;
	while i <= Length(ed) and ed[i] = 1 do i := i+1; od;
	ed := Sublist( ed, [i..Length(ed)] );

	return ed;
end;

##
##    Show the usage of the function NilpotentQuotient().
##
NqUsage := function()

    return Error("usage: NilpotentQuotient( <file>|<fin pres> [,<class>] )");

end;
	
##
##    Print a finite presentation in NQ format.
##
NqPresPrintToFile := function( file, fp )

	local	i;

	PrintTo( file, "< " );
	if Length(fp.generators) > 0 then
	    AppendTo( file, fp.generators[1] );
	fi;
	for i in [2..Length(fp.generators)] do
	    AppendTo( file, ", ", fp.generators[i] );
	od;
	AppendTo( file, " |\n    " );
	if IsBound(fp.relators) then
	    if Length(fp.relators) > 0 then
		AppendTo( file, fp.relators[1] );
	    fi;
	    for i in [2..Length(fp.relators)] do
		AppendTo( file, ",\n    ", fp.relators[i] );
	    od;
	fi;
	AppendTo( file, "\n>\n" );
end;

##
##    The interface to the NQ standalone.
##
NilpotentQuotient := function( arg )

	local	cl, cmd, name;

	if not Length(arg) in [1,2] then NqUsage(); fi;

	cl := 0;
	if Length(arg) = 2 then
	    cl := arg[2];
	    if not IsInt(cl) or cl < 1 then return NqUsage(); fi;
	fi;

	if IsRec( arg[1] ) then
	    name := "NqIn.Nq";
	    NqPresPrintToFile( name, arg[1] );
	elif IsString( arg[1] ) then
	    name := arg[1];
	else
	    return NqUsage();
	fi;

	cmd := "";
	cmd := ConcatenationString( cmd, NqLocation );
	cmd := ConcatenationString( cmd, " -g " );
	cmd := ConcatenationString( cmd, name );
	cmd := ConcatenationString( cmd, " " );
	if cl <> 0 then
	    cmd := ConcatenationString( cmd, String( cl ) );
	fi;
	cmd := ConcatenationString( cmd, " > NqOut.Nq" );
	Exec( cmd );

	Read( "NqOut.Nq" );

	return List( NqLowerCentralSeries, x->NqElementaryDivisors(x) );
end;

##
##    The following function computes left normed commutators.
##
LeftNormedComm := function( arg )

	local	c, i, l;

	if Length(arg) = 1 and IsList( arg[1] ) then
	    l := arg[1];
	else
	    l := arg;
	fi;

	c := Comm( l[1], l[2] );
	for i in [3..Length(l)] do
	    c := Comm( c, l[i] );
	od;

	return c;
end;
