/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*                  File: X_ide_token.c
 *                Author: He, Taosong
 *                  Date: 1/18/93
 *           Description: X routines for tokenizer
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 */

/******************************************************************/
/*                  VolVis include file                           */
/******************************************************************/

#include "C_volvis.h"
#include "C_ide.h"

/* Global variable: IDE_window[C_MAX_WINDOW_NUMBER]
   This variable stores the current windows of drawingareas.
   Every window has an index as its array index. 
*/

Window                          IDE_window[C_MAX_WINDOW_NUMBER];

/*
 *        Procedure Name: X_get_window_index
 *          Return Value: void
 *       Input Variables: A window  
 *      Output Variables: the index of this window in the window queue
 *      Update Variables:
 *      Global Variables: IDE_current_window_number
 *           Description: This function get the window index of a specific
 *                        window
 */

void  X_get_window_index(window, window_index)
Window window;
int    *window_index;
{
     extern    int IDE_current_window_number;
     int i;

     *window_index = -1;

     for (i=0; i<IDE_current_window_number; i++)
          {
            if (IDE_window[i] == window)
              {
                *window_index=i;
                break;
              }
          }
}

/*
 *        Procedure Name: X_assign_window_index
 *          Return Value: void
 *       Input Variables: A window 
 *      Output Variables:  
 *      Update Variables: IDE_window[IDE_current_window_number]
 *      Global Variables: IDE_window
 *                        IDE_current_window_number;
 *           Description: This function adds a window to the window queue
 */

void  X_assign_window_index(window)
Window window;
{
  extern int IDE_current_window_number;
 
  IDE_window[IDE_current_window_number] = window;
}

Window root_window;
/*
 *        Procedure Name: X_get_root_window
 *          Return Value: void
 *       Input Variables: The display name 
 *      Output Variables:
 *      Update Variables: root window 
 *      Global Variables: root_window
 *           Description: This functions can give the root window 
 */

void X_get_root_window(display)   
Display *display;
{
  root_window = DefaultRootWindow(display);
}


