/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: MOTIF_wf_setup.c
 *                Author: Hui Chen 
 *                  Date: 04/26/92
 *           Description: 
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */


# include <stdio.h>
# include <string.h>
# include <Xm/Xm.h>
# include <Xm/RowColumn.h>
# include <Xm/ToggleBG.h>
# include <Xm/ToggleB.h>
# include <Xm/BulletinB.h>
# include <Xm/DialogS.h>

#include "C_volvis.h"
#include "C_navigator.h"
#include "MOTIF_windefs.h"

/* Global Variables For Motif Windowing */
extern Widget           vv_toplevel;
extern Widget           wf_setup_bbdialog;
extern C_WindowDefs     window_defs;

C_WF_Setup      wf_param;

void wf_setup_toggle_CB();

void create_wf_setup_window()
{
 	Widget rc; 
 	Widget toggle[3];
        Arg args[20];
        XmString string;
        static char *toggle_name[3] = {"Draw Names", "Draw Axises", 
				       "Hidden Line Removal"};
        int n;

	wf_param.name = 0;
        wf_param.axis = 1;
        wf_param.hlr = 0;

 	/********************************************************/
        /* Create The Navigator Wireframe Setup Bulletin Board  */
        /********************************************************/
        n=0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
        wf_setup_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
                               "Wireframe Setup", args, n );


	n = 0;
	C_Set_Color_RowColumn( args, n, window_defs );
	rc = XmCreateRowColumn (wf_setup_bbdialog, "rc", args, n);
        XtManageChild(rc);

/*****  Create Children  **************************************************/

        n = 0;
        string = XmStringCreate (toggle_name[0], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	C_Set_Color_ToggleButton( args, n, window_defs );
        toggle[0] = XmCreateToggleButtonGadget (rc, toggle_name[0], args, n);
        XmStringFree (string);
        XtAddCallback(toggle[0], XmNvalueChangedCallback, wf_setup_toggle_CB, 0);

        n = 0;
        string = XmStringCreate (toggle_name[1], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        XtSetArg( args[n], XmNset, TRUE ); n++;
	C_Set_Color_ToggleButton( args, n, window_defs );
        toggle[1] = XmCreateToggleButtonGadget (rc, toggle_name[1], args, n);
        XmStringFree (string);
        XtAddCallback(toggle[1], XmNvalueChangedCallback, wf_setup_toggle_CB, 1);

        n = 0;
        string = XmStringCreate (toggle_name[2], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	C_Set_Color_ToggleButton( args, n, window_defs );
        toggle[2] = XmCreateToggleButtonGadget (rc, toggle_name[2], args, n);
        XmStringFree (string);
        XtAddCallback(toggle[2], XmNvalueChangedCallback, wf_setup_toggle_CB, 2);

        XtManageChildren (toggle, 3);
}



void wf_setup_toggle_CB(w, client_data, call_data)
Widget w;
int client_data;
caddr_t call_data;
{
	extern void wf_draw_all();
	extern void wf_draw_axises();
	extern void wf_draw_name();

	extern C_NavInfo	nav_info;

	switch (client_data)	
	{
	    case 0: 
		     if ( XmToggleButtonGadgetGetState(w) == 1 ) {
	   		wf_param.name = 1;
			wf_draw_name(nav_info.wf_fildes);
	   		printf("%d\n", wf_param.name);
		     }
		     else {
	   		wf_param.name = 0;
			wf_draw_all(nav_info.wf_fildes);
	   		printf("%d\n", wf_param.name);
		     }
		     break;
	    case 1: 
		     if ( XmToggleButtonGadgetGetState(w) == 1 ) {
	   		wf_param.axis = 1;
			wf_draw_axises(nav_info.wf_fildes);
	   		printf("%d\n", wf_param.axis);
		     }
		     else {
	   		wf_param.axis = 0;
			wf_draw_all(nav_info.wf_fildes);
	   		printf("%d\n", wf_param.axis);
		     }
		     break;
	    case 2: 
		     if ( XmToggleButtonGadgetGetState(w) == 1 ) {
	   		wf_param.hlr = 1;
			wf_draw_all(nav_info.wf_fildes);
	   		printf("%d\n", wf_param.hlr);
		     }
		     else {
	   		wf_param.hlr = 0;
			wf_draw_all(nav_info.wf_fildes);
	   		printf("%d\n", wf_param.hlr);
		     }
		     break;
	}
	XtUnmanageChild(wf_setup_bbdialog);
}


