/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_oco_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of The Object Properties 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <X11/StringDefs.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"
#include "C_oco.h"


/* Global Variables For Motif Windowing */
extern Widget			vv_toplevel;	/* Bulletin Board Dialog */
extern Widget			oco_bbdialog;	/* Bulletin Board Dialog */
extern C_WindowDefs		window_defs;
extern C_World			world;
extern C_View			view;
extern C_ObjectControlInfo	oco_info;


void oco_create_geo_obj_create_win()
{
	extern void	close_callback();
	extern void	help_callback();
	extern void	oco_add_sphere_to_world();
	extern void	oco_add_cone_to_world();
	extern void	oco_add_cylinder_to_world();
	extern void	oco_add_polygon_to_world();

	Arg		args[20];
	int		n;

	Widget		label;
	Widget		slider;
	Widget		oco_frame;
	Widget		oco_rowcolumn;
	Widget		oco_button;
	XmString	label_string;
	char		string[30];

	n=0;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        label_string = XmStringCreate("Create Object", 
		XmSTRING_DEFAULT_CHARSET );
	XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
        C_Set_Color_Dialog( args, n, window_defs );
        oco_info.create_geo_obj_window = 
		XmCreateBulletinBoardDialog( 
			vv_toplevel, "create", args, n );

	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	oco_frame = XmCreateFrame(oco_info.create_geo_obj_window, 
			"oco_frame", args, n );
	XtManageChild( oco_frame );

        n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 10 ); n++;
	C_Set_Color_RowColumn( args, n, window_defs );
        oco_rowcolumn = 
		XmCreateRowColumn(oco_frame, "oco_rowcolumn", args, n);
        XtManageChild (oco_rowcolumn);

	n=0;
	C_Set_Color_Button( args, n, window_defs );
	oco_button = XtCreateManagedWidget( "Create Sphere", 
		xmPushButtonWidgetClass, oco_rowcolumn, args, n );

	XtAddCallback( oco_button, XmNactivateCallback, 
		       oco_add_sphere_to_world, NULL );

	n=0;
	C_Set_Color_Button( args, n, window_defs );
	oco_button = XtCreateManagedWidget( "Create Cone", 
		xmPushButtonWidgetClass, oco_rowcolumn, args, n );

	XtAddCallback( oco_button, XmNactivateCallback, 
		       oco_add_cone_to_world, NULL );

	n=0;
	C_Set_Color_Button( args, n, window_defs );
	oco_button = XtCreateManagedWidget( "Create Cylinder", 
		xmPushButtonWidgetClass, oco_rowcolumn, args, n );

	XtAddCallback( oco_button, XmNactivateCallback, 
		       oco_add_cylinder_to_world, NULL );

	n=0;
	C_Set_Color_Button( args, n, window_defs );
	oco_button = XtCreateManagedWidget( "Create Polygon", 
		xmPushButtonWidgetClass, oco_rowcolumn, args, n );

	XtAddCallback( oco_button, XmNactivateCallback, 
		       oco_add_polygon_to_world, NULL );

	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 200 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	oco_frame = XmCreateFrame(oco_info.create_geo_obj_window, 
			"oco_frame", args, n );
	XtManageChild( oco_frame );

        n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	XtSetArg( args[n], XmNx, 10 ); n++;
	XtSetArg( args[n], XmNy, 10 ); n++;
	C_Set_Color_RowColumn( args, n, window_defs );
        oco_rowcolumn = 
		XmCreateRowColumn(oco_frame, "oco_rowcolumn", args, n);
        XtManageChild (oco_rowcolumn);

	n=0;
	C_Set_Color_Button( args, n, window_defs );
	oco_button = XtCreateManagedWidget( "Close", 
		xmPushButtonWidgetClass, oco_rowcolumn, args, n );
	XtAddCallback( oco_button, XmNactivateCallback,
		       close_callback, oco_info.create_geo_obj_window);

	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	oco_button = XtCreateManagedWidget("Help", 
			xmPushButtonWidgetClass, oco_rowcolumn, args, n );
	XtAddCallback( oco_button, XmNactivateCallback,
		       help_callback, C_OCO_CREATE_GEO_HELP );

	XtManageChild( oco_info.create_geo_obj_window );
}

void oco_add_sphere_to_world( w, client_data, call_data )
Widget			w;
XtPointer		client_data;
XtPointer		call_data;
{
	extern int	C_add_sphere_to_world();
	extern void	nav_update();

	C_message("Adding a sphere to the world\n");

	C_add_sphere_to_world();

	nav_update();
}

void oco_add_cone_to_world( w, client_data, call_data )
Widget			w;
XtPointer		client_data;
XtPointer		call_data;
{
	extern void	nav_update();

	C_message("Adding a cone to the world = Not Yet Implemented\n");

	nav_update();
}

void oco_add_cylinder_to_world( w, client_data, call_data )
Widget			w;
XtPointer		client_data;
XtPointer		call_data;
{
	extern int	C_add_cylinder_to_world();
	extern void	nav_update();

	C_message("Adding a cylinder to the world\n");

	C_add_cylinder_to_world();

	nav_update();
}

void oco_add_polygon_to_world( w, client_data, call_data )
Widget			w;
XtPointer		client_data;
XtPointer		call_data;
{
	extern int	C_add_polygon_to_world();
	extern void	nav_update();

	C_message("Adding a polygon to the world\n");

	C_add_polygon_to_world();

	nav_update();
}

