/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *                  File: MOTIF_mea_ui.c
 *                Author: Hui Chen 
 *                  Date: 04/26/92
 *           Description: Motif Windowing Routines Of VolVis 
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */


# include <stdio.h>
# include <string.h>
# include <X11/Intrinsic.h>
# include <X11/Shell.h>
# include <X11/Xlib.h>
# include <X11/Xutil.h>
# include <Xm/Xm.h>
# include <Xm/RowColumn.h>
# include <Xm/Frame.h>
# include <Xm/LabelG.h>
# include <Xm/ToggleBG.h>
# include <Xm/ToggleB.h>
# include <Xm/Text.h>
# include <Xm/PushB.h>
# include <Xm/PushBG.h>
# include <Xm/BulletinB.h>
# include <Xm/DialogS.h>

#include "C_volvis.h"
#include "C_measure.h"
#include "MOTIF_windefs.h"
#include "C_help.h"

/* Global Variables For Motif Windowing */
extern Widget           vv_toplevel;
extern Widget           mea_bbdialog;
extern C_WindowDefs     window_defs;

C_MeaInfo	mea_info;
C_SeedPoint	seed_point;

void output_mea_result();
void update_mea_result();
void invalid_seed();

/* 13 buttons in the "Measure" radiobox */ 
static Widget measure[13];

void create_mea_window()
{
	/***    External Routines  ***/
        extern void     close_callback();
        extern void     help_callback();

	/***    Internal Routines  ***/
	void mea_tool_CB();
	void mea_volume_CB();
	void mea_accept_CB();
	void mea_volume_menu();
	void mea_seed_input();

	/***    Local Variables     ***/
	Widget label, frame[2], radiobox;
	Widget rc;
        Widget accept;
	Widget cancel;
        Widget help;
        XmString string;
        Arg             args[30];       /* Argument List */
        int             n;              /* Argument Count */

	static char *menu_name[3] = {"Accept", "Close", "Help"};


	n=0;
        XtSetArg( args[n], XmNx, 0 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        C_Set_Color_Dialog( args, n, window_defs );
        mea_bbdialog = XmCreateBulletinBoardDialog( vv_toplevel,
                              "Measurements", args, n );

	n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 15 ); n++;
        label = XmCreateLabelGadget(mea_bbdialog, "Measure:", 
					args, n);
        XtManageChild(label);

/***** the frame *****/

        n = 0;
        XtSetArg (args[n], XmNshadowType, XmSHADOW_ETCHED_IN);  n++;
        XtSetArg (args[n], XmNx, 85);  n++;
        XtSetArg (args[n], XmNy, 10);  n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame[0] = XmCreateFrame (mea_bbdialog, "frame", args, n);
        XtManageChild (frame[0]);

/***** the frame encloses a RadioBox *****/

        n = 0;
/*
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
*/
        C_Set_Color_RadioBox( args, n, window_defs );
        radiobox = XmCreateRadioBox (frame[0], "radiobox", args, n);
        XtManageChild (radiobox);

/*****  Create Children  **************************************************/

        n = 0;
        string = XmStringCreate ("Surface/Voxel: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[0] = XtCreateWidget ("SurfaceV", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XmStringFree (string);
	XtManageChild( measure[0] );
        XtAddCallback (measure[0], XmNvalueChangedCallback, mea_tool_CB, 0);

        n = 0;
        string = XmStringCreate ("Surface/Cell: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[1] = XtCreateWidget ("SurfaceC", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XmStringFree (string);
	XtManageChild( measure[1] );
        XtAddCallback (measure[1], XmNvalueChangedCallback, mea_tool_CB, 1);

/****
        n = 0;
        string = XmStringCreate ("Surface/Small: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[2] = XtCreateWidget ("SurfaceA", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[2], XmNvalueChangedCallback, mea_tool_CB, 2);
***/

        n = 0;
        string = XmStringCreate ("Volume/Voxel: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[3] = XtCreateWidget ("VolumeV", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XmStringFree (string);
	XtManageChild( measure[3] );
        XtAddCallback (measure[3], XmNvalueChangedCallback, mea_tool_CB, 3);

        n = 0;
        string = XmStringCreate ("Volume/Cell: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[4] = XtCreateWidget ("VolumeC", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XmStringFree (string);
	XtManageChild( measure[4] );
        XtAddCallback (measure[4], XmNvalueChangedCallback, mea_tool_CB, 4);

/***
        n = 0;
        string = XmStringCreate ("Volume/Small: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[5] = XtCreateWidget ("VolumeA", xmToggleButtonWidgetClass,
                                    radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[5], XmNvalueChangedCallback, mea_tool_CB, 5);

        n = 0;
        string = XmStringCreate ("Surface/Voxel/Seed: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[6] = XtCreateWidget ("SurfaceV/Seed", 
			xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[6], XmNvalueChangedCallback, mea_tool_CB, 6);

        n = 0;
        string = XmStringCreate ("Surface/Cell/Seed: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[7] = XtCreateWidget ("SurfaceC/Seed", 
			xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[7], XmNvalueChangedCallback, mea_tool_CB, 7);

        n = 0;
        string = XmStringCreate ("Surface/Small/Seed: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[8] = XtCreateWidget ("SurfaceA/Seed", 
			xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[8], XmNvalueChangedCallback, mea_tool_CB, 8);

        n = 0;
        string = XmStringCreate ("Volume/Voxel/Seed: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[9] = XtCreateWidget ("VolumeV/Seed", 
			xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[9], XmNvalueChangedCallback, mea_tool_CB, 9);

        n = 0;
        string = XmStringCreate ("Volume/Cell/Seed: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[10] = XtCreateWidget ("VolumeC/Seed", 
			xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[10], XmNvalueChangedCallback, mea_tool_CB, 10);

        n = 0;
        string = XmStringCreate ("Volume/Small/Seed: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[11] = XtCreateWidget ("VolumeA/Seed", 
			xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[11], XmNvalueChangedCallback, mea_tool_CB, 11);

        n = 0;
        string = XmStringCreate ("Distance: ", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_ToggleButton( args, n, window_defs );
        measure[12] = XtCreateWidget ("Distance", 
			xmToggleButtonWidgetClass, radiobox, args, n);
        XmStringFree (string);
        XtAddCallback (measure[12], XmNvalueChangedCallback, mea_tool_CB, 12);

	n = 0;
        XtSetArg( args[n], XmNset, TRUE ); n++;
        XtSetValues (measure[mea_info.mea_tool], args, n);

	XtManageChildren (measure, 13);
***/

/***** Create a option menu for volume selection *****/
	mea_volume_menu();

/***** Create menu buttons *****************************/
        n = 0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 300 ); n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame[2] = XmCreateFrame (mea_bbdialog, "frame", args, n);
        XtManageChild (frame[2]);

        n = 0;
/*
        XtSetArg( args[n], XmNspacing, 130 ); n++;
*/
        XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        rc = XmCreateRowColumn (frame[2], "rc", args, n);
        XtManageChild(rc);

        n = 0;
        C_Set_Color_Button( args, n, window_defs );
        accept = XmCreatePushButton(rc, menu_name[0], args, n);
        XtManageChild(accept);
        XtAddCallback(accept, XmNactivateCallback, mea_accept_CB, 0);

	cancel = XmCreatePushButton(rc, menu_name[1], args, n);
        XtManageChild(cancel);
        XtAddCallback(cancel, XmNactivateCallback, 
			close_callback, mea_bbdialog);

        help = XmCreatePushButton(rc, menu_name[2], args, n);
        XtManageChild(help);
        XtAddCallback(help, XmNhelpCallback, help_callback, mea_bbdialog);
        XtAddCallback(help, XmNactivateCallback, 
			help_callback, C_MEA_HELP);

/********* Create a seed point display area ***********/
/***
	mea_seed_input();
***/
}

static char *seed_found = "Push middle button in navigator window to selsect a seed.";
static char *seed_not_found = "Seed not found. Push middle button in navigator window to selsect a seed.";
static Widget seed_msg;
static Widget text[3];
void mea_seed_input()
{
        Widget label;
	Widget frame;
	Widget bb;
        Widget other_label[3];
        Arg args[20];
        XmString string;
        static char *other_name[3] = {"X:", "Y:", "Z:"};

        int n;

/***** the label *****/
        n = 0;
        XtSetArg (args[n], XmNx, 20);  n++;
        XtSetArg (args[n], XmNy, 500);  n++;
        XtSetArg( args[n], XmNheight, 40 ); n++;
        string = XmStringCreate ("Seed:", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        label = XmCreateLabel (mea_bbdialog, "Seed:", args, n);
        XmStringFree (string);

        XtManageChild (label);

/***** the frame *****/

        n = 0;
        XtSetArg (args[n], XmNx, 85);  n++;
        XtSetArg (args[n], XmNy, 220);  n++;
        C_Set_Color_Frame( args, n, window_defs );
        frame = XmCreateFrame (mea_bbdialog, "frame", args, n);
        XtManageChild (frame);

/***** the frame encloses a bulletin board *****/

        n = 0;
        C_Set_Color_Bboard( args, n, window_defs );
        bb = XmCreateBulletinBoard (frame, "bb", args, n);
        XtManageChild (bb);

/*****  Create Children  **************************************************/

        n = 0;
        XtSetArg (args[n], XmNx, 5);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        string = XmStringCreate (other_name[0], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        other_label[0] = XmCreateLabel (bb, other_name[0], args, n);
        XmStringFree (string);

        n  = 0;
        XtSetArg (args[n], XmNx, 30);  n++;
        XtSetArg( args[n], XmNwidth, 60 ); n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        C_Set_Color_Text( args, n, window_defs );
        text[0] = XmCreateText (bb, "x", args, n);

        n = 0;
        XtSetArg (args[n], XmNx, 95);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        string = XmStringCreate (other_name[1], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        other_label[1] = XmCreateLabel (bb, other_name[1], args, n);
        XmStringFree (string);

        n  = 0;
        XtSetArg (args[n], XmNx, 115);  n++;
        XtSetArg( args[n], XmNwidth, 60 ); n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        C_Set_Color_Text( args, n, window_defs );
        text[1] = XmCreateText (bb, "y", args, n);

        n = 0;
        XtSetArg (args[n], XmNx, 180);  n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        string = XmStringCreate (other_name[2], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        other_label[2] = XmCreateLabel (bb, other_name[2], args, n);
        XmStringFree (string);

        n  = 0;
        XtSetArg (args[n], XmNx, 200);  n++;
        XtSetArg( args[n], XmNwidth, 60 ); n++;
        XtSetArg( args[n], XmNheight, 35 ); n++;
        C_Set_Color_Text( args, n, window_defs );
        text[2] = XmCreateText (bb, "z", args, n);

        XtManageChildren (other_label, 3);
        XtManageChildren (text, 3);

/***** the msg label *****/
        n = 0;
        XtSetArg (args[n], XmNx, 20);  n++;
        XtSetArg (args[n], XmNy, 550);  n++;
        XtSetArg( args[n], XmNheight, 40 ); n++;
        string = XmStringCreate (seed_found, XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        C_Set_Color_Label( args, n, window_defs );
        seed_msg = XmCreateLabel (mea_bbdialog, "s_msg", args, n);
        XmStringFree (string);
        XtManageChild (seed_msg);
}


/* Create a volume option pulldown manu */ 
void mea_volume_menu()
{
	extern C_World  world;
	void mea_volume_CB();

	Widget mea_rc;
        Arg args[10];
        XmString string;
	int n;
        int i;

        n = 0;
        XtSetArg (args[n], XmNx, 15);  n++;
        XtSetArg (args[n], XmNy, 200);  n++;
        C_Set_Color_RowColumn( args, n, window_defs );
        mea_rc = XmCreateRowColumn(mea_bbdialog, "rc", args, n);
        XtManageChild (mea_rc);

	n = 0;
        C_Set_Color_PullDown( args, n, window_defs );
        mea_info.pulldown = XmCreatePulldownMenu(mea_rc, "pulldown", args, n);

	for (i=0; i<C_MAX_VOLUMES; i++)
        {
		mea_info.options[i] = NULL;
	}

	for (i=0; i<world.num_volumes; i++)
        {
	  if ( world.volume[i]->data_type == C_SCALAR_DATA_8BIT )
	  {
            n = 0;
            string = XmStringCreate (world.volume[i]->volume_name,
                                        XmSTRING_DEFAULT_CHARSET);
            XtSetArg (args[n], XmNlabelString, string); n++;
            mea_info.options[i] = XmCreatePushButtonGadget(mea_info.pulldown,
                                   world.volume[i]->volume_name, args, n);
            XmStringFree (string);
            XtAddCallback (mea_info.options[i], XmNactivateCallback,
                           mea_volume_CB, i);
	  }
        }
	for ( i = world.num_volumes; i < C_MAX_VOLUMES; i++ )
		mea_info.options[i] = NULL;

	XtManageChildren (mea_info.options, world.num_volumes);

/***** Create a option menu and attach the pulldown menu *************/

        n = 0;
        string = XmStringCreate ("Volume:", XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
        XtSetArg (args[n], XmNsubMenuId, mea_info.pulldown); n++;
        XtSetArg (args[n], XmNmenuHistory, 
			mea_info.options[mea_info.mea_volume]); n++;
        C_Set_Color_OptionMenu( args, n, window_defs );
        mea_info.option_menu = XmCreateOptionMenu(mea_rc, "option_menu", 
							args, n);

        XtManageChild(mea_info.option_menu);
}

void update_mea_volume_opt()
{
	extern C_World	world;
	void		mea_volume_CB();
	Arg             args[10];       /* Argument List */
        int             n;              /* Argument Count */
        XmString        string;
        int             i;

	if ( mea_bbdialog )
	{
	  for (i=0; i<C_MAX_VOLUMES; i++) 
	  {
		    XtDestroyWidget( mea_info.options[i] );
		    mea_info.options[i] = NULL;
	  }
	}
	if ( mea_bbdialog ) 
	{
	    for (i=0; i<world.num_volumes; i++)
            {
	      if ( world.volume[i]->data_type == C_SCALAR_DATA_8BIT )
	      {
                n = 0;
                string = XmStringCreate (world.volume[i]->volume_name,
                                        XmSTRING_DEFAULT_CHARSET);
                XtSetArg (args[n], XmNlabelString, string); n++;
                mea_info.options[i] = XmCreatePushButtonGadget(
		     mea_info.pulldown, world.volume[i]->volume_name, args, n);
                XmStringFree (string);
                XtManageChild( mea_info.options[i] );
                XtAddCallback (mea_info.options[i], XmNactivateCallback,
                               mea_volume_CB, i);
	      }
            }
	    n = 0;
	    if (mea_info.mea_volume > world.num_volumes )
	     	mea_info.mea_volume = 0;

	    XtSetArg( args[n], XmNmenuHistory,
			 mea_info.options[mea_info.mea_volume]); n++;
            XtSetArg (args[n], XmNsubMenuId, mea_info.pulldown); n++;
	    XtSetValues( mea_info.option_menu, args, n );
	}
}


void mea_tool_CB(w, client_data, call_data)
Widget          w;
int             client_data;
caddr_t         call_data;
{
	extern C_World	world;

	switch (client_data) {
	case 0 :
		mea_info.mea_tool = C_SURFACE;
		mea_info.mea_method = C_VOXEL_METHOD;
		break;
	case 1 :
		mea_info.mea_tool = C_SURFACE;
		mea_info.mea_method = C_CELL_METHOD;
		break;
	case 2 :
		mea_info.mea_tool = C_SURFACE;
		mea_info.mea_method = C_ANALY_METHOD;
		mea_info.steps = 200;
		break;
	case 3 :
		mea_info.mea_tool = C_VOLUME;
		mea_info.mea_method = C_VOXEL_METHOD;
		break;
	case 4 :
		mea_info.mea_tool = C_VOLUME;
		mea_info.mea_method = C_CELL_METHOD;
		break;
	case 5 :
		mea_info.mea_tool = C_VOLUME;
		mea_info.mea_method = C_ANALY_METHOD;
		mea_info.steps = 200;
		break;
	case 6 :
		mea_info.mea_tool = C_SURFACE_SEED;
		mea_info.mea_method = C_VOXEL_METHOD;
		break;
	case 7 :
		mea_info.mea_tool = C_SURFACE_SEED;
		mea_info.mea_method = C_CELL_METHOD;
		break;
	case 8 :
		mea_info.mea_tool = C_SURFACE_SEED;
		mea_info.mea_method = C_ANALY_METHOD;
		mea_info.steps = 200;
		break;
	case 9 :
		mea_info.mea_tool = C_VOLUME_SEED;
		mea_info.mea_method = C_VOXEL_METHOD;
		break;
	case 10 :
		mea_info.mea_tool = C_VOLUME_SEED;
		mea_info.mea_method = C_CELL_METHOD;
		break;
	case 11 :
		mea_info.mea_tool = C_VOLUME_SEED;
		mea_info.mea_method = C_ANALY_METHOD;
		mea_info.steps = 200;
		break;
	case 12 :
		mea_info.mea_tool = C_DISTANCE;
		break;
	}
}

void mea_volume_CB(w, client_data, call_data)
Widget          w;
int             client_data;
caddr_t         call_data;
{
	extern C_World	world;

	if (mea_info.mea_volume != client_data) {
		mea_info.mea_volume = client_data;
		update_mea_result();
	}
}

void mea_accept_CB (w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	extern void mea_main();
	C_SeedPoint mea_get_typein_seed();

	extern C_World	world;

	if ((mea_info.mea_tool == C_SURFACE_SEED) ||
	    (mea_info.mea_tool == C_VOLUME_SEED)) {
		if (seed_point.flag == C_MEA_VALID) {
			mea_info.seed1 = mea_get_typein_seed(mea_info.seed1);
        		mea_main();
		}
		else {
			C_error_message("Invalid seed point!!!\n");
		}
	}
	else {
		if (!(world.volume[mea_info.mea_volume]->mea_values[mea_info.mea_tool][mea_info.mea_method].flag == C_MEA_VALID)) {
        		mea_main();
		}
	}
}


int mea_seed_x()
{
        char    *string;
        int   x;

        string = (char *)XmTextGetString( text[0] );
        sscanf( string, "%d", &x );
        return(x);
}

int mea_seed_y()
{
        char    *string;
        int   y;

        string = (char *)XmTextGetString( text[1] );
        sscanf( string, "%d", &y );
        return(y);
}

int mea_seed_z()
{
        char    *string;
        int   z;

        string = (char *)XmTextGetString( text[2] );
        sscanf( string, "%d", &z );
        return(z);
}

C_SeedPoint mea_get_typein_seed(seedpoint)
C_SeedPoint seedpoint;
{
	seedpoint.flag = C_MEA_VALID;
	seedpoint.volume_index = mea_info.mea_volume;
	seedpoint.seed.x = mea_seed_x();
	seedpoint.seed.y = mea_seed_y();
	seedpoint.seed.z = mea_seed_z();
	return(seedpoint);
}

void mea_display_seed()
{
	char temp[5];
        Arg             args[20];       /* Argument List */
        int             n;              /* Argument Count */

	if (seed_point.flag == C_MEA_VALID) {
		mea_info.seed2 = mea_get_typein_seed(mea_info.seed2);
	}
	else {
		seed_point.flag = C_MEA_VALID;
		
	}
	mea_info.mea_volume = seed_point.volume_index;
        n  = 0;
        XtSetArg (args[n], XmNmenuHistory, 
		mea_info.options[mea_info.mea_volume]); n++;
	XtSetValues( mea_info.option_menu, args, n );
	update_mea_result();

	sprintf(temp, "%d", seed_point.seed.x);
        n  = 0;
        XtSetArg( args[n], XmNvalue, temp ); n++;
	XtSetValues( text[0], args, n );

	sprintf(temp, "%d", seed_point.seed.y);
        n  = 0;
        XtSetArg( args[n], XmNvalue, temp ); n++;
	XtSetValues( text[1], args, n );

	sprintf(temp, "%d", seed_point.seed.z);
        n  = 0;
        XtSetArg( args[n], XmNvalue, temp ); n++;
	XtSetValues( text[2], args, n );
}

static char *blank = "";

static char *unit[5] = {"m", "mm", "microns", "ft", "in"};
static char *tool[13] = {"Surface/Voxel: ", "Surface/Cell: ", "Surface/Small: ",
		 	 "Volume/Voxel: ", "Volume/Cell: ", "Volume/Small: ",
	"Surface/Voxel/Seed: ", "Surface/Cell/Seed: ", "Surface/Small/Seed: ",
	"Volume/Voxel/Seed: ", "Volume/Cell/Seed: ", "Volume/Small/Seed: ",
			"Distance: "};

void output_mea_result(value1, value2)
float value1;
int value2;
{
	extern C_World	world;
	char	temp1[80];
	char	temp2[80];
        XmString string;
        Arg             args[20];       /* Argument List */
        int             n;              /* Argument Count */

	if ((mea_info.mea_tool == C_SURFACE) && 
	    (mea_info.mea_method == C_VOXEL_METHOD)) {
		sprintf(temp1, "%s%.2f %s^2", tool[0], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
		sprintf(temp2, "   %d voxels^2", value2);
		strcat(temp1, temp2);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[0], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_SURFACE) && 
	    (mea_info.mea_method == C_CELL_METHOD)) {
		sprintf(temp1, "%s%.2f %s^2", tool[1], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[1], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_SURFACE) && 
	    (mea_info.mea_method == C_ANALY_METHOD)) {
		sprintf(temp1, "%s%.2f %s^2", tool[2], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[2], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_VOLUME) && 
	    (mea_info.mea_method == C_VOXEL_METHOD)) {
		sprintf(temp1, "%s%.2f %s^3", tool[3], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
		sprintf(temp2, "   %d voxels^3", value2);
		strcat(temp1, temp2);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[3], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_VOLUME) && 
	    (mea_info.mea_method == C_CELL_METHOD)) {
		sprintf(temp1, "%s%.2f %s^3", tool[4], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[4], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_VOLUME) && 
	    (mea_info.mea_method == C_ANALY_METHOD)) {
		sprintf(temp1, "%s%.2f %s^3", tool[5], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[5], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_SURFACE_SEED) && 
	    (mea_info.mea_method == C_VOXEL_METHOD)) {
		sprintf(temp1, "%s%.2f %s^2", tool[6], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
		sprintf(temp2, "   %d voxels^2", value2);
		strcat(temp1, temp2);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[6], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_SURFACE_SEED) && 
	    (mea_info.mea_method == C_CELL_METHOD)) {
		sprintf(temp1, "%s%.2f %s^2", tool[7], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[7], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_SURFACE_SEED) && 
	    (mea_info.mea_method == C_ANALY_METHOD)) {
		sprintf(temp1, "%s%.2f %s^2", tool[8], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[8], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_VOLUME_SEED) && 
	    (mea_info.mea_method == C_VOXEL_METHOD)) {
		sprintf(temp1, "%s%.2f %s^3", tool[9], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
		sprintf(temp2, "   %d voxels^3", value2);
		strcat(temp1, temp2);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[9], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_VOLUME_SEED) && 
	    (mea_info.mea_method == C_CELL_METHOD)) {
		sprintf(temp1, "%s%.2f %s^3", tool[10], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[10], args, n );
        	XmStringFree (string);
	}
	if ((mea_info.mea_tool == C_VOLUME_SEED) && 
	    (mea_info.mea_method == C_ANALY_METHOD)) {
		sprintf(temp1, "%s%.2f %s^3", tool[11], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[11], args, n );
        	XmStringFree (string);
	}
	C_message(temp1);
	C_message("\n");
}

void output_mea_distance(value1)
float value1;
{
	char	temp1[80];
        XmString string;
        Arg             args[20];       /* Argument List */
        int             n;              /* Argument Count */

	sprintf(temp1, "%s%.2f", tool[12], value1);
       	n = 0;
       	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
       	XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( measure[12], args, n );
        XmStringFree (string);
	C_message(temp1);
	C_message("\n");

        n = 0;
        string = XmStringCreate (seed_found, XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNy, 550);  n++;
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( seed_msg, args, n );
        XmStringFree (string);
}


void update_mea_result()
{
	extern C_World	world;
	float value1;
	int value2;
	char	temp1[80];
	char	temp2[80];
        XmString string;
        Arg             args[20];       /* Argument List */
        int             n;              /* Argument Count */

	if (world.volume[mea_info.mea_volume]->mea_values[0][0].flag == C_MEA_VALID) {
		value1 = world.volume[mea_info.mea_volume]->mea_values[0][0].value_units;
		value2 = world.volume[mea_info.mea_volume]->mea_values[0][0].value_voxels; 
		sprintf(temp1, "%s%.2f %s^2", tool[0], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
		sprintf(temp2, "   %d voxels^2", value2);
		strcat(temp1, temp2);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[0], args, n );
        	XmStringFree (string);
	}
	else {
        	n = 0;
        	string = XmStringCreate (tool[0], XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[0], args, n );
        	XmStringFree (string);
	}
	if (world.volume[mea_info.mea_volume]->mea_values[0][1].flag == C_MEA_VALID) {
		value1 = world.volume[mea_info.mea_volume]->mea_values[0][1].value_units;
		sprintf(temp1, "%s%.2f %s^2", tool[1], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[1], args, n );
        	XmStringFree (string);
	}
	else {
        	n = 0;
        	string = XmStringCreate (tool[1], XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[1], args, n );
        	XmStringFree (string);
	}
/****
	if (world.volume[mea_info.mea_volume]->mea_values[0][2].flag == C_MEA_VALID) {
		value1 = world.volume[mea_info.mea_volume]->mea_values[0][2].value_units;
		sprintf(temp1, "%s%.2f %s^2", tool[2], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[2], args, n );
        	XmStringFree (string);
	}
	else {
        	n = 0;
        	string = XmStringCreate (tool[2], XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[2], args, n );
        	XmStringFree (string);
	}
*****/
	if (world.volume[mea_info.mea_volume]->mea_values[1][0].flag == C_MEA_VALID) {
		value1 = world.volume[mea_info.mea_volume]->mea_values[1][0].value_units;
		value2 = world.volume[mea_info.mea_volume]->mea_values[1][0].value_voxels; 
		sprintf(temp1, "%s%.2f %s^3", tool[3], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
		sprintf(temp2, "   %d voxels^3", value2);
		strcat(temp1, temp2);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[3], args, n );
        	XmStringFree (string);
	}
	else {
        	n = 0;
        	string = XmStringCreate (tool[3], XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[3], args, n );
        	XmStringFree (string);
	}
	if (world.volume[mea_info.mea_volume]->mea_values[1][1].flag == C_MEA_VALID) {
		value1 = world.volume[mea_info.mea_volume]->mea_values[1][1].value_units;
		sprintf(temp1, "%s%.2f %s^3", tool[4], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[4], args, n );
        	XmStringFree (string);
	}
	else {
        	n = 0;
        	string = XmStringCreate (tool[4], XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[4], args, n );
        	XmStringFree (string);
	}
/****
	if (world.volume[mea_info.mea_volume]->mea_values[1][2].flag == C_MEA_VALID) {
		value1 = world.volume[mea_info.mea_volume]->mea_values[1][2].value_units;
		sprintf(temp1, "%s%.2f %s^3", tool[5], value1, unit[world.volume[mea_info.mea_volume]->unit_type]);
        	n = 0;
        	string = XmStringCreate (temp1, XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[5], args, n );
        	XmStringFree (string);
	}
	else {
        	n = 0;
        	string = XmStringCreate (tool[5], XmSTRING_DEFAULT_CHARSET);
        	XtSetArg (args[n], XmNlabelString, string); n++;
		XtSetValues( measure[5], args, n );
        	XmStringFree (string);
	}
        n = 0;
        string = XmStringCreate (tool[6], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( measure[6], args, n );
        XmStringFree (string);
        n = 0;
        string = XmStringCreate (tool[7], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( measure[7], args, n );
        XmStringFree (string);
        n = 0;
        string = XmStringCreate (tool[8], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( measure[8], args, n );
        XmStringFree (string);
        n = 0;
        string = XmStringCreate (tool[9], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( measure[9], args, n );
        XmStringFree (string);
        n = 0;
        string = XmStringCreate (tool[10], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( measure[10], args, n );
        XmStringFree (string);
        n = 0;
        string = XmStringCreate (tool[11], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( measure[11], args, n );
        XmStringFree (string);
        n = 0;
        string = XmStringCreate (tool[12], XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( measure[12], args, n );
        XmStringFree (string);
****/
}

void invalid_seed()
{
        XmString string;
        Arg             args[20];       /* Argument List */
        int             n;              /* Argument Count */

	update_mea_result();

	seed_point.flag = C_MEA_INVALID;

        n  = 0;
        XtSetArg( args[n], XmNvalue, blank ); n++;
	XtSetValues( text[0], args, n );

        n  = 0;
        XtSetArg( args[n], XmNvalue, blank ); n++;
	XtSetValues( text[1], args, n );

        n  = 0;
        XtSetArg( args[n], XmNvalue, blank ); n++;
	XtSetValues( text[2], args, n );

        n = 0;
        string = XmStringCreate (seed_not_found, XmSTRING_DEFAULT_CHARSET);
        XtSetArg (args[n], XmNy, 550);  n++;
        XtSetArg (args[n], XmNlabelString, string); n++;
	XtSetValues( seed_msg, args, n );
        XmStringFree (string);
}
