/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *		File:  C_mea_rotate.c
 *	      Author:  Hui Chen
 *		Date:  Dec. 7, 1991
 * 	 Description:  This file contains the routine: rotate_cube(),
 *		       which rotates each cube(cell) to one of the 
 *		       stardard patterns.
 *		       This routine is device-independent.
 * Modification History:
 * 
 *	who?		when?		why?
 * -----------------------------------------------
 *
 */

#include "C_volvis.h"
#include "C_measure.h"

/****************************************/
/*					
/*	Procedure Name:  rotate_cube
/*	  Return Value:  none
/*     Input Variables:  int rotate_case  /*indicating which rotation to take*/
/*			 C_Voxel_8bit *o1, *o2, *o3, *o4, *o5, *o6, *o7, *o8
/*			         /* these are the original pointers to the 
/*				    eight vertices of the cell(cube)         */
/*    Output Variables:  none
/*    Update Variables:  none
/*    Global Variables:  C_Mea_Vertices		mea_vertices 
/*			         /* these are the pointers to the eight
/*				    vertices of the rotated cell(cube)       */
/*     	   Description:  This routine rotates each cell in the way according
/*			 to the rotating case indicated by the value of 
/*			 input variable, rotate_case, by renaming the vertices
/*			 of the cell to the global variables to achieve the
/*			 rotating effect. 
/* 			 The detail of each rotating case is described in the
/*			 project report.
 */


C_Mea_Vertices         mea_vertices;

void rotate_cube(rotate_case,o1,o2,o3,o4,o5,o6,o7,o8)
int rotate_case;
C_Voxel_8bit *o1, *o2, *o3, *o4, *o5, *o6, *o7, *o8; 
{
	switch(rotate_case) { 
		case 0:
			mea_vertices.v1 = o1;
			mea_vertices.v2 = o2;
			mea_vertices.v3 = o3;
			mea_vertices.v4 = o4;
			mea_vertices.v5 = o5;
			mea_vertices.v6 = o6;
			mea_vertices.v7 = o7;
			mea_vertices.v8 = o8;
			break;
		case 1:
			mea_vertices.v1 = o2;
			mea_vertices.v2 = o6;
			mea_vertices.v3 = o7;
			mea_vertices.v4 = o3;
			mea_vertices.v5 = o1;
			mea_vertices.v6 = o5;
			mea_vertices.v7 = o8;
			mea_vertices.v8 = o4;
			break;
		case 2:
			mea_vertices.v1 = o3;
			mea_vertices.v2 = o2;
			mea_vertices.v3 = o6;
			mea_vertices.v4 = o7;
			mea_vertices.v5 = o4;
			mea_vertices.v6 = o1;
			mea_vertices.v7 = o5;
			mea_vertices.v8 = o8;
			break;
		case 3:
			mea_vertices.v1 = o4;
			mea_vertices.v2 = o3;
			mea_vertices.v3 = o7;
			mea_vertices.v4 = o8;
			mea_vertices.v5 = o1;
			mea_vertices.v6 = o2;
			mea_vertices.v7 = o6;
			mea_vertices.v8 = o5;
			break;
		case 4:
			mea_vertices.v1 = o5;
			mea_vertices.v2 = o1;
			mea_vertices.v3 = o4;
			mea_vertices.v4 = o8;
			mea_vertices.v5 = o6;
			mea_vertices.v6 = o2;
			mea_vertices.v7 = o3;
			mea_vertices.v8 = o7;
			break;
		case 5:
			mea_vertices.v1 = o6;
			mea_vertices.v2 = o5;
			mea_vertices.v3 = o8;
			mea_vertices.v4 = o7;
			mea_vertices.v5 = o2;
			mea_vertices.v6 = o1;
			mea_vertices.v7 = o4;
			mea_vertices.v8 = o3;
			break;
		case 6:
			mea_vertices.v1 = o7;
			mea_vertices.v2 = o8;
			mea_vertices.v3 = o4;
			mea_vertices.v4 = o3;
			mea_vertices.v5 = o6;
			mea_vertices.v6 = o5;
			mea_vertices.v7 = o1;
			mea_vertices.v8 = o2;
			break;
		case 7:
			mea_vertices.v1 = o8;
			mea_vertices.v2 = o7;
			mea_vertices.v3 = o6;
			mea_vertices.v4 = o5;
			mea_vertices.v5 = o4;
			mea_vertices.v6 = o3;
			mea_vertices.v7 = o2;
			mea_vertices.v8 = o1;
			break;
		case 8:
			mea_vertices.v1 = o4;
			mea_vertices.v2 = o1;
			mea_vertices.v3 = o2;
			mea_vertices.v4 = o3;
			mea_vertices.v5 = o8; 
			mea_vertices.v6 = o5;
			mea_vertices.v7 = o6;
			mea_vertices.v8 = o7;
			break;
		case 9:
			mea_vertices.v1 = o1;
			mea_vertices.v2 = o5;
			mea_vertices.v3 = o6;
			mea_vertices.v4 = o2;
			mea_vertices.v5 = o4;
			mea_vertices.v6 = o8;
			mea_vertices.v7 = o7;
			mea_vertices.v8 = o3;
			break;
		case 10:
			mea_vertices.v1 = o1;
			mea_vertices.v2 = o4;
			mea_vertices.v3 = o8;
			mea_vertices.v4 = o5;
			mea_vertices.v5 = o2;
			mea_vertices.v6 = o3;
			mea_vertices.v7 = o7;
			mea_vertices.v8 = o6;
			break;
		case 11:
			mea_vertices.v1 = o5;
			mea_vertices.v2 = o6;
			mea_vertices.v3 = o2;
			mea_vertices.v4 = o1;
			mea_vertices.v5 = o8;
			mea_vertices.v6 = o7;
			mea_vertices.v7 = o3;
			mea_vertices.v8 = o4;
			break;
		case 12:
			mea_vertices.v1 = o3;
			mea_vertices.v2 = o7;
			mea_vertices.v3 = o8;
			mea_vertices.v4 = o4;
			mea_vertices.v5 = o2;
			mea_vertices.v6 = o6;
			mea_vertices.v7 = o5;
			mea_vertices.v8 = o1;
			break;
		case 13:
			mea_vertices.v1 = o8;
			mea_vertices.v2 = o4;
			mea_vertices.v3 = o3;
			mea_vertices.v4 = o7;
			mea_vertices.v5 = o5;
			mea_vertices.v6 = o1;
			mea_vertices.v7 = o2;
			mea_vertices.v8 = o6;
			break;
		case 14:
			mea_vertices.v1 = o5;
			mea_vertices.v2 = o8;
			mea_vertices.v3 = o7;
			mea_vertices.v4 = o6;
			mea_vertices.v5 = o1;
			mea_vertices.v6 = o4;
			mea_vertices.v7 = o3;
			mea_vertices.v8 = o2;
			break;
		case 15:
			mea_vertices.v1 = o6;
			mea_vertices.v2 = o7;
			mea_vertices.v3 = o3;
			mea_vertices.v4 = o2;
			mea_vertices.v5 = o5;
			mea_vertices.v6 = o8;
			mea_vertices.v7 = o4;
			mea_vertices.v8 = o1;
			break;
		case 16:
			mea_vertices.v1 = o2;
			mea_vertices.v2 = o1;
			mea_vertices.v3 = o5;
			mea_vertices.v4 = o6;
			mea_vertices.v5 = o3;
			mea_vertices.v6 = o4;
			mea_vertices.v7 = o8;
			mea_vertices.v8 = o7;
			break;
		case 17:
			mea_vertices.v1 = o7;
			mea_vertices.v2 = o3;
			mea_vertices.v3 = o2;
			mea_vertices.v4 = o6;
			mea_vertices.v5 = o8;
			mea_vertices.v6 = o4;
			mea_vertices.v7 = o1;
			mea_vertices.v8 = o5;
			break;
		case 18:
			mea_vertices.v1 = o7;
			mea_vertices.v2 = o6;
			mea_vertices.v3 = o5;
			mea_vertices.v4 = o8;
			mea_vertices.v5 = o3;
			mea_vertices.v6 = o2;
			mea_vertices.v7 = o1;
			mea_vertices.v8 = o4;
			break;
		case 19:
			mea_vertices.v1 = o6;
			mea_vertices.v2 = o2;
			mea_vertices.v3 = o1;
			mea_vertices.v4 = o5;
			mea_vertices.v5 = o7;
			mea_vertices.v6 = o3;
			mea_vertices.v7 = o4;
			mea_vertices.v8 = o8;
			break;
		case 20:
			mea_vertices.v1 = o2;
			mea_vertices.v2 = o3;
			mea_vertices.v3 = o4;
			mea_vertices.v4 = o1;
			mea_vertices.v5 = o6;
			mea_vertices.v6 = o7;
			mea_vertices.v7 = o8;
			mea_vertices.v8 = o5;
			break;
		case 21:
			mea_vertices.v1 = o8;
			mea_vertices.v2 = o5;
			mea_vertices.v3 = o1;
			mea_vertices.v4 = o4;
			mea_vertices.v5 = o7;
			mea_vertices.v6 = o6;
			mea_vertices.v7 = o2;
			mea_vertices.v8 = o3;
			break;
		case 22:
			mea_vertices.v1 = o3;
			mea_vertices.v2 = o4;
			mea_vertices.v3 = o1;
			mea_vertices.v4 = o2; 
			mea_vertices.v5 = o7; 
			mea_vertices.v6 = o8;
			mea_vertices.v7 = o5;
			mea_vertices.v8 = o6;
			break;
		case 23: 
			mea_vertices.v1 = o4;
			mea_vertices.v2 = o8;
			mea_vertices.v3 = o5;
			mea_vertices.v4 = o1; 
			mea_vertices.v5 = o3; 
			mea_vertices.v6 = o7;
			mea_vertices.v7 = o6;
			mea_vertices.v8 = o2;
			break;
		default:
			printf("error in data file: rotate_case is invalid.\n");
			break;
	}
}
