/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: C_main.c
 *		      Author: Rick Avila
 *			Date: 03/07/92
 *		 Description: The VolVis Main Routine 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

/****		Standard C Includes		****/
#include <stdio.h>

/****		VolVis Includes			****/
#include "C_constants.h"
#include "C_enums.h"
#include "C_typedefs.h"
#include "C_macros.h"


C_World         world;
C_View          view;
C_ImageTable   image_table;

/* Temporary Variables - Used In Procedures & Macros */
float		C_temp_float1;
float		C_temp_float2;
float		C_temp_float3;
float		C_temp_float4;
float		C_temp_float5;

float		C_temp_int1;
float		C_temp_int2;
float		C_temp_int3;
float		C_temp_int4;
float		C_temp_int5;

/*
 *        Procedure Name: main
 *          Return Value: none
 *       Input Variables: argc	- Argument Count
 *			  argv  - Argument Array
 *      Output Variables: none
 *      Update Variables: none
 *      Global Variables: none
 *           Description: The VolVis Main Routine. The initialization of the
 *			  VolVis system is performed followed by the creation
 *			  of the windowing system. The windowing system 
 *			  initialization is responsible for starting the 
 *			  event loop.
 */
void main( argc, argv )
unsigned int	argc;
char		**argv;
{
	extern void	C_initialize_volvis();
        extern void     C_initialize_VD_default();

printf("\t                    VolVis 1.0                            \n");
printf("                                                            \n");
printf("\tCopyright (C) 1993 by the Research Foundation of the State\n"); 
printf("\t                   University of New York                 \n");
printf("                                                            \n");
printf("\tVolVis comes with ABSOLUTELY NO WARRANTY;  for details see\n");
printf("\tthe GNU General Public License.                           \n");
printf("                                                            \n");
printf("\tThis is free software, and you are welcome to redistribute\n");
printf("\tit  under  certain  conditions;  for  details  see the GNU\n");
printf("\tGeneral Public License.                                   \n");
printf("                                                            \n");
printf("                                                            \n");

	/* Initialize The VolVis Environment */
	C_initialize_volvis();

	/* Initialize The Navigator */
	/* Add here if Necessary */

        /* Initialize The Input Device System */
        C_initialize_VD_default();

	/* Initialize The Windowing System */
	C_initialize_windowing_system( argc, argv );

}

