/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




# define C_RT_MAX_QUAD	4

typedef struct
{
        int             num_intersections;
        C_FPosition     local_position[3];
        float           local_distance[3];
} C_LineIntersectInfo;
 

typedef enum
{
	C_PRIMARY_RAY,
	C_SHADOW_RAY,
	C_REFLECT_RAY,
	C_TRANSMIT_RAY,
	C_PRIMARY_LIGHT_RAY,
	C_SECONDARY_LIGHT_RAY,
	C_PARC_RAY,
	C_PROBE_RAY
} C_RTRayType;

typedef struct
{
        int             ray_level;
        C_RTRayType     ray_type;
        int             volume_num;
        C_FVector       ray_direction;
        C_FVector       world_normal;
        C_FPosition     local_point;
        C_FPosition     world_point;
        float           world_distance;
        int             exiting_volume;
	int		start_on_cut;
	float		opacity_red;
	float		opacity_green;
	float		opacity_blue;
	float		opacity;
} C_ShadeInfo;
 
struct intern
{
        int             volume;         /* Volume Index Of Intersection */
        C_FPosition     position;
        float           distance;
        float           min_distance;
        float           max_distance;
        C_StepType      start_step;
	C_CutGeom	*start_cut;
	C_CutGeom	*end_cut;
        struct intern   *next_intersection;
};

typedef struct intern C_IntersectionList;

typedef struct
{
        C_FPosition     ray_origin;
        C_FVector       ray_direction;
        int             ray_level;
        C_RTRayType     ray_type;
        float           max_distance;
} C_RayTraceInfo;


typedef struct
{
        C_FPosition     intersect_local_position;
        C_FPosition     intersect_world_position;
	C_FVector	intersect_world_normal;
	C_FVector	intersect_local_normal;
        int             intersect_volume;
        float           intersect_distance;
	C_Color		intersect_color;
} C_IntersectInfo;


struct qnode
{
	float		x_avg_refl_dir;
	float		y_avg_refl_dir;
	float		z_avg_refl_dir;
	float		max_refl_diff;
	struct qnode	*prev_level;
};

typedef struct qnode  C_RTQuadNode;

typedef struct
{
	C_RTQuadNode	*top_level;
	int		level_width[C_RT_MAX_QUAD+1];
	int		level_height[C_RT_MAX_QUAD+1];
} C_RTQuadTree;

typedef struct
{
	int		width_pixels;
	int		height_pixels;
	int		need_to_recalculate;
	float		*x_pos[C_MAX_LIGHTS*C_MAX_VOLUMES];
	float		*y_pos[C_MAX_LIGHTS*C_MAX_VOLUMES];
	float		*z_pos[C_MAX_LIGHTS*C_MAX_VOLUMES];
	float		*x_refl_dir[C_MAX_LIGHTS*C_MAX_VOLUMES];
	float		*y_refl_dir[C_MAX_LIGHTS*C_MAX_VOLUMES];
	float		*z_refl_dir[C_MAX_LIGHTS*C_MAX_VOLUMES];
	C_RTQuadTree	*quad_tree[C_MAX_LIGHTS*C_MAX_VOLUMES];
} C_IndirectLightInfo;
