#include "all.h"
#include "mygraph.h"
#define MAXNAME 400
#ifdef __TURBOC__
#define MAXNAME 40
#endif
static double namex1[MAXNAME],namey1[MAXNAME],namex2[MAXNAME],namey2[MAXNAME];
static char *names[MAXNAME];
static int nnam=0;
int swap_minmax(double *x1, double *y1, double *x2, double *y2);
name_set(char *n,double x1,double y1,double x2,double y2)
{
	double xx1,yy1,xx2,yy2;
	int i;
	strupr(n);
	for (i=0;i<nnam;i++) if (strcmp(n,names[i])==0) break;
	if (i==nnam) {
		nnam++;
		if (nnam>=MAXNAME) {
			gprint("Too many names in gle file, reuse them\n");
			return;
		}
		names[i] = sdup(n);
	}
	g_dev(x1,y1,&xx1,&yy1);
	g_dev(x2,y2,&xx2,&yy2);
	swap_minmax(&xx1, &yy1, &xx2, &yy2);
	namex1[i] = xx1;
	namey1[i] = yy1;
	namex2[i] = xx2;
	namey2[i] = yy2;
}
swap_minmax(double *x1, double *y1, double *x2, double *y2)
{
	double a;
	if (*x1 > *x2) { a = *x1; *x1 = *x2; *x2 = a;}
	if (*y1 > *y2) { a = *y1; *y1 = *y2; *y2 = a;}
}
name_show()
{
	int i;
	for (i=0;i<nnam;i++) {
		gprint("Name %d {%s} \n",i,names[i]);
	}
}
name_get(char *n,double *x1,double *y1,double *x2,double *y2)
{
	int i;
	double xx1,yy1,xx2,yy2;
	for (i=0;i<nnam;i++) {
		if (strcmp(n,names[i])==0) break;
	}
	if (i==nnam) {
		gprint("Name not defined {%s} \n",n);
		i=0;
		return;
	}
	g_undev(namex1[i],namey1[i],&xx1,&yy1);
	g_undev(namex2[i],namey2[i],&xx2,&yy2);
	swap_minmax(&xx1, &yy1, &xx2, &yy2);
	*x1 = xx1;
	*y1 = yy1;
	*x2 = xx2;
	*y2 = yy2;
}















