// wavheader.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author 	
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// WAVSoundHeader is the subclass of SoundHeader that reads and writes .wav
// format sound files from Intel platforms.

#ifndef WAVHEADER_H
#ifdef __GNUG__
#pragma interface
#endif
#define WAVHEADER_H

#include "diskstruct.h"
#include "id.h"
#include "soundheader.h"

// header magic number, swapped and unswapped

#define RIFF 0x52494646
#define FFIR 0x46464952

class WAVSoundHeader : public SoundHeader {
	typedef SoundHeader Super;
public:
	WAVSoundHeader(DataType format, int rate, int chans);
protected:
	redefined boolean isLittleEndian() { return true; }
	redefined boolean isMagic();
	redefined boolean magicIsSwapped();
	redefined int checkHeader();
	redefined boolean isValid(DataType t) { return (t <= ShortData); }
	redefined int readInfo(DataFile *);
	redefined int readComment(DataFile *) { return true; }
	redefined int writeInfo(DataFile *);
	redefined int writeComment(DataFile *) { return true; }
private:
	// first all the private nested classes
	class RIFFChunk : public StandardChunk {
		typedef StandardChunk Super;
	public:
		RIFFChunk(long totalsize=0)
			: StandardChunk("RIFF", totalsize), typeId("WAVE") {}
		redefined boolean isValid() { return isA("RIFF") && typeId == "WAVE"; }
		redefined int read(DataFile*);
		redefined int write(DataFile*);
	protected:
		redefined ValueSetterBase** valueSetters();
		enum { NumElements = 1 };
	private:
		Id typeId;
	};
	class FormatChunk : public StandardChunk {
		typedef StandardChunk Super;
	public:
		FormatChunk(long totalsize=0) : StandardChunk("fmt ", totalsize) {}
		redefined boolean isValid() { return isA("fmt ") && size() > 0L; }
	};
	class FormatStruct : public DiskStruct {
		typedef DiskStruct Super;
	public:
		FormatStruct(short fmt=0, short chans=0, long sr=0, short sampsize=0);
		redefined long readSize() { return sizeof(*this) - Super::readSize(); }
	protected:
		redefined ValueSetterBase** valueSetters();
		enum { NumElements = 6 };
	private:
		friend class WAVSoundHeader;
		enum Format {
			WAVE_FORMAT_UNKNOWN		= 0x0000, 
			WAVE_FORMAT_PCM			= 0x0001,  
			WAVE_FORMAT_ADPCM		= 0x0002, 
			WAVE_FORMAT_ALAW		= 0x0006, 
			WAVE_FORMAT_MULAW		= 0x0007, 
			WAVE_FORMAT_OKI_ADPCM	= 0x0010, 
			WAVE_FORMAT_DIGISTD		= 0x0015, 
			WAVE_FORMAT_DIGIFIX		= 0x0016, 
			IBM_FORMAT_MULAW        = 0x0101, 
			IBM_FORMAT_ALAW			= 0x0102, 
			IBM_FORMAT_ADPCM        = 0x0103
		};
		unsigned short dataFormat;
		unsigned short channels;
		unsigned long sampleRate;
		unsigned long bytesPerSecond;
		unsigned short blockAlign;
		unsigned short sampleSize;
	};
	class DataChunk : public StandardChunk {
	public:
		DataChunk(long datasize) : StandardChunk("data", datasize) {}
		redefined boolean isValid() { return isA("data") && size() >= 0L; }
	};
	// now the private functions
	void readFmt(const FormatStruct &);
	// and private members
	unsigned short sampleFormat;
};

#endif
