// soundeditor.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
// DataEditor subclass for handling modifications of Sound objects.

#ifndef SOUNDEDITOR_H
#ifdef __GNUG__
#pragma interface
#endif
#define SOUNDEDITOR_H

#include "editor.h"

class Controller;
class Data;
class Sound;

class SoundEditor : public DataEditor {
	typedef DataEditor Super;
public:
	// file methods
	static Controller* new_File(Controller *);
	redefined void newFile();
	redefined void saveFile();
	redefined void saveToFile();
	// modify methods
	redefined void changeLength();
	redefined void interpolate();
	redefined void insertSpace();
	void removeDC_Component();
	redefined void lowPassFilter();
	void resonFilter();
	void combFilter();
	void ellipticalFilter();
	void lpcFilter();
 	// converter methods
	void record();
	void play();
	void stop();
	void configureConverter();
	// synthesis methods
	void resynthesizeFromLPC();
	void resynthesizeFromPvoc();
	// analysis methods
	void rescanForPeak();
	redefined void rescale();
	void changeFormat();
	int pitchTrackAnalysis();
	void FFTAnalysis();
	void PVocAnalysis();
	int LPCAnalysis();
	void LPCAndPitchTrackAnalysis();
	redefined void setDataOptions();
protected:
	SoundEditor(Controller *c) : DataEditor(c) {}
	SoundEditor(Controller *c, const Data *d) : DataEditor(c, d) {}
	Sound *soundModel() { return (Sound *) model(); }
	redefined boolean keyCommand(unsigned long);
public:
	redefined const MenuBarInfo *menuBarInfo() const;
	static DataEditor* new_DataEditor1(Controller *);
	static DataEditor* new_DataEditor2(Controller *, const Data *);
private:
	friend DataEditor;	
	friend Controller;
	redefined Data *newModel();
};

#endif
