// vw_converter.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <sys/soundcard.h>
#include "application.h"
#include "vw_converter.h"
#include "typeconvert.h"

VW_Converter::VW_Converter() : ConverterDevice("/dev/dsp"), audioBufferSize(0) {
}

VW_Converter::~VW_Converter() {
	stop();
}

boolean
VW_Converter::isPlayableFormat(DataType type) {
	return (type < FloatData);
}

// what is best format to play (if given choice)

DataType
VW_Converter::bestPlayableType() {
	return ShortData;
}

// for future use -- no real way to do this yet

int
VW_Converter::pause() {
	return false;
}

// add any specific code needed to stop play or record

int
VW_Converter::stop() {
	return Super::stop();
}

int
VW_Converter::checkChannels(int chans) {
	int status = false;
	if(chans != 1 && chans != 2)
		Application::alert("Converter only handles monaural and stereo files.");
	else
		status = true;
	return status;
}

int
VW_Converter::doConfigure() {
	int status = false;
	if(reOpen()) {
		int dsp_speed = sampleRate();
		int dsp_stereo = (channels() == 2);
		int sampleSize = type_to_sampsize(dataType()) << 3;
		int confirmedSize = sampleSize;
		if (!ioctl (SNDCTL_DSP_SPEED, (char *) &dsp_speed))
			error("Unable to set converter sample rate.");
		else if (!ioctl(SNDCTL_DSP_STEREO, (char *) &dsp_stereo))
			error("Unable to set converter channel attribute.");
		else if (!ioctl(SNDCTL_DSP_SAMPLESIZE, (char *) &confirmedSize)
			|| confirmedSize != sampleSize)
			error("Unable to set sample size.");
		else if(!ioctl(SNDCTL_DSP_GETBLKSIZE, (char *) &audioBufferSize))
			error("Unable to get audio buffer size.");
		else if(audioBufferSize < 1024 || audioBufferSize > (2*65536)) {
			char msg[128];
			sprintf(msg, "Invalid audio buffer size %d", audioBufferSize);
			error(msg);
		}
		else status = true;
	}
	return status;
}

// return size of buffer, in bytes, to be written to the device during play
// this can either be computed or just a static value

int
VW_Converter::writeSize() {
	return audioBufferSize;
}

// return size of buffer, in bytes, to be read from the device during record
// this can either be computed or just a static value

int
VW_Converter::readSize() {
	return audioBufferSize;
}

