// soundblaster.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifndef MXV_SOUNDBLASTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define MXV_SOUNDBLASTER_H

#include "conv_device.h"

class SoundBlaster : public ConverterDevice {
	typedef ConverterDevice Super;
public:
	SoundBlaster();
	virtual ~SoundBlaster();
	redefined int pause();
	redefined int stop();
	redefined DataType bestPlayableType();
	virtual int setSpeakerOutput(boolean flag=true);	// new to class
protected:
	redefined boolean isPlayableFormat(DataType type);
	redefined int doConfigure();
	redefined int checkSampleRate(int rate);
	redefined int checkChannels(int chans);
	redefined int writeSize() { return 65536; }
	redefined int readSize() { return 65536; }
private:
	SoundBlaster(const SoundBlaster &);
};

#endif
